/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef DPAIR
int dpair(A, C, D) /* pair */ 
register AFFIX A, C, D;
{
  AFFIX B = ++af;
  A->t = c;
  A->l = nil;
  A->r = nil;
  B->t = fast_list_acces;
  B->l = C;
  B->r = D;
  PUT_CELL_ADDR(B);
  return true;
}
#endif

#ifdef DUNPAIR
int             dunpair(A, B, C)       /* lifted unpair */
register AFFIX A, B, C;
{
  char           *xs = c;
  AFFIX   cell;
  if ((A->r == nil) && (A->l == nil)) xs = A->t;
  else {
    sprinta(A);
    *c++ = '\0';
  }
  GET_CELL_ADDR(cell,xs);
  if ((long) cell != -1) {
    COPY(B, cell->l);
    COPY(C, cell->r);
    return true;
  }
  return false;
}
#endif

#ifdef DREPAIR
int             drepair(A_0, A_1, A_2)       /* lifted unpair */
register AFFIX A_0, A_1, A_2;
{
  AFFIX    cell = nil;
  register char           *xs = c;
  if ((A_0->r == nil) && (A_0->l == nil)) xs =  A_0->t;
  else {
    sprinta(A_0);
    *c++ = '\0';
  }
  GET_CELL_ADDR(cell,xs);
  if ((long) cell != -1) {
    cell->l = A_1;
    cell->r = A_2;
    return true;
  }
  return false;
}
#endif

#ifdef UREPAIR
void urepair() {             /* repair */

  register cont  *rq = q;
register AFFIX A_2 = (rq + 0)->a;
register AFFIX A_1 = (rq + -1)->a;
register AFFIX A_0 = (rq + -2)->a;
  affix    x, *cell = nil, old;
  char           *xs = c;
  SAVE(x, A_0);
  if ((x.r == nil) && (x.l == nil));
  else {
    sprinta(A_0);
    A_0->t = xs;
    A_0->l = nil;
    A_0->r = nil;
    *c++ = '\0';
  }
  GET_CELL_ADDR(cell,A_0->t);
  if ((long) cell != -1) {
    SAVE(old, cell);
    cell->l = A_1;
    cell->r = A_2;
    q = rq + -4;
    (*(rq + -3)->q) ();
    rq = q + 3;
    RESTORE(cell, old);
  }

  RESTORE(A_0, x);
  (rq + -2)->a = A_0;
  (rq + -1)->a = A_1;
  (rq + 0)->a = A_2;
  (rq + 1)->q = urepair;
  q = rq + 1;
  c = xs;
}
#endif

#ifdef DWHERE
int dwhere(A_0,A_1)              /* where */
register AFFIX A_0;
register AFFIX A_1;
{
    MAKE(A_1, A_0);
    return true;
}
#endif

#ifdef DEVALMETA
int devalmeta(A_0)
register AFFIX A_0;
{   
  register char  *rc = c;
  if (((A_0->r) == nil) && ((A_0->l) == nil)) return;
  else {
    sprinta(A_0);
    *c++ = '\0';
  }
    A_0->t = rc;
    A_0->r = nil;
    A_0->l = nil;
    return true;
}
#endif

#ifdef UEVALMETA
void uevalmeta()
{ 
   register cont *rq = q;
register AFFIX A_0 = rq->a;
   char *rc = c; 
   q = rq -2;
   if (((A_0->r) == nil) && ((A_0->l) == nil))  {
      (*(rq -1)->q)(); 
   } else {
       affix S_0;
       S_0.t = A_0->t;
       S_0.r = A_0->r;
       S_0.l = A_0->l;
       A_0->t = c;
       A_0->r = nil;
       A_0->l = nil;
       sprinta(A_0);
       *c++ = '\0';
       if (c > cstore_top ) cstore_overflow();
       (*(rq -1)->q)(); 
       c = A_0 ->t;
       A_0->t = S_0.t;
       A_0->r = S_0.r;
       A_0->l = S_0.r;
    }
   rq = q +1;
   rq->a = A_0;
   (rq + 1)->q = uevalmeta; 
   q = rq + 1; 
}
#endif

#ifdef DINITMETA
int dinitmeta(A_0,A_1)
register AFFIX A_0;
register AFFIX A_1;
{   
    A_0->t = "";
    A_0->r = A_1;
    A_0->l = nil;
    return true;
}
#endif

#ifdef UINITMETA 
void uinitmeta () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( dinitmeta (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = uinitmeta; 
   q = rq + 1; 
   c = rc;
}
#endif

#ifdef DASSIGN
int dassign(A_0,A_1,A_2)
register AFFIX A_0;
register AFFIX A_1;
register AFFIX A_2;
{
    A_2->t = A_0->t;
    A_2->r = A_0->r;
    A_2->l = A_0->l;
    A_0->t = A_1->t;
    A_0->r = A_1->r;
    A_0->l = A_1->l;
    return true;
}
#endif

#ifdef UASSIGN
void uassign() {
    register cont  *rq = q;
register AFFIX A_2 = (rq + 0)->a;
register AFFIX A_1 = (rq + -1)->a;
register AFFIX A_0 = (rq + -2)->a;
    {
      A_2->t = A_0->t;
      A_2->r = A_0->r;
      A_2->l = A_0->l;
      A_0->t = A_1->t;
      A_0->r = A_1->r;
      A_0->l = A_1->l;
      q = rq + -4;
      (*(rq + -3)->q) ();
      rq = q +3;
      A_0->t = A_2->t;
      A_0->r = A_2->r;
      A_0->l = A_2->l;
    }
    (rq + -2)->a = A_0;
    (rq + -1)->a = A_1;
    (rq + 0)->a = A_2;
    (rq + 1)->q = uassign;
    q = rq + 1;
}
#endif
