/*
   File: DiscEvents.c
   Defines the structure of the discrete event queue and signal storage
*/

struct sig_rec
	{ int sig [MaxTime];		/* The stored signal */
	  void (*event_proc) ();	/* Proc to call at event */
	  int cv;			/* Current value of sig */
	  int time;			/* Last time 'cv' changed */
	  Widget ws;			/* Widget displaying sig, if nec. */
	};

typedef struct queue_rec
	{ int nr;			/* number of signal */
	  int time;			/* time of event */
	  int newval;			/* new value of signal */
	  struct queue_rec *next;	/* next event to occur */
	} *queue;

#define empty_queue (queue)0
static queue the_queue = empty_queue;	/* the discrete event queue */
static queue free_queue = empty_queue;	/* free_list */

static struct sig_rec Sigs[MaxSignals];	/* The whole of all signals */

/*
   As events will be enqueued en dequeued quite oft,
   it is worthwhile maintaining a free_list
*/
static queue alloc_event ()
	{ queue new;
	  if (free_queue == empty_queue)
	     { new = (queue) malloc (sizeof (struct queue_rec));
	       if (new == empty_queue)
		  { fprintf (stderr, "Out of memory\n");
		    exit (1);
		  };
	     }
	  else
	     { new = free_queue;
	       free_queue = free_queue -> next;
	     };
	  return (new);
	};

static void free_event (old)
 queue old;
	{ old -> next = free_queue;
	  free_queue = old;
	};

/*
   Enqueue an event
*/
static void enqueue (nr, time, value)
 int nr, time, value;
	{ queue *qptr = &the_queue;
	  queue new;
	  while (*qptr != empty_queue)
	     { if ((*qptr) -> time > time) break;
	       if (((*qptr) -> time == time) && ((*qptr) -> nr > nr)) break;
	       if (((*qptr) -> time == time) && ((*qptr) -> nr == nr))
		  { (*qptr) -> newval = value;
		    return;
		  };
	       qptr = &((*qptr) -> next);
	     };
	  new = alloc_event ();
	  new -> nr = nr;
	  new -> time = time;
	  new -> newval = value;
	  new -> next = *qptr;
	  *qptr = new;
	};

static void check_enqueue (nr, time, value)
 int nr, time, value;
	{ if (Sigs [nr].cv != value) enqueue (nr, time, value);
	};
static void dequeue (nr, time, value)
 int *nr;
 int *time;
 int *value;
	{ queue old = the_queue;
	  the_queue = the_queue -> next;
	  *nr = old -> nr;
	  *time = old -> time;
	  *value = old -> newval;
	  free_event (old);
	};

/*
   update event adm
*/
static void update (nr, time, val)
 int nr;
 int time;
 int val;
	{ register int ix;
	  for (ix = Sigs[nr].time; ix < time; ix++)
	     Sigs[nr].sig[ix] = Sigs[nr].cv;
	  Sigs[nr].time = time;
	  Sigs[nr].cv = val;
	};
