static char sccsid[] = "@(#)ThisForth Beta Wil Baden 94-09-12";
# include "fo.h"

# define nestingcheck()	if ((unsigned)(R - rack) >= RETURN_STACK_CELLS - 2)\
			sorry("(Nesting Error)")

# define stackcheck() if ((unsigned)(S - stack) >= STACK_CELLS - 2)\
			sorry("(Stack Error)")

/** @(#)llfc.m4	Wil Baden 94-06-25	**/
/** Low Level Forth for C **/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

# define SELF_COMPILE if (! state) namespace=finger,dataspace=here,\
	state=TRUE,progress=next,next=(CODEROOM - 100)+2,colevel=S-stack;
# define COMPLETE if (progress && colevel == S-stack)\
	c(6),finger=namespace,next=progress,progress=0,state=FALSE,\
		*++R=I, I=(CODEROOM - 100)+2;
# define HOW sorry("(Misused)");
# define HUH sorry("(Unknown)");
# define COMPILE_ONLY if (! state) sorry("(Compile Only)") ;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

FILE * usrin = stdin, * usrout = stdout;
int parg; int pargc; char ** pargv;

unsigned char * word;

unsigned char data[DATAROOM] = { 0, /* Next name at 2029 */

4,'e','x','i','t',
7,'e','x','p','o','u','n','d',
4,'q','u','i','t',
5,'a','b','o','r','t',
3,'b','y','e',
1,';',
1,':',
4,'d','r','o','p',
3,'d','u','p',
3,'n','i','p',
4,'o','v','e','r',
3,'r','o','t',
4,'s','w','a','p',
4,'?','d','u','p',
5,'2','d','r','o','p',
4,'2','d','u','p',
5,'2','o','v','e','r',
5,'2','s','w','a','p',
4,'p','i','c','k',
4,'r','o','l','l',
2,'>','r',
2,'r','>',
2,'r','@',
1,'@',
1,'!',
2,'+','!',
2,'c','@',
2,'c','!',
5,'d','e','p','t','h',
4,'h','e','r','e',
7,'n','e','s','t','i','n','g',
7,'o','u','t','s','i','d','e',
9,'s','o','u','r','c','e','-','i','d',
6,'u','n','u','s','e','d',
6,'l','s','h','i','f','t',
1,'+',
1,'-',
1,'*',
1,'/',
2,'2','/',
1,'>',
1,'<',
1,'=',
7,'a','l','i','g','n','e','d',
5,'a','l','l','o','t',
3,'a','n','d',
5,'c','e','l','l','s',
7,'c','o','m','p','a','r','e',
3,'m','o','d',
4,'/','m','o','d',
5,'*','/','m','o','d',

6,'n','e','g','a','t','e',
2,'o','r',
6,'r','s','h','i','f','t',
2,'u','>',
2,'u','<',
6,'u','n','d','e','r','+',
3,'x','o','r',
2,'i','f',
4,'e','l','s','e',
4,'t','h','e','n',
4,'c','a','s','e',
4,'e','s','a','c',
5,'b','e','g','i','n',
5,'w','h','i','l','e',
5,'u','n','t','i','l',
6,'r','e','p','e','a','t',
2,'d','o',
3,'?','d','o',
6,'u','n','l','o','o','p',
5,'l','e','a','v','e',
4,'l','o','o','p',
5,'+','l','o','o','p',
1,'i',
1,'j',
1,40, /* 40 == left parenthesis */
5,'>','b','o','d','y',
2,'c','\"',
8,'g','e','t','-','c','h','a','r',
10,'s','t','a','c','k','-','c','h','a','r',
9,'n','e','x','t','-','c','h','a','r',
5,'c','o','u','n','t',
2,'c','r',
4,'e','m','i','t',
7,'e','x','e','c','u','t','e',
4,'f','i','n','d',
4,'f','i','l','l',
9,'i','m','m','e','d','i','a','t','e',
6,'i','n','l','i','n','e',
7,'l','i','t','e','r','a','l',
4,'m','o','v','e',
7,':','n','o','n','a','m','e',
6,'p','l','e','a','s','e',
7,'r','e','c','u','r','s','e',
15,'s','e','a','r','c','h','-','w','o','r','d','l','i','s','t',
6,'s','p','a','c','e','s',
5,'s','t','a','t','e',
9,'t','i','m','e','&','d','a','t','e',
4,'t','y','p','e',
4,'w','o','r','d',
5,'p','a','r','s','e',
8,'s','l','i','t','e','r','a','l',
1,'[',
1,'\\',
1,']',
2,'d','+',
2,'d','-',
3,'u','m','*',
6,'u','m','/','m','o','d',
2,'m','*',
6,'s','m','/','r','e','m',
6,'f','m','/','m','o','d',
8,'c','o','n','s','t','a','n','t',
5,'d','o','e','s','>',
1,'|',
2,'|','|',
4,'b','a','s','e',
6,'m','a','r','k','e','r',
6,'s','t','r','e','a','m',
8,'u','n','s','t','r','e','a','m',
7,'d','i','s','p','l','a','y',
5,'f','o','p','e','n',
6,'f','f','l','u','s','h',
6,'f','c','l','o','s','e',
5,'f','s','e','e','k',
5,'f','t','e','l','l',
6,'e','r','r','o','r','?',
3,'h','a','s',
5,'p','a','t','c','h',
8,'a','r','g','u','m','e','n','t',
6,'s','y','s','t','e','m',
6,'[','c','h','a','r',']',
7,'v','e','r','s','i','o','n',
2,'b','l',3,'e','o','l',5,'f','a','l','s','e',4,'t','r',
'u','e',3,'e','o','f',2,'<','>',5,'=',' ','0','=',' ',5,
'c','e','l','l','+',10,'1',' ','c','e','l','l','s',' ','+',' ',
5,'c','h','a','r','+',10,'1',' ','c','h','a','r','s',' ','+',
' ',5,'c','h','a','r','s',6,'i','n','v','e','r','t',9,'t',
'r','u','e',' ','x','o','r',' ',3,'n','o','t',8,'f','a','l',
's','e',' ','=',' ',4,'t','u','c','k',10,'s','w','a','p',' ',
'o','v','e','r',' ',8,'g','e','t','-','w','o','r','d',7,'~',
'p','l','e','a','s','e',16,'g','e','t','-','w','o','r','d',' ',
'p','l','e','a','s','e',' ',4,'c','h','a','r',4,'w','i','l',
'l',8,' ','[','e','x','i','t',']',' ',8,'e','v','a','l','u',
'a','t','e',1,'~',2,'s',34,12,'c',34,' ','~',34,' ','c',
'o','u','n','t',' ',2,'.',34,17,'c',34,' ','~',34,' ','c',
'o','u','n','t',' ','t','y','p','e',' ',6,'a','b','o','r','t',
34,20,'i','f',' ','.',34,' ','~',34,' ','a','b','o','r','t',
' ','t','h','e','n',' ',1,39,11,'C','a','n',39,'t',' ','f',
'i','n','d',' ',3,'[',39,']',16,'[',' ',39,' ','~',' ',']',
' ','L','I','T','E','R','A','L',' ',8,'p','o','s','t','p','o',
'n','e',14,'[',39,']',' ','~',' ','E','X','E','C','U','T','E',
' ',2,'o','f',15,'o','v','e','r',' ','=',' ','i','f',' ','d',
'r','o','p',' ',5,'e','n','d','o','f',5,'e','l','s','e',' ',
7,'e','n','d','c','a','s','e',10,'d','r','o','p',' ','e','s',
'a','c',' ',5,'a','g','a','i','n',12,'f','a','l','s','e',' ',
'u','n','t','i','l',' ',5,'a','n','d','i','f',12,'d','u','p',
' ','i','f',' ','d','r','o','p',' ',4,'o','r','i','f',11,'?',
'd','u','p',' ','0','=',' ','i','f',' ',2,'?','?',10,'i','f',
' ','~',' ','t','h','e','n',' ',3,'a','b','s',3,'c','+','!',
7,'d','e','c','i','m','a','l',3,'h','e','x',3,'m','a','x',
3,'m','i','n',5,'s','p','a','c','e',6,'w','i','t','h','i',
'n',2,'*','/',5,'>','c','h','a','r',2,'<','#',4,'h','o',
'l','d',4,'s','i','g','n',1,'#',2,'#','s',2,'#','>',3,
'(','.',')',1,'.',2,'.','r',2,'u','.',3,'u','.','r',1,
'?',5,'a','l','i','g','n',1,',',2,'c',',',6,'c','r','e',
'a','t','e',8,'v','a','r','i','a','b','l','e',6,'[','h','e',
'r','e',']',23,'[',' ','a','l','i','g','n',' ','h','e','r','e',
' ',']',' ','l','i','t','e','r','a','l',' ',5,'v','a','l','u',
'e',4,'~',' ','@',' ',2,'t','o',14,'[',39,']',' ','~',' ',
'>','B','O','D','Y',' ','!',' ',2,'2','!',2,'2','@',3,'2',
'>','r',3,'2','r','>',4,'2','r','o','t',3,'2','r','@',2,
'x','.',2,'.','s',2,'.','.',2,'s','=',11,'C','O','M','P',
'A','R','E',' ','0','=',' ',2,'t','h',10,'C','E','L','L','S',
' ','~',' ','+',' ',2,'0','x',14,'H','E','X',' ','~',' ','D',
'E','C','I','M','A','L',' ',4,'[','0','x',']',22,'[',' ','h',
'e','x',' ',']',' ','~',' ','[',' ','d','e','c','i','m','a','l',
' ',']',' ',6,'o','p','e','n','e','d',11,'C','a','n',39,'t',
' ','o','p','e','n',' ',5,'i','n','p','u','t',1,'r',6,'o',
'u','t','p','u','t',1,'w',6,'c','l','o','s','e','d',13,'C',
'a','n',39,'t',' ','c','l','o','s','e','.',' ',6,'r','e','w',
'i','n','d',4,'t','o','l','d',12,'C','a','n',39,'t',' ','t',
'e','l','l','.',' ',6,'s','o','u','g','h','t',12,'C','a','n',
39,'t',' ','s','e','e','k','.',' ',7,'f','l','u','s','h','e',
'd',13,'C','a','n',39,'t',' ','f','l','u','s','h','.',' ',11,
'e','n','d','-','o','f','-','f','i','l','e',6,'[','e','x','i',
't',']',1,'$',8,'F','a','i','l','e','d','.',' ',2,'t','r',
2,'~',' ',3,'-','-','>','&','s',34,' ','e','l','e','c','t',
'i','v','e',' ','~',' ','i','n','p','u','t',' ','s','t','r','e',
'a','m',' ',34,' ','e','v','a','l','u','a','t','e',' ',8,'i',
'n','c','l','u','d','e','d',12,'i','n','p','u','t',' ','s','t',
'r','e','a','m',2,'s','+',3,'~',34,' ',4,'S',34,' ','~',
4,'h','a','v','e',15,'c',34,' ','~',34,' ','f','i','n','d',
' ','n','i','p',' ',6,'f','i','l','t','e','r','$','s','t','r',
'e','a','m',' ','b','e','g','i','n',' ','n','e','x','t','-','c',
'h','a','r',' ','e','o','f',' ','<','>',' ','w','h','i','l','e',
' ',8,'u','n','f','i','l','t','e','r','!','r','e','p','e','a',
't',' ','s','o','u','r','c','e','-','i','d',' ','u','n','s','t',
'r','e','a','m',' ','r','e','w','i','n','d',' ',5,'e','m','p',
't','y',6,'-','-','-','-','-','-',13,'M','A','R','K','E','R',
' ','-','-','-','-','-','-',5,'3','d','r','o','p',4,'3','d',
'u','p',5,'4','d','r','o','p',4,'4','d','u','p',7,'/','s',
't','r','i','n','g',6,'>','u','p','p','e','r',6,'b','o','u',
'n','d','s',4,'c','o','p','y',6,'[','c','t','r','l',']',3,
'.','0','r',1,'0',6,'g','r','a','p','h','?',1,'k',11,'e',
'o','l',' ','l','s','h','i','f','t',' ',8,'g','e','t','-','l',
'i','n','e',5,'p','l','a','c','e',6,'p','r','i','n','t','?',
9,'-','t','r','a','i','l','i','n','g',2,'<','=',5,'>',' ',
'0','=',' ',2,'>','=',5,'<',' ','0','=',' ',2,'r','!',3,
'r','+','!',5,'e','r','a','s','e',3,'p','a','d',3,'s','>',
'd',3,'k','e','y',6,'a','c','c','e','p','t',6,'>','d','i',
'g','i','t',7,'>','n','u','m','b','e','r',6,'s','o','u','r',
'c','e',6,'r','e','f','i','l','l',2,'.','(',8,'c','o','m',
'p','i','l','e',',',9,'[','c','o','m','p','i','l','e',']',5,
'w','o','r','d','s',6,'*','*','*','*','*','*',2,'h','i',

};

instruction code[CODEROOM]={ /* Next instruction at 2025 */
	0, 0,

 /* Must contain 0 */ 0,

0,1,1,/* exit 5 */
3,0, /* CONTEXT */ 0,0,0,0,0,0,0,0,

/* CURRENT and CONTEXT should be defined in fo.h */

 -1,-1,-1,-1,-1,-1,-1,-1,

/* Such is sacred. */

4,5,3,6,1,/* expound 28 */
 2,
	 24, 25,-2,
/* : QUIT restart EXPOUND ; */

26,14,1,/* quit 35 */
8,33,19,1,/* abort 39 */
9,37,25,1,/* bye 43 */
10,41,29,11,/* ; 47 */
45,31,1,/* : 50 */
12,48,33,1,/* drop 54 */
13,52,38,1,/* dup 58 */
14,56,42,1,/* nip 62 */
15,60,46,1,/* over 66 */
16,64,51,17,/* rot 70 */
18,19,68,55,1,/* swap 75 */
20,73,60,1,/* ?dup 79 */
21,77,65,1,/* 2drop 83 */
22,81,71,1,/* 2dup 87 */
23,85,76,1,/* 2over 91 */
24,89,82,1,/* 2swap 95 */
25,93,88,26,/* pick 99 */
27,28,97,93,1,/* roll 104 */
29,102,98,1,/* >r 108 */
30,106,101,1,/* r> 112 */
31,110,104,1,/* r@ 116 */
32,114,107,33,/* @ 120 */
34,35,118,109,36,/* ! 125 */
37,38,123,111,39,/* +! 130 */
40,41,128,114,1,/* c@ 135 */
42,133,117,1,/* c! 139 */
43,137,120,1,/* depth 143 */
44,141,126,1,/* here 147 */
45,145,131,1,/* nesting 151 */
46,149,139,1,/* outside 155 */
47,153,147,1,/* source-id 159 */
48,157,157,1,/* unused 163 */
49,161,164,50,/* lshift 167 */
51,52,165,171,53,/* + 172 */
54,55,170,173,56,/* - 177 */
57,58,175,175,59,/* * 182 */
60,180,177,61,/* / 186 */
62,184,179,1,/* 2/ 190 */
63,188,182,1,/* > 194 */
64,192,184,65,/* < 198 */
66,67,196,186,68,/* = 203 */
69,70,71,201,188,72,/* aligned 209 */
73,207,196,1,/* allot 213 */
74,211,202,75,/* and 217 */
76,77,215,206,78,/* cells 222 */
79,220,212,1,/* compare 226 */
80,224,220,81,/* mod 230 */
82,228,224,1,/* /mod 234 */
83,232,229,1,/* SCALE 238 */
84,236,235,1,/* negate 242 */
85,240,242,86,/* or 246 */
87,88,244,245,89,/* rshift 251 */
90,91,249,252,1,/* u> 256 */
92,254,255,93,/* u< 260 */
94,95,258,258,96,/* under+ 265 */
97,98,263,265,99,/* xor 270 */
100,101,102,103,104,105,106,107,268,269,108,/* if 281 */
279,272,109,/* else 284 */
282,277,110,/* then 287 */
285,282,111,/* case 290 */
288,287,112,/* esac 293 */
291,292,113,/* begin 296 */
294,298,114,/* while 299 */
297,304,115,/* until 302 */
300,310,116,/* repeat 305 */
303,317,117,/* do 308 */
118,306,320,119,/* ?do 312 */
120,310,324,1,/* unloop 316 */
121,314,331,122,/* leave 320 */
318,337,123,/* loop 323 */
124,321,342,125,/* +loop 327 */
126,325,348,1,/* i 331 */
127,329,350,1,/* j 335 */
128,333,352,129,/* Left Parenthesis 339 */
337,354,130,/* >body 342 */
131,340,360,132,/* c\" 346 */
344,363,1,/* get-char 349 */
133,347,372,1,/* stack-char 353 */
134,351,383,1,/* next-char 357 */
135,355,393,136,/* count 361 */
137,138,359,399,1,/* cr 366 */
139,364,402,1,/* emit 370 */
140,368,407,1,/* execute 374 */
141,372,415,1,/* find 378 */
142,376,420,1,/* fill 382 */
143,380,425,1,/* immediate 386 */
144,384,435,1,/* inline 390 */
147,388,442,149,/* literal 394 */
150,392,450,1,/* move 398 */
151,396,455,1,/* :noname 402 */
152,400,463,153,/* please 406 */
154,404,470,155,/* recurse 410 */
408,478,1,/* search-wordlist 413 */
156,411,494,1,/* spaces 417 */
157,415,501,1,/* state 421 */
158,419,507,1,/* time&date 425 */
159,423,517,1,/* type 429 */
160,427,522,1,/* word 433 */
161,431,527,1,/* parse 437 */
162,435,533,163,/* sliteral 441 */
439,542,164,/* [ 444 */
442,544,165,/* \\ 447 */
445,546,1,/* ] 450 */
166,448,548,1,/* d+ 454 */
167,452,551,1,/* d- 458 */
168,456,554,1,/* um* 462 */
169,460,558,1,/* um/mod 466 */
170,464,565,1,/* m* 470 */
171,468,568,1,/* sm/rem 474 */
172,472,575,1,/* fm/mod 478 */
173,476,582,1,/* constant 482 */
174,480,591,1,/* does> 486 */
175,484,597,1,/* | 490 */
179,488,599,1,/* || 494 */
180,492,602,6,/* base 498 */
 NAMEROOM,

496,607,1,/* marker 502 */
181,500,614,1,/* stream 506 */
183,504,621,1,/* unstream 510 */
184,508,630,1,/* display 514 */
185,512,638,1,/* fopen 518 */
186,516,644,1,/* fflush 522 */
187,520,651,1,/* fclose 526 */
188,524,658,1,/* fseek 530 */
189,528,664,1,/* ftell 534 */
190,532,670,1,/* error? 538 */
191,536,677,1,/* has 542 */
192,540,681,1,/* patch 546 */
193,544,687,1,/* argument 550 */
194,548,696,1,/* system 554 */
195,552,703,196,/* [char] 558 */
556,710,1,/* version 561 */
197,
559,718,6,32,563,721,6,10,567,725,6,0,571,731,6,-1,
575,736,6,-1,579,740,145,2,407,743,6,583,749,145,2,407,
755,6,590,766,145,2,407,772,6,597,783,145,2,407,0,6,
604,789,145,2,407,796,6,611,806,145,2,407,810,6,618,819,
145,2,407,824,6,625,835,1,2,2,32,434,362,6,632,844,
145,2,407,852,6,641,869,1,2,635,55,136,6,648,874,1,
2,407,879,6,656,888,1,2,659,407,897,29,6,663,899,145,
2,2,34,438,407,902,6,672,915,145,2,2,34,438,407,918,
6,682,936,145,2,2,34,438,407,943,6,692,964,1,2,2,
32,434,379,277,5,363,966,430,40,6,702,978,145,2,422,121,
278,6,635,407,982,25,2,705,6,717,999,145,2,635,407,1008,
6,732,1023,145,2,407,1026,6,740,1042,145,2,407,1048,6,747,
1054,145,2,407,1062,6,754,1073,145,2,407,1079,6,761,1092,145,
2,407,1098,6,768,1111,145,2,407,1116,6,775,1128,145,2,635,
407,1131,6,782,1142,1,2,59,200,0,278,2,243,6,790,1146,
1,2,59,136,266,140,6,801,1150,1,2,2,10,127,7000,6,
810,1158,1,2,2,16,127,7000,6,819,1162,1,2,88,199,278,
2,76,55,6,828,1166,1,2,88,195,278,2,76,55,6,839,
1170,1,2,2,32,371,6,850,1176,1,2,67,178,109,178,113,
261,6,858,1183,1,2,239,63,6,869,1186,1,2,59,200,10,
277,3,174,7,174,48,6,876,1192,1,2,2,0,2,6999,140,
6,890,1195,1,2,2,1,2,6999,804,2,6999,59,136,178,140,
6,900,1200,1,2,200,0,278,4,2,45,903,6,916,1205,1,
2,2,0,122,7000,467,109,122,7000,467,76,879,903,113,6,928,
1207,1,2,931,88,247,277,-4,6,946,1210,1,2,84,2,6999,
59,136,59,243,266,6,956,1213,1,2,59,109,793,2,0,893,
949,113,919,959,6,969,1217,1,2,972,430,853,6,984,1219,1,
2,109,972,113,67,178,418,430,6,992,1222,1,2,2,0,893,
949,959,430,853,6,1004,1225,1,2,109,2,0,893,949,959,113,
67,178,418,430,6,1016,1229,1,2,121,987,6,1032,1231,1,2,
148,210,148,178,214,6,1039,1237,1,2,1042,148,126,2,4,214,
6,1049,1239,1,2,148,140,2,1,214,6,1060,1242,1,2,1042,
148,483,6,1070,1249,1,2,1073,2,0,1052,6,1078,1258,145,2,
407,1265,6,1087,1289,1,2,1073,1052,387,487,972,407,1295,6,1094,
1300,145,2,635,407,1303,6,1106,1318,1,2,76,67,126,174,4,
126,6,1114,1321,1,2,59,174,4,121,76,121,6,1125,1324,148,
3,76,109,109,6,1136,1328,148,3,113,113,76,6,1144,1332,1,
2,2,5,105,2,5,105,6,1152,1337,148,5,113,117,76,59,
109,6,1163,1341,1,2,122,7000,205,10,278,4,987,25,2,1007,
6,1173,1344,1,2,144,274,8,59,100,1176,174,-1,25,-8,6,
1188,1347,1,2,1191,144,278,4,55,25,-5,6,1203,1350,145,2,
407,1353,6,1215,1365,145,2,635,407,1368,6,1222,1379,145,2,635,
407,1382,6,1230,1397,145,2,635,407,1402,6,1238,1425,1,2,519,
206,0,278,5,363,1432,430,40,6,1246,1444,1,2,363,1450,1249,
6,1260,1452,1,2,363,1459,1249,6,1268,1461,1,2,274,8,527,
278,5,363,1468,430,40,6,1276,1482,1,2,2,0,2,0,531,
55,539,55,6,1290,1489,1,2,535,59,200,0,278,5,363,1494,
430,40,6,1303,1507,1,2,531,278,5,363,1514,430,40,6,1318,
1527,1,2,523,278,5,363,1535,430,40,6,1330,1549,1,2,160,
511,1279,6,1342,1561,145,2,113,55,6,1350,1568,1,2,2,10,
438,2,10,354,555,278,5,363,1570,430,40,6,1357,1579,145,2,
635,635,96,407,1582,407,1582,6,1375,1585,145,2,635,407,1589,6,
1387,1628,1,2,363,1637,666,6,1395,1650,1,2,659,407,1653,407,
1657,29,6,1403,1662,145,2,635,407,1667,6,1414,1683,145,2,407,
1690,6,1422,1727,145,2,407,1736,6,1429,1770,1,2,2,1776,379,
278,4,375,25,2,55,363,1783,666,6,1436,1797,148,2,84,55,
6,1453,1803,1,2,101,2,101,2,101,2,6,1460,1808,148,2,
84,84,6,1471,1814,148,2,92,92,6,1478,1819,1,2,59,243,
266,266,6,1485,1827,1,2,59,174,-97,262,26,278,3,174,-32,
6,1494,1834,1,2,67,173,76,6,1508,1841,1,2,507,358,205,
-1,277,5,350,371,25,-8,160,511,1293,6,1516,1846,145,2,350,
1497,174,-64,219,127,2,394,375,6,1534,1853,1,2,109,972,113,
67,178,2,0,831,2,0,313,6,363,1857,430,324,-4,430,6,
1548,1859,1,2,174,-33,262,94,6,1571,1866,145,2,407,1868,6,
1580,1880,1,2,2,10,438,6,1587,1889,1,2,88,109,109,174,
1,76,399,113,113,140,6,1595,1895,1,2,174,-32,262,95,6,
1610,1902,1,2,206,0,278,2,6,174,-1,88,173,136,1574,278,
-12,174,1,6,1619,1912,145,2,407,1915,6,1639,1921,145,2,407,
1924,6,1646,1930,148,3,113,55,109,6,1653,1933,148,3,113,173,
109,6,1661,1937,1,2,2,0,383,6,1669,1943,6,7004,1677,1947,
1,2,59,200,0,6,1681,1951,1,2,2,0,507,350,511,6,
1689,1955,1,2,2,0,507,1590,511,71,842,109,76,117,399,113,
6,1699,1962,1,2,59,174,-48,262,10,278,5,174,-48,25,19,
59,248,32,174,-97,262,26,278,7,248,32,174,-87,25,4,55,
2,-1,6,1716,1969,1,2,96,109,109,273,33,67,136,1719,59,
122,7000,261,278,23,2,0,113,122,7000,463,113,122,7000,183,173,
455,109,109,109,174,1,113,174,-1,25,-32,55,113,113,96,6,
1750,1977,1,2,2,1,543,362,6,1795,1984,1,2,1590,84,358,
205,-1,205,0,6,1804,1991,145,2,2,41,438,430,6,1816,1994,
1,2,174,1,2,0,543,59,174,1,2,0,547,547,6,1825,
2003,145,2,2,32,434,379,276,5,363,966,430,40,200,0,278,
4,1828,25,7,2,394,375,2,374,375,6,1842,2013,1,2,2,
7,543,543,2,0,109,274,32,59,174,1,543,362,59,174,1,
113,173,109,117,2,72,195,278,8,367,59,174,1,113,55,109,
430,2,1,418,543,25,-32,113,278,-42,6,1870,2019,1,182,2019,
7088,16,16,0,0,0,0,0,0,0,1870,-1,-1,-1,-1,-1,
-1,-1,1918,2026,1,2,148,2,7000,1042,148,178,214,2,10,1052,
2,0,1052,2,0,1052,2,0,1052,2,0,1052,2,0,1052,2,
0,1052,2,0,1052,2,0,1052,2,0,1052,2,0,1052,2,0,
1052,2,0,1052,2,0,1052,2,0,1052,2,0,1052,2,0,1052,
2,0,1052,2,0,1052,2,0,1052,2,0,1052,2,0,1052,148,
831,148,178,214,1921,6,

};

char CS[CHARACTERROOM];

union { double Double; long Long; short Short[4]; } u;

cell rack[RETURN_STACK_CELLS], *R = rack;
cell stack[STACK_CELLS], *S = stack, top;
double fstack[FSTACK_CELLS], *F = fstack, ftop; /* floating point stack */

unsigned int current, context, last, link, I;
int colevel, finger, here, leaves, level, progress, state = FALSE;
int shelf = wall;
int dataspace, namespace;
int latest, previous, preceding;
int localname = LOCALNAME;
int anonymous = FALSE;

FILE * file[maxfiles];
char* cpps[maxfiles]; /* Character Pointer Pointer Stack */
char* cpp = CS; /* Character Pointer Pointer */
char* cp = CS; /* Character Pointer */
int files = 0;

jmp_buf jmpbuf;

static void literalize(int normally, int literally);

/* Optimize:	n `$1'    x n `$1'    */

static void (nestingcheck)(void);
static void (stackcheck)(void);

/* This is sacred.*/

/* The following are placed here to be easy to find. */

/* CURRENT */

void interpret(int n)
{
	code[(CODEROOM - 100)] = n;
	code[(CODEROOM - 100) + 1] = 6;
	*++R = I, I = (CODEROOM - 100);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* : EXPOUND BEGIN filterexecute AGAIN ; */

static void literalize(int normally, int literally)
{
	if (! state)
		interpret(normally);
	else if (previous == 2)
		latest = code[next-2] = literally, previous = preceding;
	else
		latest = c(normally);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Stack Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:	n PICK    */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Data Space Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:	x @    */

/* Optimize:	x !    */

/* Optimize:	x +!    */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Status Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Arithmetic and Logical Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:	n LSHIFT    x n LSHIFT    */

/* Optimize:	 n +    x n +    x + n +    0 +   */

/* Optimize:	 n -    x n -    x + n -    0 -    SWAP -    */

/* Optimize:	x n *    b *    1 *    */

/* Optimize:	x n /    1 /    */

/* Optimize:	n <    */

/* Optimize:	n =    n OVER =    DUP n =   */

/* Optimize:	n ALIGNED    */

/* Optimize:	n AND    x n AND    */

/* Optimize:	n CELLS    */

/* Optimize:	b MOD    */

/* Optimize:	n OR    x n OR    */

/* Optimize:	n RSHIFT   x n RSHIFT    */

/* Optimize:	n U<    */

/* Optimize:	n UNDER+    */

/* Optimize:	n XOR    x n XOR    */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Control Flow */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:
	{ DUP   ?DUP   0=   DUP 0=   ?DUP 0=   0<> } { IF WHILE UNTIL }
*/
void condition(void)
{
	if (previous == 59)

		latest = operation = 273;

	else if (previous == 80)

		latest = operation = 274;

	else if (previous == 2 && operand == 0)

		-- next, latest = operation = 25;

	else if (previous == 205 && operand == 0) {

		if (preceding == 59)

			next -= 2, latest = operation = 275;

		else if (preceding == 80)

			next -= 2, latest = operation = 276;

		else if (preceding == 205 && code[next - 3] == 0)

			/* Must be the next to last test. */

			next -= 3, latest = operation = 278;

		else

			-- next, latest = operation = 277;

	} else

		latest = c(278);

}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:	1 +LOOP   */

void rake(void)
{	/* Gather the leaves.*/
	int n = next;
	top = - top;
	if (code[top])
		c(top - n);
	else
		c(top + 1 - n), code[top] = next - top;
	for ( ; leaves > top; leaves = n)
		n = code[leaves], code[leaves] = next - leaves;
	pop;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Optimize:	n >BODY   [] x >BODY    '*/

/* Optimize:	n COUNT    C" ccc" COUNT    */

void literal(void)
{
	if (! state) return ;
	if (isshort(top))
		latest = c(2), c(top);
	else
		u.Long = top, latest = c(395),
			c(u.Short[0]), c(u.Short[1]);
	pop;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* CONSTANT DOES> */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* File primitives. */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Implementation Words */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* This file is for your custom primitives. */

#define HI

int main(int argc, char ** argv)
{ /* Skeleton for the Kernel */
	register xt;
	register int n;
	register int c;
	int d;
	cell w;
	char *charp;

	pargc = argc, pargv = argv;
	data(NAMEROOM) = 10;
	finger = 2029;
	next = 2025;
	current = 0, code[next] = code[16] = last = 1941;
	code[CURRENT] = code[CONTEXT] = 16;
	here = NAMEROOM + sizeof(cell);

	if (stream() == NULL) return EXIT_FAILURE ;
# ifdef HI
	unchar(EOL), unchar('I'), unchar('H');
# endif
	switch (setjmp(jmpbuf))
	{
	case 0: case 1: break;
	case 2: return EXIT_SUCCESS;
	default: return EXIT_FAILURE;
	}
	I = 30;
	R = rack;
	rack[0] = 0;
	for (;/* ever */;) { /* INNER INTERPRETER */
		xt = code[I++]; /* Number of codes = 198 */
		RECURSE: switch(code[xt++]) { /* NATIVE OPERATIONS */
			case 0: /* NAME -1 */ /* For literals */
	push code[I++];
break;
case 1: /*   -1 */ /* For ordinary words */
	if (! state)
		interpret(xt);
	else
		latest = c(xt);
break;
case 2: /*   -1 */ /* For nesting */
	nestingcheck();
	*++R = I, I = xt;
break;
case 3: /* exit 6 */
	stackcheck();
	I = *R--;
break;
case 4: /*   24 */
{
	char * pp;

	if (state) preceding = previous, previous = latest ;
	filterword(pocket);
	lookup(link, pocket);
	if (link) {
		latest = xt = code(link);
		recurse;
	}
	pp = (char *) &name[pocket + 1];
	w = tonumber(pp, &charp, data(NAMEROOM));
	if (* charp == EOS)
		push w, literal();
	else if (pp != charp && charp[0] == '.' && charp[1] == EOS)
		push w, literal(), push w < 0 ? -1 : 0, literal();
	else if (pp != charp && strchr("+-*/,<=>", charp[0]) != NULL) {
		push w, literal();
		unchar(SPACE);
		for (n = strlen(charp); n; unchar(charp[--n])) ;
	} else {

			HUH ;
	}
}
break;
case 5: /*   25 */ I += code[I]; break;
case 6: /*   25 */
		push code[xt], literal();
	break;
case 7: /*   25 */
		u.Short[0] = code[xt++], u.Short[1] = code[xt],
			push u.Long, literal();
	break;
case 8: /* quit 36 */ restart(); break;
case 9: /* abort 40 */
	type(&name[source+1], name[source]);
	S = stack; top = *S = 0;
	restart();
break;
case 10: /* bye 44 */ longjmp(jmpbuf, 2); break;
case 11: /* ; 47 */ COMPILE_ONLY
	if (leaves) sorry("leave ?") ;
	if
	( previous != 25
	&& previous != 6
	&& previous != 36
	&& previous != 40
	&& previous != 44
	)
		c(6);
	state = FALSE;
	if (current && code[current + 1]) code[code[CURRENT]] = current ;
	code[next] = last = current ;
	if (level != S - stack)
		type(&name[code[current +1]+1],name[code[current+1]]),
			fprintf(usrout, " (Incomplete) " ) ;
	here = aligned(here);
	if (next >= (CODEROOM - 100))
		sorry("(Code space exceeded)");
	if (finger >= wall - sizeof(cell))
		sorry("(Name space exceeded)");
break;
case 12: /* : 51 */
	adopt(1), c(2);
	last = code[last];
	level = S - stack;
	leaves = 0;
	state = TRUE;
break;
case 13: /* drop 55 */ pop; break;
case 14: /* dup 59 */ *++S = top; break;
case 15: /* nip 63 */ S--; break;
case 16: /* over 67 */ push S[-1]; break;
case 17: /* rot 70 */
	if (! state) interpret(71); else
	if (previous == 71)
		latest = code[next-1] = 72, previous = preceding;
	else if (previous == 72)
		--next, latest = preceding, previous = 0;
	else latest = c(71); break;
case 18: /*   71 */
		w = S[-1], S[-1] = *S, *S = top, top = w;
	break;
case 19: /*   72 */
		w = top, top = *S, *S = S[-1], S[-1] = w;
	break;
case 20: /* swap 76 */ w = top, top = *S, *S = w; break;
case 21: /* ?dup 80 */ if (top) *++S = top ; break;
case 22: /* 2drop 84 */ S--, pop; break;
case 23: /* 2dup 88 */ w = *S, *++S = top, *++S = w; break;
case 24: /* 2over 92 */ push S[-2], w = S[-3], *++S = w; break;
case 25: /* 2swap 96 */
	w = S[-1], S[-1] = top, top = w;
	w = S[-2], S[-2] = *S, *S = w;
break;
case 26: /* pick 99 */

	literalize(100, 101); break;
case 27: /*   100 */ top = S[-top]; break;
case 28: /*   101 */ push S[-code[I++]]; break;
case 29: /* roll 105 */
	for (n = top, top = S[-top]; n; --n)
		S[-n] = S[-(n - 1)];
	S--;
break;
case 30: /* >r 109 */ *++R = top, pop; break;
case 31: /* r> 113 */  push *R--; break;
case 32: /* r@ 117 */ push *R; break;
case 33: /* @ 120 */

	literalize(121, 122); break;
case 34: /*   121 */ top = data(top); break;
case 35: /*   122 */ push data(code[I++]); break;
case 36: /* ! 125 */

	literalize(126, 127); break;
case 37: /*   126 */ data(top) = *S--, pop; break;
case 38: /*   127 */ data(code[I++]) = top, pop; break;
case 39: /* +! 130 */

	literalize(131, 132); break;
case 40: /*   131 */ data(top) += *S--, pop; break;
case 41: /*   132 */ data(code[I++]) += top, pop; break;
case 42: /* c@ 136 */ top = data[top]; break;
case 43: /* c! 140 */ data[top] = *S--, pop; break;
case 44: /* depth 144 */ push S - stack - 1; break;
case 45: /* here 148 */ push here; break;
case 46: /* nesting 152 */ push R - rack; break;
case 47: /* outside 156 */ push S - stack - 1 - level; break;
case 48: /* source-id 160 */ push files ? (cell) usrin : 0; break;
case 49: /* unused 164 */ push DATAROOM - here; break;
case 50: /* lshift 167 */ if (state && (2 == previous && 2 == preceding))
		push code[next-3] << code[next-1],
		next -= 4, previous = 0, literal();
	else

	literalize(168, 169); break;
case 51: /*   168 */ top = *S-- << top; break;
case 52: /*   169 */ top = top << code[I++]; break;
case 53: /* + 172 */
	if (! state) interpret(173); else
	if (previous == 2) {
		if (preceding == 2) {
			w = code[next-3] + code[next-1];
			if (isshort(w))
				next -= 2, operand = w, latest = 2;
			else
				push w, next -= 4, literal(), latest = c(173);
			previous = 0;
		} else if (preceding == 174) {
			w = code[next-3] + code[next-1];
			if (w == 0)
				next -= 4, latest = 0;
			else if (isshort(w))
				next -= 2, operand = w, latest = 174;
			else
				next -= 4, push w, literal(), latest = c(173);
			previous = 0;
		} else {
			if (operand == 0)
				next += -2, latest = preceding, previous = 0;
			else
				latest = code[next-2] = 174,
					previous = preceding;
		}
	}
	else latest = c(173); break;
case 54: /*   173 */ top += *S--; break;
case 55: /*   174 */ top += code[I++]; break;
case 56: /* - 177 */
	if (! state) interpret(178); else
	if (previous == 2 && operand != SHRT_MIN) {
		operand = -operand, xt = latest = 172;
		recurse;
		/*NOTREACHED*/
	} else if (previous == 76)
		latest = operation = 179, previous = preceding;
	else latest = c(178); break;
case 57: /*   178 */ top = *S-- - top; break;
case 58: /*   179 */ top -= *S--; break;
case 59: /* * 182 */
	if (! state) interpret(183); else
	if (previous == 2) {
		if (preceding == 2)
			push operand, next += -2,
				top *= operand, next += -2,
					previous = 0, literal();
		else if ((operand & operand - 1) == 0) {
			for (n = 0; (operand = (unsigned) operand >> 1) != 0; ++ n)
				;
			if (n)
				latest = code[next-2] = 169, operand = n;
			else
				next -= 2, latest = previous, previous = preceding;
		} else
			c(183);
	}
	else latest = c(183); break;
case 60: /*   183 */ top *= *S--; break;
case 61: /* / 186 */
	if (! state) interpret(187); else
	if (previous == 2) {
		if (operand == 1)
			next -= 2, latest = preceding, previous = 0;
		else if (preceding == 2)
			push code[next-3] / code[next-1],
				next -= 4, previous = 0, literal();
		else
			latest = c(187);
	}
	else latest = c(187); break;
case 62: /*   187 */ top = top ? *S-- / top : (S--, 0) ; break;
case 63: /* 2/ 191 */ top = (signed long) top >> 1; break;
case 64: /* > 195 */ top = *S-- > top LOGICAL; break;
case 65: /* < 198 */

	literalize(199, 200); break;
case 66: /*   199 */ top = *S-- < top LOGICAL; break;
case 67: /*   200 */ top = top < code[I++] LOGICAL; break;
case 68: /* = 203 */
	if (! state) interpret(204); else
	if (previous == 2) {
		if (preceding == 59)
			-- next,
				latest = code[next-2] = 204 + 2,
					operand = code[next], previous = 0;
		else
			latest = code[next-2] = 204 + 1, previous = preceding;
	} else if (previous == 67 && preceding == 2)  {
		-- next; latest = code[next-2] = 204 + 2, previous = 0;
	}
	else latest = c(204); break;
case 69: /*   204 */ top = *S-- == top LOGICAL; break;
case 70: /*   205 */ top = top == code[I++] LOGICAL; break;
case 71: /*   206 */ push top == code[I++] LOGICAL; break;
case 72: /* aligned 209 */
	if (! state) interpret(210); else
	if (previous == 2)
		operand = aligned(operand),
			latest = 2,
				previous = preceding;
	else latest = c(210); break;
case 73: /*   210 */ top = aligned(top); break;
case 74: /* allot 214 */ here += top, pop; break;
case 75: /* and 217 */ if (state && (2 == previous && 2 == preceding))
		push code[next-3] & code[next-1],
		next -= 4, previous = 0, literal();
	else

	literalize(218, 219); break;
case 76: /*   218 */ top &= *S--; break;
case 77: /*   219 */ top &= code[I++]; break;
case 78: /* cells 222 */
	if (! state) interpret(223); else
	if (previous == 2)
		push operand, next += -2, top *= sizeof(cell),
			previous = preceding, literal();
	else latest = c(223); break;
case 79: /*   223 */ top *= sizeof(cell); break;
case 80: /* compare 227 */ /* c-addr1 u1 c-addr2 u2 -- n */
/*
Compare the string specified by c-addr1 u1 to the string specified by
c-addr2 u2.

The strings are compared, beginning at the given addresses, character by
character, up to the length of the shorter string or until a difference
is found.

If the two strings are identical, n is zero.

If the two strings are identical up to the length of the shorter string,
n is minus-one (-1) if u1 is less than u2 and one (1) otherwise.

If the two strings are not identical up to the length of the shorter
string, n is minus-one (-1) if the first non-matching character in the
string specified by c-addr1 u1 has a lesser numeric value than the
corresponding character in the string specified by c-addr2 u2 and one
(1) otherwise.
*/
	n = S[-1] < top ? S[-1] : top;
	d = memcmp((char *) &data[S[-2]], (char *) &data[*S], n);
	if (d == 0 && S[-1] != top)
		d = S[-1] < top ? -1 : 1;
	S -= 3;
	top = d;
break;
case 81: /* mod 230 */
	if (! state) interpret(231); else
	if (previous == 2 && (operand & operand - 1) == 0)
		latest = code[next-2] = 219,
			-- operand, previous = preceding;
	else latest = c(231); break;
case 82: /*   231 */ top = top ? *S-- % top: *S--; break;
case 83: /* /mod 235 */
	if (top != 0)
		w = *S / top, *S -= w * top, top = w;
break;
case 84: /* SCALE 239 */
	scale();
break;
case 85: /* negate 243 */ top = -top; break;
case 86: /* or 246 */ if (state && (2 == previous && 2 == preceding))
		push code[next-3] | code[next-1],
		next -= 4, previous = 0, literal();
	else

	literalize(247, 248); break;
case 87: /*   247 */ top |= *S--; break;
case 88: /*   248 */ top |= code[I++]; break;
case 89: /* rshift 251 */
	if (state && (2 == previous && 2 == preceding))
		w = code[next - 3],
			push (unsigned long) w >> code[next-1],
				next -= 4, previous = 0, literal();
	else
		literalize(252, 253);
break;
case 90: /*   252 */ top = (unsigned long) *S-- >> top; break;
case 91: /*   253 */ top = (unsigned long) top >> code[I++]; break;
case 92: /* u> 257 */ top = LOWER(top, *S) LOGICAL; S--; break;
case 93: /* u< 260 */

	literalize(261, 262); break;
case 94: /*   261 */ top = LOWER(*S, top) LOGICAL; S--; break;
case 95: /*   262 */ top = LOWER(top, code[I]) LOGICAL; I++; break;
case 96: /* under+ 265 */

	literalize(266, 267); break;
case 97: /*   266 */ S[-1] += top, pop; break;
case 98: /*   267 */ *S += code[I++]; break;
case 99: /* xor 270 */ if (state && (2 == previous && 2 == preceding))
		push code[next-3] ^ code[next-1],
		next -= 4, previous = 0, literal();
	else

	literalize(271, 272); break;
case 100: /*   271 */ top ^= *S--; break;
case 101: /*   272 */ top ^= code[I++]; break;
case 102: /*   273 */ I += top ? 1 : code[I]; break;
case 103: /*   274 */ I += top ? 1 : (pop, code[I]); break;
case 104: /*   275 */ I += top ? code[I] : 1; break;
case 105: /*   276 */ I += top ? code[I] : (pop, 1); break;
case 106: /*   277 */ I += top ? code[I]: 1, pop; break;
case 107: /*   278 */ I += top ? 1 : code[I], pop; break;
case 108: /* if 281 */ SELF_COMPILE
	condition();
	push next, c(0);
break;
case 109: /* else 284 */ COMPILE_ONLY
	c(25);
	if (top <= 0 || code[top]) HOW ;
	w = top, top = next, c(0);
	code[w] = next - w;
break;
case 110: /* then 287 */ COMPILE_ONLY
	if (top <= 0 || top >= next || code[top]) HOW ;
	code[top] = next - top, pop;
							COMPLETE
break;
case 111: /* case 290 */ SELF_COMPILE
	push 0;
break;
case 112: /* esac 293 */ COMPILE_ONLY
	while (top) {
		if (top <= 0 || top >= next || code[top]) HOW ;
		code[top] = next - top, pop;
	}
	pop; COMPLETE
break;
case 113: /* begin 296 */ SELF_COMPILE
	push next;
break;
case 114: /* while 299 */ COMPILE_ONLY
	condition();
	*++S = next, c(0);
break;
case 115: /* until 302 */ COMPILE_ONLY
	if (previous == 2 && operand)
		next -= 2;
	else {
		condition();
		n = next, c(top - n);
	}
	if (top <= 0 || ! code[top]) HOW ;
	pop; COMPLETE
break;
case 116: /* repeat 305 */ COMPILE_ONLY
	c(25);
	if (top <= 0 || ! code[top]) HOW ;
	w = next, c(top - w), pop;
	if (top <= 0 || code[top]) HOW ;
	code[top] = next - top, pop;
							COMPLETE
break;
case 117: /* do 308 */ SELF_COMPILE
	c(309), push -next;
break;
case 118: /*   309 */
		*++R = *S, *++R = top - *S--, pop;
	break;
case 119: /* ?do 312 */ SELF_COMPILE
	c(313), push -next, c(0);
break;
case 120: /*   313 */
		I += top == *S ? code[I]
			: (*++R = *S, *++R = top - *S, 1),
				S--, pop;
	break;
case 121: /* unloop 317 */
	R -= 2;
break;
case 122: /* leave 320 */ COMPILE_ONLY
	c(317), c(25), c(leaves);
	leaves = next - 1;
break;
case 123: /* loop 323 */  COMPILE_ONLY
	if (top >= 0) HOW ;
	c(324);
	rake(); COMPLETE
break;
case 124: /*   324 */
		if ((++ * R) == 0)
			++ I, R -= 2;
		else
			I += code[I];
	break;
case 125: /* +loop 327 */ COMPILE_ONLY
	if (previous == 2 && operand == 1) {
		next -= 2;
		xt = latest = 323, previous = preceding;
		recurse;
	}
	if (top >= 0) HOW ;
	c(328);
	rake(); COMPLETE
break;
case 126: /*   328 */
		w = *R, *R += top;
		if ((w ^ *R) < 0 && (w ^ top) < 0)
			++ I, R -= 2;
		else
			I += code[I];
		pop;
	break;
case 127: /* i 332 */ push R[0] + R[-1]; break;
case 128: /* j 336 */ push R[-2] + R[-3]; break;
case 129: /* Left Parenthesis 339 */
	if (state) latest = previous, previous = preceding ;
	while (
		(c = char()) != ')'
	&&
		c != EOF
	&&
		! (usrin == stdin && c == EOL)
	) ;
break;
case 130: /* >body 342 */
	if (! state) interpret(343); else
	if (previous == 2)
		operand = code[operand + 1],
			latest = 2,
				previous = preceding;
	else latest = c(343); break;
case 131: /*   343 */ top = code[top + 1]; break;
case 132: /* c\" 346 */
	parse(QUOTE);
	if (! state)
		push shelve();
	else {
		latest = c(2);
		stringcompile();
	}
break;
case 133: /* get-char 350 */ *++S = top, top = char(); break;
case 134: /* stack-char 354 */ unchar(top), pop; break;
case 135: /* next-char 358 */
	*++S = top, top = char();
	if (top != EOF) unchar(top) ;
break;
case 136: /* count 361 */

	literalize(362, 363); break;
case 137: /*   362 */ *++S = top + 1; top = data[top]; break;
case 138: /*   363 */ w = code[I++];	push data[w]; *++S = w + 1
; break;
case 139: /* cr 367 */ emit(EOL); break;
case 140: /* emit 371 */ emit(top); pop; break;
case 141: /* execute 375 */ xt = top, pop; recurse; break;
case 142: /* find 379 */
	memcpy(&name[finger], &name[top], name[top] + 1);
	lookup(link, finger);
	if (link)
		*++S = code(link),
			top = code[code(link)] == 1 ? -1 : 1;
	else
		push 0;
break;
case 143: /* fill 383 */
	memset(data + S[-1], top, *S), S -= 2, pop;
break;
case 144: /* immediate 387 */
	if (code[code(last)] == 1)
		code[code(last)] = 145;
	else if (code[code(last)] == 6)
		code[code(last)] = 146;
	else
		sorry("(Can't be made IMMEDIATE)") ;
break;
case 145: /*   387 */ recurse; break;
case 146: /*   387 */ push code[xt]; break;
case 147: /* inline 391 */
	if (code[code(last)] != 1 || code[code(last) + 1] != 2)
		HOW ;
	/* Set immediate behavior to copy compiled code to object. */
	code[code(last)] = 148;
	code[code(last) + 1] = next - 3 - code(last);
break;
case 148: /*   391 */
		if (state)
			for (n = 0; n < code[xt]; ++ n)
				c(code[xt + 1 + n]);
		else
			*++R = I, I = xt + 1;
	break;
case 149: /* literal 394 */ literal(); break;
case 150: /*   395 */
		u.Short[0] = code[I++], u.Short[1] = code[I++], push u.Long;
	break;
case 151: /* move 399 */
	move(&data[*S], &data[S[-1]], top), S -= 2, pop;
break;
case 152: /* :noname 403 */
	current = next, dataspace = here, namespace = finger;
	c(0), c(0); push next;
	c(1), c(2);
	level = S - stack;
	leaves = 0;
	state = TRUE;
break;
case 153: /* please 406 */ SELF_COMPILE
	c(407);
	n = 0;
	do d = char(); while (! isgraph(d)) ;
	while ((c = char()) != d && c != EOF) {
		if (n < COUNTED_STRING_MAX)
			name[++ n + finger] = c ;
		if (c == EOL) {
			while (isspace(c = char())) ;
			unchar(c);
		}
	}
	name[finger] = n;

	stringcompile();
	COMPLETE
break;
case 154: /*   407 */
		latest = previous, previous = preceding;
		d = 1; /* Non-zero */
		for (n = name[code[I]]; n; -- n)
			if ((c = name[code[I] + n]) != PARAMETER)
				unchar(c);
			else if (n > 1
			&& name[code[I] + n - 1] == PARAMETER)
				unchar(PARAMETER), -- n;
			else
				for (d = top; d > 0; )
					unchar(data[* S + --d]);
		I++;
		if (! d) S-- , pop ;
	break;
case 155: /* recurse 410 */ COMPILE_ONLY
	c(code(current) + 1);
break;
case 156: /* search-wordlist 414 */ /* c-addr u wid -- 0 | xt 1 | xt -1 */
/*
Find the definition identified by the string c-addr u in the word list
identified by wid . If the definition is not found, return zero. If
the definition is found, return its execution token xt and one (1) if
the definition is immediate, minus-one (-1) otherwise.
*/
	/* Make counted string at finger from S[-1],*S */
	move(&name[finger + 1], &data[S[-1]], data[* S]);
	name[finger] = *S--, S--;
	monocase(finger);
	source = finger;
	if ((link = searchwordlist(&name[finger], top)) != 0)
		*++S = code(link),
			top = code[code(link)] == 1 ? -1 : 1;
	else
		top = 0;
break;
case 157: /* spaces 418 */
	while (top-- > 0) emit(SPACE) ;
	pop;
break;
case 158: /* state 422 */
	data(wall - sizeof(cell)) = state;
	push wall - sizeof(cell);
break;
case 159: /* time&date 426 */
{
	struct tm * broken_down_time;
	time_t time_now;

	time_now = time(NULL);
	broken_down_time = localtime(&time_now);
	push broken_down_time->tm_sec;
	push broken_down_time->tm_min;
	push broken_down_time->tm_hour;
	push broken_down_time->tm_mday;
	push broken_down_time->tm_mon + 1;
	push broken_down_time->tm_year + 1900;
}
break;
case 160: /* type 430 */ type(&data[*S--], top), pop; break;
case 161: /* word 434 */
	parseword(top);
	top = shelve();
break;
case 162: /* parse 438 */
	parse(top);
	*++S = shelve() + 1, top = name[*S - 1];
break;
case 163: /* sliteral 441 */
	if (state) {
		/* Make counted string at finger from *S,top */
		move(&name[finger+1], &data[*S--], top);
		name[finger] = top, pop;
		latest = c(363);
		stringcompile();
	}
break;
case 164: /* [ 444 */
	if (state) latest = previous, previous = preceding ;
	state = FALSE;
break;
case 165: /* \\ 447 */
	if (state) latest = previous, previous = preceding ;
	while ((c = char()) != EOF && c != EOL) ;
	unchar(EOL);
break;
case 166: /* ] 451 */ state = TRUE; break;
case 167: /* d+ 455 */
	S[-2] += *S;
	top += S[-1] + LOWER(S[-2], *S);
	S -= 2;
break;
case 168: /* d- 459 */
	top = S[-1] - top - LOWER(S[-2], *S);
	S[-2] -= *S;
	S -= 2;
break;
case 169: /* um* 463 */ umul(); break;
case 170: /* um/mod 467 */ udiv(); break;
case 171: /* m* 471 */ smul(); break;
case 172: /* sm/rem 475 */ sdiv(); break;
case 173: /* fm/mod 479 */ fdiv(); break;
case 174: /* constant 483 */
	if (isshort(top))
		adopt(6), c(top);
	else
		adopt(7),
			u.Long = top, c(u.Short[0]), c(u.Short[1]);
	pop;
	code[code[CURRENT]] = code[next] = last = current;
	here = aligned(here);
break;
case 175: /* does> 487 */
	if (code[code(last)] == 6) {
		code[next-2] = 175 + 1, c(175 + 2), c(I);
		code[next] = last = current;
	} else if (code[code(last)] == 175 + 1
	       || code[code(last)] == 175 + 3)
	{
		code[code(last) + 3] = I;
	} else if (code[code(last)] == 145 + 1)  {
		code[next-2] = 175 + 3, c(175 + 2), c(I);
		code[next] = last = current;
	} else HOW ;
	I = *R--;
break;
case 176: /*   487 */
		if (! state)
			interpret(++xt);
		else
			c(++xt);
	break;
case 177: /*   487 */
		push code[xt - 2];
		*++R = I, I = code[xt];
	break;
case 178: /*   487 */
		++xt; recurse;
	break;
case 179: /* | 491 */ if (anonymous) HOW ;
	anonymous = TRUE;
break;
case 180: /* || 495 */ if (anonymous) HOW ;
	for (link = code[code[CURRENT]]; localname != LOCALNAME; link = code[link]
)
		if (code[link + 1] >= LOCALNAME)
			localname = code[link + 1], code[link + 1] = 0;
	anonymous = FALSE;
break;
case 181: /* marker 503 */ if (anonymous) HOW ;
	adopt(1), c(182), c(namespace), c(here);
	for (n = 0; n < (24 - CURRENT); ++ n)
		c(code[CURRENT + n]);
	code[code[CURRENT]] = code[next] = last = current;
break;
case 182: /*   503 */
	next = xt - 4;
	finger = code[xt++];
	here = code[xt++];
	for (n = 0; n < (24 - CURRENT); ++ n)
		code[CURRENT + n] = code[xt++];
	code[code[CURRENT]] = last = current = code[next];
break;
case 183: /* stream 507 */
	cpps[files] = cpp, cpp = cp;
	file[files ++] = usrin;
	usrin = top ? (FILE *) top : stdin;
	pop;
break;
case 184: /* unstream 511 */
	if (files)
		usrin = file[--files],
			cp = cpp,
				cpp = cpps[files];
	else
		if (stream() == NULL)
			usrin = stdin;
break;
case 185: /* display 515 */
	usrout = top ? (FILE *) top : stdout;
	pop;
break;
case 186: /* fopen 519 */
{	/* Standard C Library */
	char filemode[4];
	/* Make NUL-terminated string at &name[pocket+1] from S[-2],S[-1] */
	move(&name[pocket + 1], &name[S[-2]], S[-1]),
		name[pocket + S[-1] + 1] = EOS,
			name[pocket] = S[-1];
	/* Make NUL-terminated string at filemode from *S,top */
	move(filemode, &name[* S], top), filemode[top] = EOS;
	S -= 3;
	top = (cell) fopen((char *)&name[pocket + 1], filemode);
}
break;
case 187: /* fflush 523 */ top = fflush((FILE *) top); break;
case 188: /* fclose 527 */
	top = (cell) fclose(top ? (FILE *) top : usrin);
break;
case 189: /* fseek 531 */
	if (! S[-1] || (FILE *) S[-1] == usrin) cp = cpp ;
	top = fseek(S[-1] ? (FILE *) S[-1] : usrin, *S, top);
	S -= 2;
break;
case 190: /* ftell 535 */
	top = ftell(top ? (FILE *) top : usrin) - (cp - cpp);
break;
case 191: /* error? 539 */ push errno, errno = 0; break;
case 192: /* has 543 */ top = code[top]; break;
case 193: /* patch 547 */ code[top] = *S--, pop; break;
case 194: /* argument 551 */
	if (++parg < pargc) {
		name[finger] = strlen(pargv[parg]);
		strcpy((char *) &name[finger + 1], pargv[parg]);
	} else
		name[finger] = 0;
	n = shelve();
	push name[n], *++S = n + 1;
break;
case 195: /* system 555 */
	/* Make NUL-terminated string at &name[finger] from *S,top */
	move(&name[finger], &name[*S--], top);
	name[finger + top] = EOS;
	top = system((char *) &name[finger]);
break;
case 196: /* [char] 558 */	/* Placed here for optimizing. */
        parseword(SPACE);
        push name[finger] ? name[finger+1] : EOL;
        literal();
break;
case 197: /* version 562 */
	fprintf(stderr, "%s   197 Primitives\n", sccsid);
	fprintf(stderr, "Used: Codespace %d, Namespace %d, Dataspace %d\n",
		next, finger, here);
break;

		default:
			fprintf(usrout, "(%ld: %ld ", I - 1, code[--xt]);
			sorry("(Trolley Error)");
		}
	}
}
