/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Version.h"

extern int	num_CWDFilHdrS;
extern int	num_DrvPthS;
extern int	num_DrvSpcS;
extern int	num_StrS;
extern int	num_FilHdrS;
extern int	num_FilElmS;
extern int	num_FilInpS;
extern int	num_PrmsS;
extern int	num_PosS;
extern int	num_NodS;
extern int	num_StackElmS;
extern int	num_PrmFHdrS;


boolean		Verify;
tp_Str		EditorName;


Init_Vars()
{
   EditorName = getenv("EDITOR");
   if (EditorName == 0) EditorName = "vi";
   Verify = FALSE;
   }/*Init_Vars*/;


ShowVars()
{
   Writeln(StdOutFD, "Dir Editor ErrFile HelpLevel History HogSize LogFile LogLevel");
   Writeln(StdOutFD, "MaxSize MinSize Size Verify Version");
   }/*ShowVars*/;


HelpVar(Nod)
   tp_Nod Nod;
{
   tp_Str VarStr;

   VarStr = Sym_Str(Nod_Sym(Nod_Son(1, Nod)));
   /*select*/{
      if (strcasecmp(VarStr, "dir") == 0) {
	 Writeln(StdOutFD, "The current working directory.");
      }else if (strcasecmp(VarStr, "editor") == 0) {
	 Writeln(StdOutFD, "The default editor.");
      }else if (strcasecmp(VarStr, "errfile") == 0) {
	 Writeln(StdOutFD,
	  "       1: Error information sent to standard output.");
	 Writeln(StdOutFD,
	  "       2: Error information sent to standard error.");
	 Writeln(StdOutFD,
	  "filename: Error information sent to file named \"filename\".");
      }else if (strcasecmp(VarStr, "history") == 0) {
	 Writeln(StdOutFD,
	  "The number of lines displayed from the history file.");
      }else if (strcasecmp(VarStr, "helplevel") == 0) {
	 Writeln(StdOutFD,
	  "1: Help returns information for common file types.");
	 Writeln(StdOutFD, "2: Help returns information for all file types.");
      }else if (strcasecmp(VarStr, "hogsize") == 0) {
	 Writeln(StdOutFD,
	  "The size above which files have first priority for purging.");
      }else if (strcasecmp(VarStr, "logfile") == 0) {
	 Writeln(StdOutFD,
	  "       1: Log information sent to standard output.");
	 Writeln(StdOutFD,
	  "       2: Log information sent to standard error.");
	 Writeln(StdOutFD,
	  "filename: Log information sent to file named \"filename\".");
      }else if (strcasecmp(VarStr, "loglevel") == 0) {
	 Writeln(StdOutFD, "1: No log information is generated.");
	 Writeln(StdOutFD,
	  "2: Commands executed by scripts listed in LogFile.");
	 Writeln(StdOutFD,
	  "3: And names of objects generated by external tools.");
	 Writeln(StdOutFD,
	  "4: And names of objects generated by internal tools.");
	 Writeln(StdOutFD,
	  "5: And names of objects deleted.");
	 Writeln(StdOutFD,
	  "6: And names of objects touched by broadcast.");
      }else if (strcasecmp(VarStr, "maxsize") == 0) {
	 Writeln(StdOutFD,
	  "The maximum disk space (kilobytes) to be used by derived objects.");
      }else if (strcasecmp(VarStr, "minsize") == 0) {
	 Writeln(StdOutFD,
	  "A minimum value for MaxSize (will not decrease MaxSize).");
      }else if (strcasecmp(VarStr, "size") == 0) {
	 Writeln(StdOutFD,
	  "The current amount disk space (kilobytes) used by derived objects.");
      }else if (strcasecmp(VarStr, "verify") == 0) {
	 Writeln(StdOutFD,
	  "off: Assume all host system files modified through Odin.");
	 Writeln(StdOutFD,
	  "on : Check all host system files for external modification.");
      }else if (strcasecmp(VarStr, "version") == 0) {
	 Writeln(StdOutFD,
	  "The version of the Odin derived object manager.");
      }else{
	 Writeln(StdOutFD, "** Unknown variable name **");
	 };}/*select*/;
   }/*HelpVar*/;


ShowVar(Nod)
   tp_Nod Nod;
{
   tp_Str VarStr;
   tp_FilHdr FilHdr;
   tps_FileName FileName;

   VarStr = Sym_Str(Nod_Sym(Nod_Son(1, Nod)));
   /*select*/{
      if (strcasecmp(VarStr, "dir") == 0) {
	 FilHdr = Top_CWDFilHdr();
	 FilHdr_HostFN(FileName, FilHdr);
	 Ret_FilHdr(FilHdr);
	 Writeln(StdOutFD, FileName);
      }else if (strcasecmp(VarStr, "editor") == 0) {
	 Writeln(StdOutFD, EditorName);
      }else if (strcasecmp(VarStr, "errfile") == 0) {
	 Writeln(StdOutFD, ErrFileName);
      }else if (strcasecmp(VarStr, "history") == 0) {
	 WriteInt(StdOutFD, History);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "helplevel") == 0) {
	 WriteInt(StdOutFD, HelpLevel);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "hogsize") == 0) {
	 WriteInt(StdOutFD, HogSize/1000);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "logfile") == 0) {
	 Writeln(StdOutFD, LogFileName);
      }else if (strcasecmp(VarStr, "loglevel") == 0) {
	 WriteInt(StdOutFD, LogLevel);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "maxsize") == 0) {
	 WriteInt(StdOutFD, MaxSize/1000);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "minsize") == 0) {
	 WriteInt(StdOutFD, MaxSize/1000);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "size") == 0) {
	 WriteInt(StdOutFD, CurSize/1000);
	 Writeln(StdOutFD, "");
      }else if (strcasecmp(VarStr, "verify") == 0) {
	 Writeln(StdOutFD, (Verify ? "on" : "off"));
      }else if (strcasecmp(VarStr, "version") == 0) {
	 Writeln(StdOutFD, Odin_Version);

      }else if (strcmp(VarStr, "SIZES") == 0) {
	 (void)printf("num_CWDFilHdrS = %d\n", num_CWDFilHdrS);
	 (void)printf("num_DrvPthS = %d\n", num_DrvPthS);
	 (void)printf("num_DrvSpcS = %d\n", num_DrvSpcS);
	 (void)printf("num_StrS = %d\n", num_StrS);
	 (void)printf("num_FilHdrS = %d\n", num_FilHdrS);
	 (void)printf("num_FilElmS = %d\n", num_FilElmS);
	 (void)printf("num_FilInpS = %d\n", num_FilInpS);
	 (void)printf("num_PrmsS = %d\n", num_PrmsS);
	 (void)printf("num_PosS = %d\n", num_PosS);
	 (void)printf("num_NodS = %d\n", num_NodS);
	 (void)printf("num_StackElmS = %d\n", num_StackElmS);
	 (void)printf("num_PrmFHdrS = %d\n", num_PrmFHdrS);
      }else if (strcmp(VarStr, "SYMBOLS") == 0) {
	 Write_Syms(StdOutFD);
      }else if (strcmp(VarStr, "USERS") == 0) {
	 WriteInt(StdOutFD, UseCount);
	 Writeln(StdOutFD, "");

      }else{
	 Writeln(StdOutFD, "** Unknown variable name **");
	 };}/*select*/;
   }/*ShowVar*/;


SetVar(Nod)
   tp_Nod Nod;
{
   tp_Nod ValNod;
   tp_Str VarStr, ValStr;
   tps_FileName ValBuf;
   int MinSize, Size;
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr;
   tp_Prms Prms;

   VarStr = Sym_Str(Nod_Sym(Nod_Son(1, Nod)));
   ValNod = Nod_Son(2, Nod);
   /*select*/{
      if (Nod_Sym(ValNod) != NIL) {
	 ValStr = Sym_Str(Nod_Sym(ValNod));
      }else{
	 PrmFHdr = Nod_PrmFHdr(ValNod);
	 Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
	 if (FilHdr == ERROR) {
	    return; }/*if*/;
	 FilHdr_OdinName(ValBuf, FilHdr);
	 Ret_FilHdr(FilHdr);
	 ValStr = Sym_Str(Str_Sym(ValBuf)); };}/*select*/;
   /*select*/{
      if (strcasecmp(VarStr, "dir") == 0) {
	 Set_Dir(ValStr);
      }else if (strcasecmp(VarStr, "editor") == 0) {
	 EditorName = ValStr;
      }else if (strcasecmp(VarStr, "errfile") == 0) {
	 Set_ErrFile(ValStr);
      }else if (strcasecmp(VarStr, "helplevel") == 0) {
	 Set_HelpLevel(atoi(ValStr));
      }else if (strcasecmp(VarStr, "history") == 0) {
	 Set_History(atoi(ValStr));
      }else if (strcasecmp(VarStr, "hogsize") == 0) {
	 Size = atoi(ValStr);
	 /*select*/{
	    if (Size > 0) {
	       Set_HogSize(Size*1000);
	    }else{
	       Writeln(StdOutFD, "** Hog size must be positive **");
	       };}/*select*/;
      }else if (strcasecmp(VarStr, "logfile") == 0) {
	 Set_LogFile(ValStr);
      }else if (strcasecmp(VarStr, "loglevel") == 0) {
	 Set_LogLevel(atoi(ValStr));
      }else if (strcasecmp(VarStr, "maxsize") == 0) {
	 Size = atoi(ValStr);
	 /*select*/{
	    if (Size > 0 || strcmp(ValStr, "00") == 0) {
	       Set_MaxSize(Size*1000);
	    }else{
	       Writeln(StdOutFD, "** Maximum size must be positive **");
	       };}/*select*/;
      }else if (strcasecmp(VarStr, "minsize") == 0) {
	 MinSize = atoi(ValStr)*1000;
	 if (MinSize > MaxSize) Set_MaxSize(MinSize);
      }else if (strcasecmp(VarStr, "size") == 0) {
	 Writeln(StdOutFD, "** Size is a read-only variable **");
      }else if (strcasecmp(VarStr, "verify") == 0) {
	 /*select*/{
	    if (strcasecmp(ValStr, "off") == 0) {
	       Set_Verify(FALSE);
	    }else if (strcasecmp(ValStr, "on") == 0) {
	       Set_Verify(TRUE);
	    }else{
	       Writeln(StdOutFD, "** \"off\" or \"on\" **"); };}/*select*/;

      }else if (strcmp(VarStr, "DEBUG") == 0) {
	 Set_Debug(ValStr);
      }else if (strcmp(VarStr, "USERS") == 0) {
	 UseCount = atoi(ValStr);
	 if (UseCount <= 0) {
	    UseCount = 1;
	    Writeln(StdOutFD, "Users must be at least 1"); }/*if*/;
	 WriteUseCount(UseCount);

      }else{
	 Writeln(StdOutFD, "** Unknown variable name **");
	 };}/*select*/;
   }/*SetVar*/;


