/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FKind_.h"
#include "inc/RunSpc.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"
#include "inc/Str.h"


Do_Update(SignalPtr, RunSpc, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_RunSpc RunSpc;
   tp_Status Status;
   boolean IsRestore;
{
   tp_Status NewStatus;
   int i;
   tp_FilHdr FilHdr;
   tps_FileName WorkFileName;

   FORBIDDEN(IsStructMem(RunSpc->FilHdr) && IsAtmc(RunSpc->FilHdr));

   if (IsStruct(RunSpc->FilHdr)) {
      Update_Struct(SignalPtr, RunSpc->FilHdr, Status, IsRestore);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*if*/;
   for (i=0; i<RunSpc->NumOuts; i++) {
      NewStatus = Status;
      FilHdr = Copy_FilHdr(RunSpc->OutFilHdrs[i]);
      if (NewStatus == STAT_Error
	  && FilHdr_FKind(FilHdr) == FK_User
	  && IsErrOK(FilHdr_FilTyp(FilHdr))) {
	 NewStatus = STAT_Warning; }/*if*/;
      /*select*/{
	 if (IsAtmc(FilHdr)) {
	    I_WorkFileName(WorkFileName, i);
	    Update_File(SignalPtr, FilHdr, NewStatus, WorkFileName, IsRestore);
	 }else{
	    Update_RefFile(SignalPtr, FilHdr, NewStatus, IsRestore);
	    };}/*select*/;
      Ret_FilHdr(FilHdr);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*for*/;
   }/*Do_Update*/;


Do_Compound(SignalPtr, RunSpc, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_RunSpc RunSpc;
   tp_Status Status;
   boolean IsRestore;
{
   int i;
   tp_FilHdr FilHdr, ElmFilHdr;
   tp_LocElm FirstLocElm, LastLocElm, LocElm;
   tp_FilTyp ElmFilTyp;
   tps_FileName WorkFileName, WorkDirFileName, InFileName;
   tps_Str Key;
   tp_FilDsc WorkDirFilDsc;
   boolean End;
   tp_Status NewStatus;

   if (IsStruct(RunSpc->FilHdr)) {
      Update_Struct(SignalPtr, RunSpc->FilHdr, Status, IsRestore);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*if*/;
   for (i=0; i<RunSpc->NumOuts; i++) {
      NewStatus = Status;
      FilHdr = Copy_FilHdr(RunSpc->OutFilHdrs[i]);
      if (NewStatus == STAT_Error && IsErrOK(FilHdr_FilTyp(FilHdr))) {
	 NewStatus = STAT_Warning; }/*if*/;
      /*select*/{
	 if (IsAtmc(FilHdr)) {
	    I_WorkFileName(WorkFileName, i);
	    Update_File(SignalPtr, FilHdr, NewStatus, WorkFileName, IsRestore);
	 }else if (IsDrvDir(FilHdr)) {
	    FirstLocElm = 0; LastLocElm = 0;
	    I_WorkDirFileName(WorkDirFileName, i);
	    WorkDirFilDsc = OpenDir(WorkDirFileName);
	    ReadDir(Key, &End, WorkDirFilDsc);
	    while (!End) {
	       (void)strcpy(InFileName, WorkDirFileName);
	       (void)strcat(InFileName, "/");
	       (void)strcat(InFileName, Key);
	       ElmFilHdr = Do_Key(Copy_FilHdr(FilHdr), Key);
	       ElmFilTyp = FilHdr_FilTyp(ElmFilHdr);
	       /*select*/{
		  if (IsCmpd_FilTyp(ElmFilTyp) || IsPntr_FilTyp(ElmFilTyp)) {
		     Do_Cmpd(SignalPtr, InFileName, ElmFilHdr, NewStatus,
			     IsRestore);
		  }else{
		     Update_File(SignalPtr, ElmFilHdr, NewStatus, InFileName,
				 IsRestore);
		     };}/*select*/;
	       if (*SignalPtr != NIL) {
		  Ret_FilHdr(ElmFilHdr);
		  Ret_FilHdr(FilHdr);
		  CloseDir(WorkDirFilDsc);
		  return; }/*if*/;
	       LocElm = Make_LocElm(ElmFilHdr, DfltPrms, FilHdr);
	       Ret_FilHdr(ElmFilHdr);
	       Chain_LocElms(&FirstLocElm, &LastLocElm, LocElm);
	       ReadDir(Key, &End, WorkDirFilDsc); }/*while*/;
	    CloseDir(WorkDirFilDsc);
	    Set_LocElm(FilHdr, FirstLocElm);
	    Update_RefFile(SignalPtr, FilHdr, NewStatus, IsRestore);
	 }else{
	    I_WorkFileName(WorkFileName, i);
	    Do_Cmpd(SignalPtr, WorkFileName, FilHdr, NewStatus, IsRestore);
	    };}/*select*/;
      Ret_FilHdr(FilHdr);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*for*/;
   }/*Do_Compound*/;


Do_Cmpd(SignalPtr, WorkFileName, FilHdr, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_FileName WorkFileName;
   tp_FilHdr FilHdr;
   tp_Status Status;
   boolean IsRestore;
{
   tps_FileName ErrorFileName;
   tp_FileName OldErrFileName;
   tp_Status NewStatus;
   boolean Err_Flag;

   FORBIDDEN(IsDrvDir(FilHdr));

   NewStatus = Status;
   if (NewStatus > STAT_Error) {
      OldErrFileName = ErrFileName; Set_ErrFile(ErrorFN);
      Set_LocElm(FilHdr, Exec_Compound(FilHdr, WorkFileName, FilHdr));
      if (IsPntr(FilHdr)) Validate_IsPntr(FilHdr);
      Err_Flag = IsErr();
      Set_ErrFile(OldErrFileName);
      /*select*/{
	 if (Err_Flag) {
	    FilHdr_ErrorFileName(ErrorFileName, FilHdr);
	    Rename(ErrorFN, ErrorFileName);
	    MakeReadOnly(ErrorFileName);
	    if (NewStatus > STAT_Error) NewStatus = STAT_Error;
	 }else if (Has_ErrorFile(FilHdr)) {
	    FilHdr_ErrorFileName(ErrorFileName, FilHdr);
	    Remove(ErrorFileName); };}/*select*/; }/*if*/;
   Update_RefFile(SignalPtr, FilHdr, NewStatus, IsRestore);
   }/*Do_Cmpd*/;


Validate_IsPntr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilElm FilElm;

   FilElm = LocElm_FilElm(FilHdr_LocElm(FilHdr));
   /*select*/{
      if (FilElm == NIL) {
	 FilHdr_Error("Empty pointer file : <%s>.\n", FilHdr);
      }else{
	 if (FilElm_Next(FilElm) != NIL) {
	    FilHdr_Error
	       ("Too many elements in pointer file : <%s>.\n", FilHdr);
	    }/*if*/;
	 Ret_FilElm(FilElm); };}/*select*/;
   }/*Validate_IsPntr*/;


Update_File(SignalPtr, FilHdr, Status, WorkFileName, IsRestore)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   tp_Status Status;
   tp_FileName WorkFileName;
   boolean IsRestore;
{
   tp_Status OldStatus;
   boolean Changed;
   tps_FileName DataFileName;
   tp_FilDsc WorkFD, DataFD;
   boolean Abort;

   FORBIDDEN(Status <= STAT_SysAbort);
   FilHdr_DataFileName(DataFileName, FilHdr);
   OldStatus = FilHdr_OldStatus(FilHdr);
   Changed = (Status != OldStatus || FilHdr_Purged(FilHdr));
   if (!Changed && IsSaved_FilTyp(FilHdr_FilTyp(FilHdr))) {
      WorkFD = FileName_RFilDsc(WorkFileName);
      if (WorkFD == ERROR) {
	 MakeEmptyFile(WorkFileName, &Abort);
	 FORBIDDEN(Abort);
	 WorkFD = FileName_RFilDsc(WorkFileName); }/*if*/;
      DataFD = FileName_RFilDsc(DataFileName);
      FORBIDDEN(DataFD == ERROR);
      Changed = !(Equal(WorkFD, DataFD));
      Close(WorkFD); Close(DataFD); }/*if*/;
   if (Changed) {
      Set_ModDate(FilHdr);
      Set_Size(FilHdr, FileSize(WorkFileName));
      Rename(WorkFileName, DataFileName);
      Clear_Purged(FilHdr);
      MakeReadOnly(DataFileName); }/*if*/;
   Set_UpToDate(SignalPtr, FilHdr, Status, IsRestore);
   }/*Update_File*/;


Update_RefFile(SignalPtr, FilHdr, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   tp_Status Status;
   boolean IsRestore;
{
   FORBIDDEN(Status <= STAT_SysAbort);
   if (!(Status == FilHdr_OldStatus(FilHdr)
	 && IsEquiv_LocElms(FilHdr_OldLocElm(FilHdr),
			    FilHdr_LocElm(FilHdr)))) {
      Set_ModDate(FilHdr);
      Set_ElmNameStatus(FilHdr, STAT_Unknown); }/*if*/;
   Set_OldLocElm(FilHdr);
   Set_UpToDate(SignalPtr, FilHdr, Status, IsRestore);
   }/*Update_RefFile*/;


Update_Struct(SignalPtr, FilHdr, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   tp_Status Status;
   boolean IsRestore;
{
   FORBIDDEN(FilHdr == ERROR || !IsStruct(FilHdr));
   if (Status != FilHdr_OldStatus(FilHdr)) {
      Set_ModDate(FilHdr); }/*if*/;
   Set_UpToDate(SignalPtr, FilHdr, Status, IsRestore);
   }/*Update_Struct*/;


Set_UpToDate(SignalPtr, FilHdr, Status, IsRestore)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   tp_Status Status;
   boolean IsRestore;
{
   FORBIDDEN(Status <= STAT_Unknown);
   *SignalPtr = NIL;
   if (IsRestore) {
      if (Status != FilHdr_Status(FilHdr)) {
	 Write(StdErrFD, "** Request Aborted : Host Files changed **\n");
	 Write(StdErrFD, "Use \"Verify = on\" before request.\n");
	 Flush(StdErrFD);
	 *SignalPtr = SIGNAL_Interrupt; }/*if*/;
      return; }/*if*/;
   Set_OldStatus(FilHdr, Status);
   Set_Status(FilHdr, Status);
   Set_ConfirmDate(FilHdr);
   }/*Set_UpToDate*/;


Set_CompoundConfirm(FilHdr, Status)
   tp_FilHdr FilHdr;
   tp_Status Status;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   Set_Status(FilHdr, Status);
   Set_ConfirmDate(FilHdr);
   if (IsDrvDir(FilHdr) && Status > STAT_Error) {
      LocElm = FilHdr_LocElm(FilHdr);
      while (LocElm != 0) {
	 FilElm = LocElm_FilElm(LocElm);
	 ElmFilHdr = FilElm_FilHdr(FilElm);
	 FORBIDDEN(ElmFilHdr == ERROR);
	 Set_Status(ElmFilHdr, Status);
	 Set_ConfirmDate(ElmFilHdr);
	 Ret_FilHdr(ElmFilHdr);
	 LocElm = FilElm_Next(FilElm);
	 Ret_FilElm(FilElm); }/*while*/; }/*if*/;
   }/*Set_CompoundConfirm*/;


Set_CompoundStatus(FilHdr, Status)
   tp_FilHdr FilHdr;
   tp_Status Status;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   Set_Status(FilHdr, Status);
   if (IsDrvDir(FilHdr) && Status > STAT_Error) {
      LocElm = FilHdr_LocElm(FilHdr);
      while (LocElm != 0) {
	 FilElm = LocElm_FilElm(LocElm);
	 ElmFilHdr = FilElm_FilHdr(FilElm);
	 FORBIDDEN(ElmFilHdr == ERROR);
	 Set_Status(ElmFilHdr, Status);
	 Ret_FilHdr(ElmFilHdr);
	 LocElm = FilElm_Next(FilElm);
	 Ret_FilElm(FilElm); }/*while*/; }/*if*/;
   }/*Set_CompoundStatus*/;


