/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/NodTyp_.h"
#include "inc/ParseKind_.h"
#include "inc/RunSpc.h"
#include "inc/Status_.h"
#include "inc/Str.h"


WriteCat(FilDsc, FilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilDsc InFD;
   tps_FileName FileName;
   tp_FilHdr ElmFilHdr;

   if (FilHdr_Status(FilHdr) <= STAT_Error) {
      Writeln(FilDsc, "--- bad cat elm ---");
      WriteOdinName(FilDsc, FilHdr);
      Writeln(FilDsc, "-------------------");
      return; }/*if*/;

   if (IsStruct(FilHdr)) {
      Writeln(FilDsc, "---  structure  ---");
      WriteStruct(FilDsc, FilHdr);
      Writeln(FilDsc, "-------------------");
      return; }/*if*/;

   if (!IsRef(FilHdr)) {
      FilHdr_DataFileName(FileName, FilHdr);
      InFD = FileName_RFilDsc(FileName);
      FORBIDDEN(InFD == ERROR);
      FileCopy(FilDsc, InFD);
      Close(InFD);
      return; }/*if*/;

   if (FilHdr_Flag(FilHdr, FLAG_Flat)) {
      FilHdr_Error("<%s> is cyclic.\n", FilHdr);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Flat);

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      WriteCat(FilDsc, ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   Clr_Flag(FilHdr, FLAG_Flat);
   }/*WriteCat*/;


WriteFlat(FilDsc, FilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tps_FileName FileName;
   tp_FilHdr ElmFilHdr;

   if (!IsOdinRef(FilHdr)) {
      FilHdr_DataFileName(FileName, FilHdr);
      Writeln(FilDsc, FileName);
      return; }/*if*/;

   if (FilHdr_Flag(FilHdr, FLAG_Flat)) {
      FilHdr_Error("<%s> is cyclic.\n", FilHdr);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Flat);

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      WriteFlat(FilDsc, ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;

   Clr_Flag(FilHdr, FLAG_Flat);
   }/*WriteFlat*/;


WriteNames(FilDsc, FilHdr, Prms)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   if (!IsOdinRef(FilHdr)) {
      WritePrmOdinName(FilDsc, FilHdr, Prms);
      return; }/*if*/;

   if (FilHdr_Flag(FilHdr, FLAG_Flat)) {
      FilHdr_Error("<%s> is cyclic.\n", FilHdr);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Flat);

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      WriteNames(FilDsc, ElmFilHdr, Union_Prms(FilElm_Prms(FilElm), Prms));
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;

   Clr_Flag(FilHdr, FLAG_Flat);
   }/*WriteNames*/;


WriteLabels(FilDsc, FilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;
   tps_Str Str;

   if (!IsOdinRef(FilHdr)) {
      Writeln(FilDsc, FilHdr_Label(Str, FilHdr));
      return; }/*if*/;

   if (FilHdr_Flag(FilHdr, FLAG_Flat)) {
      FilHdr_Error("<%s> is cyclic.\n", FilHdr);
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Flat);

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      WriteLabels(FilDsc, ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;

   Clr_Flag(FilHdr, FLAG_Flat);
   }/*WriteLabels*/;


Do_Union(FirstLocElmPtr, LastLocElmPtr, FilHdr, Prms, CmpdFilHdr)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm LocElm, NewLocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;
   tp_Prms ElmPrms;

   if (FilHdr_Flag(FilHdr, FLAG_Union)) {
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Union);

   if (!IsOdinRef(FilHdr)) {
      NewLocElm = Make_LocElm(FilHdr, Prms, CmpdFilHdr);
      Chain_LocElms(FirstLocElmPtr, LastLocElmPtr, NewLocElm);
      return; }/*if*/;

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      ElmPrms = Union_Prms(Prms, FilElm_Prms(FilElm));
      Do_Union(FirstLocElmPtr, LastLocElmPtr, ElmFilHdr, ElmPrms, CmpdFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*Do_Union*/;


Clr_ElmFlags(FilHdr, Flag)
   tp_FilHdr FilHdr;
   tp_Flag Flag;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   if (!FilHdr_Flag(FilHdr, Flag)) {
      return; }/*if*/;
   Clr_Flag(FilHdr, Flag);
   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      Clr_ElmFlags(ElmFilHdr, Flag);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*Clr_ElmFlags*/;


tp_LocElm
Exec_Compound(InpFilHdr, FileName, CmpdFilHdr)
   tp_FilHdr InpFilHdr;
   tp_FileName FileName;
   tp_FilHdr CmpdFilHdr;
{
   tp_FilDsc InFD;
   tp_LocElm FirstLocElm, LastLocElm, NewLocElm;
   tp_FilHdr ElmFilHdr;
   int LineCount;
   tp_Str Str;
   tps_Str StrBuf;
   tp_Nod DS_Nod;
   tp_PrmFHdr PrmFHdr;
   tp_Prms ElmPrms;

   Push_CWDFilHdr(FilHdr_SrcDirFilHdr(Copy_FilHdr(InpFilHdr)));

   FirstLocElm = 0; LastLocElm = 0;
   InFD = FileName_RFilDsc(FileName);
   if (InFD == ERROR) {
      SystemError(SystemErrorFD(), "Input file <%s> not found.\n", FileName);
      goto done; }/*if*/;
   for (Str = ReadLine(StrBuf, InFD), LineCount = 1;
	Str != ERROR;
	Str = ReadLine(StrBuf, InFD), LineCount += 1) {
      DS_Nod = Parse(FILE_PARSE, Str);
      if (DS_Nod == ERROR || Nod_NodTyp(DS_Nod) != NULLFL) {
	 PrmFHdr = Nod_PrmFHdr(DS_Nod);
	 Use_PrmFHdr(&ElmFilHdr, &ElmPrms, PrmFHdr);
	 /*select*/{
	    if (ElmFilHdr == ERROR) {
	       SystemError(SystemErrorFD(), "at line %d in request:\n   %s\n", LineCount, Str);
	    }else{
	       NewLocElm = Make_LocElm(ElmFilHdr, ElmPrms, CmpdFilHdr);
	       Ret_FilHdr(ElmFilHdr);
	       Chain_LocElms(&FirstLocElm, &LastLocElm, NewLocElm);
	       };}/*select*/; }/*if*/;
      Ret_Nod(DS_Nod); }/*for*/;
   if (!EndOfFile(InFD)) {
      SystemError(SystemErrorFD(), "Unexpected EOF at line %d in %s\n", LineCount, FileName);
      }/*if*/;
   Close(InFD);

done:;
   Pop_CWDFilHdr();
   return FirstLocElm;
   }/*Exec_Compound*/;


Exec_CopyCheck(InpLocElmPtr, DstLocElmPtr, RunSpc)
   tp_LocElm *InpLocElmPtr;
   tp_LocElm *DstLocElmPtr;
   tp_RunSpc RunSpc;
{
   tp_FilHdr InpFilHdr, DstFilHdr;
   tps_FileName FileName;
   tp_FilDsc InFD;
   tp_LocElm FirstLocElm1, LastLocElm1, FirstLocElm2, LastLocElm2, NewLocElm;
   int LineCount;
   tp_Str Str;
   tps_Str StrBuf;
   tp_Nod Nod;
   tp_PrmFHdr PrmFHdr;
   tp_Prms Prms;

   Push_CWDFilHdr(FilHdr_SrcDirFilHdr(Copy_FilHdr(RunSpc->InpFilHdrs[0])));
   FirstLocElm1 = 0; LastLocElm1 = 0;
   FirstLocElm2 = 0; LastLocElm2 = 0;
   FilHdr_DataFileName(FileName, RunSpc->InpFilHdrs[0]);
   InFD = FileName_RFilDsc(FileName);
   FORBIDDEN(InFD == ERROR);
   Str = ReadLine(StrBuf, InFD); LineCount = 1;
   while (Str != ERROR) {
      Nod = Parse(CMD_PARSE, Str);
      if (Nod == ERROR || Nod_NodTyp(Nod) != NULLCD) {
	 if (Nod != ERROR && Nod_NodTyp(Nod) != COPY) {
	    SystemError(SystemErrorFD(), "Must be Copy command ");
	    Nod = ERROR; }/*if*/;

	 PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Nod));
	 Use_PrmFHdr(&InpFilHdr, &Prms, PrmFHdr);
	 InpFilHdr = FilHdr_AtmFilHdr(InpFilHdr);

	 PrmFHdr = Nod_PrmFHdr(Nod_Son(2, Nod));
	 Use_PrmFHdr(&DstFilHdr, &Prms, PrmFHdr);

	 /*select*/{
	    if (InpFilHdr == ERROR || DstFilHdr == ERROR) {
	       SystemError(SystemErrorFD(), "at line %d in request:\n   %s\n", LineCount, Str);
	    }else{
	       NewLocElm
		= Make_LocElm(InpFilHdr, DfltPrms, RunSpc->OutFilHdrs[0]);
	       Chain_LocElms(&FirstLocElm1, &LastLocElm1, NewLocElm);
	       NewLocElm
		= Make_LocElm(DstFilHdr, DfltPrms, RunSpc->OutFilHdrs[1]);
	       Chain_LocElms(&FirstLocElm2, &LastLocElm2, NewLocElm);
	       };}/*select*/;
	 Ret_FilHdr(InpFilHdr); Ret_FilHdr(DstFilHdr); }/*if*/;
      Ret_Nod(Nod);
      Str = ReadLine(StrBuf, InFD); LineCount += 1; }/*while*/;
   FORBIDDEN(!EndOfFile(InFD));
   Close(InFD);
   Pop_CWDFilHdr();

   *InpLocElmPtr = FirstLocElm1; *DstLocElmPtr = FirstLocElm2;
   }/*Exec_CopyCheck*/;


WriteExpand(OutFilDsc, RefFilDsc, FilHdr)
   tp_FilDsc OutFilDsc, RefFilDsc;
   tp_FilHdr FilHdr;
{
   tps_FileName FileName;
   tp_FilDsc InFD;
   tp_Str Str;
   tps_Str StrBuf, Expansion;

   Push_CWDFilHdr(FilHdr_SrcDirFilHdr(Copy_FilHdr(FilHdr)));
   FilHdr_DataFileName(FileName, FilHdr);
   InFD = FileName_RFilDsc(FileName);
   FORBIDDEN(InFD == ERROR);
   Str = Readln(StrBuf, InFD);
   while (Str != ERROR) {
      /*select*/{
	 if (Has_Macro(Str)) {
	    Expand_MacroLine(Expansion, RefFilDsc, Str,
			     (tp_RunSpc)NIL, (tp_Tool)NIL,
			     (tp_PrmFTLst)NIL, (tp_OutTyps)NIL);
	    Writeln(OutFilDsc, Expansion);
	 }else if (OutFilDsc) {
	    Writeln(OutFilDsc, Str); };}/*select*/;
      Str = Readln(StrBuf, InFD); }/*while*/;
   FORBIDDEN(!EndOfFile(InFD));
   Close(InFD);
   Pop_CWDFilHdr();
   }/*WriteExpand*/;


WriteCmdRef(RefFilDsc, FilTyp, FilHdr)
   tp_FilDsc RefFilDsc;
   tp_FilTyp FilTyp;
   tp_FilHdr FilHdr;
{
   tps_FileName FileName;
   tp_FilDsc InFD;
   tp_Str Str;
   tps_Str StrBuf;
   tps_RunSpc _RunSpc; tp_RunSpc RunSpc = &_RunSpc;
   tp_Tool Tool;
   tp_PrmFTLst PrmFTLst;
   tps_OutTyps OutTyps;

   RunSpc->FilHdr = FilHdr;
   Tool = FilTyp_Tool(FilTyp);
   GetOutTyps(FilTyp, OutTyps, &RunSpc->NumOuts);
   PrmFTLst = Tool_PrmFTLst(Tool);
   Push_CWDFilHdr(FilHdr_SrcDirFilHdr(Copy_FilHdr(FilHdr)));
   FilHdr_DataFileName(FileName, FilHdr);
   InFD = FileName_RFilDsc(FileName);
   FORBIDDEN(InFD == ERROR);
   Str = Readln(StrBuf, InFD);
   while (Str != ERROR) {
      if (Has_Macro(Str)) {
	 Expand_MacroLine
	    ((tp_Str)NIL, RefFilDsc, Str, RunSpc, Tool, PrmFTLst, OutTyps);
	 }/*if*/;
      Str = Readln(StrBuf, InFD); }/*while*/;
   FORBIDDEN(!EndOfFile(InFD));
   Close(InFD);
   Pop_CWDFilHdr();
   }/*WriteCmdRef*/;

