/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/InpKind_.h"
#include "inc/Status_.h"
#include "inc/Str.h"


static tp_FilDsc	StatusFD;
static tp_Status	SearchStatus;
static boolean		Search;


GetReport(CurFilHdr, Status, FilDsc)
   tp_FilHdr CurFilHdr;
   tp_Status Status;
   tp_FilDsc FilDsc;
{
   SearchStatus = Status;
   StatusFD = FilDsc;

   FORBIDDEN(Search);
   Search = TRUE;
   GetStats(CurFilHdr, IK_Trans, CurFilHdr);
   Search = FALSE;
   GetStats(CurFilHdr, IK_Trans, CurFilHdr);
   }/*GetReport*/;


GetStats(FilHdr, InpKind, CmpdFilHdr)
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
   tp_FilHdr CmpdFilHdr;
{
   tp_Status Status;
   tp_FilHdr NewCmpdFilHdr;

   FORBIDDEN(FilHdr == ERROR);

   if (!NeedsData(FilHdr, InpKind)) {
      return; }/*if*/;

   /*select*/{
      if (Search) {
	 if (FilHdr_Flag(FilHdr, FLAG_Report)) {
	    return; }/*if*/;
	 Set_Flag(FilHdr, FLAG_Report);
      }else{
	 if (!FilHdr_Flag(FilHdr, FLAG_Report)) {
	    return; }/*if*/;
	 Clr_Flag(FilHdr, FLAG_Report); };}/*select*/;

   Status = FilHdr_Status(FilHdr);
   NewCmpdFilHdr = (Status <= STAT_NoFile ? CmpdFilHdr : FilHdr);

   if (Status <= SearchStatus) {
      Get_InputStatFiles(FilHdr, NewCmpdFilHdr); }/*if*/;

   /*select*/{
      if (NeedsElmsData(FilHdr, InpKind)
	  && FilHdr_ElmStatus(FilHdr) <= SearchStatus) {
	 Get_TransStatFiles(FilHdr, TRUE, NewCmpdFilHdr);
      }else if (InpKind_IsTransName(InpKind)
		&& FilHdr_ElmNameStatus(FilHdr) <= SearchStatus) {
	 Get_TransStatFiles(FilHdr, FALSE, NewCmpdFilHdr); };}/*select*/;

   if (Search && (FilHdr_Status(FilHdr) <= SearchStatus)
       && (!(IsStructMem(FilHdr) || IsDrvDirElm(FilHdr))
	   || Has_ErrorFile(FilHdr))) {
      Report_StatusVal(StatusFD, FilHdr, SearchStatus, NewCmpdFilHdr); }/*if*/;
   }/*GetStats*/;


Get_InputStatFiles(FilHdr, CmpdFilHdr)
   tp_FilHdr FilHdr, CmpdFilHdr;
{
   tp_LocInp LocInp;
   tp_FilInp FilInp;
   tp_FilHdr InpFilHdr;

   if (IsSource(FilHdr)) return;

   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      GetStats(InpFilHdr, FilInp_InpKind(FilInp), CmpdFilHdr);
      Ret_FilHdr(InpFilHdr);
      LocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp); }/*while*/;
   }/*Get_InputStatFiles*/;


Get_TransStatFiles(FilHdr, DataFlag, CmpdFilHdr)
   tp_FilHdr FilHdr;
   boolean DataFlag;
   tp_FilHdr CmpdFilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   if (!IsRef(FilHdr)) return;
   if (FilHdr_Status(FilHdr) > STAT_Error) {
      LocElm = FilHdr_LocElm(FilHdr);
      while (LocElm != 0) {
	 FilElm = LocElm_FilElm(LocElm);
	 ElmFilHdr = FilElm_FilHdr(FilElm);
	 FORBIDDEN(ElmFilHdr == ERROR);
	 if (DataFlag || IsRef(ElmFilHdr)) {
	    GetStats(ElmFilHdr, (DataFlag ? IK_Trans : IK_TransName),
		     CmpdFilHdr); }/*if*/;
	 Ret_FilHdr(ElmFilHdr);
	 LocElm = FilElm_Next(FilElm);
	 Ret_FilElm(FilElm); }/*while*/; }/*if*/;
   }/*Get_TransStatFiles*/;


Report_StatusVal(FilDsc, FilHdr, Status, CmpdFilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
   tp_Status Status;
   tp_FilHdr CmpdFilHdr;
{
   tp_Status FilHdrStatus;
   tps_Str OdinName;
   tps_FileName WarningFileName, ErrorFileName;
   tp_FilDsc StatFD;

   FilHdrStatus = FilHdr_Status(FilHdr);
   FORBIDDEN(FilHdrStatus == ERROR);
   if (FilHdrStatus == STAT_Unknown && Status >= STAT_Unknown) {
      Write(FilDsc, "--- <");
      FilHdr_OdinName(OdinName, FilHdr);
      Write(FilDsc, OdinName);
      Writeln(FilDsc, "> has unknown status ---");
      return; }/*if*/;
   if (FilHdrStatus == STAT_SysAbort) {
      return; }/*if*/;
   if (FilHdrStatus == STAT_NoFile && Status >= STAT_NoFile) {
      /*select*/{
         if (CmpdFilHdr != FilHdr) {
	    Write(FilDsc, "--- <");
	    FilHdr_OdinName(OdinName, CmpdFilHdr);
	    Write(FilDsc, OdinName);
	    Write(FilDsc, "> uses <");
	    FilHdr_OdinName(OdinName, FilHdr);
	    Write(FilDsc, OdinName);
	    Writeln(FilDsc, "> which does not exist ---");
 	 }else{
            Write(FilDsc, "--- <");
	    FilHdr_OdinName(OdinName, FilHdr);
	    Write(FilDsc, OdinName);
	    Writeln(FilDsc, "> does not exist ---"); };}/*select*/;
      return; }/*if*/;
   if (FilHdrStatus == STAT_NoRead && Status >= STAT_NoRead) {
      Write(FilDsc, "--- <");
      FilHdr_OdinName(OdinName, FilHdr);
      Write(FilDsc, OdinName);
      Writeln(FilDsc, "> does not have read permission set ---");
      return; }/*if*/;
   if (FilHdrStatus == STAT_Circular && Status >= STAT_Circular) {
      Write(FilDsc, "--- <");
      FilHdr_OdinName(OdinName, FilHdr);
      Write(FilDsc, OdinName);
      Writeln(FilDsc, "> depends on itself ---");
      return; }/*if*/;

   if (Status < STAT_Error) {
      return; }/*if*/;
   if (Has_ErrorFile(FilHdr)) {
      Write(FilDsc, "--- <");
      FilHdr_OdinName(OdinName, FilHdr);
      Write(FilDsc, OdinName);
      Writeln(FilDsc, "> generated errors ---");
      FilHdr_ErrorFileName(ErrorFileName, FilHdr);
      StatFD = FileName_RFilDsc(ErrorFileName);
      FORBIDDEN(StatFD == ERROR);
      FileCopy(FilDsc, StatFD);
      Close(StatFD); }/*if*/;

   if (Status < STAT_Warning) {
      return; }/*if*/;
   if (Has_WarningFile(FilHdr)) {
      Write(FilDsc, "--- <");
      FilHdr_OdinName(OdinName, FilHdr);
      Write(FilDsc, OdinName);
      Writeln(FilDsc, "> generated warnings ---");
      FilHdr_WarningFileName(WarningFileName, FilHdr);
      StatFD = FileName_RFilDsc(WarningFileName);
      FORBIDDEN(StatFD == ERROR);
      FileCopy(FilDsc, StatFD);
      Close(StatFD); }/*if*/;
   }/*Report_StatusVal*/;


ReportStatus(FilHdr)
   tp_FilHdr FilHdr;
{
   switch(FilHdr_MinStatus(FilHdr)) {
      case STAT_Unknown: {
	 FilHdr_Error("<%s> is not up-to-date.\n", FilHdr);
	 break;}/*case*/;
      case STAT_SysAbort: {
	 FilHdr_Error("System abort status set for <%s>.\n", FilHdr);
	 break;}/*case*/;
      case STAT_NoFile: {
	 /*select*/{
	    if (FilHdr_Status(FilHdr) == STAT_NoFile) {
	       FilHdr_Error("<%s> does not exist.\n", FilHdr);
	    }else{
	       FilHdr_Error("An element of <%s> does not exist.\n", FilHdr);
	       };}/*select*/; break;}/*case*/;
      case STAT_NoRead: {
	 /*select*/{
	    if (FilHdr_Status(FilHdr) == STAT_NoFile) {
	       FilHdr_Error("Cannot read <%s>.\n", FilHdr);
	    }else{
	       FilHdr_Error("Cannot read an element of <%s>.\n", FilHdr);
	       };}/*select*/; break;}/*case*/;
      case STAT_Circular: {
	 /*select*/{
	    if (FilHdr_Status(FilHdr) == STAT_Circular) {
	       FilHdr_Error("<%s> depends on itself.\n", FilHdr);
	    }else{
	       FilHdr_Error("An element of <%s> depends on itself.\n", FilHdr);
	       };}/*select*/; break;}/*case*/;
      case STAT_Error: {
	 FilHdr_Error("Error status set for <%s>.\n", FilHdr);
	 break;}/*case*/;
      case STAT_Warning: {
	 FilHdr_Error("Note: Warning status set for <%s>.\n", FilHdr);
	 break;}/*case*/;
      case STAT_OK: {
	 break;}/*case*/;
      default: {
	 FatalError("bad FilHdr status"); };}/*switch*/;
   }/*ReportStatus*/;


