/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/PrmClass_.h"
#include "inc/Parm.h"


tp_LocPrm		DfltLocPrm = 1;


tp_LocPrm
Alloc_Parm()
{
   return (tp_LocPrm) Alloc(sizeof(tps_Parm));
   }/*Alloc_Parm*/;


boolean
Equal_Parm(Parm1, Parm2)
   tp_Parm Parm1, Parm2;
{
   FORBIDDEN(Parm1 == ERROR || Parm2 == ERROR);
   return (Parm1->PrmInf.PrmClass == Parm2->PrmInf.PrmClass
	   && Parm1->PrmInf.IPrmFT == Parm2->PrmInf.IPrmFT
	   && Parm1->PrmVal == Parm2->PrmVal
	   && Parm1->PrmInf.LocHdr == Parm2->PrmInf.LocHdr);
   }/*Equal_Parm*/;


Print_Parm(Parm)
   tp_Parm Parm;
{
   tp_FilTyp FilTyp;
   tp_FTName FTName;
   tps_FileName FileName, DirName;
   tp_FilDsc PrmFilDsc, FilDsc;
   tp_FilHdr FilHdr;
   boolean Abort;
   tp_Prms Prms;

   FORBIDDEN(Parm == ERROR);

   FilTyp = IFilTyp_FilTyp(Parm->PrmInf.IPrmFT);
   FTName = FilTyp_FTName(FilTyp);
   Get_PrmFileName(FileName, FTName);

   switch (Parm->PrmInf.PrmClass) {
      case PC_Boolean: {
	 MakePlnFile(FileName, &Abort);
	 FORBIDDEN(Abort);
	 break;}/*case*/;
      case PC_String: {
	 PrmFilDsc = FileName_AFilDsc(FileName);
	 Writeln(PrmFilDsc, Parm->PrmVal);
	 Close(PrmFilDsc);
	 break;}/*case*/;
      case PC_File: {
	 FilHdr = LocHdr_FilHdr(Parm->PrmInf.LocHdr);
	 Deref_Pntrs(&FilHdr, &Prms, FilHdr, FALSE);
	 FORBIDDEN(FilHdr == ERROR);
	 Make_ElmData(FilHdr);
	 PrmFilDsc = FileName_AFilDsc(FileName);
	 FilHdr_DataFileName(FileName, FilHdr);
	 /*select*/{
	    if (IsParameter_FilTyp(FilTyp)) {
	       FilDsc = FileName_RFilDsc(FileName);
	       FileCopy(PrmFilDsc, FilDsc);
	       Close(FilDsc);
	    }else{
	       Writeln(PrmFilDsc, FileName); };}/*select*/;
	 Close(PrmFilDsc);
	 if (FilTyp_Mark(FilTyp)) {
	    Get_LinkedPrmInputDirName(DirName, FTName);
	    LinkCmpdFile(DirName, FilHdr); }/*if*/;
	 Ret_FilHdr(FilHdr);
	 break;}/*case*/;
      default: {
	 FatalError("bad PrmClass"); };}/*switch*/;
   }/*Print_Parm*/;



