/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include "inc/GMC.h"
#include "inc/Filename.h"

extern char *getwd();


MakeDirFile(FileName, AbortPtr)
   tp_FileName FileName;
   boolean *AbortPtr;
{
   struct stat buf;
   int status;
   tps_FileName DirName;
   int i;

   *AbortPtr = FALSE;
   if (FileName == ERROR) fatal_err("bad arg to MakeDirFile");
   status = stat(FileName, &buf);
   if (status == 0) {
      if ((buf.st_mode & S_IFDIR) != S_IFDIR) fatal_err("file must be a dir");
      return; }/*if*/;
   status = mkdir(FileName, 0777);
   if (status != 0) {
      i = strlen(FileName) - 2;
      while (i > 0 && FileName[i] != '/') i -= 1;
      if (i < 1) {
	 SystemError(SystemErrorFD(), "Could not create <%s>.\n", FileName);
	 *AbortPtr = TRUE;
	 return; }/*if*/;
      (void)strcpy(DirName, FileName);
      DirName[i] = 0;
      MakeDirFile(DirName, AbortPtr);
      if (*AbortPtr) {
	 return; }/*if*/;
      status = mkdir(FileName, 0777);
      if (status != 0) {
	 SystemError(SystemErrorFD(), "Could not create <%s>.\n", FileName);
	 *AbortPtr = TRUE;
	 return; }/*if*/; }/*if*/;
   }/*MakeDirFile*/;


#ifdef _AIX

#include "inc/Filename.h"
char *
getwd(FileName)
   tp_FileName FileName;
{
   return getcwd(FileName, MAX_FileName);
   }/*getwd*/;

#endif


GetWorkingDir(DirName)
   tp_FileName DirName;
{
   char *WDstat;
   static char *auto_mount_root = "/tmp_mnt";
   int i, j;

   WDstat = getwd(DirName);
   FORBIDDEN(WDstat == 0);
   if (strncmp(DirName, auto_mount_root, strlen(auto_mount_root)) == 0) {
      for (i=strlen(auto_mount_root),j=0; DirName[i]!=0; i+=1,j+=1) {
	 DirName[j] = DirName[i]; }/*for*/;
      DirName[j] = 0; }/*if*/;
   }/*GetWorkingDir*/;


ChangeDir(AbortPtr, DirName)
   boolean *AbortPtr;
   tp_FileName DirName;
{
   int status;

   status = chdir(DirName);
   *AbortPtr = (status != 0);
   }/*ChangeDir*/;


MakePlnFile(FileName, AbortPtr)
   tp_FileName FileName;
   boolean *AbortPtr;
{
   int status, fd, i;
   struct stat buf;
   tps_FileName DirName;

   if (FileName == ERROR) fatal_err("bad arg to MakePlnFile");

   status = stat(FileName, &buf);
   if (status == 0) {
      if ((buf.st_mode & S_IFREG) != S_IFREG) {
	 SystemError(SystemErrorFD(), "<%s> is a directory.\n", FileName);
	 *AbortPtr = TRUE; }/*if*/;
      *AbortPtr = FALSE;
      return; }/*if*/;

   fd = creat(FileName, 0666);
   if (fd < 0) {
      (void)strcpy(DirName, FileName);
      i=strlen(DirName)-1;
      while (i > 0 && DirName[i] != '/') i -= 1;
      if (i <= 0) {
	 SystemError(SystemErrorFD(), "Could not create <%s>.\n", FileName);
	 *AbortPtr = TRUE;
	 return; }/*if*/;
      DirName[i] = 0;
      MakeDirFile(DirName, AbortPtr);
      if (*AbortPtr) {
	 return; }/*if*/;
      fd = creat(FileName, 0666);
      if (fd < 0) {
	 SystemError(SystemErrorFD(), "Could not create <%s>.\n", FileName);
	 *AbortPtr = TRUE;
	 return; }/*if*/; }/*if*/;

   (void)close(fd);
   *AbortPtr = FALSE;
   }/*MakePlnFile*/;


MakeEmptyFile(FileName, AbortPtr)
   tp_FileName FileName;
   boolean * AbortPtr;
{
   tp_FilDsc FilDsc;
   
   FilDsc = FileName_WFilDsc(FileName);
   if (FilDsc == ERROR) {
      SystemError(SystemErrorFD(), "Could not empty <%s>.\n", FileName);
      *AbortPtr = TRUE;
      return; }/*if*/;
   Close(FilDsc);
   *AbortPtr = FALSE;
   }/*MakeEmptyFile*/;


MakeExecFile(FileName)
   tp_FileName FileName;
{
   int status, fd;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to MakeExecFile");
   status = stat(FileName, &buf);
   if (status == 0) {
      if ((buf.st_mode & S_IEXEC) != S_IEXEC) {
	 status = chmod(FileName, 0777);
	 if (status != 0) fatal_err("could not chmod"); }/*if*/;
      return; }/*if*/;
   fd = creat(FileName, 0777);
   if (fd < 0) fatal_err("cannot make file");
   (void)close(fd);
   }/*MakeExecFile*/;


MakeReadOnly(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to MakeReadOnly");
   status = stat(FileName, &buf);
   FORBIDDEN(status != 0);
   status = chmod(FileName, ((int)buf.st_mode | 0444) & 0555);
   if (status != 0) fatal_err("could not chmod");
   }/*MakeReadOnly*/;


MakeReadWrite(FileName, AbortPtr)
   tp_FileName FileName;
   boolean *AbortPtr;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to MakeReadWrite");
   *AbortPtr = FALSE;
   status = stat(FileName, &buf);
   FORBIDDEN(status != 0);
   status = chmod(FileName, (int)buf.st_mode | 0666);
   if (status != 0) {
      SystemError(SystemErrorFD(), "Could not set write permission for <%s>.\n", FileName);
      *AbortPtr = TRUE; }/*if*/;
   }/*MakeReadWrite*/;


Link(ToFileName, FromFileName, AbortPtr)
   tp_FileName ToFileName, FromFileName;
   boolean *AbortPtr;
{
   int status;

   if (ToFileName == ERROR || FromFileName == ERROR) {
      fatal_err("bad arg to Link"); }/*if*/;
   *AbortPtr = FALSE;
   status = symlink(FromFileName, ToFileName);
   if (status != 0) {
      perror("symlink");
      SystemError(SystemErrorFD(), "Cannot make symbolic link from <%s> to <%s>.\n",
		  FromFileName, ToFileName);
      *AbortPtr = TRUE; }/*if*/;
   }/*Link*/;


IsLink_FileName(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   status = lstat(FileName, &buf);
   return (status == 0 && (buf.st_mode & S_IFLNK) == S_IFLNK);
   }/*IsLink_FileName*/;


FileName_LinkFileName(LinkFileName, FileName)
   tp_FileName LinkFileName, FileName;
{
   int cc;

   cc = readlink(FileName, LinkFileName, MAX_FileName);
   if (cc <= 0) fatal_err("could not get file link");
   LinkFileName[cc] = (char)0;
   }/*FileName_LinkFileName*/;


Copy_Mode(ToFileName, FromFileName, AbortPtr)
   tp_FileName ToFileName, FromFileName;
   boolean *AbortPtr;
{
   int status;
   struct stat buf;

   if (ToFileName == ERROR || FromFileName == ERROR) {
      fatal_err("bad arg to Copy_Mode"); }/*if*/;
   status = stat(FromFileName, &buf);
   if (status != 0) fatal_err("bad FromFile in Copy_Mode");
   status = chmod(ToFileName, (int)buf.st_mode);
   *AbortPtr = FALSE;
   if (status != 0) {
      *AbortPtr = TRUE;
      SystemError(SystemErrorFD(), "Could not copy mode to <%s>.\n", ToFileName); }/*if*/;
   }/*Copy_Mode*/;


boolean
IsDirectory_FileName(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   status = stat(FileName, &buf);
   return ((status == 0) && ((buf.st_mode & S_IFDIR) == S_IFDIR));
   }/*IsDirectory_FileName*/;


boolean
Exists(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to Exists");
   status = stat(FileName, &buf);
   return (status == 0);
   }/*Exists*/;


boolean
Link_Exists(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to Link_Exists");
   status = lstat(FileName, &buf);
   return (status == 0);
   }/*Link_Exists*/;


boolean
CanRead(FileName)
   tp_FileName FileName;
{
   if (FileName == ERROR) fatal_err("bad arg to CanRead");
   return (access(FileName, R_OK) == 0);
   }/*CanRead*/;


boolean
Empty(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to Empty");
   status = stat(FileName, &buf);
   if (status != 0) fatal_err("no such file");
   return (buf.st_size == 0);
   }/*Empty*/;


int
FileSize(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;
   boolean Abort;

   if (FileName == ERROR) fatal_err("bad arg to Size");
   status = stat(FileName, &buf);
   if (status != 0) {
      MakeEmptyFile(FileName, &Abort);
      FORBIDDEN(Abort);
      return 0; }/*if*/;
   return buf.st_size;
   }/*FileSize*/;


Remove(FileName)
   tp_FileName FileName;
{
   int status;

   if (FileName == ERROR) fatal_err("bad arg to Remove");
   status = unlink(FileName);
   if (status != 0) SystemError(SystemErrorFD(), "<%s> could not be removed.\n", FileName);
   }/*Remove*/;


RemoveDir(DirName)
   tp_FileName DirName;
{
   int status;
   tps_FileName NFS_Hack;

   if (DirName == ERROR) fatal_err("bad arg to RemoveDir");
   status = rmdir(DirName);
   if (status != 0) {
      (void)sprintf(NFS_Hack, "rm -f %s/.nfs*", DirName);
      (void)system(NFS_Hack);
      status = rmdir(DirName);
      if (status != 0) SystemError(SystemErrorFD(), "<%s> could not be removed.\n", DirName);
      }/*if*/;
   }/*RemoveDir*/;


Rename(OldFileName, NewFileName)
   tp_FileName OldFileName, NewFileName;
{
   int status;

   if (OldFileName == ERROR  || NewFileName == ERROR) {
      fatal_err("bad arg to Rename"); }/*if*/;
   status = rename(OldFileName, NewFileName);
   if (status != 0) {
      SystemError(SystemErrorFD(), "Bad status from rename of <%s> to be <%s>.\n",
		  OldFileName, NewFileName);
      if (Exists(OldFileName) || !Exists(NewFileName)) fatal_err("");
      SystemError(SystemErrorFD(), "  (but it apparently worked).\n"); }/*if*/;
   }/*Rename*/;


int
ModTime(FileName)
   tp_FileName FileName;
{
   int status;
   struct stat buf;

   if (FileName == ERROR) fatal_err("bad arg to ModTime");
   status = lstat(FileName, &buf);
   if (status != 0) fatal_err("no such file");
   return (buf.st_mtime);
   }/*ModTime*/;


