/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <ctype.h>
#include "inc/GMC.h"
#include "inc/FKind_.h"
#include "inc/Filename.h"
#include "inc/FilHdr.h"
#include "inc/Str.h"


FilHdr_DataFileName(FileName, FilHdr)
   tp_FileName FileName;
   tp_FilHdr FilHdr;
{
#ifdef READABLE_CACHENAMES
   tps_Str StrBuf;
#endif
   boolean New_Flag, Abort;
   int Num;

   FORBIDDEN(FileName == ERROR || FilHdr == ERROR);
   /*select*/{
      if (IsSource(FilHdr)) {
	 FilHdr_HostFN(FileName, FilHdr);
      }else{
	 New_Flag = FALSE;
	 if (FilHdr->HdrInf.DataNum == 0) {
	    DataNum += 1;
	    FilHdr->HdrInf.DataNum = DataNum;
	    New_Flag = TRUE; }/*if*/;
	 (void)strcpy(FileName, CacheDirName);
	 Num = (FilHdr->HdrInf.DataNum-1) / 34;
	 if (Num > 0) {
	    Append_DataNum(FileName, Num-1);
	    if (New_Flag) {
	       MakeDirFile(FileName, &Abort);
	       if (Abort) FatalError("cannot make cache directory");
	       }/*if*/; }/*if*/;
#ifdef READABLE_CACHENAMES
	 (void)sprintf(Tail(FileName), "/%s.%d",
		       FilHdr_Label(StrBuf, FilHdr),
		       (int)FilHdr_LocHdr(FilHdr));
#else	 
	 (void)sprintf(Tail(FileName), "/%d", (int)FilHdr_LocHdr(FilHdr));
#endif
	 };}/*select*/;
   }/*FilHdr_DataFileName*/;


/*private*/ boolean
Has_DataFile(FilHdr)
   tp_FilHdr FilHdr;
{
   return (FilHdr->HdrInf.DataNum != 0);
   }/*Has_DataFile*/;


FilHdr_ErrorFileName(FileName, FilHdr)
   tp_FileName FileName;
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FileName == ERROR || FilHdr == ERROR);
   FORBIDDEN(IsSource(FilHdr));
   FilHdr_DataFileName(FileName, FilHdr);
   (void)strcat(FileName, "E");
   }/*FilHdr_ErrorFileName*/;


boolean
Has_ErrorFile(FilHdr)
   tp_FilHdr FilHdr;
{
   tps_FileName ErrorFileName;

   if (!Has_DataFile(FilHdr)) {
      return FALSE; }/*if*/;
   FilHdr_ErrorFileName(ErrorFileName, FilHdr);
   return Exists(ErrorFileName);
   }/*Has_ErrorFile*/;


FilHdr_WarningFileName(FileName, FilHdr)
   tp_FileName FileName;
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FileName == ERROR || FilHdr == ERROR);
   FORBIDDEN(IsSource(FilHdr));
   FilHdr_DataFileName(FileName, FilHdr);
   (void)strcat(FileName, "W");
   }/*FilHdr_WarningFileName*/;


boolean
Has_WarningFile(FilHdr)
   tp_FilHdr FilHdr;
{
   tps_FileName WarningFileName;

   if (!Has_DataFile(FilHdr)) {
      return FALSE; }/*if*/;
   FilHdr_WarningFileName(WarningFileName, FilHdr);
   return Exists(WarningFileName);
   }/*Has_WarningFile*/;


tp_FilHdr
FilHdr_Head(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr HeadFilHdr;

   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(FilHdr->HdrInf.Father == ERROR);
   HeadFilHdr = LocHdr_FilHdr(FilHdr->HdrInf.Father);

   Ret_FilHdr(FilHdr);
   return HeadFilHdr;
   }/*FilHdr_Head*/;


tp_FilHdr
FilHdr_SrcDirFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   return FilHdr_Head(FilHdr_SrcFilHdr(FilHdr));
   }/*FilHdr_SrcDirFilHdr*/;


FilHdr_HostFN(Str, FilHdr)
   tp_Str Str;
   tp_FilHdr FilHdr;
{
   int i, j, middle;
   tp_FilHdr RestFilHdr;
   tp_LocHdr RestLocHdr;
   char ch;
   tps_Str KeyBuf;
   tp_Str Key;

   FORBIDDEN(Str == ERROR || FilHdr == ERROR);
   if (FilHdr->HdrInf.LocHdr == RootLocHdr) {
      (void)strcpy(Str, "/");
      return; }/*if*/;
   i = 0;
   RestFilHdr = Copy_FilHdr(FilHdr);
   while (RestFilHdr->HdrInf.LocHdr != RootLocHdr) {
      Str[i] = '/'; i += 1;
      Key = FilHdr_Key(KeyBuf, RestFilHdr);
      for (j=strlen(Key)-1; j>=0; j--) {
	 Str[i] = Key[j]; i += 1; }/*for*/;
      RestLocHdr = RestFilHdr->HdrInf.Father;
      Ret_FilHdr(RestFilHdr);
      RestFilHdr = LocHdr_FilHdr(RestLocHdr); }/*while*/;
   Str[i] = '/';
   middle = (i+1) / 2;
   for (j=0; j<middle; j++) {
      ch = Str[j]; Str[j] = Str[i-j]; Str[i-j] = ch; }/*for*/;
   Str[i] = 0;
   Ret_FilHdr(RestFilHdr);
   }/*FilHdr_HostFN*/;


Append_DataNum(Str, OldNum)
   tp_Str Str;
   int OldNum;
{
   int Num, Rem;
   tp_Str TailStr;

   Num = OldNum / 26;
   Rem = OldNum % 26;
   if (Num > 0) Append_DataNum(Str, Num-1);
   TailStr = Tail(Str);
   TailStr[0] = '/';
   TailStr[1] = (char)((int)'a' + Rem);
   TailStr[2] = 0;
   }/*Append_DataNum*/;


tp_FilHdr
HostFN_FilHdr(FileName)
   tp_FileName FileName;
{
   tp_FilHdr FilHdr;
   int i, j;
   tps_Str Key;

   if (FileName == ERROR) return ERROR;
   i = 0;
   switch (FileName[i]) {
      case '/': {
	 FilHdr = LocHdr_FilHdr(RootLocHdr);
	 break;}/*case*/;
      case '$': {
	 FilHdr = Copy_FilHdr(OdinDirFilHdr);
         i += 1;
	 break;}/*case*/;
      default: {
	 FilHdr = Top_CWDFilHdr(); };}/*switch*/;
   while (FileName[i] != 0) {
      while (FileName[i] == '/') i += 1;
      j = 0;
      while (FileName[i] != '/' && FileName[i] != 0) {
	 Key[j] = FileName[i];
	 j += 1; i += 1;}/*while*/;
      if (j > 0) {
	 Key[j] = 0;
	 FilHdr = Do_Key(FilHdr, Key);
	 if (FilHdr == ERROR) {
	    return ERROR; }/*if*/; }/*while*/; }/*while*/;
   if (i > 0 && FileName[i-1] == '/') {
      FilHdr = FilHdr_DirElmsFilHdr(FilHdr); }/*if*/;
   return FilHdr;
   }/*HostFN_FilHdr*/;


tp_FilHdr
FilHdr_DirFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr DirFilHdr;

   FORBIDDEN(FilHdr == RootFilHdr);
   DirFilHdr = LocHdr_FilHdr(FilHdr->HdrInf.Father);
   Ret_FilHdr(FilHdr);
   return DirFilHdr;
   }/*FilHdr_DirFilHdr*/;


tp_FilHdr
CacheFileName_FilHdr(CacheFileName)
   tp_FileName CacheFileName;
{
   int i;
   tp_LocHdr LocHdr;

   for (i = strlen(CacheFileName) - 1;
	i > 0 && isdigit(CacheFileName[i]);
	i -= 1);
   if ((i != 0) && (CacheFileName[i] != '/') && (CacheFileName[i] != '.')) {
      SystemError("Bad cache filename: <%s>.\n", CacheFileName);
      return ERROR; }/*if*/;
   if (i > 0) i += 1;
   LocHdr = atoi(&CacheFileName[i]);
   if (LocHdr <= 0) {
      SystemError("Bad cache filename: <%s>.\n", CacheFileName);
      return ERROR; }/*if*/;
   return LocHdr_FilHdr(LocHdr);
   }/*CacheFileName_FilHdr*/;


tp_FilHdr
DataFileName_FilHdr(DataFileName)
   tp_FileName DataFileName;
{
   if (DataFileName == ERROR) return ERROR;
   if (strncmp(CacheDirName, DataFileName, strlen(CacheDirName)) == 0) {
      return CacheFileName_FilHdr(DataFileName); }/*if*/;
   return HostFN_FilHdr(DataFileName);
   }/*DataFileName_FilHdr*/;



