/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <stdio.h>
#include <varargs.h>
#include "inc/GMC.h"
#include "inc/Filename.h"


tp_FilDsc		ErrFD;
tp_FileName		ErrFileName;

int			num_Errors = 0;
int			num_Warnings = 0;

boolean			DumpCore;


Init_Err()
{
   ErrFD = StdOutFD;
   ErrFileName = "1";
   }/*Init_Err*/;


Set_ErrFile(FileName)
   tp_FileName FileName;
{
   if (FileName == ErrFileName || strcmp(FileName, ErrFileName) == 0) {
      ErrFileName = FileName;
      return; }/*if*/;

   ErrFileName = FileName;
   if (ErrFD != NIL && ErrFD != StdOutFD && ErrFD != StdErrFD) Close(ErrFD);
   /*select*/{
      if (strcmp(ErrFileName, "1") == 0) {
	 ErrFD = StdOutFD;
      }else if (strcmp(ErrFileName, "2") == 0) {
	 ErrFD = StdErrFD;
      }else{
	 ErrFD = NIL; };}/*select*/;
   }/*Set_ErrFile*/;


boolean
IsErr()
{
   return (ErrFD != NIL);
   }/*IsErr*/;


Reset_Err()
{
   num_Errors = 0;
   num_Warnings = 0;
   }/*Reset_Err*/;


Increment_Errors()
{
   num_Errors += 1;
   }/*Increment_Errors*/;


int
Num_Errors()
{
   return num_Errors;
   }/*Num_Errors*/;


Increment_Warnings()
{
   num_Warnings += 1;
   }/*Increment_Warnings*/;


int
Num_Warnings()
{
   return num_Warnings;
   }/*Num_Warnings*/;


FatalError(Message)
   char *Message;
{
   Flush(StdOutFD);
   Flush(StdErrFD);
   fatal_err(Message);
   }/*FatalError*/;


#ifdef NO_VARARGS

FILE *
SystemErrorFD()
{
   Increment_Errors();
   if (ErrFD != NIL) {
      return (FILE *)ErrFD; }/*if*/;
   FORBIDDEN(ErrFileName == ERROR);
   ErrFD = FileName_WFilDsc(ErrFileName);
   if (ErrFD != ERROR) {
      return (FILE *)ErrFD; }/*if*/;
   Writeln(StdErrFD, "!! Could not open error file !!");
   return (FILE *)StdErrFD;
   }/*SystemErrorFD*/;

#else

tp_FilDsc
SystemErrorFD()
{
   if (ErrFD != NIL) {
      return ErrFD; }/*if*/;
   FORBIDDEN(ErrFileName == ERROR);
   ErrFD = FileName_WFilDsc(ErrFileName);
   if (ErrFD != ERROR) {
      return ErrFD; }/*if*/;
   Writeln(StdErrFD, "!! Could not open error file !!");
   return StdErrFD;
   }/*SystemErrorFD*/;


/*VARARGS0*/
SystemError(FilDsc, va_alist)
   tp_FilDsc FilDsc;
   va_dcl
{
   va_list Args;
   tp_Str Fmt;

   va_start(Args);
   Fmt = va_arg(Args, char *);
   Increment_Errors();
   (void)vfprintf((FILE *)FilDsc, Fmt, Args);
   }/*SystemError*/;

#endif


fatal_err(Message)
   char *Message;
{
   (void)fputs(Message, stderr);
   (void)fputs("\n", stderr);
   (void)fputs("Anomalous Internal State Detected\n", stderr);
   (void)fputs("please mail description to geoff@bellcore.com\n", stderr);
   if (DumpCore) {
      (void)fputs("'illegal instruction' issued to generate core for analysis\n",
       stderr);
      abort(); }/*if*/;
   exit(2);
   }/*fatal_err*/;


