/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/DPType_.h"
#include "inc/DrvSpc.h"
#include "inc/FKind_.h"
#include "inc/Str.h"


tp_DrvSpc	FreeDrvSpc;
int		num_DrvSpcS;


/*private*/ tp_DrvSpc
New_DrvSpc()
{
   tp_DrvSpc DrvSpc;

   /*select*/{
      if (FreeDrvSpc == 0) {
	 DrvSpc = (tp_DrvSpc)malloc(sizeof(tps_DrvSpc));
	 num_DrvSpcS += 1;
	 DrvSpc->InUse = FALSE;
      }else{
	 DrvSpc = FreeDrvSpc;
	 FreeDrvSpc = FreeDrvSpc->Next; };}/*select*/;

   DrvSpc->Prms = 0;
   DrvSpc->FilTyp = 0;
   DrvSpc->Key = 0;
   DrvSpc->FilHdr = 0;
   DrvSpc->Next = 0;
   FORBIDDEN(DrvSpc->InUse);
   DrvSpc->InUse = TRUE;
   return DrvSpc;
   }/*New_DrvSpc*/;


Ret_DrvSpc(DrvSpc)
   tp_DrvSpc DrvSpc;
{
   tp_DrvSpc TmpDrvSpc, LastDrvSpc;

   FORBIDDEN(DrvSpc == ERROR);
   LastDrvSpc = DrvSpc;
   TmpDrvSpc = DrvSpc;
   while (TmpDrvSpc != 0) {
      FORBIDDEN(!TmpDrvSpc->InUse);
      TmpDrvSpc->InUse = FALSE;
      Ret_FilHdr(TmpDrvSpc->FilHdr);
      LastDrvSpc = TmpDrvSpc;
      TmpDrvSpc = TmpDrvSpc->Next; }/*while*/;

   LastDrvSpc->Next = FreeDrvSpc;
   FreeDrvSpc = DrvSpc;
   }/*Ret_DrvSpc*/;


/*private*/ tp_DrvSpc
Last_DrvSpc(DrvSpc)
   tp_DrvSpc DrvSpc;
{
   tp_DrvSpc LastDrvSpc;

   FORBIDDEN(DrvSpc == ERROR);
   LastDrvSpc = DrvSpc;
   while (LastDrvSpc->Next != 0) LastDrvSpc = LastDrvSpc->Next;
   return LastDrvSpc;
   }/*Last_DrvSpc*/;


ShiftLeft_DrvSpc(LeftDrvSpc, RiteDrvSpcPtr)
   tp_DrvSpc LeftDrvSpc;
   tp_DrvSpc *RiteDrvSpcPtr;
{
   tp_DrvSpc LastDrvSpc;

   FORBIDDEN(LeftDrvSpc == 0 || *RiteDrvSpcPtr == 0);

   LastDrvSpc = Last_DrvSpc(LeftDrvSpc);
   LastDrvSpc->Next = *RiteDrvSpcPtr;

   *RiteDrvSpcPtr = (*RiteDrvSpcPtr)->Next;
   LastDrvSpc->Next->Next = 0;
   }/*ShiftLeft_DrvSpc*/;


DrvSpc_Str(Str, DrvSpc)
   tp_Str Str;
   tp_DrvSpc DrvSpc;
{
   FORBIDDEN(Str == ERROR || DrvSpc == ERROR);
   (void)strcpy(Str, "");
   /*select*/{
      if (DrvSpc->FKind == FK_DrvDirElm) {
	 (void)strcat(Str, "/");
	 (void)strcat(Str, DrvSpc->Key);
      }else if (DrvSpc->FKind == FK_DirElms) {
	 (void)strcat(Str, "/");
      }else if (DrvSpc->FKind == FK_Homo) {
	 (void)strcat(Str, " ::");
	 (void)strcat(Str, FilTyp_FTName(DrvSpc->FilTyp));
      }else{
	 (void)strcat(Str, " :");
	 (void)strcat(Str, FilTyp_FTName(DrvSpc->FilTyp));
	 };}/*select*/;
   }/*DrvSpc_Str*/;


/*private*/ tp_DrvSpc
FilHdr_DrvSpc(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr TmpFilHdr;
   tp_DrvSpc DrvSpc, NewDrvSpc;
   tps_Str KeyBuf;

   FORBIDDEN(FilHdr == ERROR);

   TmpFilHdr = Copy_FilHdr(FilHdr);
   DrvSpc = NIL;
   while (!IsSource(TmpFilHdr)) {
      if (!IsInstance(TmpFilHdr)) {
	 NewDrvSpc = New_DrvSpc();
	 NewDrvSpc->FKind = FilHdr_FKind(TmpFilHdr);
	 NewDrvSpc->FilTyp = FilHdr_FilTyp(TmpFilHdr);
	 NewDrvSpc->Prms = FilHdr_Prms(TmpFilHdr);
	 NewDrvSpc->Key = Sym_Str(Str_Sym(FilHdr_Key(KeyBuf, TmpFilHdr)));
	 NewDrvSpc->FilHdr = Copy_FilHdr(TmpFilHdr);
	 NewDrvSpc->Next = DrvSpc;
	 DrvSpc = NewDrvSpc; }/*if*/;
      TmpFilHdr = FilHdr_BaseFilHdr(TmpFilHdr); }/*while*/;

   Ret_FilHdr(TmpFilHdr);
   return DrvSpc;
   }/*FilHdr_DrvSpc*/;


/*private*/ boolean
CheckCompact(DrvSpc, NextDrvSpc, DrvPth, Prms)
   tp_DrvSpc DrvSpc;
   tp_DrvSpc NextDrvSpc;
   tp_DrvPth DrvPth;
   tp_Prms Prms;
{
   tp_DrvSpc TmpDrvSpc;
   tp_DrvPth TmpDrvPth;
   tp_PrmFTLst PrmFTLst;
   tp_Prms NewPrms;

   FORBIDDEN(DrvSpc==ERROR||NextDrvSpc==ERROR||DrvPth==ERROR||Prms==ERROR);
   TmpDrvSpc = DrvSpc;
   TmpDrvPth = DrvPth;
   while (TmpDrvPth != 0) {
      if (DrvPth_DPType(TmpDrvPth) == DPT_Drv) {
	 if (TmpDrvSpc == NIL) {
	    TmpDrvSpc = NextDrvSpc;
	    NextDrvSpc = NIL; }/*if*/;
	 FORBIDDEN(TmpDrvSpc == NIL);
	 FORBIDDEN(TmpDrvSpc->Key != NIL && NextDrvSpc != NIL);
	 if (DrvPth_FilTyp(TmpDrvPth) != TmpDrvSpc->FilTyp) {
	    return FALSE; }/*if*/;
	 if (DrvPth_FKind(TmpDrvPth) != TmpDrvSpc->FKind) {
	    return FALSE; }/*if*/;
	 PrmFTLst = DrvPth_PrmFTLst(TmpDrvPth);
	 NewPrms = Strip_Prms(Prms, PrmFTLst);
	 if (!Equal_Prms(TmpDrvSpc->Prms, NewPrms)) {
	    return FALSE; }/*if*/;
	 TmpDrvSpc = TmpDrvSpc->Next; }/*if*/;
      TmpDrvPth = DrvPth_Next(TmpDrvPth); }/*while*/;
   return (NextDrvSpc == 0);
   }/*CheckCompact*/;


CanCompact(FilHdr, DrvSpc, NextDrvSpc)
   tp_FilHdr FilHdr;
   tp_DrvSpc DrvSpc;
   tp_DrvSpc NextDrvSpc;
{
   tp_DrvPth DrvPth;
   tp_Prms Prms;
   tp_DrvSpc TmpDrvSpc;
   boolean Can;

   FORBIDDEN(FilHdr == ERROR || DrvSpc == ERROR);

   if (FilHdr_FilTyp(FilHdr) == NextDrvSpc->FilTyp) {
      return FALSE; }/*if*/;

   DrvPth = Get_DrvPth(FilHdr, NextDrvSpc->FilTyp);
   if (DrvPth == ERROR) {
      return FALSE; }/*if*/;

   Prms = DfltPrms;
   TmpDrvSpc = DrvSpc;
   while (TmpDrvSpc != 0) {
      Prms = Union_Prms(Prms, TmpDrvSpc->Prms);
      TmpDrvSpc = TmpDrvSpc->Next; }/*while*/;
   Prms = Union_Prms(Prms, NextDrvSpc->Prms);
   Can = CheckCompact(DrvSpc, NextDrvSpc, DrvPth, Prms);

   Ret_DrvPth(DrvPth);

   return Can;
   }/*CanCompact*/;


FilHdr_OdinName(OdinName, FilHdr)
   tp_Str OdinName;
   tp_FilHdr FilHdr;
{
   tp_FilHdr TmpFilHdr;
   tp_DrvSpc DrvSpc, LastDrvSpc, RestDrvSpc, TmpDrvSpc;
   tp_Prms Prms;

   FORBIDDEN(OdinName == ERROR || FilHdr == ERROR);

   TmpFilHdr = FilHdr_SrcFilHdr(Copy_FilHdr(FilHdr));
   FilHdr_HostFN(OdinName, TmpFilHdr);

   DrvSpc = 0;
   RestDrvSpc = FilHdr_DrvSpc(FilHdr);

   while (RestDrvSpc != 0) {

      DrvSpc = RestDrvSpc;
      RestDrvSpc = RestDrvSpc->Next;
      DrvSpc->Next = NIL;

      if (DrvSpc->Key == NIL) {
	 while (RestDrvSpc != 0
		&& RestDrvSpc->Key == NIL
		&& CanCompact(TmpFilHdr, DrvSpc, RestDrvSpc)) {
	    ShiftLeft_DrvSpc(DrvSpc, &RestDrvSpc); }/*while*/; }/*if*/;

      Prms = DfltPrms;
      TmpDrvSpc = DrvSpc;
      while (TmpDrvSpc != 0) {
	 Prms = Union_Prms(Prms, TmpDrvSpc->Prms);
	 TmpDrvSpc = TmpDrvSpc->Next; }/*while*/;
      Prms_Str(Tail(OdinName), Prms);

      LastDrvSpc = Last_DrvSpc(DrvSpc);
      Ret_FilHdr(TmpFilHdr);
      TmpFilHdr = Copy_FilHdr(LastDrvSpc->FilHdr);
      DrvSpc_Str(Tail(OdinName), LastDrvSpc);
      Ret_DrvSpc(DrvSpc);
      DrvSpc = 0; }/*while*/
     
   Ret_FilHdr(TmpFilHdr);
   }/*FilHdr_OdinName*/;


FilHdr_VerboseOdinName(OdinName, FilHdr)
   tp_Str OdinName;
   tp_FilHdr FilHdr;
{
   tp_FilHdr SrcFilHdr;
   tp_DrvSpc HeadDrvSpc, DrvSpc;

   FORBIDDEN(OdinName == ERROR || FilHdr == ERROR);

   SrcFilHdr = FilHdr_SrcFilHdr(Copy_FilHdr(FilHdr));
   FilHdr_HostFN(OdinName, SrcFilHdr);
   Ret_FilHdr(SrcFilHdr);
   HeadDrvSpc = FilHdr_DrvSpc(FilHdr);
   for (DrvSpc=HeadDrvSpc; DrvSpc!=NIL; DrvSpc=DrvSpc->Next) {
      Prms_Str(Tail(OdinName), DrvSpc->Prms);
      DrvSpc_Str(Tail(OdinName), DrvSpc); }/*for*/;
   Ret_DrvSpc(HeadDrvSpc);
   }/*FilHdr_VerboseOdinName*/;


