/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/DPType_.h"
#include "inc/DrvPth.h"
#include "inc/FKind_.h"


tp_DrvPth	FreeDrvPth = NIL;
int		num_DrvPthS = 0;


/*private*/ tp_DrvPth
New_DrvPth()
{
   tp_DrvPth DrvPth;

   /*select*/{
      if (FreeDrvPth == 0) {
	 DrvPth = (tp_DrvPth)malloc(sizeof(tps_DrvPth));
	 num_DrvPthS += 1;
	 DrvPth->InUse = FALSE;
      }else{
	 DrvPth = FreeDrvPth;
	 FreeDrvPth = FreeDrvPth->Next; };}/*select*/;

   DrvPth->DPType = ERROR;
   DrvPth->FKind = FK_User;
   DrvPth->FilTyp = ERROR;
   DrvPth->DrvEdg = ERROR;
   DrvPth->Next = 0;
   FORBIDDEN(DrvPth->InUse);
   DrvPth->InUse = TRUE;
   return DrvPth;
   }/*New_DrvPth*/;


AppendDrvPth(DrvPthPtr, AddDrvPth)
   tp_DrvPth *DrvPthPtr, AddDrvPth;
{
   tp_DrvPth DrvPth;

   if (AddDrvPth == 0) return;
   DrvPth = *DrvPthPtr;
   if (DrvPth == 0) {
      *DrvPthPtr = AddDrvPth;
      return; }/*if*/;
   while (DrvPth->Next != NIL) {
      DrvPth = DrvPth->Next; }/*while*/;
   DrvPth->Next = AddDrvPth;
   }/*AppendDrvPth*/;


tp_DrvPth
FilTyp_Cast_DrvPth(FilTyp)
   tp_FilTyp FilTyp;
{
   tp_DrvPth DrvPth;

   FORBIDDEN(FilTyp == ERROR);
   DrvPth = New_DrvPth();
   DrvPth->DPType = DPT_Cast;
   DrvPth->FilTyp = FilTyp;
   return DrvPth;
   }/*FilTyp_Cast_DrvPth*/;


tp_DrvPth
FilTyp_Eqv_DrvPth(FilTyp)
   tp_FilTyp FilTyp;
{
   tp_DrvPth DrvPth;

   FORBIDDEN(FilTyp == ERROR);
   DrvPth = New_DrvPth();
   DrvPth->DPType = DPT_Eqv;
   DrvPth->FilTyp = FilTyp;
   return DrvPth;
   }/*FilTyp_Eqv_DrvPth*/;


tp_DrvPth
FilTyp_Drv_DrvPth(FilTyp, DrvEdg)
   tp_FilTyp FilTyp;
   tp_DrvEdg DrvEdg;
{
   tp_DrvPth DrvPth;

   FORBIDDEN(FilTyp == ERROR);
   DrvPth = New_DrvPth();
   DrvPth->DPType = DPT_Drv;
   DrvPth->FilTyp = FilTyp;
   DrvPth->DrvEdg = DrvEdg;
   return DrvPth;
   }/*FilTyp_Drv_DrvPth*/;


Ret_DrvPth(DrvPth)
   tp_DrvPth DrvPth;
{
   tp_DrvPth TmpDrvPth;

   FORBIDDEN(DrvPth == ERROR);
   TmpDrvPth = DrvPth;
   while (TmpDrvPth->Next != 0) {
      FORBIDDEN(!TmpDrvPth->InUse);
      TmpDrvPth->InUse = FALSE;
      TmpDrvPth = TmpDrvPth->Next; }/*while*/;
   FORBIDDEN(!TmpDrvPth->InUse);
   TmpDrvPth->InUse = FALSE;
   TmpDrvPth->Next = FreeDrvPth;
   FreeDrvPth = DrvPth;
   }/*Ret_DrvPth*/;


tp_DPType
DrvPth_DPType(DrvPth)
   tp_DrvPth DrvPth;
{
   return DrvPth->DPType;
   }/*DrvPth_DPType*/;


tp_FKind
DrvPth_FKind(DrvPth)
   tp_DrvPth DrvPth;
{
   return DrvPth->FKind;
   }/*DrvPth_FKind*/;


tp_FilTyp
DrvPth_FilTyp(DrvPth)
   tp_DrvPth DrvPth;
{
   return DrvPth->FilTyp;
   }/*DrvPth_FilTyp*/;


tp_DrvEdg
DrvPth_DrvEdg(DrvPth)
   tp_DrvPth DrvPth;
{
   return DrvPth->DrvEdg;
   }/*DrvPth_DrvEdg*/;


tp_DrvPth
DrvPth_Next(DrvPth)
   tp_DrvPth DrvPth;
{
   return DrvPth->Next;
   }/*DrvPth_Next*/;


boolean
IsDrv_DrvPth(DrvPth)
   tp_DrvPth DrvPth;
{
   tp_DrvPth DrvPthElm;

   DrvPthElm = DrvPth;
   while (DrvPthElm != 0) {
      if (DrvPthElm->DPType == DPT_Drv) {
	 return TRUE; }/*if*/;
      DrvPthElm = DrvPthElm->Next; }/*while*/;
   return FALSE;
   }/*IsDrv_DrvPth*/;


