/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"


boolean			CheckSet = FALSE;
tp_FilTyp		CheckPrmFT;


Init_Check()
{
   CheckPrmFT = FTName_FilTyp(".copy_commands");
   FORBIDDEN(CheckPrmFT == ERROR);
   }/*Init_Check*/;

   
Make_TestLocInp(OldLocInp, CheckFilHdr)
   tp_LocInp OldLocInp;
   tp_FilHdr CheckFilHdr;
{
   tp_FilInp FilInp;
   tp_FilHdr InpFilHdr;
   tp_LocInp LocInp, NxtLocInp;
   tp_LocHdr OldLocHdr, NewLocHdr;
   boolean DidCheck;

   if (OldLocInp == 0) {
      return; }/*if*/;

   DidCheck = FALSE;
   if (!CheckSet) {
      Set_SourceOrgs(CheckFilHdr);
      DidCheck = TRUE; }/*if*/;

   LocInp = OldLocInp;
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      NxtLocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp);

      OldLocHdr = FilHdr_LocHdr(InpFilHdr);
      InpFilHdr = Make_TestFilHdr(InpFilHdr, CheckFilHdr);
      NewLocHdr = FilHdr_LocHdr(InpFilHdr);
      if (NewLocHdr != OldLocHdr) {
	 Unlink_LocInp(LocInp);
	 Link_LocInp(LocInp, InpFilHdr); }/*if*/;
      Ret_FilHdr(InpFilHdr);
      LocInp = NxtLocInp; }/*while*/;

   if (DidCheck) {
      Clr_TestInpTestLocHdrs(OldLocInp);
      Clr_SourceOrgs(CheckFilHdr); }/*if*/;
   }/*Make_TestLocInp*/;


Make_TestLocElm(OldLocElm, CheckFilHdr)
   tp_LocElm OldLocElm;
   tp_FilHdr CheckFilHdr;
{
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;
   tp_LocElm LocElm, NxtLocElm;
   tp_LocHdr OldLocHdr, NewLocHdr;
   boolean DidCheck;

   if (OldLocElm == 0) {
      return; }/*if*/;

   DidCheck = FALSE;
   if (!CheckSet) {
      Set_SourceOrgs(CheckFilHdr);
      DidCheck = TRUE; }/*if*/;

   LocElm = OldLocElm;
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      NxtLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);

      OldLocHdr = FilHdr_LocHdr(ElmFilHdr);
      ElmFilHdr = Make_TestFilHdr(ElmFilHdr, CheckFilHdr);
      NewLocHdr = FilHdr_LocHdr(ElmFilHdr);
      if (NewLocHdr != OldLocHdr) {
	 Unlink_LocElm(LocElm);
	 Link_LocElm(LocElm, ElmFilHdr); }/*if*/;
      Ret_FilHdr(ElmFilHdr);
      LocElm = NxtLocElm; }/*while*/;

   if (DidCheck) {
      Clr_TestElmTestLocHdrs(OldLocElm);
      Clr_SourceOrgs(CheckFilHdr); }/*if*/;
   }/*Make_TestLocElm*/;


/*private*/ boolean
HasTestInp(FilHdr, CheckFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr CheckFilHdr;
{
   tp_LocInp LocInp, NxtLocInp;
   tp_FilInp FilInp;
   tp_FilHdr InpFilHdr;
   tp_LocHdr OldLocHdr, NewLocHdr;

   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      NxtLocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp);
      OldLocHdr = FilHdr_LocHdr(InpFilHdr);
      InpFilHdr = Make_TestFilHdr(InpFilHdr, CheckFilHdr);
      NewLocHdr = FilHdr_LocHdr(InpFilHdr);
      Ret_FilHdr(InpFilHdr);
      if (NewLocHdr != OldLocHdr) {
	 return TRUE; }/*if*/;
      LocInp = NxtLocInp; }/*while*/;
   return FALSE;
   }/*HasTestInp*/;


/*private*/ boolean
HasTestElm(FilHdr, CheckFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr CheckFilHdr;
{
   tp_LocElm LocElm, NxtLocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;
   tp_LocHdr OldLocHdr, NewLocHdr;

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      NxtLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);
      OldLocHdr = FilHdr_LocHdr(ElmFilHdr);
      ElmFilHdr = Make_TestFilHdr(ElmFilHdr, CheckFilHdr);
      NewLocHdr = FilHdr_LocHdr(ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      if (NewLocHdr != OldLocHdr) {
	 return TRUE; }/*if*/;
      LocElm = NxtLocElm; }/*while*/;
   return FALSE;
   }/*HasTestElm*/;


tp_FilHdr
Make_TestFilHdr(FilHdr, CheckFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr CheckFilHdr;
{
   tp_FilHdr TestFilHdr, OldCheckFilHdr;

   if (FilHdr == CheckFilHdr) {
      return FilHdr; }/*if*/;

   FORBIDDEN(!CheckSet);

   if (FilHdr_TestLocHdr(FilHdr) != NIL) {
      TestFilHdr = LocHdr_FilHdr(FilHdr_TestLocHdr(FilHdr));
      Ret_FilHdr(FilHdr);
      return TestFilHdr; }/*if*/;

   if (IsSource(FilHdr) && IsAtmc(FilHdr)) {
      return FilHdr; }/*if*/;
      
   OldCheckFilHdr = FilHdr_CheckFilHdr(Copy_FilHdr(FilHdr));
   if (OldCheckFilHdr != ERROR) {
      FORBIDDEN(OldCheckFilHdr != CheckFilHdr);
      Ret_FilHdr(OldCheckFilHdr);
      return FilHdr; }/*if*/;

   if (IsUpToDate(FilHdr)
    && !HasTestInp(FilHdr, CheckFilHdr) && !HasTestElm(FilHdr, CheckFilHdr)) {
      TestFilHdr = Copy_FilHdr(FilHdr);
      goto done; }/*if*/;

   TestFilHdr = FilHdr_TestFilHdr(Copy_FilHdr(FilHdr), CheckFilHdr);
   FORBIDDEN(TestFilHdr == ERROR);

   if (IsUpToDate(TestFilHdr)
       || (FilHdr_ConfirmDate(TestFilHdr) == 0
	   && FilHdr_TestLocHdr(TestFilHdr) != NIL)) {
      goto done; }/*if*/;

done:
   Set_TestLocHdr(FilHdr, FilHdr_LocHdr(TestFilHdr));
   Ret_FilHdr(FilHdr);
   return TestFilHdr;
   }/*Make_TestFilHdr*/;


Set_SourceOrgs(CheckFilHdr)
   tp_FilHdr CheckFilHdr;
{
   tp_LocElm LocElm, OrgLocElm, NextOrgLocElm, DstLocElm, NextDstLocElm;
   tp_FilHdr OrgsFilHdr, DstsFilHdr, OrgFilHdr, DstFilHdr, TestFilHdr;
   tp_FilElm FilElm, OrgFilElm, DstFilElm;
   tp_Prms Prms;

   FORBIDDEN(CheckSet);
   CheckSet = TRUE;

   LocElm = FilHdr_LocElm(CheckFilHdr);
   FilElm = LocElm_FilElm(LocElm);
   OrgsFilHdr = FilElm_FilHdr(FilElm);
   LocElm = FilElm_Next(FilElm);
   Ret_FilElm(FilElm);
   FilElm = LocElm_FilElm(LocElm);
   DstsFilHdr = FilElm_FilHdr(FilElm);
   FORBIDDEN(FilElm_Next(FilElm) != 0);
   Ret_FilElm(FilElm);

   OrgLocElm = FilHdr_LocElm(OrgsFilHdr);
   Ret_FilHdr(OrgsFilHdr);
   DstLocElm = FilHdr_LocElm(DstsFilHdr);
   Ret_FilHdr(DstsFilHdr);

   while (OrgLocElm != 0) {
      OrgFilElm = LocElm_FilElm(OrgLocElm);
      OrgFilHdr = FilElm_FilHdr(OrgFilElm);
      FORBIDDEN(OrgFilHdr == ERROR);
      NextOrgLocElm = FilElm_Next(OrgFilElm);
      Ret_FilElm(OrgFilElm);

      DstFilElm = LocElm_FilElm(DstLocElm);
      DstFilHdr = FilElm_FilHdr(DstFilElm);
      FORBIDDEN(DstFilHdr == ERROR);
      NextDstLocElm = FilElm_Next(DstFilElm);
      Ret_FilElm(DstFilElm);

      Deref_Pntrs(&DstFilHdr, &Prms, DstFilHdr, FALSE);
      Deref_Pntrs(&OrgFilHdr, &Prms, OrgFilHdr, FALSE);
      OrgFilHdr = FilHdr_AtmFilHdr(OrgFilHdr);
      TestFilHdr
       = FilHdr_SrcTestFilHdr(Copy_FilHdr(DstFilHdr), OrgFilHdr, CheckFilHdr);
      Set_TestLocHdr(DstFilHdr, FilHdr_LocHdr(TestFilHdr));
      Ret_FilHdr(DstFilHdr); Ret_FilHdr(OrgFilHdr); Ret_FilHdr(TestFilHdr);

      OrgLocElm = NextOrgLocElm; DstLocElm = NextDstLocElm; }/*while*/;
   }/*Set_SourceOrgs*/;


Clr_SourceOrgs(CheckFilHdr)
   tp_FilHdr CheckFilHdr;
{
   tp_LocElm LocElm, DstLocElm, NextDstLocElm;
   tp_FilHdr DstsFilHdr, DstFilHdr;
   tp_FilElm FilElm, DstFilElm;
   tp_Prms Prms;

   FORBIDDEN(!CheckSet);
   CheckSet = FALSE;

   LocElm = FilHdr_LocElm(CheckFilHdr);
   FilElm = LocElm_FilElm(LocElm);
   LocElm = FilElm_Next(FilElm);
   Ret_FilElm(FilElm);
   FilElm = LocElm_FilElm(LocElm);
   DstsFilHdr = FilElm_FilHdr(FilElm);
   FORBIDDEN(FilElm_Next(FilElm) != 0);
   Ret_FilElm(FilElm);

   DstLocElm = FilHdr_LocElm(DstsFilHdr);
   Ret_FilHdr(DstsFilHdr);

   while (DstLocElm != 0) {
      DstFilElm = LocElm_FilElm(DstLocElm);
      DstFilHdr = FilElm_FilHdr(DstFilElm);
      FORBIDDEN(DstFilHdr == ERROR);
      NextDstLocElm = FilElm_Next(DstFilElm);
      Ret_FilElm(DstFilElm);
      Deref_Pntrs(&DstFilHdr, &Prms, DstFilHdr, FALSE);
      Clr_CmpdOutTestLocHdrs(DstFilHdr);
      Ret_FilHdr(DstFilHdr);
      DstLocElm = NextDstLocElm; }/*while*/;
   }/*Clr_SourceOrgs*/;


Clr_CmpdOutTestLocHdrs(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr OutFilHdr, CmpdFilHdr;
   tp_LocInp LocInpLink, FirstInpLink;
   tp_FilInp FilInpLink;
   tp_LocElm LocElmLink, FirstElmLink;
   tp_FilElm FilElmLink;

   if (FilHdr_TestLocHdr(FilHdr) == NIL) {
      return; }/*if*/;
   Set_TestLocHdr(FilHdr, (tp_LocHdr)NIL);

   FirstInpLink = 0;
   LocInpLink = FilHdr_InpLink(FilHdr);
   while (LocInpLink != FirstInpLink) {
      FilInpLink = LocInp_FilInp(LocInpLink);
      OutFilHdr = LocHdr_FilHdr(FilInp_OutLocHdr(FilInpLink));
      Clr_CmpdOutTestLocHdrs(OutFilHdr);
      Ret_FilHdr(OutFilHdr);
      LocInpLink = FilInp_Link(FilInpLink);
      Ret_FilInp(FilInpLink); }/*while*/;
   FirstElmLink = 0;
   LocElmLink = FilHdr_ElmLink(FilHdr);
   while (LocElmLink != FirstElmLink) {
      FilElmLink = LocElm_FilElm(LocElmLink);
      CmpdFilHdr = FilElm_CmpdFilHdr(FilElmLink);
      Clr_CmpdOutTestLocHdrs(CmpdFilHdr);
      Ret_FilHdr(CmpdFilHdr);
      LocElmLink = FilElm_Link(FilElmLink);
      Ret_FilElm(FilElmLink); }/*while*/;
   }/*Clr_CmpdOutTestLocHdrs*/;


Clr_TestInpTestLocHdrs(LocInp)
   tp_LocInp LocInp;
{
   tp_LocInp TmpLocInp, NxtLocInp;
   tp_FilInp FilInp;
   tp_LocHdr LocHdr;
   tp_FilHdr FilHdr;

   TmpLocInp = LocInp;
   while (TmpLocInp != 0) {
      FilInp = LocInp_FilInp(TmpLocInp);
      FilHdr = FilHdr_NonTestFilHdr(FilInp_FilHdr(FilInp));
      LocHdr = FilHdr_LocHdr(FilHdr);
      Ret_FilHdr(FilHdr);
      NxtLocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp);
      Clr_ElmInpTestLocHdrs(LocHdr);
      TmpLocInp = NxtLocInp; }/*while*/;
   }/*Clr_TestInpTestLocHdrs*/;


Clr_InpTestLocHdrs(LocInp)
   tp_LocInp LocInp;
{
   tp_LocInp TmpLocInp, NxtLocInp;
   tp_FilInp FilInp;
   tp_LocHdr LocHdr;

   TmpLocInp = LocInp;
   while (TmpLocInp != 0) {
      FilInp = LocInp_FilInp(TmpLocInp);
      LocHdr = FilInp_LocHdr(FilInp);
      NxtLocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp);
      Clr_ElmInpTestLocHdrs(LocHdr);
      TmpLocInp = NxtLocInp; }/*while*/;
   }/*Clr_InpTestLocHdrs*/;


Clr_TestElmTestLocHdrs(LocElm)
   tp_LocElm LocElm;
{
   tp_LocElm TmpLocElm, NxtLocElm;
   tp_FilElm FilElm;
   tp_LocHdr LocHdr;
   tp_FilHdr FilHdr;

   TmpLocElm = LocElm;
   while (TmpLocElm != 0) {
      FilElm = LocElm_FilElm(TmpLocElm);
      FilHdr = FilHdr_NonTestFilHdr(FilElm_FilHdr(FilElm));
      LocHdr = FilHdr_LocHdr(FilHdr);
      Ret_FilHdr(FilHdr);
      NxtLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);
      Clr_ElmInpTestLocHdrs(LocHdr);
      TmpLocElm = NxtLocElm; }/*while*/;
   }/*Clr_TestElmTestLocHdrs*/;


Clr_ElmTestLocHdrs(LocElm)
   tp_LocElm LocElm;
{
   tp_LocElm TmpLocElm, NxtLocElm;
   tp_FilElm FilElm;
   tp_LocHdr LocHdr;

   TmpLocElm = LocElm;
   while (TmpLocElm != 0) {
      FilElm = LocElm_FilElm(TmpLocElm);
      LocHdr = FilElm_LocHdr(FilElm);
      NxtLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);
      Clr_ElmInpTestLocHdrs(LocHdr);
      TmpLocElm = NxtLocElm; }/*while*/;
   }/*Clr_ElmTestLocHdrs*/;


Clr_ElmInpTestLocHdrs(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocInp LocInp;
   tp_LocElm LocElm;

   FilHdr = LocHdr_FilHdr(LocHdr);

   if (FilHdr_TestLocHdr(FilHdr) == 0) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;

   Set_TestLocHdr(FilHdr, (tp_LocHdr)NIL);
   LocInp = FilHdr_LocInp(FilHdr);
   LocElm = FilHdr_LocElm(FilHdr);
   Ret_FilHdr(FilHdr);
   Clr_InpTestLocHdrs(LocInp);
   Clr_ElmTestLocHdrs(LocElm);
   }/*Clr_ElmInpTestLocHdrs*/;



