# $Id: Makefile.cpp,v 1.61 1993/01/05 21:08:14 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/texinfo

# We can build three different versions: tty, sunview and xview.

SUNTOOLDIR	= /usr/include/suntool

#ifdef XVIEWINC
XVI	= XVIEWINC
XVL	= XVIEWLIB
XI	= XINC
XL	= XLIB
XEXE    = xinfotool
#endif

# Override the defaults for some things here.

# CP = cp
# DEFAULT_EDITOR = vi
# DEFAULT_PRINTER = postscript
# DEFAULT_WINRUNNER = xterm -e or shelltool
# ISHELL = /bin/sh
# LPR = lpr -P
# MAIL = mail
# MAINTAINER = elibugs@cs.colorado.edu
# MV = mv
# PRINTEXTENSION = .ps
# SCRIPT = script
# SCRIPTOUTPUT = scriptout
# SED = sed
# SHELL = /bin/sh
# TOUCH = touch

# Override things like this:

# OVERRIDES = -DMAINTAINER=\"${MAINTAINER}\"

# Might want to override ISHELL for makeinfo too.

# MIDEFS = -DSHELL="\"${ISHELL}\""

# ---------------------------------------------------------------------------
# Shouldn't need to customize anything below here.

SHELL		= /bin/sh

CFLAGS		= $(OVERRIDES)
XCFLAGS		= $(CFLAGS) -I$(XI) -I$(XVI) -DXVIEW
LDFLAGS		=

LIBS		= -lcurses -ltermcap
SUNVLIBS 	= -lsuntool -lsunwindow -lpixrect
XVIEWLIBS	= -L$(XVL) -lxview -lolgx -L$(XL) -lX11

BROWSRCS  = example.c file.c info.c list.c node.c option.c system.c util.c
BROWHDRS  = file.h info.h node.h option.h
BROWOBJS  = example.o file.o info.o list.o node.o option.o system.o util.o

INFOSRCS  = infoReader.c complete.c help.c menunote.c page.c \
	    signals.c strbuild.c typeout.c obstack.c
INFOHDRS  = strbuild.h obstack.h typeout.h
INFOOBJS  = infoReader.o complete.o help.o menunote.o page.o \
	    signals.o strbuild.o typeout.o obstack.o

SUNVSRCS  = infotool.c panel_sw.c text_sw.c complain_sw.c option_sw.c \
            print_sw.c
SUNVHDRS  = panel_sw.h text_sw.h complain_sw.h option_sw.h print_sw.h \
	    infotool.icon
SUNVOBJS  = infotool.o panel_sw.o text_sw.o complain_sw.o option_sw.o \
  	    print_sw.o

XVIEWOBJS = infotool_x.o panel_sw_x.o text_sw_x.o complain_sw_x.o \
	    option_sw_x.o print_sw_x.o

SRCS 	  = $(BROWSRCS) $(BROWHDRS) $(INFOSRCS) $(INFOHDRS) \
	    $(SUNVSRCS) $(SUNVHDRS) \
	    texindex.c info.sh hypermsg.c \
	    makeinfo.c getopt.c getopt.h getopt1.c
EXE	  = infoReader infotool $(XEXE) makeinfo texindex hypermsg.exe
SYS	  = texinfo.tex org.tnf padorg.tnf
AUX	  = texinfo.dg
CMD	  = hypertext.cmd help.cmd std_err.cmd all_info.cmd all_dvi.cmd \
	    format.cmd tex.cmd info_data.cmd

TIDY	  = core *~ *.o *.a ERRS TAGS a.out
CLEAN	  = $(TIDY) $(EXE) *.exe ../info.exe
CLOBBER   = $(CLEAN) Makefile
RCS	  = $(SRCS) $(SYS) $(AUX) $(CMD) Makefile.cpp

all:		$(SYS) $(AUX) $(CMD) $(EXE) ../info.exe
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

../info.exe: info.sh
	rm -f ../info.exe
	cp info.sh ../info.exe
	chmod 775 ../info.exe

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/texinfo; \
		rm -f $(DESTDIR)/Tool/texinfo/$$f; \
		cp $$f $(DESTDIR)/Tool/texinfo/$$f; \
		chmod 644 $(DESTDIR)/Tool/texinfo/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/texinfo/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for i in $(SYS); do \
		echo install -c -m 644 $$i $(DESTDIR)/Tool/texinfo; \
		rm -f $(DESTDIR)/Tool/texinfo/$$i; \
		cp $$i $(DESTDIR)/Tool/texinfo/$$i; \
		chmod 644 $(DESTDIR)/Tool/texinfo/$$i; \
	done
	@for i in $(EXE); do \
		echo install -c -m 755 $$i $(DESTDIR)/Tool/texinfo; \
		rm -f $(DESTDIR)/Tool/texinfo/$$i; \
		cp $$i $(DESTDIR)/Tool/texinfo/$$i; \
		chmod 755 $(DESTDIR)/Tool/texinfo/$$i; \
	done
	rm -f $(DESTDIR)/Tool/info.exe
	cp ../info.exe $(DESTDIR)/Tool/info.exe
	chmod 755 $(DESTDIR)/Tool/info.exe

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRCS) $(AUX) *infotool.exe

SourceDistr:	$(RCS)

# infoReader

infoReader:	info.a $(INFOOBJS)
	$(CC) $(LDFLAGS) -o infoReader $(INFOOBJS) info.a $(LIBS)

infoReader.o:	$(INFOHDRS)

# infotool

infotool:
	-if test -d $(SUNTOOLDIR); \
	then make infotool.exe; ln infotool.exe infotool; \
	else echo "#! /bin/sh" > infotool; \
	     echo -n "echo \"Sorry, infotool is not available" >> infotool; \
	     echo " because you don't have suntools.\"" >> infotool; \
	fi; chmod 775 infotool

infotool.exe:	info.a $(SUNVOBJS)
	$(CC) $(LDFLAGS) -o infotool.exe $(SUNVOBJS) info.a $(SUNVLIBS)

$(SUNVOBJS):	info.h $(SUNVHDRS)

# xinfotool	

xinfotool:	info.a $(XVIEWOBJS)
	$(CC) $(LDFLAGS) -o xinfotool $(XVIEWOBJS) info.a $(XVIEWLIBS)

$(XVIEWOBJS):	info.h $(SUNVHDRS)

.SUFFIXES:	_x.o .o .c

.c_x.o:
	$(CC) $(XCFLAGS) -c $< -o $*_x.o

# The standard library.

#if defined(NO_RANLIB)
info.a:		$(BROWOBJS)
	ar rcus info.a $(BROWOBJS)
#else
info.a:		$(BROWOBJS)
	ar rcu info.a $(BROWOBJS)
	ranlib info.a
#endif

# Auxiliary programs.

makeinfo:	makeinfo.c getopt.c getopt1.c getopt.h
	$(CC) $(CFLAGS) $(MIDEFS) -o makeinfo makeinfo.c getopt.c getopt1.c

texindex:	texindex.c
	$(CC) $(CFLAGS) -o texindex texindex.c

# Development tools.

kbdlint:	$(INFOSRCS) $(INFOHDRS) $(BROWSRCS) $(BROWHDRS)
	lint $(INFOSRCS) $(BROWSRCS)

sunlint:	$(SUNVSRCS) $(BROWSRCS) $(BROWHDRS)
	lint $(SUNVSRCS) $(BROWSRCS)

TAGS:		$(SRCS)
	etags $(SRCS)

# Cleaning, etc.

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(RCS)
	rm -rf $(CLEAN) Makefile

.PRECIOUS:	$(SYS) $(AUX) $(CMD)

.SUFFIXES:	.exe
.c.exe:
	$(CC) $(CFLAGS) -o $@ $*.c

STRBUILD	= strbuild.h obstack.h

complain_sw.o:	info.h file.h
complete.o:	info.h $(STRBUILD) typeout.h
example.o:	info.h file.h node.h option.h
file.o:		info.h file.h option.h
getopt1.o:	getopt.h
help.o:		info.h typeout.h
info.o:		info.h node.h
infoReader.o:	info.h $(STRBUILD) file.h node.h option.h
infotool.o:	info.h panel_sw.h text_sw.h complain_sw.h option_sw.h \
		infotool.icon option.h
list.o:		info.h
makeinfo.o:	getopt.h
menunote.o:	info.h node.h
node.o:		info.h file.h node.h
obstack.o:	obstack.h
option.o:	info.h option.h
option_sw.o:	info.h option.h
page.o:		info.h node.h
panel_sw.o:	info.h complain_sw.h option_sw.h print_sw.h info.h
print_sw.o:	info.h file.h node.h option.h
signals.o:	info.h
strbuild.o:	$(STRBUILD)
system.o:	info.h
termio.o:	info.h
text_sw.o:	info.h panel_sw.h
typeout.o:	info.h typeout.h
util.o:		info.h option.h
