static char RCSid[] = "$Id: get_incl.c,v 1.16 1993/01/11 22:42:37 kadhim Exp $";
/* Copyright, 1992, The Regents of the University of Colorado */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	FALSE 0
#define	TRUE 1

typedef struct {
	char *whole;	/* Complete name */
	char *key;	/* Selector */
} NAMESPEC;

#define NAMESZ 500
#define LINESZ 1000

static NAMESPEC *p, name[NAMESZ];
static char *me;

#if defined(__cplusplus) || defined(__STDC__)
int
main(int argc, char **argv)
#else
int
main(argc, argv)
   int argc;
   char **argv;
#endif
{
   char StrBuf[LINESZ], FileName[NAMESZ], NewFileName[NAMESZ];
   char *Str, *EndStr;
   int i;

   me = argv[0];

   if (argc < 2) {
      (void)fprintf(stderr, "%s: Search path required\n", me);
      return 1; }/*if*/

   InitPath(argv[1]);

   if (argc > 2) {
      InitDefine(argv[2]); }/*if*/

   if (argc > 3) {
      InitIgnore(argv[3]); }/*if*/

   if (argc > 4) {
      if (argc > 5)
         (void)fprintf(stderr, "%s: Only four arguments expected\n", me);
      InitDerived(argv[4]);
   } else {p = name; }/*if*/

   Str = fgets(StrBuf, LINESZ, stdin);
   while (Str != 0) {
      if (Str[strlen(Str)-1] != '\n') {
         (void)fprintf(stderr, "\"%s\" too long\n", Str);
         exit(1);
      }
      if (Str[0] == '#') {
	 i = 1;
	 while (Str[i] == ' ') i += 1;
	 /*select*/{
	    if (strncmp(&Str[i], "include", 7) == 0) {
	       i += 7;
	       while (Str[i] != '<' && Str[i] != '"' && Str[i] != 0) i += 1;
	       /*select*/{
		  if (Str[i] == '<') {
		     i += 1;
		     EndStr = strchr(&Str[i], '>');
		     if (EndStr == 0) {
			(void)fprintf(stderr, "%s: Bad include : \"%s\"\n", me, Str);
		     }else{
			EndStr[0] = '\0';
			if (Str[i] == '/') FileName[0] = '\0';
			else (void)strcpy(FileName, "/usr/include/");
			(void)strcat(FileName, &Str[i]);
			ExpandFileName(NewFileName, FileName);
			if (!IsIgnore(NewFileName)) puts(NewFileName);
		     }
		  }else if (Str[i] == '"') {
		     i += 1;
		     EndStr = strchr(&Str[i], '"');
		     if (EndStr == 0) {
			(void)fprintf(stderr, "%s: Bad include : \"%s\"\n", me, Str);
		     }else{
			EndStr[0] = '\0';
			if ((Str[i] == '/' || !IsDerived(&Str[i])) && !Exists(&Str[i])) {
			   /* Assume it's a system file as per cpp */
			   if (Str[i] == '/') FileName[0] = '\0';
			   else (void)strcpy(FileName, "/usr/include/");
			   (void)strcat(FileName, &Str[i]);
			   ExpandFileName(NewFileName, FileName);
			   if (!IsIgnore(NewFileName)) puts(NewFileName);
			}
		     }
		  }else{
		     (void)fprintf(stderr, "%s: Bad include : \"%s\"\n", me, Str);
		     };}/*select*/;
	    }else if (strncmp(&Str[i], "ifndef", 6) == 0) {
	       i += 6;
	       while (Str[i] == ' ') i += 1;
	       if (IsDefine(&Str[i])) SkipToEndIf();
	    }else{
	       }}/*select*/ }/*if*/
      Str = fgets(StrBuf, LINESZ, stdin); }/*while*/
   return 0;
   }/*main*/


static char *Path[20];

/**/
InitPath(FileName)
char *FileName;
/* Initialize the directory names on the search path
 *    On entry-
 *       FileName defines a file containing n directory names, 1 per line
 *    On exit-
 *       Path[0..n-1] point to the directory names
 *       Path[n]=0
 **/
{
	char line[LINESZ];
	int n;
	FILE *names;

	if ((names = fopen(FileName, "r")) == NULL) {
		(void)fprintf(stderr, "%s: Could not open %s\n", me, FileName);
		exit(1);
	}

	n = 0;
	while (fgets(line,LINESZ,names) != NULL) {
		int l = strlen(line);

		Path[n] = (char *)malloc((unsigned)(l));
		if (Path[n] == (char *) NULL) {
			(void)fprintf (stderr, "%s: malloc failed (Path[%d])\n",
				       me, n);
			exit (1);
		}
		(void)strncpy(Path[n],line,l-1);
		(Path[n++])[l-1] = '\0';
	}
	Path[n] = NULL;
}

/**/
int
Exists(included)
char *included;
/* Check the existence of an included file
 *    On entry-
 *       included=relative file name to be checked
 *    If the file is either available or explicitly ignored then on exit-
 *       Exists=TRUE
 *       If the file was not explicitly ignored then its full path name
 *         has been written to standard output
 *    Else on exit-
 *       Exists=FALSE
 **/
{
	char FileName[NAMESZ], NewFileName[NAMESZ];
	int i;
	struct stat buf;

	if (*included == '/') {
		if (IsIgnore(included)) return(TRUE);
		if (stat(included,&buf) == 0) {
			puts(included);
			return(TRUE);
		}
	}

	for (i = 0; Path[i] != NULL; i++) {
		(void)strcpy(FileName,Path[i]);
		(void)strcat(FileName,"/");
		(void)strcat(FileName,included);
		ExpandFileName(NewFileName,FileName);
		if (IsIgnore(NewFileName)) return(TRUE);
		if (stat(NewFileName,&buf) == 0) {
			puts(NewFileName);
			return(TRUE);
		}
	}
	return(FALSE);
}


int	num_IgnoreS = 0;
char	IgnoreS [10] [200];


InitIgnore(FileName)
   char *FileName;
{
   FILE *stream;
   char *Line, LineBuf[200];

   stream = fopen(FileName, "r");
   if (stream == NULL) {
      return; }/*if*/
   Line = fgets(LineBuf, sizeof(LineBuf), stream);
   while (Line != NULL) {
      Line[strlen(Line)-1] = 0;
      (void)strcpy(IgnoreS[num_IgnoreS], Line);
      num_IgnoreS += 1;
      Line = fgets(LineBuf, sizeof(LineBuf), stream); }/*while*/
   (void) fclose(stream);
   }/*InitIgnore*/


IsIgnore(FileName)
   char *FileName;
{
   int i;

   for (i=0; i<num_IgnoreS; i++) {
      if (strncmp(FileName, IgnoreS[i], strlen(IgnoreS[i])) == 0) {
	 return TRUE; }/*if*/ }/*for*/
   return FALSE;
   }/*IsIgnore*/


ExpandFileName(NewStr, OldStr)
   char *NewStr, *OldStr;
{
   int iNew, iOld, iSeg;
   char SegStr[200];

   iNew = 0; iOld = 0;
   while (OldStr[iOld] != 0) {
      /*select*/{
	 if (OldStr[iOld] == '/') {
	    NewStr[iNew] = '/';
	    iOld += 1; iNew += 1;
	 }else{
	    iSeg = 0;
	    while (OldStr[iOld] != '/' && OldStr[iOld] != 0) {
	       SegStr[iSeg] = OldStr[iOld];
	       iSeg += 1; iOld += 1; }/*while*/
	    SegStr[iSeg] = 0;
	    /*select*/{
	       if (strcmp(SegStr, "..") == 0) {
		  if (NewStr[iNew-1] != '/' || iNew <= 1) {
		     (void)fprintf(stderr, "%s: Bad filename : \"%s\"\n", me, OldStr);
		     }/*if*/
		  iNew -= 2;
		  while (NewStr[iNew] != '/') iNew -= 1;
	       }else if (strcmp(SegStr, ".") == 0) {
		  iNew -= 1;
		  if (NewStr[iNew] != '/') {
		     (void)fprintf(stderr, "%s: Bad filename : \"%s\"\n", me, OldStr);
		     }/*if*/
	       }else{
		  (void)strcpy(&NewStr[iNew], SegStr);
		  iNew += strlen(SegStr);
		  };}/*select*/ }}/*select*/ }/*while*/
   NewStr[iNew] = 0;
   }/*ExpandFileName*/


int	num_DefineS = 0;
char	DefineS [20] [200];


InitDefine(FileName)
   char *FileName;
{
   FILE *stream;
   char *Line, LineBuf[200];

   stream = fopen(FileName, "r");
   if (stream == NULL) {
      return; }/*if*/
   Line = fgets(LineBuf, sizeof(LineBuf), stream);
   while (Line != NULL) {
      Line[strlen(Line)-1] = 0;
      (void)strcpy(DefineS[num_DefineS], Line);
      num_DefineS += 1;
      Line = fgets(LineBuf, sizeof(LineBuf), stream); }/*while*/
   (void) fclose(stream);
   }/*InitDefine*/


IsDefine(Macro)
   char *Macro;
{
   int i;

   for (i=0; i<num_DefineS; i++) {
      if (strncmp(Macro, DefineS[i], strlen(DefineS[i])) == 0) {
	 return TRUE; }/*if*/ }/*for*/
   return FALSE;
   }/*IsDefine*/


SkipToEndIf()
{
   char StrBuf[LINESZ];
   char *Str;
   int i;

   Str = fgets(StrBuf, LINESZ, stdin);
   while (Str != 0) {
      if (Str[strlen(Str)-1] != '\n') {
         (void)fprintf(stderr, "\"%s\" too long\n", Str);
         exit(1);
      }
      if (Str[0] == '#') {
	 i = 1;
	 while (Str[i] == ' ') i += 1;
	 if (strncmp(&Str[i], "endif", 5) == 0) {
	    return; }/*if*/
	 if (strncmp(&Str[i], "if", 2) == 0) {
	    SkipToEndIf(); }/*if*/ }/*if*/
      Str = fgets(StrBuf, LINESZ, stdin); }/*while*/
   }/*SkipToEndIf*/


/**/
InitDerived(Filename)
char *Filename;
/* Initialize the list of derived include files
 *    On entry-
 *       Filename=name of the file containing the derived include files
 *    On exit-
 *       name points to the first derived include file name
 *       p points beyond the last derived include file name
 **/
{
	char line[LINESZ];
	FILE *names;

	if ((names = fopen(Filename, "r")) == NULL) {
		(void)fprintf(stderr, "%s: Could not open %s\n", me, Filename);
		exit(1);
	}

	p = name;
	while (fgets(line,LINESZ,names) != NULL) {
		char *q = line + strlen(line);

		do q--; while (*q <= ' ');
		*(q+1) = '\0';
		p->whole = (char *)malloc((unsigned)(q-line+2));
		if (p->whole == (char *) NULL) {
			(void)fprintf (stderr, "%s: malloc failed (p->whole)\n",
				       me);
			exit (1);
		}
		(void)strcpy(p->whole,line);
		q = (p->whole) + (q-line);
		while (*q > ' ' && *q != '@') q--;
		*q = '\0'; (p++)->key = q + 1;
	}
}

/**/
int
IsDerived(q)
char *q;
/* Check whether an include file is derived
 *    On entry-
 *       q points to the name of the include file
 *    If the name is on the derived include file list then on exit-
 *       IsDerived=1
 *    Else on exit-
 *       IsDerived=0
 **/
{
	char candidate[NAMESZ];
	NAMESPEC *t;

	(void)strcpy(candidate,q);
	t = name;
	while (t != p) {
		if (strcmp(candidate,t->key) == 0) break;
		t++;
	}
	if (t != p) puts(t->whole);
	return(t != p);
}
