#! /bin/csh -f
# $Id: batch_run.cmd,v 1.10 1990/03/02 13:40:34 waite Exp $
# Copyright, 1989, The Regents of the University of Colorado

#batch_run <
#   stdout "standard output from a test run"
#   output [data] "output files from a test run"
#   core ! "core dump of a test run"*
#   prof_dat ! "execution profile data"*
#   > "test run" :
#	USER
#		: exe
#		+ input
#		+ arg
#		+ stdin

umask 0
cd (|>output|)

if (-e (|<input|)) then
   set dir = `cat (|<input|)`
   foreach f (`ls $dir`)
      ln -s $f $f:t
      end
   endif
set arg = ""
if (-e (|<arg|)) then
   set arg = `cat (|<arg|)`
   endif
set stdin = /dev/null
if (-e (|<stdin|)) then
   set stdin = `cat (|<stdin|)`
   endif

((|<exe|) $arg < $stdin >! (|>stdout|)) >>&! (|>ERROR|)
if ($status != 0) echo run failed >>! (|>ERROR|)

if (-e core) mv core (|>core|)
if (-e gmon.out) mv gmon.out (|>prof_dat|)
exit 0
