# $Id: Makefile.cpp,v 1.5 1992/08/12 12:18:26 cogito Exp $
# Copyright (c) 1990, University of Paderborn.

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/ptg

COFLAGS	= -q

SPECS	= ptgprod.lido ptgall.lido ptghdr.lido ptggen.lido ptgprt.lido \
	ptgtype.lido ptgufct.lido ptgstyle.lido ptg.gla ptg.ptg ptg.pdl \
	ptg.head ptgtypes.c ptgstr.c ptgint.c ptgfct.c ptgfct.h ptg.specs \
	mk.ptg ptgtypes.h
EXE	= ptg.exe
AUX	= ptg.tnf ptg.dg
SYS	= ptg.err ptgadt.head
CMD	= ptg_gen.cmd ptg_out.cmd
SRCS	= $(SPECS) $(SYS) $(AUX) $(CMD)

TIDY	= *.o core a.out ELI *.dvi *.alw *.ps
CLEAN	= $(TIDY) *.exe
CLOBBER	= $(CLEAN) COMPILER Makefile

all:	$(AUX) $(SYS) $(CMD)
	cd COMPILER; make CC="$(CC)" ptg.exe
	if test -f ptg.exe; then rm -f ptg.exe; else :; fi
	ln COMPILER/ptg.exe $(EXE)
	@if test ! -d $(DESTDIR)/Cmd; \
		then umask 002; mkdir $(DESTDIR)/Cmd; \
		else :; \
		fi
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

gen: $(SPECS)
	rm -rf CACHE
	rm -f ptg.error
	-$(DESTDIR)/bin/eli -c $(DESTDIR) -n CACHE < mk.ptg
	@if test -s ptg.error ; \
	then exit 1 ; \
	else :; \
	fi

install: $(EXE) $(CMD) $(SYS) 
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR); \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp COMPILER $(AUX)

#
# Cleaning Targets
#

tidy:
	rm -rf $(TIDY)
	-cd COMPILER; make tidy

clean:
	rm -rf $(CLEAN)
	-cd COMPILER; make clean

clobber:
	rm -rf $(CLOBBER)

rcsclean:	clean
	-rcsclean $(COFLAGS) $(RCS) Makefile
	rm -f Makefile

#
# Distribution
#

SourceDistr:	$(SYS) $(AUX) $(CMD)
	mkdir COMPILER
	cp $(ELI)/COMPILER/* COMPILER
	cd COMPILER; make clean

distrib:	$(CMD) $(SYS) $(AUX) Makefile.cpp COMPILER
	cd COMPILER; make clean
	-rm -rf $(DISTRIB)/ptg
	mkdir $(DISTRIB)/ptg
	cp $(CMD) $(SYS) $(AUX) Makefile.cpp $(DISTRIB)/ptg
	cp -r COMPILER $(DISTRIB)/ptg/COMPILER
	cd $(DISTRIB)/ptg; chmod 644 $(CMD) $(SYS) $(AUX) Makefile.cpp COMPILER/*
	chmod 755 $(DISTRIB)/ptg/COMPILER

#
# Miscellenges
#

checkout:
	co $(COFLAGS) $(SRCS)

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u $(COFLAGS) Makefile $(RCS)
	-rcs -bOriginal.1 $(COFLAGS) Makefile $(RCS)
	-ci -fOriginal.1 -m/dev/null $(COFLAGS) -u Makefile
	-ci -fOriginal.1 -m/dev/null $(COFLAGS) $(RCS)

.PRECIOUS:	$(SRCS)



