static char RCSid[] = "$Id: ptgstr.c,v 2.1 1991/09/09 12:20:00 cogito Exp $";
/* Copyright, 1991, the University of Paderborn */
/* Author: Karl-Josef Prott
 *
 * This file contains the pair auxPtgString() and ptg_mkstr(). auxPTGString
 * is identical to the standard function auxCString() and ptg_mkstr() is
 * c_mkstr() except that the conversion to internal string representation
 * is deleted. It follows that these functionc must be used as a pair equal
 * to their originals.
 */

#include "err.h"
#include "source.h"
#include "gla.h"

extern char* malloc();
static char * DynamicStart = 0;
static char * DynamicEnd   = 0;
#define DYNAMICSIZE 1024	/* handle strings up to this length */
				/* not greater than PGSIZE in csmtbl.h ! */
#define BKSLASH '\\'
#define SQ	'\''

/*
** If arbitrary length strings are used, then BOTH
** auxPtgString and ptg_mkstr MUST be used.  The following
** variable checks this.
*/
static char CompanionWasNotCalled = 0;

/*
 * auxPtgString
 *
 * Scan a string literal after the opening double quote.
 *
 * On entry, start points to the opening quote, len should be 1.
 * On exit, we return the position after the closing quote.
 */

char *auxPtgString( start, len )
char *start;	/* used subtly - see below */
int len;
{
        register char c ;
        register char *p = start + len;
	int escape = 0;

newbuf:	if (escape) {
		if((c = *p++) == '\n') {
			LineNum++;
			StartLine = p - 1;
			}
		}
		
	/* three possible conditions can stop the loop */
top:	while( (c = *p++) && c != '"' && c != '\\' && c != '\n' )
		;

	if(c == '"'){
		if(DynamicStart<DynamicEnd){/* copy rest of multi-line*/

		    if(CompanionWasNotCalled)	/* assertion check */
		        message(FATAL, 
			"auxPtgString + ptg_mkstr must be used as a pair",0,
			&curpos);
		    CompanionWasNotCalled++;  /* ptg_mkstr must clear it*/

		    if(DynamicEnd-DynamicStart + p-start > DYNAMICSIZE){
			message(FATAL,
			"multi-line string too long", 0, &curpos);
			return p;
			}

		    while(start < p)
			*DynamicEnd++ = *start++;
		    }
		return(p);	/* normal string ending */
		} /* " */

	else if(c == '\\') {
		if((c = *p++) == '\n') {
			LineNum++;
			StartLine = p - 1;
			}
		else if(c == '\0') {
			p--;
			escape = 1;
			}
		goto top;
		}

	else if(c == '\n') {
		LineNum++;
		StartLine = p - 1;
		message(ERROR, "illegal newline in string literal", 0, &curpos);
		return p;
		}


	/*
	** We hit EOB or EOF and still have not finished finding string -
	** prepare for dynamic memory.
	*/
	else /* if (c == '\0') */ {
		/* if memory doesnt exist, get it */
		if(DynamicStart==0){
			DynamicStart = DynamicEnd = malloc(DYNAMICSIZE);
			if(DynamicStart == 0)
			  message(FATAL, "No mem for auxPtgString", 0,&curpos);
			}

		/* copy from source buffer to dynamic mem */
		/*  amt used so far        + new amt > total avail amt */
		if(DynamicEnd-DynamicStart + p-start > DYNAMICSIZE){
		  message(FATAL,"out of mem for multi-line string", 0, &curpos);
		  return p;
		  }
		while(start < p-1)
			*DynamicEnd++ = *start++;

		refillBuf( p-1 );
		start = p = TokenEnd; /* reset start so next copy will work */
		if (*p == '\0') {
			message(ERROR,"file ends in literal string",0,&curpos);
			return p-1;
			}
		else
			goto newbuf;	/* continue scanning string */
        }/*end else*/
}/*auxPtgString*/


/*
 * ptg_mkstr
 *
 * Make an internal string value from a character string by
 * colapsing escape sequences.
 *
 * On entry, c points to a character string of length 
 *           t points to a location containing the initial terminal code
 * On exit, t points to a location containing the correct terminal code
 *          an internal string value representing the character string has been
 *          stored at the location pointed to by v.
 */

void ptg_mkstr(c, length, t, v)
char *c;
int length, *t;
char *v;
{
	CompanionWasNotCalled = 0;	/* reset for auxPtgString */

	if (DynamicStart < DynamicEnd) {	/* difficult strings */

		/* overRide some stuff, BACKDOOR method !!! */
		c = DynamicStart;
		length = DynamicEnd-DynamicStart;
		DynamicEnd = DynamicStart;	/* reset back to normal */
		}

        mkstr( c, length, t, v ); /* save the string */
}
