
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) {
     (* (r->_print)) (r);
     fputs("\n", f);
  }
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  return (r);
}

typedef struct _SPTG6 *_PPTG6;
struct _SPTG6{
  _PTGProc _print;
  PTGNode _desc [6];
};

typedef struct _SPTG5 *_PPTG5;
struct _SPTG5{
  _PTGProc _print;
  PTGNode _desc [5];
};

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGName *_PPTGName;
struct _SPTGName{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGHeaderHead(_PPTG0 n)
#else
static void _PrPTGHeaderHead(n)
_PPTG0 n;
#endif
{
  fputs ("\n#ifndef _PTG_DEF\
\n#define _PTG_DEF\n\
\n#if defined(__STDC__) || defined(__cplusplus)\
\n#include <stdio.h>\
\n/* Needed, because we have Prototypes using FILE-Pointers */\
\n#endif\n", f);
  fputs ("\n#if defined(__cplusplus)\
\ntypedef void (* _PTGProc)(struct _SPTG0 *);\
\n#else\
\ntypedef void (* _PTGProc) ();\
\n#endif\
\ntypedef struct _SPTG0\
\n{\
\n  _PTGProc _print;\
\n} * _PPTG0;\
\ntypedef _PPTG0 PTGNode;			/* the only exported type */\n", f);
  fputs ("\n/* predefined value for empty PTG nodes */\
\nextern struct _SPTG0 _PTGNULL;\
\n#define PTGNULL (& _PTGNULL)\
\n#define PTGNull() (& _PTGNULL)\n", f);
  fputs ("\n/* output functions */\
\n#if defined(__STDC) || defined(__cplusplus)\
\nextern PTGNode PTGOut(PTGNode root);\
\n#else\
\nextern PTGNode PTGOut (/* PTGNode root */);\
\n#endif\n", f);
  fputs ("\n#if defined(__STDC) || defined(__cplusplus)\
\nextern PTGNode PTGOutFile(char *filename, PTGNode root);\
\n#else\
\nextern PTGNode PTGOutFile (/* char *filename, PTGNode root */);\
\n#endif\n", f);
  fputs ("\n#if defined(__STDC) || defined(__cplusplus)\
\nextern PTGNode PTGOutFPtr (FILE *outfile, PTGNode root);\
\n#else\
\nextern PTGNode PTGOutFPtr (/* FILE *outfile, PTGNode root */);\
\n#endif\n", f);
  fputs ("\n/* functions for making PTG nodes */", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGHeaderTail(_PPTG0 n)
#else
static void _PrPTGHeaderTail(n)
_PPTG0 n;
#endif
{
  fputs ("\n#endif\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGExternFct(_PPTG3 n)
#else
static void _PrPTGExternFct(n)
_PPTG3 n;
#endif
{
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nextern PTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (");\
\n#else\
\nextern PTGNode ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("();\
\n#endif\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTreeParamType(_PPTG0 n)
#else
static void _PrPTGTreeParamType(n)
_PPTG0 n;
#endif
{
  fputs ("PTGNode", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNoParamType(_PPTG0 n)
#else
static void _PrPTGNoParamType(n)
_PPTG0 n;
#endif
{
  fputs ("void", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIntType(_PPTG0 n)
#else
static void _PrPTGIntType(n)
_PPTG0 n;
#endif
{
  fputs ("int", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStringType(_PPTG0 n)
#else
static void _PrPTGStringType(n)
_PPTG0 n;
#endif
{
  fputs ("char *", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPointerType(_PPTG0 n)
#else
static void _PrPTGPointerType(n)
_PPTG0 n;
#endif
{
  fputs ("void *", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGFileHead(_PPTG0 n)
#else
static void _PrPTGFileHead(n)
_PPTG0 n;
#endif
{
  fputs ("\n#include <stdio.h>\
\n#ifndef MACH\
\n#include <malloc.h>\
\n#else\
\nextern void *malloc(unsigned);\
\nextern void free(void *);\
\n#endif\
\n#include \"ptg_gen.h\"\n", f);
  fputs ("\n#if defined(__STDC__) || defined (__cplusplus)\
\nstatic void _PrPTGNULL(_PPTG0 n)\
\n#else\
\nstatic void _PrPTGNULL(n)\
\n_PPTG0 n;\
\n#endif\
\n{(void)n; /* function printing nothing */}\n", f);
  fputs ("\nstruct _SPTG0   _PTGNULL = { _PrPTGNULL };\n\
\n#define MEMERR\\\
\n\t{ fprintf(stderr, \"Fatal ERROR: no memory available.\\n\"); exit(1); }\n\
\nstatic FILE *f;\n", f);
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nPTGNode PTGOut (PTGNode r)\
\n#else\
\nPTGNode PTGOut (r)\
\nPTGNode r;\
\n#endif\
\n{\
\n  f = stdout;\
\n  if (r) {\
\n     (* (r->_print)) (r);\
\n     fputs(\"\\n\", f);\
\n  }\
\n  return (r);\
\n}\
\n", f);
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nPTGNode PTGOutFile (char *fn, PTGNode r)\
\n#else\
\nPTGNode PTGOutFile (fn, r)\
\nchar * fn; PTGNode r;\
\n#endif\
\n{\
\n  if ((f = fopen(fn, \"w\"))  == (FILE *)NULL)\
\n  {\n\tfprintf(stderr, \"ERROR: PTGOutFile: output file '%s' can't be opened.\\n\",fn);\
\n\texit(1);\n  }\
\n  if (r) {\
\n    (* (r->_print)) (r);\
\n    fputs(\"\\n\", f);\
\n  }\
\n  fclose(f);\
\n  return (r);\
\n}\
\n", f);
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nPTGNode PTGOutFPtr(FILE *fptr, PTGNode r)\
\n#else\
\nPTGNode PTGOutFPtr(fptr, r)\
\nFILE * fptr; PTGNode r;\
\n#endif\
\n{\
\n  if ((f = fptr) == (FILE *)NULL)\
\n  {\
\n    fprintf(stderr, \"ERROR: PTGOutFPtr: output file not open.\\n\");\
\n    exit(1);\
\n  }\
\n  if (r) {\
\n    (* (r->_print)) (r);\
\n    fputs(\"\\n\", f);\
\n  }\
\n  return (r);\
\n}\
\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGFileTail(_PPTG0 n)
#else
static void _PrPTGFileTail(n)
_PPTG0 n;
#endif
{
  fputs ("\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPtrTypeDef(_PPTG2 n)
#else
static void _PrPTGPtrTypeDef(n)
_PPTG2 n;
#endif
{
  fputs ("\ntypedef ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" *", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNodeStructName(_PPTG1 n)
#else
static void _PrPTGNodeStructName(n)
_PPTG1 n;
#endif
{
  fputs ("struct _SPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNodePtrName(_PPTG1 n)
#else
static void _PrPTGNodePtrName(n)
_PPTG1 n;
#endif
{
  fputs ("_PPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGLeafStructName(_PPTG1 n)
#else
static void _PrPTGLeafStructName(n)
_PPTG1 n;
#endif
{
  fputs ("struct _SPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGLeafPtrName(_PPTG1 n)
#else
static void _PrPTGLeafPtrName(n)
_PPTG1 n;
#endif
{
  fputs ("_PPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStructDecl(_PPTG2 n)
#else
static void _PrPTGStructDecl(n)
_PPTG2 n;
#endif
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{", f);
  fputs ("\n  _PTGProc _print;", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGDescField(_PPTG1 n)
#else
static void _PrPTGDescField(n)
_PPTG1 n;
#endif
{
  fputs ("\n  PTGNode _desc [", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("];", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGGenFctName(_PPTG1 n)
#else
static void _PrPTGGenFctName(n)
_PPTG1 n;
#endif
{
  fputs ("PTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGParmName(_PPTG1 n)
#else
static void _PrPTGParmName(n)
_PPTG1 n;
#endif
{
  fputs ("_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGProtoParmName(_PPTG1 n)
#else
static void _PrPTGProtoParmName(n)
_PPTG1 n;
#endif
{
  fputs ("PTGNode _t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGGenFctHead(_PPTG6 n)
#else
static void _PrPTGGenFctHead(n)
_PPTG6 n;
#endif
{
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)", f);
  fputs ("\nPTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
  fputs ("\n#else\
\nPTGNode ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (")", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("\n#endif\
\n{\n  ", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs (" n;", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGGenFctBody(_PPTG5 n)
#else
static void _PrPTGGenFctBody(n)
_PPTG5 n;
#endif
{
  fputs ("\n\n  if ((n = (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") malloc (sizeof (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")))  ==  (", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (")NULL)\n\tMEMERR", f);
  fputs ("\n  n->_print = (_PTGProc) ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (";", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("\n  return ((PTGNode) n);\n}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNodeParmSpecs(_PPTG1 n)
#else
static void _PrPTGNodeParmSpecs(n)
_PPTG1 n;
#endif
{
  fputs ("\nPTGNode ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIntSpec(_PPTG1 n)
#else
static void _PrPTGIntSpec(n)
_PPTG1 n;
#endif
{
  fputs ("\n  int ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStringSpec(_PPTG1 n)
#else
static void _PrPTGStringSpec(n)
_PPTG1 n;
#endif
{
  fputs ("\n  char *", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPointerSpec(_PPTG1 n)
#else
static void _PrPTGPointerSpec(n)
_PPTG1 n;
#endif
{
  fputs ("\n  void *", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIntProto(_PPTG1 n)
#else
static void _PrPTGIntProto(n)
_PPTG1 n;
#endif
{
  fputs ("int _t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStringProto(_PPTG1 n)
#else
static void _PrPTGStringProto(n)
_PPTG1 n;
#endif
{
  fputs ("char *_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPointerProto(_PPTG1 n)
#else
static void _PrPTGPointerProto(n)
_PPTG1 n;
#endif
{
  fputs ("void *_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNodeAssign(_PPTG2 n)
#else
static void _PrPTGNodeAssign(n)
_PPTG2 n;
#endif
{
  fputs ("\n  n->_desc[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGLeafAssign(_PPTG2 n)
#else
static void _PrPTGLeafAssign(n)
_PPTG2 n;
#endif
{
  fputs ("\n  n->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintFctName(_PPTG1 n)
#else
static void _PrPTGPrintFctName(n)
_PPTG1 n;
#endif
{
  fputs ("_PrPTG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintFct(_PPTG5 n)
#else
static void _PrPTGPrintFct(n)
_PPTG5 n;
#endif
{
  fputs ("\n#if defined (__STDC__) || defined(__cplusplus)\
\nstatic void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" n)", f);
  fputs ("\n#else\
\nstatic void ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(n)", f);
  fputs ("\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (" n;", f);
  fputs ("\n#endif\
\n{", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("\n}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintStmt(_PPTG1 n)
#else
static void _PrPTGPrintStmt(n)
_PPTG1 n;
#endif
{
  fputs ("\n  fputs (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", f);", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisit(_PPTG2 n)
#else
static void _PrPTGVisit(n)
_PPTG2 n;
#endif
{
  fputs ("\n  (* (n->_desc [", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]->_print))", f);
  fputs ("(n->_desc[", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("]);", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGUserExternLibFct(_PPTG2 n)
#else
static void _PrPTGUserExternLibFct(n)
_PPTG2 n;
#endif
{
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nextern void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(FILE *f);\
\n#else\
\nextern void ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("();\n\
\n#endif\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGUserExternFct(_PPTG3 n)
#else
static void _PrPTGUserExternFct(n)
_PPTG3 n;
#endif
{
  fputs ("\n#if defined(__STDC__) || defined(__cplusplus)\
\nextern void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(FILE *, ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (");\
\n#else\
\nextern void ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("();\
\n#endif\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGCall(_PPTG1 n)
#else
static void _PrPTGCall(n)
_PPTG1 n;
#endif
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(f);", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintInt(_PPTG1 n)
#else
static void _PrPTGPrintInt(n)
_PPTG1 n;
#endif
{
  fputs ("\n  fprintf (f, \"%d\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintString(_PPTG1 n)
#else
static void _PrPTGPrintString(n)
_PPTG1 n;
#endif
{
  fputs ("\n  fprintf (f, \"%s\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPrintPointer(_PPTG1 n)
#else
static void _PrPTGPrintPointer(n)
_PPTG1 n;
#endif
{
  fputs ("\n  printf (f, \"%p\",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (");", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGArg(_PPTG1 n)
#else
static void _PrPTGArg(n)
_PPTG1 n;
#endif
{
  fputs ("n->_t", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGUserCall(_PPTG2 n)
#else
static void _PrPTGUserCall(n)
_PPTG2 n;
#endif
{
  fputs ("\n  ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(f", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (");", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeq(_PPTG2 n)
#else
static void _PrPTGSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeqCom(_PPTG2 n)
#else
static void _PrPTGSeqCom(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGComSeq(_PPTG2 n)
#else
static void _PrPTGComSeq(n)
_PPTG2 n;
#endif
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGComVal(_PPTG1 n)
#else
static void _PrPTGComVal(n)
_PPTG1 n;
#endif
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGName(_PPTGName n)
#else
static void _PrPTGName(n)
_PPTGName n;
#endif
{
  fprintf (f, "%s",n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNumb(_PPTGNumb n)
#else
static void _PrPTGNumb(n)
_PPTGNumb n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGHeaderHead()
#else
PTGNode PTGHeaderHead()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGHeaderHead;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGHeaderTail()
#else
PTGNode PTGHeaderTail()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGHeaderTail;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGExternFct(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGExternFct(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGExternFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTreeParamType()
#else
PTGNode PTGTreeParamType()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTreeParamType;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNoParamType()
#else
PTGNode PTGNoParamType()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNoParamType;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIntType()
#else
PTGNode PTGIntType()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIntType;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStringType()
#else
PTGNode PTGStringType()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStringType;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPointerType()
#else
PTGNode PTGPointerType()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPointerType;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGFileHead()
#else
PTGNode PTGFileHead()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGFileHead;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGFileTail()
#else
PTGNode PTGFileTail()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGFileTail;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPtrTypeDef(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGPtrTypeDef(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPtrTypeDef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNodeStructName(PTGNode _t0)
#else
PTGNode PTGNodeStructName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNodeStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNodePtrName(PTGNode _t0)
#else
PTGNode PTGNodePtrName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNodePtrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGLeafStructName(PTGNode _t0)
#else
PTGNode PTGLeafStructName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGLeafStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGLeafPtrName(PTGNode _t0)
#else
PTGNode PTGLeafPtrName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGLeafPtrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStructDecl(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGStructDecl(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGDescField(PTGNode _t0)
#else
PTGNode PTGDescField(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGDescField;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGGenFctName(PTGNode _t0)
#else
PTGNode PTGGenFctName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGGenFctName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGParmName(PTGNode _t0)
#else
PTGNode PTGParmName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProtoParmName(PTGNode _t0)
#else
PTGNode PTGProtoParmName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGProtoParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGGenFctHead(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3,PTGNode _t4,PTGNode _t5)
#else
PTGNode PTGGenFctHead(_t0,_t1,_t2,_t3,_t4,_t5)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5;
#endif
{
  _PPTG6 n;

  if ((n = (_PPTG6) malloc (sizeof (struct _SPTG6)))  ==  (_PPTG6)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGGenFctHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGGenFctBody(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3,PTGNode _t4)
#else
PTGNode PTGGenFctBody(_t0,_t1,_t2,_t3,_t4)
PTGNode _t0,_t1,_t2,_t3,_t4;
#endif
{
  _PPTG5 n;

  if ((n = (_PPTG5) malloc (sizeof (struct _SPTG5)))  ==  (_PPTG5)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGGenFctBody;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNodeParmSpecs(PTGNode _t0)
#else
PTGNode PTGNodeParmSpecs(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNodeParmSpecs;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIntSpec(PTGNode _t0)
#else
PTGNode PTGIntSpec(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIntSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStringSpec(PTGNode _t0)
#else
PTGNode PTGStringSpec(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStringSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPointerSpec(PTGNode _t0)
#else
PTGNode PTGPointerSpec(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPointerSpec;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIntProto(PTGNode _t0)
#else
PTGNode PTGIntProto(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIntProto;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStringProto(PTGNode _t0)
#else
PTGNode PTGStringProto(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStringProto;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPointerProto(PTGNode _t0)
#else
PTGNode PTGPointerProto(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPointerProto;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNodeAssign(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGNodeAssign(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNodeAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGLeafAssign(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGLeafAssign(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGLeafAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintFctName(PTGNode _t0)
#else
PTGNode PTGPrintFctName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintFctName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintFct(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3,PTGNode _t4)
#else
PTGNode PTGPrintFct(_t0,_t1,_t2,_t3,_t4)
PTGNode _t0,_t1,_t2,_t3,_t4;
#endif
{
  _PPTG5 n;

  if ((n = (_PPTG5) malloc (sizeof (struct _SPTG5)))  ==  (_PPTG5)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintStmt(PTGNode _t0)
#else
PTGNode PTGPrintStmt(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintStmt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisit(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGVisit(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGUserExternLibFct(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGUserExternLibFct(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGUserExternLibFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGUserExternFct(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGUserExternFct(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGUserExternFct;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGCall(PTGNode _t0)
#else
PTGNode PTGCall(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGCall;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintInt(PTGNode _t0)
#else
PTGNode PTGPrintInt(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintInt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintString(PTGNode _t0)
#else
PTGNode PTGPrintString(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintString;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPrintPointer(PTGNode _t0)
#else
PTGNode PTGPrintPointer(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPrintPointer;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGArg(PTGNode _t0)
#else
PTGNode PTGArg(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGArg;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGUserCall(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGUserCall(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGUserCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeqCom(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeqCom(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeqCom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGComSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGComVal(PTGNode _t0)
#else
PTGNode PTGComVal(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGComVal;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGName(char *_t0)
#else
PTGNode PTGName(_t0)
  char *_t0;
#endif
{
  _PPTGName n;

  if ((n = (_PPTGName) malloc (sizeof (struct _SPTGName)))  ==  (_PPTGName)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGName;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNumb(int _t0)
#else
PTGNode PTGNumb(_t0)
  int _t0;
#endif
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}


