static char rcsid[] = "$Id: keyarray.c,v 1.1 1993/01/05 05:12:41 waite Exp $";
/* Copyright 1992, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <stdlib.h>
#include "err.h"
#include "keyarray.h"
#include "obstack.h"
#define obstack_chunk_alloc malloc
#define obstack_chunk_free free

#define NoPosition (POSITION *)0

static struct obstack *ArrayStack = (struct obstack *)0;
static DefTableKey Nothing = NoKey;

/***/
KeyArray
NewKeyArray(n)
int n;
/* Create a array of definition table keys
 *    On entry-
 *       n=number of keys in the array
 *    On exit-
 *       NewKeyArray is an array of n "NoKey" values,
 *          indexed by the integers 0 through n-1 inclusive
 ***/
{
  if (ArrayStack == (struct obstack *)0) {
    ArrayStack = (struct obstack *)malloc(sizeof(struct obstack));
    if (ArrayStack == (struct obstack *)0) {
      message(DEADLY, "NewKeyArray: malloc failure", 0, NoPosition);
    }
    obstack_init(ArrayStack);
  }

  if (n < 0)
    message(DEADLY, "NewKeyArray: Negative size requested", 0, NoPosition);

  if (n == 0) return NoKeyArray;

  obstack_grow(ArrayStack, (void *)&n, sizeof(int));
  while (n--) obstack_grow(ArrayStack, (void *)&Nothing, sizeof(DefTableKey));
  return (KeyArray)obstack_finish(ArrayStack);
}

/***/
void
StoreKeyInArray(b,i,k)
KeyArray b; int i; DefTableKey k;
/* Store a definition table key into an array of keys
 *    On entry-
 *       b is the array into which the key is to be stored
 *       k is the key to be stored
 *    If i is a valid index for b then on exit-
 *       element i of b contains k
 *    Else on exit-
 *       b is unchanged
 ***/
{
  if (b != NoKeyArray && i >= 0 && i < b->size) b->Key[i] = k;
}

/***/
DefTableKey
FetchKeyFromArray(b,i)
KeyArray b; int i;
/* Fetch a definition table key from an array of keys
 *    On entry-
 *       b is the array from which the key is to be fetched
 *       i is the index of the element to be fetched
 *    If i is a valid index for b then on exit-
 *       FetchKeyFromArray=key i of array b
 *    Else on exit-
 *       FetchKeyFromArray=NoKey
 ***/
{
  if (b == NoKeyArray || i < 0 || i >= b->size) return NoKey;
  return b->Key[i];
}
