
#include "HEAD.h"

#include "node.h"

#include "visitprocs.h"

#include "gsdescr.h"

extern void free();

extern char *malloc();

#include "obstack.h"

static struct obstack TreeSpace;

#define obstack_chunk_alloc malloc

#define obstack_chunk_free free

char* TreeNodeAlloc(size) int size;

{return (obstack_alloc(&TreeSpace, size));}

void InitTree() { obstack_init(&TreeSpace); }

NODEPTR MkIdentifier(_coordref,_tr1)
POSITION *_coordref;
int _tr1;
{
_TSPIdentifier n;
n = (_TSPIdentifier) TreeNodeAlloc (sizeof (struct _TSIdentifier));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATsym=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkString(_coordref,_tr1)
POSITION *_coordref;
int _tr1;
{
_TSPString n;
n = (_TSPString) TreeNodeAlloc (sizeof (struct _TSString));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATsym=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkText(_coordref,_tr1)
POSITION *_coordref;
pchar _tr1;
{
_TSPText n;
n = (_TSPText) TreeNodeAlloc (sizeof (struct _TSText));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATptr=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkAxiom(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPAxiom n;
n = (_TPPAxiom) TreeNodeAlloc (sizeof (struct _TPAxiom));
n->_proc =_VS1Axiom;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPRange)_tr1;
n->_desc2= (_TSPLibraryList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkMultipleOpDecls(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMultipleOpDecls n;
n = (_TPPMultipleOpDecls) TreeNodeAlloc (sizeof (struct _TPMultipleOpDecls));
n->_proc =_VS1MultipleOpDecls;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationList)_tr1;
n->_desc2= (_TSPOperationDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkSingleOpDecl(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSingleOpDecl n;
n = (_TPPSingleOpDecl) TreeNodeAlloc (sizeof (struct _TPSingleOpDecl));
n->_proc =_VS1SingleOpDecl;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkDeclarations(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPDeclarations n;
n = (_TPPDeclarations) TreeNodeAlloc (sizeof (struct _TPDeclarations));
n->_proc =_VS1Declarations;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPGEN_Range)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkPropertySpec(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPPropertySpec n;
n = (_TPPPropertySpec) TreeNodeAlloc (sizeof (struct _TPPropertySpec));
n->_proc =_VS1PropertySpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPropertyNameList)_tr1;
n->_desc2= (_TSPType)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkMultipleProperties(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMultipleProperties n;
n = (_TPPMultipleProperties) TreeNodeAlloc (sizeof (struct _TPMultipleProperties));
n->_proc =_VS1MultipleProperties;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPropertyNameList)_tr1;
n->_desc2= (_TSPPropertyNameDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkSingleProperty(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSingleProperty n;
n = (_TPPSingleProperty) TreeNodeAlloc (sizeof (struct _TPSingleProperty));
n->_proc =_VS1SingleProperty;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPropertyNameDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkPropertyName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPPropertyName n;
n = (_TPPPropertyName) TreeNodeAlloc (sizeof (struct _TPPropertyName));
n->_proc =_VS1PropertyName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkTypeNoOp(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPTypeNoOp n;
n = (_TPPTypeNoOp) TreeNodeAlloc (sizeof (struct _TPTypeNoOp));
n->_proc =_VS1TypeNoOp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkTypeWithOp(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPTypeWithOp n;
n = (_TPPTypeWithOp) TreeNodeAlloc (sizeof (struct _TPTypeWithOp));
n->_proc =_VS1TypeWithOp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
n->_desc2= (_TSPOperationNameList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkMultipleOperations(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMultipleOperations n;
n = (_TPPMultipleOperations) TreeNodeAlloc (sizeof (struct _TPMultipleOperations));
n->_proc =_VS1MultipleOperations;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationNameList)_tr1;
n->_desc2= (_TSPOperationNameDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkSingleOperation(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSingleOperation n;
n = (_TPPSingleOperation) TreeNodeAlloc (sizeof (struct _TPSingleOperation));
n->_proc =_VS1SingleOperation;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationNameDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOperationName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOperationName n;
n = (_TPPOperationName) TreeNodeAlloc (sizeof (struct _TPOperationName));
n->_proc =_VS1OperationName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkFileSpec(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPFileSpec n;
n = (_TPPFileSpec) TreeNodeAlloc (sizeof (struct _TPFileSpec));
n->_proc =_VS1FileSpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPString)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOperationSpec(_coordref,_tr1,_tr2,_tr3,_tr4)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
{_TPPOperationSpec n;
n = (_TPPOperationSpec) TreeNodeAlloc (sizeof (struct _TPOperationSpec));
n->_proc =_VS1OperationSpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
n->_desc3= (_TSPParameterList)_tr3;
n->_desc4= (_TSPText)_tr4;
return ( (NODEPTR) n);
}

NODEPTR MkGenericType(_coordref)
POSITION *_coordref;
{_TPPGenericType n;
n = (_TPPGenericType) TreeNodeAlloc (sizeof (struct _TPGenericType));
n->_proc =_VS1GenericType;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkDefinedType(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPDefinedType n;
n = (_TPPDefinedType) TreeNodeAlloc (sizeof (struct _TPDefinedType));
n->_proc =_VS1DefinedType;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkMultipleParameters(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMultipleParameters n;
n = (_TPPMultipleParameters) TreeNodeAlloc (sizeof (struct _TPMultipleParameters));
n->_proc =_VS1MultipleParameters;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterList)_tr1;
n->_desc2= (_TSPParameterDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkSingleParameter(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSingleParameter n;
n = (_TPPSingleParameter) TreeNodeAlloc (sizeof (struct _TPSingleParameter));
n->_proc =_VS1SingleParameter;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkParameterSpec(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPParameterSpec n;
n = (_TPPParameterSpec) TreeNodeAlloc (sizeof (struct _TPParameterSpec));
n->_proc =_VS1ParameterSpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
n->_desc3= (_TSPModifier)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkEmptyModifier(_coordref)
POSITION *_coordref;
{_TPPEmptyModifier n;
n = (_TPPEmptyModifier) TreeNodeAlloc (sizeof (struct _TPEmptyModifier));
n->_proc =_VS1EmptyModifier;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkVoidModifier(_coordref)
POSITION *_coordref;
{_TPPVoidModifier n;
n = (_TPPVoidModifier) TreeNodeAlloc (sizeof (struct _TPVoidModifier));
n->_proc =_VS1VoidModifier;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkSimpleModifier(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSimpleModifier n;
n = (_TPPSimpleModifier) TreeNodeAlloc (sizeof (struct _TPSimpleModifier));
n->_proc =_VS1SimpleModifier;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterTypeList)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkExtendedModifier(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPExtendedModifier n;
n = (_TPPExtendedModifier) TreeNodeAlloc (sizeof (struct _TPExtendedModifier));
n->_proc =_VS1ExtendedModifier;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterTypeList)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkMultipleParameterTypes(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMultipleParameterTypes n;
n = (_TPPMultipleParameterTypes) TreeNodeAlloc (sizeof (struct _TPMultipleParameterTypes));
n->_proc =_VS1MultipleParameterTypes;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterTypeList)_tr1;
n->_desc2= (_TSPParameterTypeDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkSingleParameterType(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSingleParameterType n;
n = (_TPPSingleParameterType) TreeNodeAlloc (sizeof (struct _TPSingleParameterType));
n->_proc =_VS1SingleParameterType;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPParameterTypeDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkParameterTypeSpec(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPParameterTypeSpec n;
n = (_TPPParameterTypeSpec) TreeNodeAlloc (sizeof (struct _TPParameterTypeSpec));
n->_proc =_VS1ParameterTypeSpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
n->_desc2= (_TSPModifier)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkIdentParameterTS(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPIdentParameterTS n;
n = (_TPPIdentParameterTS) TreeNodeAlloc (sizeof (struct _TPIdentParameterTS));
n->_proc =_VS1IdentParameterTS;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTypeSpecifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
n->_desc3= (_TSPModifier)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkLibrarySpec(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPLibrarySpec n;
n = (_TPPLibrarySpec) TreeNodeAlloc (sizeof (struct _TPLibrarySpec));
n->_proc =_VS1LibrarySpec;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationList)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkTypeName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPTypeName n;
n = (_TPPTypeName) TreeNodeAlloc (sizeof (struct _TPTypeName));
n->_proc =_VS1TypeName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_19_1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPGEN_73_19_1 n;
n = (_TPPGEN_73_19_1) TreeNodeAlloc (sizeof (struct _TPGEN_73_19_1));
n->_proc =_VS1GEN_73_19_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPGEN_Range)_tr1;
n->_desc2= (_TSPPropertyDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_19_0(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPGEN_73_19_0 n;
n = (_TPPGEN_73_19_0) TreeNodeAlloc (sizeof (struct _TPGEN_73_19_0));
n->_proc =_VS1GEN_73_19_0;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPropertyDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_20_1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPGEN_73_20_1 n;
n = (_TPPGEN_73_20_1) TreeNodeAlloc (sizeof (struct _TPGEN_73_20_1));
n->_proc =_VS1GEN_73_20_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPGEN_Range)_tr1;
n->_desc2= (_TSPFileDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_20_0(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPGEN_73_20_0 n;
n = (_TPPGEN_73_20_0) TreeNodeAlloc (sizeof (struct _TPGEN_73_20_0));
n->_proc =_VS1GEN_73_20_0;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPFileDecl)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_18_1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPGEN_73_18_1 n;
n = (_TPPGEN_73_18_1) TreeNodeAlloc (sizeof (struct _TPGEN_73_18_1));
n->_proc =_VS1GEN_73_18_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPGEN_Range)_tr1;
n->_desc2= (_TSPOperationDecl)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkGEN_73_18_0(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPGEN_73_18_0 n;
n = (_TPPGEN_73_18_0) TreeNodeAlloc (sizeof (struct _TPGEN_73_18_0));
n->_proc =_VS1GEN_73_18_0;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOperationDecl)_tr1;
return ( (NODEPTR) n);
}

#ifndef GETIdentifiersym
#define GETIdentifiersym(x) (x)
#endif

#ifndef GETStringsym
#define GETStringsym(x) (x)
#endif

#ifndef GETTextptr
#define GETTextptr(x) (x)
#endif

void SourceLeaf(d) GRUNDSYMBOLDESKRIPTOR *d;
{_incrnodestack ();
switch (d->SyntaxCode) {

case 2: _nst[_nsp] =MkIdentifier(&(d->Pos),GETIdentifiersym (d->Attr)); break;

case 3: _nst[_nsp] =MkString(&(d->Pos),GETStringsym (d->Attr)); break;

case 4: _nst[_nsp] =MkText(&(d->Pos),GETTextptr (d->Attr)); break;
}}

