# $Id: Makefile.cpp,v 1.34 1992/07/02 18:26:26 kadhim Exp $
# Copyright (c) 1989, The Regents of the University of Colorado.

SHELL	= /bin/sh

ODIN	= ../../odin/odin.sh

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/oil

#ifdef _AIX
ACC     = cc -qlanglvl=ansi
#else
ACC	= $(CC)
#endif

CFLAGS	= -I../../.. 
LINTFLAGS	= 
PFLAGS	= -w -temp=.
COFLAGS	= -q

SRCS    = oiladt2a.c oiladt2b.c oiladt2c.c oiladt2d.c oiladt2e.c
HDRS    = oiladt2.h oiladt2a.h oiladt2c.h oiladt2d.h oiladt2e.h
SYS	= $(HDRS) $(SRCS) oil.err
AUX	= oil.dg oil.tnf
CMD	= oil_gen.cmd oil_out.cmd

TIDY	= ERRS *.o core a.out *~ *.dvi
CLEAN	= $(TIDY) testShip oil.exe *.ps *.alw
CLOBBER	= $(CLEAN) Makefile

SUBDIRS	= compiler

MAKE	= make DESTDIR=$(DESTDIR) ELI=$(ELI) ODIN=$(ODIN) \
		CFLAGS="$(CFLAGS)" PFLAGS="$(PFLAGS)" CC="$(ACC)"

all:	$(SYS) $(AUX) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for d in $(SUBDIRS); do echo; echo Making Tool/oil/$$d; (cd $$d; \
		$(MAKE) all); done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/oil; \
		rm -f $(DESTDIR)/Tool/oil/$$f; \
		cp $$f $(DESTDIR)/Tool/oil/$$f; \
		chmod 644 $(DESTDIR)/Tool/oil/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/oil/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/oil; \
		rm -f $(DESTDIR)/Tool/oil/$$f; \
		cp $$f $(DESTDIR)/Tool/oil; \
		chmod 644 $(DESTDIR)/Tool/oil/$$f; \
	done
	rm -f $(DESTDIR)/Tool/oil/oil.exe 
	cp oil.exe $(DESTDIR)/Tool/oil/oil.exe 
	chmod 755 $(DESTDIR)/Tool/oil/oil.exe

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp tests adttests $(SUBDIRS) $(AUX)

SourceDistr:	$(SYS) $(AUX) $(CMD)
	@for d in $(SUBDIRS); do \
		echo; echo Source Tool/oil/$$d; \
		mkdir $$d; cd $$d; ln -s $(ELI)/$$d/RCS .; \
		co $(COFLAGS) Makefile.cpp; \
		$(MAKE) -f Makefile.cpp SourceDistr; \
		rm RCS; cd ..; done

# Keeping things neat
tidy:
	rm -rf $(TIDY)
	@for d in $(SUBDIRS); do echo ; echo Tidying Tool/oil/$$d; \
		(cd $$d; $(MAKE) tidy); done

clean:
	rm -rf $(CLEAN)
	@for d in $(SUBDIRS); do echo; echo Cleaning Tool/oil/$$d; \
		(cd $$d; $(MAKE) clean); done
	

clobber:
	rm -rf $(CLOBBER)
	@for d in $(SUBDIRS); do echo; echo Clobbering Tool/oil/$$d; \
		cd $$d; $(MAKE) clobber; cd ..; done

rcsclean:
	@for d in $(SUBDIRS); do echo; echo RCScleaning Tool/oil/$$d; \
		(cd $$d; $(MAKE) rcsclean); done
	-rcsclean $(COFLAGS) Makefile.cpp $(SYS) $(AUX) $(CMD)
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SYS) $(AUX) $(CMD)
	-rcs -bOriginal.1 -q Makefile.cpp $(SYS) $(AUX) $(CMD)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SYS) $(AUX) $(CMD)
	for d in $(SUBDIRS); do \
		cd $$d; $(MAKE) save; cd ..; done

.PRECIOUS:	$(SYS) $(AUX) $(CMD)

# check for lint in library
lint.log:	$(SRCS) $(HDRS)
	lint $(LINTFLAGS) $(SRCS) | \
	sed -e "/^Oil[a-zA-Z0-9]* defined/d" >lint.log

# Derive compilable sources from Eli
derive: derivedSRCS

derivedSRCS:
	cd compiler; $(MAKE) derivedSRCS


# Test shipment
testShip:
	mkdir testShip; mkdir testShip/Cmd
	cd testShip;  ln -s ../RCS .;  co Makefile.cpp; \
		$(MAKE) -f Makefile.cpp ELI=`pwd`/.. DESTDIR=`pwd` \
			SourceDistr all
