/* $Id: showproc.c,v 3.3 1992/09/16 14:14:28 cogito Exp $ */

static char rcsi_d[] = "$Id: showproc.c,v 3.3 1992/09/16 14:14:28 cogito Exp $";

/***********************************************************************\
*									*
*		Implementation of a LIGA pass				*
*		    -- Interface Analyzer --				*
*									*
*	Module:		Show    					*
*	File:		showproc.c	      				*
*	Author:		U. Kastens					*
*									*
\***********************************************************************/

#include <stdio.h>

/*
#include "global.h"	included by LIGA.h
#include "LIGA.h"	included by lookup_idl.h
#include "LIGAMacros.h"	included by lookup_idl.h
*/

#include "lookup_idl.h"
#include "liga_func.h"
#include "ligaconsts.h"

#include "showproc.h"
#include "show_ptg_gen.h"
#include "map_errors.h"

#define IsLast(x)	(x->next == NULL)

static PTGNode	Unknown;

PTGNode MakeCoord (line, col)
	int	line, col;
{	int	ind, nline;
MapCoord (line, &ind, &nline);
return (PTGCoord (PTGFileRef (PTGNumb (ind)), 
		PTGNumb (nline), PTGNumb (col)));
}/*MakeCoord*/

PTGNode GetDefName (did)
	int	did;
{	Def	d;
if (did > DIDNON) {
	d = lookup_def (did); 
	if (d.IDLclassCommon != (CPDef)0)
		return (PTGName (dnameOfDef (d)));
	else return (Unknown);
} else	return (Unknown); 
}/*GetDefName*/

PTGNode GetAttrName (did)
	int	did;
{	Attrdef	d;
if (did > DIDNON) {
	d = lookup_attrdef (did); 
	if (d != (Attrdef)0)
		return (PTGName (nameOfAttrdef (d)));
	else return (Unknown);
} else	return (Unknown); 
}/*GetAttrName*/

PTGNode ShowProduction (did)
	int	did;
{	PTGNode	res, pname, plhs;
	int	rhscnt;
	Prod	AProd;
	Def	d;
	int		lhs;
	SEQEntity	TRrhs;
	Entity		AEntity;

if (did > DIDNON) d = lookup_def (did); 
else	return (PTGNULL);

if (typeof (d) != KProd) return (PTGNULL);
AProd = DefToProd (d);
lhs = lhsOfProd (AProd);

/*===================process a Prod=======================*/
res = PTGNULL;
rhscnt = 0;
plhs = PTGSymbolIndex (GetDefName(lhs), PTGNumb (rhscnt++));
pname = PTGName (dnameOfDef (d));

foreachinSEQEntity (rhsOfProd (AProd), TRrhs, AEntity) {

switch (typeof (AEntity)) {
case KUnit: {Unit	AUnit; 
	int		row;
	int		col;
AUnit = EntityToUnit (AEntity);
row = rowOfUnit (AUnit);
col = colOfUnit (AUnit);

switch (typeof (AUnit)) {
case KSymbol: {Symbol	ASymbol; 
	int		did;
ASymbol = EntityToSymbol (AEntity);
did = didOfSymbol (ASymbol);
/*===================process a Symbol=======================*/

res = PTGSeq (res, 
	PTGSymbolIndex (GetDefName (did), PTGNumb(rhscnt++)));

/*===================end of Symbol==========================*/
break;}/*Symbol*/

case KLiteral: {Literal	ALiteral; 
	char*		str;
ALiteral = EntityToLiteral (AEntity);
str = strOfLiteral (ALiteral);
/*===================process a Literal=======================*/

res = PTGSeq (res, PTGLiteral (PTGName (str)));
/*===================end of Literal==========================*/
break;}/*Literal*/

}/*switch Unit*/

break;}/*Unit*/

default:;
/* unused:
Opt		=>	rhs:		Seq Of Unit;

Star		=>	rhs:		Seq Of Unit;

Plus		=>	rhs:		Seq Of Unit;

Delim		=>	rhs:		Seq Of Unit,
			del:		Literal;

Delopt		=>	rhs:		Seq Of Unit,
			del:		Literal;
*/
}/*switch Entity*/

}/*foreachinSEQEntity*/

return (PTGVisitRule (pname, plhs, res));
/*===================end of Prod==========================*/
}/* ShowProduction */


void PAttrEval (AAttrEval)
	AttrEval	AAttrEval;
{	SEQDef		TRdefseq; 
	Def		ADef;
	SEQAttribution	TRattrrules; 
	Attribution	AAttribution;
/*===================process a AttrEval=======================*/
PTGNode Comma, ColSemi, Semicol, NewLine;
PTGNode TreeStore, StackStore;
PTGNode OrigChain, OrigConst, OrigIncl;
PTGNode AttrLists;
PTGNode NTerms, Terms, AllVisits;
int	NTermCnt = 0, TermCnt = 0;

init_did_table (AAttrEval->defseq);

Unknown = PTGUnknown ();
Comma = PTGComma ();
ColSemi = PTGColSemi ();
Semicol = PTGSemicol ();
NewLine = PTGNewLine ();

TreeStore = PTGTreeStore ();
StackStore = PTGStackStore ();
OrigChain = PTGOrigChain ();
OrigConst = PTGOrigConst ();
OrigIncl = PTGOrigIncl ();

/* symbols only :*/
NTerms = PTGNONTERM ();
Terms = PTGTERM ();

/* attribute lists */
AttrLists = PTGNULL;

foreachinSEQDef (defseqOfAttrEval (AAttrEval), TRdefseq, ADef) {
	int		did;
	char*		dname;
	int		row;
	int		col;
did = didOfDef (ADef);
dname = dnameOfDef (ADef);
row = rowOfDef (ADef);
col = colOfDef (ADef);

switch (typeof (ADef)) {
case KChain: {Chain AChain; 
	int		typeid;
AChain = DefToChain (ADef);
typeid = typeidOfChain (AChain);
/*===================process a Chain=======================*/

/*===================end of Chain==========================*/
break;}/*Chain*/

case KTypedef: {Typedef ATypedef; 
	char*		extname;
	int		listedto;
ATypedef = DefToTypedef (ADef);
extname = extnameOfTypedef (ATypedef);
listedto = listedtoOfTypedef (ATypedef);
/*===================process a Typedef=======================*/

/*===================end of Typedef==========================*/
break;}/*Typedef*/

case KSymb: {Symb ASymb;
	int		tornt;
	SEQAttrdef	TRattrs;
	Attrdef		AAttrdef;
ASymb = DefToSymb (ADef);
tornt = torntOfSymb (ASymb);
/*===================process a Symb==========================*/

/* symbols only :*/
if (tornt == SYMBNONT) {
	if (NTermCnt > 0) NTerms = PTGSeq (NTerms, Comma);
	if ((NTermCnt++ % 5) == 0) NTerms = PTGSeq (NTerms, NewLine);
	NTerms = PTGSeq (NTerms, PTGName (dname));
} else {
	if (TermCnt > 0) Terms = PTGSeq (Terms, Comma);
	if ((TermCnt++ % 5) == 0) Terms = PTGSeq (Terms, NewLine);
	Terms = PTGSeq (Terms, PTGName (dname));
}

/* attribute lists */
AttrLists = PTGSeq (AttrLists, PTGAttrListHead (
		(tornt == SYMBNONT ? PTGNONTERM () : PTGTERM ()),
		PTGName (dname)));

foreachinSEQAttrdef (attrsOfSymb (ASymb), TRattrs, AAttrdef) {
	int		did;
	char*		name;
	int		row;
	int		col;
	int		typeid;
	int		class;
	int		prodid;
	int		store;
	int		gen;
	int		part;
	char*		globname;
	PTGNode		adecl, ainfo, a1, a2, a3;
	Def		d;
did = didOfAttrdef (AAttrdef);
name = nameOfAttrdef (AAttrdef);
row = rowOfAttrdef (AAttrdef);
col = colOfAttrdef (AAttrdef);
typeid = typeidOfAttrdef (AAttrdef);
class = classOfAttrdef (AAttrdef);
prodid = prodidOfAttrdef (AAttrdef);
store = storeOfAttrdef (AAttrdef);
gen = genOfAttrdef (AAttrdef);
part = partOfAttrdef (AAttrdef);
globname = globnameOfAttrdef (AAttrdef);
/*===================process a Attrdef=======================*/
/* attribute lists */
a1 = GetDefName (typeid);
if (class == ATCLSYNT) a2 = PTGSYNT (); else
if (class == ATCLINH)  a2 = PTGINH (); else a2 = Unknown;
a3 = (IsLast (TRattrs) ? PTGSpace2 () : Comma);
adecl = PTGAttrDecl (PTGName (name), a1, a2, a3);

if (store == STORGLVA) a1 = PTGVarStore (PTGName (globname)); else
if (store == STORGLST) a1 = StackStore; else
if (store == STORTRAT) a1 = TreeStore; else a1 = Unknown;

if (gen == GENINCL) a2 = OrigIncl; else
if (gen == GENCONST) a2 = OrigConst; else
if (gen == GENCHAIN) a2 = OrigChain; else
if (prodid > 0) 
	a2 = PTGOrigRule (GetDefName (prodid));
else	a2 = PTGNULL;

a3 = MakeCoord (row, col);
ainfo = PTGAttrInfo (PTGNumb (part), a1, a2, a3);
AttrLists = PTGSeq (AttrLists, PTGSeq (adecl, ainfo));

/*===================end of Attrdef==========================*/

/*===================end of Symb=============================*/
}/*foreachinSEQAttrdef*/

AttrLists = PTGSeq (AttrLists, PTGSeq (NewLine, Semicol));
/*===================end of Symb=============================*/
break;}/*Symb*/

case KProd: {Prod AProd; 
break;}/*Prod*/
}/*switch Def*/

}/*foreachinSEQDef*/

/* symbols only :*/
Terms = PTGSeq (Terms, ColSemi);
NTerms = PTGSeq (NTerms, ColSemi);

/* visit sequences */
AllVisits = PTGNULL;

foreachinSEQAttribution (attrrulesOfAttrEval (AAttrEval), TRattrrules, AAttribution) {
	int		prodid;
	SEQAttrrule	TRattrrules;
	Attrrule	AAttrrule;
prodid = prodidOfAttribution (AAttribution);
/*===================process a Attribution=======================*/

/* visit sequences */
AllVisits = PTGSeq (AllVisits, ShowProduction (prodid));

foreachinSEQAttrrule (attrrulesOfAttribution (AAttribution), TRattrrules, AAttrrule) {
switch (typeof (AAttrrule)) {

case KCall: {Call ACall; 
	SEQExpr	TRparams;
	Expr	AExpr;
	char*		name;
	int		row;
	int		col;
	PTGNode		pindex, pattr, pcoord;
	int		attrassig, pushcall;

ACall = AttrruleToCall (AAttrrule);
name = nameOfCall (ACall);
row = rowOfCall (ACall);
col = colOfCall (ACall);
TRparams = paramsOfCall (ACall);
/*===================process a Call=======================*/
/* visit sequences */

pcoord = MakeCoord (row, col);

if (strcmp (name, ASSIGNFCT) == 0) {
	attrassig = 1; pushcall = 0;
	retrievefirstSEQExpr (TRparams, AExpr);
} else if (strcmp (PUSHFCT, name) == 0) {
	attrassig = 1; pushcall = 1;
	retrievelastSEQExpr (TRparams, AExpr);
} else if (strcmp (CLOBFCT, name) == 0) {
	attrassig = 1; pushcall = 1;
	retrievelastSEQExpr (TRparams, AExpr);
} else	attrassig = 0;

if (attrassig) {
switch (typeof (AExpr)) {

case KAttracc: {Attracc AAttracc; 
	int		symbno;
	int		attrid;
	int		row;
	int		col;
AAttracc = ExprToAttracc (AExpr);
symbno = symbnoOfAttracc (AAttracc);
attrid = attridOfAttracc (AAttracc);
row = rowOfAttracc (AAttracc);
col = colOfAttracc (AAttracc);
/*===================process a Attracc=======================*/
pindex = PTGNumb (symbno);
pattr = GetAttrName (attrid);
/*===================end of Attracc==========================*/
break;}/*Attracc*/

case KChainacc: {Chainacc AChainacc; 
	int		symbno;
	int		chainid;
	int		row;
	int		col;
AChainacc = ExprToChainacc (AExpr);
symbno = symbnoOfChainacc (AChainacc);
chainid = chainidOfChainacc (AChainacc);
row = rowOfChainacc (AChainacc);
col = colOfChainacc (AChainacc);
/*===================process a Chainacc=======================*/
pindex = PTGNumb (symbno);
pattr = GetDefName (chainid);
/*===================end of Chainacc==========================*/
break;}/*Chainacc*/

default:
	pindex = Unknown;
	pattr = Unknown;

}/*switch Expr*/

if (pushcall)
	AllVisits = PTGSeq (AllVisits, PTGPushCmp (pindex, pattr, pcoord));
else	AllVisits = PTGSeq (AllVisits, PTGAttrCmp (pindex, pattr, pcoord));
} else { /* plain computation */

AllVisits = PTGSeq (AllVisits, PTGPlainCmp (pcoord));
}

/*===================end of Call==========================*/
break;}/*Call*/

case KVisit: {Visit AVisit; 
	int		symbno;
	int		ord;
AVisit = AttrruleToVisit (AAttrrule);
symbno = symbnoOfVisit (AVisit);
ord = ordOfVisit (AVisit);
/*===================process a Visit=======================*/

/* visit sequences */
if (symbno == 0)
	AllVisits = PTGSeq (AllVisits, PTGLeave (PTGNumb (ord)));
else
	AllVisits = PTGSeq (AllVisits, 
		PTGVisit (PTGNumb (ord), PTGNumb (symbno)));

/*===================end of Visit==========================*/
break;}/*Visit*/

case KTransfer: {Transfer ATransfer; 
	SEQInteger	TRsymbno;
	int		AInteger;
	SEQString	TRattrs;
	char		*AString;
	int		row;
	int		col;
ATransfer = AttrruleToTransfer (AAttrrule);
row = rowOfTransfer (ATransfer);
col = colOfTransfer (ATransfer);
/*===================process a Transfer=======================*/

/* visit sequences */
AllVisits = PTGSeq (AllVisits, 
	PTGTransfer (MakeCoord (row, col)));

/*===================end of Transfer==========================*/
break;}/*Transfer*/

case KChainStart: {ChainStart AChainStart; 
	int		chainid;
	char*		pregenattr;
	char*		postgenattr;
	int		row;
	int		col;
AChainStart = AttrruleToChainStart (AAttrrule);
chainid = chainidOfChainStart (AChainStart);
pregenattr = pregenattrOfChainStart (AChainStart);
postgenattr = postgenattrOfChainStart (AChainStart);
row = rowOfChainStart (AChainStart);
col = colOfChainStart (AChainStart);
/*===================process a ChainStart=======================*/

/* visit sequences */
AllVisits = PTGSeq (AllVisits, 
	PTGChainStart (MakeCoord (row, col)));

/*===================end of ChainStart==========================*/
break;}/*ChainStart*/

default:;
}/*switch Attrrule*/

}/*foreachinSEQAttrrule*/

/* visit sequences */
AllVisits = PTGSeq (AllVisits, NewLine);

/*===================end of Attribution==========================*/
}/*foreachinSEQAttribution*/

{	int	ind;
	char	*name;
	PTGNode	filenames;

filenames = PTGNULL;
ind = 0;
do {
	name = GetErrMapFileName (ind);
	if (strlen (name) == 0) break;
	filenames = PTGSeq (filenames, 
			PTGFileAssoc (
				PTGFileRef (PTGNumb (ind)), PTGName (name)));
	ind++;
} while (1);
filenames = PTGFileList (filenames);
/* symbols only :*/
PTGOutFile ("symbols.info", PTGSeq (PTGSeq (Terms, NTerms), NewLine));

/* attribute lists */
PTGOutFile ("attrs.info", PTGSeq (PTGSeq (filenames, AttrLists), NewLine));

/* visit sequences */
PTGOutFile ("visit.info", PTGSeq (PTGSeq (filenames, AllVisits), NewLine));
}
/*===================end of AttrEval==========================*/
}/*PAttrEval*/

