/* $Id: replrem.c,v 2.3 1992/08/14 11:43:29 cogito Exp $ */
/* $Log: replrem.c,v $
 * Revision 2.3  1992/08/14  11:43:29  cogito
 * two times declaration and initialization must be separated
 *
 * Revision 2.2  1991/07/22  10:33:54  cogito
 * updates from Boulder merged
 *
 * Revision 2.1.1.1  91/07/21  16:08:09  waite
 * Removed a function call from a pointer reference
 * 
 * Revision 2.1  91/06/10  14:16:07  cogito
 * checked in with -k by tony at 91.07.12.16.40.08.
 * 
 * Revision 2.1  91/06/10  14:16:07  cogito
 * rewritten to achieve compatibility with new expand
 *  */
static char rcs_id[]= "$Id: replrem.c,v 2.3 1992/08/14 11:43:29 cogito Exp $";

/***********************************************\
*						*
*	Version : 1.schrott			*
*						*
*	Module  : replrem.c			*
*						*
*	Contains the routines to replace the	*
*	INCLUDING-shorthands			*
*						*
\***********************************************/


/***********************************************\
* includes					*
\***********************************************/

#include <stdio.h>
#include <string.h>
#include "LIGA.h"
#include "LIGAMacros.h"
#include "option_enums.h"
#include "option_types.h"
#include "rglobal.h"
#include "replidl.h"


/***********************************************\
* functions					*
\***********************************************/

void replace_includings ();
void replace_incl ();
void remove_includings ();
void remove_inclattrs ();
void remove_incltrans ();
int expr_equal ();



/***********************************************\
* expr_equal					*
* comparisonfunction for orderedinsert		*
\***********************************************/

Including incl; /* must be global */

int expr_equal (expr1,expr2)
Including expr1,expr2;
{
	return (expr1 == incl);
} /* expr_equal() */


/***********************************************\
* replace_incl					*
\***********************************************/

void replace_incl (attrib, call)
Attribution attrib;
Call call;
{
	SEQExpr x;
	Expr expr;
	Def symb;
	Attracc access;
	int modified, lhs;

	modified= 0;
	/* for each parameter of call */
	foreachinSEQExpr(call->params,x,expr)
	{
		/* select first INCLUDING */
		if (typeof(expr) == KIncluding)
		{
			Def d;
			d = lookup_def(attrib->prodid);
			incl=expr.VIncluding;
			MORE_PROT fprintf(Prot,"*** INFO\tline: %d, col: %d, prod: %s\n\n",
				incl->row, incl->col, (d.VProd)->dname);
			modified++;
			break;
		} /* if */
		if (typeof(expr)==KCall)
			replace_incl(attrib,expr.VCall);
	} /* for each parameter of call */

	if (modified)
	{
		/* making attribute access */
		Def d;
		d = lookup_def(attrib->prodid);
		lhs= (d.VProd)->lhs;
		symb=lookup_def(lhs);

		MORE_PROT fprintf(Prot,"*** INFO\treplacing as access of %s.%s\n\n",
			symb.VSymb->dname,
			incl->genattr);

		access=NAttracc;
		access->symbno=0;
		access->attrid=incl->genattrid;

		/* replace */

		IDLtempExpr.VAttracc= access;
		orderedinsertSEQExpr(call->params, IDLtempExpr, expr_equal);
		IDLtempExpr.VIncluding= incl;
		removeSEQExpr(call->params, IDLtempExpr);
	
		replace_incl(attrib,call);
	} /* if */
} /* replace_incl() */



/***********************************************\
* replace_includings				*
\***********************************************/

void replace_includings ()
{
	SEQAttribution x;
	SEQAttrrule y;
	Attrrule sem;
	Attribution attribution;

	foreachinSEQAttribution (IS->attrrules, x, attribution)
	{
		/* for each semantic rule of production */
		foreachinSEQAttrrule(attribution->attrrules,y,sem)
		{
			/* select calls */
			if (typeof(sem)==KCall)
			{
				incl_count=1;
				replace_incl (attribution, sem.VCall);
			} /*select calls */
		} /* for each semantic rule of production */
	} /* for each attnode */
} /* replace_includings() */



/***********************************************\
* remove_inclattrs				*
\***********************************************/

void remove_inclattrs (symb)
Symb symb;
{
	SEQAttrdef x;
	Attrdef attrdef;
	int modified;

	modified=0;

	foreachinSEQAttrdef(symb->attrs,x,attrdef)
	{
		/* select first attrdef */
		if ((attrdef->gen)
			&& (!strncmp(attrdef->name,INCL_ATTR,strlen(INCL_ATTR))))
		{
			modified++;
			break;
		} /* if */
	} /* foreachinSEQAttrdef */

	if (modified)
	{
		MORE_PROT fprintf(Prot,"*** INFO    removing declaration of %s.%s\n",
			symb->dname,
			attrdef->name);

		removeSEQAttrdef(symb->attrs,attrdef);
		remove_inclattrs(symb);
	} /* if */
} /* remove_inclattrs() */


/***********************************************\
* remove_incltrans				*
\***********************************************/

void remove_incltrans (attribution)
Attribution attribution;
{
	SEQAttrrule x;
	Attrrule attrrule;
	Attracc attracc;
	Expr expr;
	Def prod;	/* changed from type Prod to Def */
	Attrdef attrdef;
	int modified;

	modified=0;

	foreachinSEQAttrrule(attribution->attrrules,x,attrrule)
	{
		/* select first attrdef */
		if ((typeof(attrrule)==KCall)
			&& (!strcmp((attrrule.VCall)->name,"assign")))
		{

			retrievefirstSEQExpr((attrrule.VCall)->params,expr);
			attracc=expr.VAttracc;

			prod=lookup_def(attribution->prodid);
			attrdef=lookup_attrdef(attracc->attrid);

			if ((attrdef->gen)
				&& (!strncmp(attrdef->name,INCL_ATTR,strlen(INCL_ATTR))))
			{
				modified++;
				break;
			} /* if */
		} /* if */
	} /* foreachinSEQAttrrule */

	if (modified)
	{
		MORE_PROT fprintf(Prot,"*** INFO    removing transportrule in %s\n",
			prod.VProd->dname);

		removeSEQAttrrule(attribution->attrrules,attrrule);
		remove_incltrans(attribution);
	} /* if */
	return;

} /* remove_incltrans() */

	

/***********************************************\
* remove_includings				*
\***********************************************/

void remove_includings ()
{
	SEQDef x;
	SEQAttribution y;
	Attribution attribution;
	Def def;

	/* remove all generated transports */

	foreachinSEQAttribution(IS->attrrules,y,attribution)
	{
		remove_incltrans(attribution);
	} /* foreachinSEQAttribution */

	MORE_PROT fprintf(Prot,"\n");

	/* remove all generated attributes */

	foreachinSEQDef(IS->defseq,x,def)
	{
		if (typeof(def)==KSymb)
			remove_inclattrs(def.VSymb);
	} /* foreachinSEQDef */
	MORE_PROT fprintf(Prot,"\n");
} /* remove_includings() */

