/* $Id: stat.c,v 2.1 1991/06/10 13:26:19 cogito Exp $ */
/* $Log: stat.c,v $
 * Revision 2.1  1991/06/10  13:26:19  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: stat.c,v 2.1 1991/06/10 13:26:19 cogito Exp $";

/************************************************************************
*                                                                       *
*       Module  : stat.c                                                *
*                                                                       *
*       Version : 1.0							*
*                                                                       *
*       Author  : Jiyang Liu						*
*                                                                       *
*       Print statistic information of the input AG      		*
*                                                                       *
************************************************************************/

#include "order.h"


extern int DefSymbNum;          /* defined in ref_tab.c */
extern int DefRuleNum;          /* defined in ref_tab.c */	
extern int DefAttrNum;        	/* defined in ref_tab.c */

extern bool    AUTOMATICALLY,
               PARSE_TIME,
               ARRANGE,

               PART_EARLY, PART_LATE,
               PART_BRANCH_AND_BOUND,

               PRINT_SYMBOL_DIRECT,
               PRINT_SYMBOL_TRANSITIV,
               PRINT_SYMBOL_INDUCED,
               PRINT_RULE_DIRECT,
               PRINT_RULE_TRANSITIV,
               PRINT_RULE_INDUCED,
               PRINT_RULE_PARTITIONED,
               PRINT_PARTITION,
               PRINT_VISITSEQUENCE,

               TREE_COMPLETE, TREE_TOP_DOWN,
               TREE_BOTTOM_UP;

/* functions */

int eval_maxVisitNo();
int eval_maxSymbNoInRule();
int eval_maxAttrNoInRule();
int eval_maxAttrNoInSymb();
void print_stat();

/*********************************************
* eval_maxVisitNo                            *
**********************************************/

int
eval_maxVisitNo()

{

int maxVisitNo;
int did;
VSPTR vselmptr;

maxVisitNo = 0;

for (did = min_entry; did <= max_entry; did++)
   if (ref_tab[did].etag == PROD) {
      vselmptr = ref_tab[did].entry.prod.visitseq;
      while (vselmptr != NULL) {
         if (vselmptr->vscls == VSVISIT)
            /* if (vselmptr->vsinfo.visit.vssno > 0) */
               if (maxVisitNo < vselmptr->vsinfo.visit.vsord)
                  maxVisitNo = vselmptr->vsinfo.visit.vsord;
         vselmptr = vselmptr->next;
      }
   }

return (maxVisitNo);
} /* eval_maxVisitNo() */


/*********************************************
* eval_maxSymbNoInRule                       *
**********************************************/

int
eval_maxSymbNoInRule()

{

int did;
int MaxSymbNum, symbnum;
SLNODE *slnptr;

MaxSymbNum = 0;

for (did = min_entry; did <= max_entry; did++)
   if (ref_tab[did].etag == PROD) {
      symbnum = 0;

      for (slnptr = ref_tab[did].entry.prod.hdright; 
           slnptr != NULL; slnptr = slnptr->right)  
         symbnum++ ;

      if (MaxSymbNum < symbnum)
         MaxSymbNum = symbnum;
   }

return (MaxSymbNum);

} /* eval_maxSymbNoInRule() */
      
   
               
/*********************************************
* eval_maxAttrNoInRule                       *
**********************************************/

int 
eval_maxAttrNoInRule()

{

int did;
int MaxRuleAttrNum;

MaxRuleAttrNum = 0;

for (did = min_entry; did <= max_entry; did++)
   if (ref_tab[did].etag == PROD) {

      if (MaxRuleAttrNum < ref_tab[did].entry.prod.check_row)
         MaxRuleAttrNum = ref_tab[did].entry.prod.check_row;

   }

return (MaxRuleAttrNum);

} /* eval_maxAttrNoInRule() */


/*********************************************
* eval_maxAttrNoInSymb                       *
**********************************************/

int 
eval_maxAttrNoInSymb()

{

int did;
int MaxSymbAttrNum;

MaxSymbAttrNum = 0;

for (did = min_entry; did <= max_entry; did++)
   if (ref_tab[did].etag == SYMB) {

      if (MaxSymbAttrNum < ref_tab[did].entry.symb.attr_num)
         MaxSymbAttrNum = ref_tab[did].entry.symb.attr_num;

   }

return (MaxSymbAttrNum);

} /* eval_maxAttrNoInSymb() */


/*********************************************
* print_stat                                 *
*********************************************/

void 
print_stat()

{

  (void)fprintf(Prot,"OPTIONS OF THE AG:\n");
  (void)fprintf(Prot,"==================\n\n");

  (void)fprintf(Prot,"PARTITION-STRATEGY:   ");
  if (PART_BRANCH_AND_BOUND)
    (void)fprintf(Prot,"WITH PART_BRANCH_AND_BOUND\n\n");
  else
    if (PART_EARLY)
      (void)fprintf(Prot,"AS EARLY AS POSSIBLE\n\n");
    else
      if (PART_LATE)
        (void)fprintf(Prot,"AS LATE AS POSSIBLE\n\n");
   /* else */

/*
  (void)fprintf(Prot,"TOPOLOGICAL-STRATEGY: ");
  if (TOPO_MINCUT)
    (void)fprintf(Prot,"WITH MIN_CUT\n\n");
  else
    if (TOPO_EARLY)
      (void)fprintf(Prot,"SO EARLY AS POSSIBLE (GREEDY)\n\n");
    else
      if (TOPO_LATE)
        (void)fprintf(Prot,"SO LATE AS POSSIBLE (LAZY)\n\n");
      else
        (void)fprintf(Prot,"WITHOUT MIN_CUT\n\n");
*/
   /* else */

  (void)fprintf(Prot,"PARSE-TIME:            ");
  if (PARSE_TIME)
    (void)fprintf(Prot,"TRUE\n\n");
  else
    (void)fprintf(Prot,"FALSE\n\n");
   /* else */

  (void)fprintf(Prot,"AUTOMATICALLY:         ");
  if (AUTOMATICALLY)
    (void)fprintf(Prot,"TRUE\n\n");
  else
    (void)fprintf(Prot,"FALSE\n\n");
   /* else */

  (void)fprintf(Prot,"\n\nCHARACTERISTICS OF THE AG:\n");
  (void)fprintf(Prot,"==========================\n\n");

  (void)fprintf(Prot,"THE AG IS  ");
  if (!AUTOMATICALLY)
      (void)fprintf(Prot,"*** ORDERED ***\n\n");
  else
      (void)fprintf(Prot,"*** ARRANGED ORDERED ***\n\n");

  (void)fprintf(Prot,"MAX. NUMBER OF SYMBOL VISIT:  %10d\n\n",
                eval_maxVisitNo());
  (void)fprintf(Prot,"MAX. NUMBER OF SYMBOLS IN RULE: %8d\n\n",
                eval_maxSymbNoInRule());
  (void)fprintf(Prot,"MAX. NUMBER OF ATTRIBUTES IN RULE: %5d\n\n",
                eval_maxAttrNoInRule());
  (void)fprintf(Prot,"MAX. NUMBER OF ATTRIBUTES IN SYMBOL: %3d\n\n",
                eval_maxAttrNoInSymb());

  (void)fprintf(Prot,"NUMBER OF DEFINED SYMBOLS:    %10d\n\n",
                DefSymbNum);
  (void)fprintf(Prot,"NUMBER OF CONTEXT-FREE RULES: %10d\n\n",
                DefRuleNum);

  (void)fprintf(Prot,"NUMBER OF ALL ATTRIBUTES: %14d\n\n",
                DefAttrNum);

} /* print_stat() */

