/* $Id: option.c,v 3.5 1992/11/20 15:05:37 cogito Exp $ */
/* $Log: option.c,v $
 * Revision 3.5  1992/11/20  15:05:37  cogito
 * Fatal gcc-error removed.
 *
 * Revision 3.4  1992/10/09  13:11:53  cogito
 * one Malloc() changed into XtMalloc for GORTO
 *
 * Revision 3.3  1992/07/03  09:25:30  cogito
 * previous: there were arrays of static size MAX_SYMBNO
 * now: MAX_SYMBNO will be computed and there are "dynamic" arrays of
 *      size MAX_SYMBNO
 *
 * Revision 3.2  1992/06/30  09:41:24  cogito
 * call of malloc of standard library replaced with call of Malloc in mem.c
 *
 * Revision 3.1  1992/03/05  09:12:51  uwe
 * predefined attr GENTREE
 *
 * Revision 2.5  1991/12/02  13:15:17  cogito
 * Casted enums to integers to prevent of warning messages on
 * comparison with an integer.
 *
 * Revision 2.4  1991/10/02  15:13:53  cogito
 * Increased Length of error message buffer.
 *
 * Revision 2.3  1991/09/23  14:27:41  mjung
 * Added Errormessages using message. Protocoll-file is unchanged.
 *
 * Revision 2.2  1991/07/23  16:40:26  cogito
 * changes in option handler
 *
 * Revision 2.1  91/06/10  13:25:50  cogito
 * sources for ORDER combined with GORTO
 *  */
static char rcs_id[]= "$Id: option.c,v 3.5 1992/11/20 15:05:37 cogito Exp $";

/****************************************************************
*                                                               *
*       Module  : option.c                                      *
*                                                               *
*       Version : 1.0                                           *
*                                                               *
*       Author  : Jiyang Liu                                    *
*                                                               *
*       Contains routines for reading and processing order      *
*       options and esp. the arrange options			*
*                                                               *
****************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		25.04.90	Volker Niepel
	 */

/* includes  */
#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif

/* Includes for option handling */
#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"
#include "printerr.h"

#ifndef GORTO
extern	char	*Malloc();	/* defined in mem.c */
#endif

#define ERR_BUFF_LEN 200

/* global variables */
FILE	*order_optionfile;
OptCollect order_opts;

extern FILE *Prot;

extern AttrEval ISexp;

extern bool    AUTOMATICALLY, 
               PARSE_TIME, 
               ARRANGE,

               PART_EARLY, PART_LATE,
	       PART_BRANCH_AND_BOUND, 

#ifndef GORTO
	       PRINT_SYMBOL_DIRECT,
	       PRINT_SYMBOL_TRANSITIV,
	       PRINT_SYMBOL_INDUCED,
	       PRINT_RULE_DIRECT,
	       PRINT_RULE_TRANSITIV,
	       PRINT_RULE_INDUCED,
	       PRINT_RULE_PARTITIONED,
	       PRINT_PARTITION,
	       PRINT_VISITSEQUENCE,
#endif

	       TREE_COMPLETE, TREE_TOP_DOWN,
	       TREE_BOTTOM_UP;

/* functions */ 

void enter_depSymbol();
bool return_symbNo();
void enter_depRule();
void read_orderOption();
Symb lookupSymbByName();
Prod lookupProdByName();
ArrangeHelp MkArrangeHelp ();
ArrangeHelp getIdArrangeSymbol();
ArrangeHelp getIdArrangeRule();
void set_arrangeOption();
void read_printOption();

/*********************************************
* enter_depSymbol                            *
*********************************************/

void enter_depSymbol(Ptr)
ArrangeHelp   Ptr;
{
#ifndef GORTO
BITMATRIX DS; 
#else
DEP_MATRIX DS;
#endif
int fromAttrPos, toAttrPos;

 if (Ptr!= NULL)
 {
    DS = ref_tab[Ptr->fromSymbId].entry.symb.ds;
    fromAttrPos = ref_tab[Ptr->fromAttrId].entry.attr.pos;
    toAttrPos = ref_tab[Ptr->toAttrId].entry.attr.pos;

    /* fromAttr is required to be evaluated BEFORE toAttr, therefor an edge
       from toAttr to fromAttr should be introduced in DS.
    */
#ifndef GORTO
    if (DS[toAttrPos][fromAttrPos/WORD_LENGTH] & 0x1 << fromAttrPos%WORD_LENGTH)
    {
        char errmsgbuff[ERR_BUFF_LEN];
	
	err_setpos(ref_tab[Ptr->toAttrId].entry.attr.attr_def->row,
		   ref_tab[Ptr->toAttrId].entry.attr.attr_def->col);
	sprintf (errmsgbuff, "Arrange: '%s' already depends from '%s'", 
		 ref_tab[Ptr->toAttrId].entry.attr.attr_def->name, 
		 ref_tab[Ptr->fromAttrId].entry.attr.attr_def->name);
	err_print_warning (errmsgbuff);
	(void)fprintf(Prot,"*** WARNING *** %s\n",errmsgbuff);
    }
    else if (DS[fromAttrPos][toAttrPos/WORD_LENGTH] & 0x1 << toAttrPos%WORD_LENGTH)
    {
        char errmsgbuff[ERR_BUFF_LEN];

	err_setpos(ref_tab[Ptr->toAttrId].entry.attr.attr_def->row,
		   ref_tab[Ptr->toAttrId].entry.attr.attr_def->col);
	sprintf (errmsgbuff, "Arrange: Dependency of '%s' from '%s' not generated, it would cause a cycle.", 
		 ref_tab[Ptr->toAttrId].entry.attr.attr_def->name, 
		 ref_tab[Ptr->fromAttrId].entry.attr.attr_def->name);
	err_print_warning (errmsgbuff);
	(void)fprintf(Prot,"*** WARNING *** %s\n",errmsgbuff);
    }
    else {
       DS[toAttrPos][fromAttrPos/WORD_LENGTH] |= 0x1 << fromAttrPos%WORD_LENGTH;
       ref_tab[Ptr->fromSymbId].entry.symb.changed = TRUE;
    }
#else
    MakeArrangeNode (Ptr->fromSymbId, 
		     (SLNODE *) NULL, (SLNODE *) NULL,
		     Ptr->fromAttrId, 
		     Ptr->toAttrId, False);
#endif

 }
#ifndef GORTO
 (void)fprintf(Prot,"\n");
#endif
 return;
} /* enter_depSymbol() */
  
/*********************************************
* return_symbNo                              *
*********************************************/

bool return_symbNo(pid, sid, ord, slnptr)
int pid, sid, ord;
SLNODE **slnptr;
{
SLNODE *p;
  
  p = ref_tab[pid].entry.prod.hdright;

  while (p != NULL) 

    if (p->sid == sid) {   /* if the wanted symbol is found */
      if (ord == 1) {
      	*slnptr = p;
        return(TRUE);
      }
      else { 
        ord -= 1;
        p = p->right;
      }
    }

    else		 /* if the wanted symbol is not yet found */
      p = p->right;

  return(FALSE);

} /* return_symbNo() */


/*********************************************
* enter_depRule                              *
*********************************************/

void enter_depRule(Ptr)
ArrangeHelp	Ptr;
{
  bool   ok=TRUE;
#ifndef GORTO
  BITMATRIX DP;
  SLNODE *fromSymbPtr, *toSymbPtr;
  int fromAttrRow, fromAttrWord, fromAttrBit, fromAttrPos;
  int toAttrRow, toAttrWord, toAttrBit, toAttrPos;
#else
  DEP_MATRIX DP;
  SLNODE *fromSymbPtr, *toSymbPtr;
  int fromAttrRow, fromAttrCol, fromAttrPos;
  int toAttrRow, toAttrCol, toAttrPos;
#endif

 if (Ptr != NULL) {
  
  if (return_symbNo( Ptr->prodId,
                     Ptr->fromSymbId,
                     Ptr->fromOrd,
                     &fromSymbPtr)) {
     fromAttrRow = fromSymbPtr->start_row;
     fromAttrPos = ref_tab[Ptr->fromAttrId].entry.attr.pos;
#ifndef GORTO
     fromAttrWord = fromSymbPtr->start_col + fromAttrPos/WORD_LENGTH;
     fromAttrBit = fromAttrPos%WORD_LENGTH;
#else
     fromAttrCol = fromSymbPtr->start_row + fromAttrPos;
#endif
  }
  else {
    char errmsgbuff[ERR_BUFF_LEN];

    err_setpos(ref_tab[Ptr->fromAttrId].entry.attr.attr_def->row, 
	       ref_tab[Ptr->fromAttrId].entry.attr.attr_def->col);
    sprintf (errmsgbuff, "Arrange: Wrong ORD-Value for Symbol '%s'",
	     ref_tab[Ptr->fromAttrId].entry.attr.attr_def->name);
    err_print_warning(errmsgbuff);
    (void)fprintf(Prot,"*** WARNING *** WRONG ORD-VALUE FOR THE FIRST SYMBOL\n");
    ok = FALSE;
  }
  
  if (return_symbNo(Ptr->prodId,
                    Ptr->toSymbId,
		    Ptr->toOrd,
		    &toSymbPtr)) {     
     toAttrRow = toSymbPtr->start_row;
     toAttrPos = ref_tab[Ptr->toAttrId].entry.attr.pos;
#ifndef GORTO
     toAttrWord = toSymbPtr->start_col + toAttrPos/WORD_LENGTH;
     toAttrBit = toAttrPos%WORD_LENGTH;
#else
     toAttrCol = toSymbPtr->start_row + toAttrPos;
#endif
  }  
  else {
    char errmsgbuff[ERR_BUFF_LEN];

    err_setpos(ref_tab[Ptr->toAttrId].entry.attr.attr_def->row, 
	       ref_tab[Ptr->toAttrId].entry.attr.attr_def->col);
    sprintf (errmsgbuff, "Arrange: Wrong ORD-Value for Symbol '%s'",
	     ref_tab[Ptr->toAttrId].entry.attr.attr_def->name);
    err_print_warning(errmsgbuff);

    (void)fprintf(Prot,"*** WARNING *** WRONG ORD-VALUE FOR THE SECOND SYMBOL\n");
    ok = FALSE;
  }
  
  if (ok) {
    DP = ref_tab[Ptr->prodId].entry.prod.dp;

#ifndef GORTO
    if (DP[toAttrRow][fromAttrWord] & 0x1 << fromAttrBit)
      {
        char errmsgbuff[ERR_BUFF_LEN];
	
	err_setpos(ref_tab[Ptr->toAttrId].entry.attr.attr_def->row,
		   ref_tab[Ptr->toAttrId].entry.attr.attr_def->col);
	sprintf (errmsgbuff, "Arrange: '%s' already depends from '%s'", 
		 ref_tab[Ptr->toAttrId].entry.attr.attr_def->name, 
		 ref_tab[Ptr->fromAttrId].entry.attr.attr_def->name);
	err_print_warning (errmsgbuff);

        (void)fprintf(Prot,"*** WARNING *** DEPENDENCY ALREADY EXISTS\n");
      }
    else
      if (DP[fromAttrRow][toAttrWord] & 0x1 << toAttrBit)
	{
	  char errmsgbuff[ERR_BUFF_LEN];

	  err_setpos(ref_tab[Ptr->toAttrId].entry.attr.attr_def->row,
		     ref_tab[Ptr->toAttrId].entry.attr.attr_def->col);
	  sprintf (errmsgbuff, "Arrange: Dependency of '%s' from '%s' not generated, it would cause a cycle.", 
		   ref_tab[Ptr->toAttrId].entry.attr.attr_def->name, 
		   ref_tab[Ptr->fromAttrId].entry.attr.attr_def->name);
	  err_print_warning (errmsgbuff);

	  (void)fprintf(Prot,"*** WARNING *** DEPENDENCY IS NOT INTRODUCED, IT WOULD CAUSE A CYCLE\n");
        }
      else {
        DP[toAttrRow][fromAttrWord] |= 0x1 << fromAttrBit; /* add edge */
  	ref_tab[Ptr->prodId].entry.prod.changed = TRUE;
      }
#else
    MakeArrangeNode (Ptr->prodId, fromSymbPtr, toSymbPtr,
		     Ptr->fromAttrId, 
		     Ptr->toAttrId, False);
#endif
  } /* end ok */
 } /* end if NULL */
#ifndef GORTO
 (void)fprintf(Prot,"\n");
#endif
} /* enter_depRule() */
  

/*********************************************
* read_orderOption                           *
*********************************************/

void read_orderOption(fname)
char *fname;
{
  OrdList ordp;

#ifndef GORTO
  order_opts= (OptCollect) Malloc (sizeof (struct _optcollect));
#else
  order_opts= (OptCollect) XtMalloc (sizeof (struct _optcollect));
#endif

  order_opts->ord_opts= (OrdList) NULL;
  if (!(order_optionfile= fopen (fname, "r")))
  {
    err_setpos(0,0);
    err_print_error("Cannot open order_option file");
#ifndef GORTO
    (void) fprintf (Prot, "*** ERROR *** option file for order not found\n");
#else
    (void) fprintf (stderr, "*** ERROR *** can't open order_option file\n");
#endif
  } /* if */
  else
  {
    OptionInput (order_opts, order_optionfile);
    fclose (order_optionfile);
  } /* else */

  for (ordp= order_opts->ord_opts; ordp; ordp= ordp->next)
  {
    switch (ordp->entry->flag)
    {
      case part_early:
	PART_BRANCH_AND_BOUND = FALSE;
	PART_EARLY = TRUE; PART_LATE = FALSE;
	break;
      case part_late:
	PART_BRANCH_AND_BOUND = FALSE;
	PART_LATE = TRUE; PART_EARLY = FALSE;
	break;
      case top_early:	/* currently not in use */
#if 0
	TOPO_MINCUT = FALSE;
	TOPO_EARLY = TRUE; TOPO_LATE = FALSE;
#endif
	break;
      case top_late:	/* currently not in use */
#if 0
	TOPO_MINCUT = FALSE;
	TOPO_LATE = TRUE; TOPO_EARLY = FALSE;
#endif
	break;
#ifndef GORTO
      case direct_symb:
	PRINT_SYMBOL_DIRECT = TRUE;
	break;
      case trans_symb:
	PRINT_SYMBOL_TRANSITIV = TRUE;
	break;
      case ind_symb:
	PRINT_SYMBOL_INDUCED = TRUE;
	break;
      case direct_rule:
	PRINT_RULE_DIRECT = TRUE;
	break;
      case trans_rule:
	PRINT_RULE_TRANSITIV = TRUE;
	break;
      case ind_rule:
	PRINT_RULE_INDUCED = TRUE;
	break;
      case part_rule:
	PRINT_RULE_PARTITIONED = TRUE;
	break;
      case partition:
	PRINT_PARTITION = TRUE;
	break;
      case visit_seq:
	PRINT_VISITSEQUENCE = TRUE;
	break;
#endif
      case tree_compl:
	TREE_COMPLETE = TRUE;
	TREE_TOP_DOWN = FALSE; TREE_BOTTOM_UP = FALSE;
	PARSE_TIME = FALSE;
	break;
      case tree_up:
	TREE_BOTTOM_UP = TRUE;
	TREE_COMPLETE = FALSE; TREE_TOP_DOWN = FALSE;
	PARSE_TIME = TRUE;
	break;
      case tree_down:
	TREE_TOP_DOWN = TRUE;
	TREE_COMPLETE = FALSE; TREE_BOTTOM_UP = FALSE;
	PARSE_TIME = TRUE;
	break;
      case arr_auto:
	AUTOMATICALLY= TRUE;
	break;
      case arr_fast:
	AUTOMATICALLY= FALSE;
	break;
      case for_symb:
	ARRANGE = TRUE;
	break;
      case in_rule:
	ARRANGE = TRUE;
	break;
      case ordopt_error:
      default:
	break;
    } /* switch */
  } /* for */

} /* read_orderOption() */

/*********************************************
* lookupSymbByName                           *
*********************************************/

Symb lookupSymbByName(name)
String name;
{
  Def def;
  SEQDef sdef;
  Symb symb;

  foreachinSEQDef(ISexp->defseq, sdef, def)
    {
      if ((typeof(def) == KSymb) && (!strcmp(def.VSymb->dname, name)))
	{
	  symb = def.VSymb;
	  return(symb);
	}
    }
  return(NULL);
} /* lookupSymbByName() */


/*********************************************
* lookupProdByName                           *
*********************************************/

Prod lookupProdByName(name)
String name;
{
  Def def;
  SEQDef sdef;
  Prod  prod;

  foreachinSEQDef(ISexp->defseq, sdef, def)
    {
      if ((typeof(def) == KProd) && (strcmp(def.VProd->dname, name) == 0))
	{
	  prod = def.VProd;
	  return(prod);
	}
    }
  return(NULL);
} /* lookupProdByName() */


/*********************************************
* MkArrangeHelp                              *
*********************************************/

ArrangeHelp MkArrangeHelp (pprodId, pfromSymbId, pfromOrd, ptoSymbId, ptoOrd, pfromAttrId, ptoAttrId)
int pprodId;
int pfromSymbId;
int pfromOrd;
int ptoSymbId;
int ptoOrd;
int pfromAttrId;
int ptoAttrId;
{
  ArrangeHelp n;
	
  n = NArrangeHelp;
  n->prodId = pprodId;
  n->fromSymbId = pfromSymbId;
  n->fromOrd = pfromOrd;
  n->toSymbId = ptoSymbId;
  n->toOrd = ptoOrd;
  n->fromAttrId = pfromAttrId;
  n->toAttrId = ptoAttrId;
  return(n);
} /* MkArrangeHelp() */


/*********************************************
* getIdArrangeSymbol                         *
*********************************************/

ArrangeHelp getIdArrangeSymbol(a,b,c)
String a,b,c;
{
  Attrdef adef;
  SEQAttrdef sadef;
  ArrangeHelp result;

  bool ok=TRUE;
  Symb symb=NULL;
  int first=0, second=0;

#ifndef GORTO
  (void)fprintf(Prot,"ARRANGE: FOR SYMBOL %s EVAL %s BEFORE %s\n",a, b, c); 
#endif

  symb = lookupSymbByName(a);

  if (symb == NULL)
    {
      char errmsgbuff[ERR_BUFF_LEN];

      sprintf (errmsgbuff, "Arrange: '%s' is not a Symbol.", a);
      err_setpos(0,0);
      err_print_warning(errmsgbuff);
      (void)fprintf(Prot,"*** WARNING *** NOT A SYMBOL\n");
      ok = FALSE;
    }
  else
    {
      foreachinSEQAttrdef(symb->attrs, sadef, adef)
	{
	  if (strcmp(b, adef->name) == 0)
	    first = adef->did;
	  
	  if (strcmp(c, adef->name) == 0)
	    second = adef->did;
	  
	  if (first*second != 0)
	break;
	}
      
      if (first*second == 0) {
	err_setpos(adef->row, adef->col);
      	if (first == 0)
	  {	    
	    err_print_warning ("Arrange: Not an attribute of the symbol");
	    (void)fprintf(Prot,"*** WARNING *** NOT AN ATTRIBUTE OF THE SYMBOL\n");
	  }
        if (second == 0)
	  {
	    err_print_warning ("Arrange: Not an attribute of the symbol");
	    (void)fprintf(Prot,"*** WARNING *** NOT AN ATTRIBUTE OF THE SYMBOL\n");
	  }
        ok = FALSE;
      }
    }
  if (ok) result = MkArrangeHelp(0, symb->did, 0, 0, 0, first, second);
  else result = NULL;    
  return(result);
} /* getIdArrangeSymbol() */


/*********************************************
* getIdArrangeRule                           *
*********************************************/

ArrangeHelp getIdArrangeRule(prodName, fromSymbName, fromOrd, toSymbName, toOrd, fromAttrName, toAttrName)
String prodName, fromSymbName, toSymbName, fromAttrName, toAttrName;
int fromOrd, toOrd;
{
  int ruleid=0, symb1id=0, symb2id=0, adef1id=0, adef2id=0;

  Def def;
  SEQDef sdef;
  Symb symb;
  SEQAttrdef sadef;
  Attrdef adef;
  bool ok=TRUE;

  ArrangeHelp result;
  
#ifndef GORTO
  (void)fprintf(Prot,"ARRANGE: IN RULE %s EVAL %s[%d].%s BEFORE %s[%d].%s\n", 
               prodName, fromSymbName, fromOrd, fromAttrName, 
               toSymbName, toOrd, toAttrName);
#endif
 

  foreachinSEQDef(ISexp->defseq, sdef, def)
    {
      if ((typeof(def) == KProd) &&
 	  (strcmp(def.VProd->dname, prodName) == 0))
	{
	  ruleid = def.VProd->did;
	  break;
	}
    }

  if (ruleid == 0) {
    char errmsgbuff[ERR_BUFF_LEN];
    
    err_setpos(0,0);
    sprintf (errmsgbuff, "Arrange: Rule '%s' does not exist.", prodName);
    err_print_warning (errmsgbuff);
    (void)fprintf(Prot,"*** WARNING *** RULE '%s' DOES NOT EXIST\n", prodName);
    ok = FALSE;
  }

  
  symb = lookupSymbByName(fromSymbName);
  
  if (symb == NULL)
    {
      char errmsgbuff[ERR_BUFF_LEN];

      err_setpos(0,0);
      sprintf (errmsgbuff, "Arrange: Symbol %s does not exist in Rule %s",
	       fromSymbName, prodName);
      err_print_warning (errmsgbuff);

      (void)fprintf(Prot, "*** WARNING *** FIRST SYMBOL DOES NOT EXIST\n");
      ok = FALSE;
    }
  else
    {
      symb1id = symb->did;
  
      foreachinSEQAttrdef(symb->attrs, sadef, adef)
	{
	  if (strcmp(adef->name, fromAttrName) == 0)
	    {
	      adef1id = adef->did;
	      break;
	    }
	}
      if (adef1id == 0) {
	char errmsgbuff[ERR_BUFF_LEN];

	err_setpos(0,0);
	sprintf (errmsgbuff, "Arrange: '%s' is not an attribute of '%s'",
		 fromAttrName, fromSymbName);
	err_print_warning(errmsgbuff);
        (void)fprintf(Prot,"*** WARNING *** IS NOT AN ATTRIBUT OF THE FIRST SYMBOL\n");
        ok = FALSE;
      }

    }
  
  symb = lookupSymbByName(toSymbName);
  if (symb == NULL)
    {
      char errmsgbuff[ERR_BUFF_LEN];

      err_setpos(0,0);
      sprintf (errmsgbuff, "Arrange: Symbol %s does not exist in Rule %s",
	       toSymbName, prodName);
      err_print_warning (errmsgbuff);

      (void)fprintf(Prot, "*** WARNING *** SECOND SYMBOL DOES NOT EXIST\n");
      ok = FALSE;
    }
  else
    {
      symb2id = symb->did;
      
      foreachinSEQAttrdef(symb->attrs, sadef, adef)
	{
	  if (strcmp(adef->name, toAttrName) == 0)
	    {
	      adef2id = adef->did;
	      break;
	    }
	}
      if (adef2id == 0) {
	char errmsgbuff[ERR_BUFF_LEN];

	err_setpos(0,0);
	sprintf (errmsgbuff, "Arrange: '%s' is not an attribute of '%s'",
		 toAttrName, toSymbName);
	err_print_warning(errmsgbuff);

        (void)fprintf(Prot,"*** WARNING *** IS NOT AN ATTRIBUT OF THE SECOND SYMBOL\n");
        ok = FALSE;
      }
    
    }

  if (ok)  result = MkArrangeHelp(ruleid,
				symb1id,
				fromOrd,	/* Ord of from */
				symb2id,
				toOrd,	/* Ord of to */
				adef1id,
				adef2id);
  else result = NULL;

  return(result);
} /* getIdArrangeRule() */

  
/*********************************************
* set_arrangeOption                          *
*********************************************/

void set_arrangeOption()
{
  OrdList	ordp;
    
  for (ordp= order_opts->ord_opts; ordp; ordp= ordp->next)
  {
    switch (ordp->entry->flag)
    {
      case for_symb:
	enter_depSymbol( getIdArrangeSymbol (
		ordp->entry->names[0],
		ordp->entry->names[1],
		ordp->entry->names[2]));
	break;

      case in_rule:
	enter_depRule( getIdArrangeRule (
		ordp->entry->names[0],
		ordp->entry->names[1],
		ordp->entry->symbindex1,
		ordp->entry->names[3],
		ordp->entry->symbindex2,
		ordp->entry->names[2],
		ordp->entry->names[4]));
	break;
      default:
	break;
    } /* switch */
  } /* for */
} /* set_arrangeOption() */


#ifndef GORTO
/********************************************\
*    void read_printOption                   *
\********************************************/

void read_printOption(class)
int class;
{
  SEQString	remString;
  String	str;
  Prod		prod;
  Symb		symb;
  OrdList	ordp;
  int		i = 0;
  int		x, count;

  for (ordp= order_opts->ord_opts; ordp; ordp= ordp->next)
  {
    if ((int)(ordp->entry->flag) == class)
    {
      count= ordp->entry->namecount;
      for (x=0; x<count; x++)
      {
	if ((class==(int)(direct_symb))
		|| (class==(int)trans_symb)
		|| (class==(int)ind_symb)
		|| (class==(int)partition))
	{
	  symb= lookupSymbByName (ordp->entry->names[x]);
	  if (symb)
		PrintList[i++]= symb->did;
	} /* if */
	else
	{
	  prod= lookupProdByName (ordp->entry->names[x]);
	  if (prod)
		PrintList[i++]= prod->did;
	} /* else */
      } /* for */
      if (i)
		PrintList[i]= END_OF_PRINT;
      else
		PrintList[i]= PRINT_ALL;
    } /* if */
  } /* for */
} /* read_printOption() */
#endif
