/* $Id: option_types.h,v 2.2 1991/05/15 08:33:04 cogito Exp $ */
/* $Log: option_types.h,v $
 * Revision 2.2  1991/05/15  08:33:04  cogito
 * removed unused expand options
 *
 * Revision 2.1  90/12/04  14:45:41  cogito
 * new version of option handler
 *  */

/***********************************************************************\
*	option_types.h							*
*	types for the LIGA option handler				*
*									*
*	Written 06/20/90 - 11/14/90	by HaDeS			*
\***********************************************************************/

#ifndef _OPT_TYPES_H_INCL
#define _OPT_TYPES_H_INCL

typedef struct _idlist {
	char		*ident;
	struct _idlist	*next;
} *IdList;

typedef	struct _anameslist {
	char		*symbname;
	IdList		names;
	struct _anameslist *next;
} *ANamesList;

typedef	struct _expoption {
	expoptflag	flag;
	char		*attrname;
} *ExpOption;

typedef struct _orderoption {
	ordoptflag	flag;
	int		namecount;
	char		**names;
	int		symbindex1,
			symbindex2;
} *OrdOption;

typedef	struct _optimoption {
	optoptflag	flag;
	ANamesList	attrs;
} *OptOption;

typedef struct _backendoption {
	beoptflag	flag;
	int		value;
} *BEOption;

typedef struct _explist {
	ExpOption	entry;
	struct _explist	*next;
} *ExpList;

typedef struct _ordlist {
	OrdOption	entry;
	struct _ordlist	*next;
} *OrdList;

typedef struct _optlist {
	OptOption	entry;
	struct _optlist	*next;
} *OptList;

typedef struct _belist {
	BEOption	entry;
	struct _belist	*next;
} *BEList;

typedef struct _optcollect {
	ExpList		exp_opts;
	OrdList		ord_opts;
	OptList		opt_opts;
	BEList		be_opts;
} *OptCollect;

typedef union {
	ExpList		entry1;
	OrdList		entry2;
	OptList		entry3;
	BEList		entry4;
} OptLists;

typedef struct _optcombin {
	listtype	type;
	OptLists	entry;
} *OptCombin;

#endif

