/* $Id: option_enums.h,v 2.5 1991/10/31 15:14:28 cogito Exp $ */
/* $Log: option_enums.h,v $
 * Revision 2.5  1991/10/31  15:14:28  cogito
 * Added INCLUDING ON to the optim and backend options.
 * The enums are named opt_do_incl for option and
 * do_exp_incl for the backend.
 *
 * Revision 2.4  1991/07/23  17:21:16  cogito
 * expand options: INCLUDING_FUNCTION replaced by INCLUDING ON / OFF
 * order options: new option ARRANGE FAST to cancel default ARRANGE AUTOMATICALLY
 * backend options: new option FREE_TREE (opposite of KEEP_TREE)
 *
 * Revision 2.3  91/05/15  08:33:00  cogito
 * removed unused expand options
 * 
 * Revision 2.2  91/01/24  15:00:03  cogito
 * added new backend option
 * 
 * Revision 2.1  90/12/04  14:45:22  cogito
 * new version of option handler
 *  */

/***********************************************************************\
*	option_enums.h							*
*	enumerator types for the LIGA options				*
*									*
*	Written 06/20/90 - 07/23/91	by HaDeS			*
\***********************************************************************/

#ifndef _OPT_ENUMS_H_INCL
#define _OPT_ENUMS_H_INCL


typedef	enum {
	expopt_error,
	const_attr_name, incl_attr_name,
	chain_pre_name, chain_post_name,
	includings_separate, exp_info, including_on, including_off
} expoptflag;

typedef enum {
	ordopt_error,
	part_early, part_late, top_early, top_late,
	direct_symb, trans_symb, ind_symb,
	direct_rule, trans_rule, ind_rule, part_rule,
	partition, visit_seq,
	tree_compl, tree_up, tree_down,
	arr_auto, arr_fast, for_symb, in_rule
} ordoptflag;

typedef enum {
	optopt_error,
	opt_no_incl, opt_tree,
	opt_off, opt_info, more_globals, no_vars, no_stack,
	group_vars, group_stacks, group_all,
	attr_glob_stack, attr_glob_var, attr_group_stack, attr_group_var,
	attr_treenode, opt_do_incl
} optoptflag;

typedef enum {
	beopt_error,
	readable, keep_tree, free_tree, tree_top_down, exp_no_incl,
	case_split, atstacks, nodestacks, do_exp_incl
} beoptflag;

typedef enum {
	lt_error,
	exp_ltype, ord_ltype, opt_ltype, be_ltype
} listtype;

#endif

