# $Id: Makefile.cpp,v 1.9 1992/11/27 13:54:39 cogito Exp $
# 
# makefile of the directory option
# 

SHELL	= /bin/sh
CFLAGS	=
COFLAGS = -q

# default to a safe place for target location
DESTDIR = /tmp
DISTRIB = /tmp

PFLAGS  = -w -temp=.
COFLAGS = -q

EXE	= ../ligaOption.exe

COMP	= option.specs option.gla option.lido option.con \
	  option.head option.init optionmk option.clp
SRC	= opt_liga.c conflicts.c keywords.c optlists.c various.c output.c
HEAD	= opt_liga.h conflicts.h keywords.h optlists.h various.h \
	  option_enums.h option_types.h output.h
HEADER  = $(HEAD) output.h

INP_SRC	= opt_input.c
INP_HDR	= opt_input.h option_enums.h option_types.h
INP_OBJ	= opt_input.o

TIDY	= *.o *.a CACHE
CLEAN	= $(TIDY) RUNLL $(EXE)
CLOBBER	= $(CLEAN) COMPILER Makefile
RCS	= $(COMP) $(SRC) $(HEAD) $(INP_SRC) $(INP_HDR)

# compile ligaOption.exe

all: 	$(INP_OBJ)
	(cd COMPILER; make EXE="../$(EXE)" CC="$(CC)" PFLAGS="$(PFLAGS)";)

$(EXE):
	(cd COMPILER; make EXE="../$(EXE)" CC="$(CC)" PFLAGS="$(PFLAGS)";)

opt_input.o: $(INP_HDR) option_enums.h option_types.h

# generate sources

gen:	$(COMP) $(SRC) $(HEADER) 
	rm -rf COMPILER; mkdir COMPILER
	rm -rf CACHE
	(ELI=$$PWD"/CACHE"; export ELI; $$CST/bin/eli -c $$CST -n $$ELI < optionmk)

# installation

install:
	rm -f $(DESTDIR)/Tool/liga/ligaOption.exe
	cp $(EXE) $(DESTDIR)/Tool/liga/ligaOption.exe
	chmod 755 $(DESTDIR)/Tool/liga/ligaOption.exe

# checkout
 
checkout:
	-co $(COFLAGS) $(RCS)
	-co $(COFLAGS) README

# distribution

distrib:
	- rm -rf $(DISTRIB)/option
	mkdir $(DISTRIB)/option
	cd COMPILER; make clean
	cp -r COMPILER $(DISTRIB)/option
	cp Makefile.cpp README $(INP_HDR) $(INP_SRC) $(DISTRIB)/option
	cd $(DISTRIB)/option; chmod 0644 Makefile.cpp README $(INP_HDR) $(INP_SRC)
	cd $(DISTRIB)/option/COMPILER; chmod 0644 *

# SourceDistr

SourceDistr: Makefile.cpp $(RCS)
	cp -r $(ELI)/COMPILER .
	cd COMPILER; make clean

# cleaning targets

.PHONY:		tidy clean rcsclean clobber

tidy:
		rm -rf $(TIDY)

clean:
		rm -rf $(CLEAN)
		-cd COMPILER; make clean

clobber:
		rm -rf $(CLOBBER)

rcsclean:	clean
		-rcsclean $(COFLAGS) $(RCS) Makefile.cpp README 
		rm -f Makefile

save:
		-mkdir RCS
		-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
		-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
		-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
		-ci -fOriginal.1 -m/dev/null -q $(RCS)

.PRECIOUS:	$(INP_HDR)












