#include <stdio.h>
#include "clplib.h"
#include "pdl_gen.h"

DefTableKey CLP_InputFile = NoKey;
DefTableKey lclfile = NoKey;
DefTableKey expfile = NoKey;
DefTableKey ordfile = NoKey;
DefTableKey optfile = NoKey;
DefTableKey befile = NoKey;
static int error_count = 0;

void
clp_init (argc, argv)
int argc;
char *argv[];
{
  int i, done = 0;
  DefTableKey k;

  for (i = 1; (!done) && (i < argc); i++)
      { done = 1; i--; }
  if (i >= argc)
    error_count++;
  else {
    lclfile = NewKey();
    SetValue (lclfile,clp_string(argv[i++]),0);
    if (CLP_InputFile == NoKey) CLP_InputFile = lclfile;
  }
  if (i >= argc)
    error_count++;
  else {
    expfile = NewKey();
    SetValue (expfile,clp_string(argv[i++]),0);
    if (CLP_InputFile == NoKey) CLP_InputFile = expfile;
  }
  if (i >= argc)
    error_count++;
  else {
    ordfile = NewKey();
    SetValue (ordfile,clp_string(argv[i++]),0);
    if (CLP_InputFile == NoKey) CLP_InputFile = ordfile;
  }
  if (i >= argc)
    error_count++;
  else {
    optfile = NewKey();
    SetValue (optfile,clp_string(argv[i++]),0);
    if (CLP_InputFile == NoKey) CLP_InputFile = optfile;
  }
  if (i >= argc)
    error_count++;
  else {
    befile = NewKey();
    SetValue (befile,clp_string(argv[i++]),0);
    if (CLP_InputFile == NoKey) CLP_InputFile = befile;
  }
  if (CLP_InputFile == NoKey)
    if (i >= argc) error_count++;
    else {
      CLP_InputFile = NewKey();
      SetValue (CLP_InputFile, clp_string(argv[i++]),0);
  }
  if (error_count > 0) {
    fprintf (stderr, "Usage: %s [options] parameters\n",
             argv[0]);
    fprintf (stderr, "  options:\n");
    fprintf (stderr, "  param lclfile: Input file containing LCL\n");
    fprintf (stderr, "  param expfile: Output file for expand pass\n");
    fprintf (stderr, "  param ordfile: Output file for order pass\n");
    fprintf (stderr, "  param optfile: Output file for optim pass\n");
    fprintf (stderr, "  param befile: Output file for backend pass\n");
    exit (1);
  }
}
