
/* $Id: optstack.c,v 1.13 1991/11/22 09:07:03 cogito Exp $ */
/* $Log: optstack.c,v $
 * Revision 1.13  1991/11/22  09:07:03  cogito
 * modifications for error processing
 *
 * Revision 1.12  1991/10/30  15:00:12  cogito
 * Changed some errormessages "Anomalous internal state detected..."
 *
 * Revision 1.11  1991/10/07  12:11:56  cogito
 * the new EXPAND marks some assignments as VOID. This new
 * property causes an error of OPTIM, which is fixed now.
 *
 * Revision 1.10  1991/10/02  13:00:31  cogito
 * Error Message Output via err.c (message) added.
 *
 * Revision 1.9  1991/09/11  10:18:44  cogito
 * *** empty log message ***
 *
 * Revision 1.8  91/01/15  17:49:51  cogito
 * new IDL interface
 * 
 * Revision 1.7  90/12/11  11:26:02  cogito
 * error correction
 * 
 * 
 * Revision 1.6  90/12/04  16:26:22  cogito
 * new version of option handler
 *  */
static char rcs_id[]= "$Id: optstack.c,v 1.13 1991/11/22 09:07:03 cogito Exp $";

/************************************************/
/*						*/
/*	Version : 1.0				*/
/*						*/
/*	Module  : optstack.c			*/
/*						*/
/*	Contains the routines to insert		*/
/*	stack op's in a visit sequence		*/
/*						*/
/************************************************/



/************************************************/
/*		includes			*/
/************************************************/

#include <stdio.h>

#include "option_enums.h"
#include "option_types.h"

#include "lookup_idl.h"
#include "OPTIM.h"
#include "OPTIMMacros.h"
#include "optglobal.h"
#include "optidl.h"
#include "optfct.h"

#include "opterr.h"


/************************************************/
/*		defines				*/
/************************************************/

#define		MAX_EQUAL_SYMBOLS	50

#define		NOT_ON_STACK	        -1
#define		TOP_OF_STACK	        0


/************************************************/
/*	global variables and types		*/
/************************************************/

int offset[MAX_EQUAL_SYMBOLS];

int insert_index, rpl_fct_counter, cmp_fct_counter;

char *globname;

Attribution   targetvs;





/************************************************/
/*		functions			*/
/************************************************/

int	SuccCheckOnPop		( /* int, int */ );
int	ComputeInsertindex	( /* Action, int */ );

Boolean CmpFkt			( /* Attrrule, Attrrule */ );
Boolean	RplFkt			( /* Expr, Expr */ );

void	BuildObituaryAndBirthSets	( /* Visit_Sequences */ );
void	PushAndClobberCorrection	( /* SEQAttribution */ );
void	CheckObituary			( /* int, Action */ );
void	ReplaceParamExpr	( /* int, Call */ );
void	ReplaceArguments	( /* int, Eval */ );
void	Output		( /* int, int, Action */ );
void	Update		( /* int, int */ );
void    CheckBirthList      ( /* Action, SEQAttributes, int, int */ );
void    CheckObituaryList   ( /* Action, SEQAttributes, int, int */ );
void    InsertTermStackOperations       ( /* Attributes, Visit_Seq */ );
void	PUSHfrombelowPOPfromabove	( /* Attributes, Visit_Seq */ );
void	PUSHfromabovePOPfrombelow	( /* Attributes, Visit_Seq */ );
void	PUSHandPOPfromabove		( /* Attributes, Visit_Seq */ );

SEQAttributes	GetStackAttrs		( /* AttrSpez, SEQAttributes */ );

Boolean SymbIdInGroup		( /* Group, int */ );
Boolean	VisitToGroupAttr	( /* Group, int */ );

void	GroupPPfa		( /* Visit_Sequences, Group);
void	GroupPfaPfb		( /* Visit_Sequences, Group);
void	GroupPfbPfa		( /* Visit_Sequences, Group);
void	StackListGrouping	( /* Visit_Sequences */ );
void	StackGrouping		( /* Visit_Sequences */ );

void	InsertStackOperations	( /* Visit_Sequences */ );





/************************************************************************/
/*			SuccCheckOnPop					*/
/*									*/
/*	handles the order of multiple following POP operations		*/
/************************************************************************/

int SuccCheckOnPop(index, stackindex)
int   index, stackindex;
{
  Boolean    ready = FALSE;
  Attrrule   attrrule;
  Call       call;
  Expr       firstexpr, lastexpr;

  while (!ready)
  {
     index++;
     ithinSEQAttrrule(targetvs->attrrules, index, attrrule);
     if (typeof(attrrule) == KCall)
     {
       call = attrrule.VCall;
       if (!strcmp(call->name, "POP"))
       {
	 retrievefirstSEQExpr(call->params, firstexpr);
	 if (!strcmp(firstexpr.VName->n, globname))
	 {
	   retrievelastSEQExpr(call->params, lastexpr);
	   if (lastexpr.VVal->v < stackindex)
	     return (index);
	 }
	 else
	   return (index);
       }
       else
	 return (index);
     }
     else
       return (index);
  }

  return( index );

} /* end of SuccCheckOnPop */





/***********************************************************************/
/*                         ComputeInsertindex                          */
/***********************************************************************/

int ComputeInsertindex(action, stackindex)
Action   action;
int      stackindex;
{
  SEQAttrrule   X;
  Attrrule      attrrule;
  Eval          eval;
  Call          call;
  Expr          expr;
  int           index = 0;

  foreachinSEQAttrrule(targetvs->attrrules, X, attrrule)
  {
     index++;
     if (typeof(attrrule) == KVisit && typeof(action) == KVisits)
     {
	if (attrrule.VVisit->symbno == action.VVisits->symbno
	  && attrrule.VVisit->ord   == action.VVisits->ord)
	  return( SuccCheckOnPop(index, stackindex) );
     }
     else
       if (typeof(attrrule) == KCall && typeof(action) == KEval)
       {
	  call = attrrule.VCall;
	  eval = action.VEval;
	  if (eval->attrid == CONDITION && eval->symbno == CONDITION)
	  {
	    if (eval->row == call->row && eval->col == call->col)
	      return( SuccCheckOnPop(index, stackindex));
	  }
	  else
	  {
	    retrievefirstSEQExpr(call->params, expr);
	    if (expr.VAttracc->attrid == eval->attrid &&
	      expr.VAttracc->symbno == eval->symbno)
	      return( SuccCheckOnPop(index, stackindex) );
	  }
       }
  }

} /* end of ComputeInsertindex */




/***********************************************************************/
/*                               CmpFkt                                */
/***********************************************************************/

Boolean CmpFkt(attrrule1, attrrule2)
Attrrule   attrrule1, attrrule2;
{
	return (++cmp_fct_counter == insert_index);
} /* end of CmpFkt */




/***********************************************************************/
/*                               RplFkt                                */
/***********************************************************************/

Boolean RplFkt(expr1, expr2)
Expr   expr1, expr2;
{
	return (++rpl_fct_counter == insert_index);
} /* end of RplFkt */




/***********************************************************************/
/*                    BuildObituaryAndBirthSets                        */
/***********************************************************************/

void BuildObituaryAndBirthSets(root)
Visit_Sequences   root;
{
  SEQAttributes   X, XX;
  Attributes      sv_attr, vs_attr;
  SEQVisit_Seq    Y;
  Visit_Seq       thisvs;
  Action          action;

  foreachinSEQAttributes(root->single_visit, X, sv_attr)
  {
    if (!sv_attr->termattr)
    {
       foreachinSEQVisit_Seq(root->vi_seq, Y, thisvs)
       {
          foreachinSEQAttributes(thisvs->attrs, XX, vs_attr)
	  {
	     if (vs_attr->attrid == sv_attr->attrid)
	     {
	       ithinSEQAction(thisvs->actions, vs_attr->birth, action);
	       appendrearSEQAttributes(action.IDLclassCommon->birth, vs_attr);
	       ithinSEQAction(thisvs->actions, vs_attr->death, action);
	       appendrearSEQAttributes(action.IDLclassCommon->obituary, vs_attr);
             }
          }
       }
    }
  }

} /* end of BuildObituaryAndBirthSets */





/***********************************************************************/
/*                       PushAndClobberCorrection                      */
/***********************************************************************/

void PushAndClobberCorrection(attributionseq)
SEQAttribution   attributionseq;
{
  SEQAttribution   X;
  Attribution      vs;
  SEQAttrrule      Y;
  Attrrule         attrrule;
  Call             call;
  Expr		lhsattr, voidmark;

  foreachinSEQAttribution(attributionseq, X, vs)
  {
     foreachinSEQAttrrule(vs->attrrules, Y, attrrule)
     {
        if (typeof(attrrule) == KCall)
	{
          call = attrrule.VCall;
          if (!strcmp(call->name, "PUSH") || !strcmp(call->name, "CLOBBER")) {
/* for backend visit procs: Attracc for lefthand side added as final argument */
            retrievefirstSEQExpr(call->params, lhsattr);
/**/
            removefirstSEQExpr(call->params);
/**/
	    retrievelastSEQExpr(call->params, voidmark);
	    if ((typeof(voidmark) == KName) &&
		!strcmp(nOfName(ExprToName(voidmark)), "VOID")) {
/* make VOID mark last argument */
		removelastSEQExpr(call->params);
		appendrearSEQExpr(call->params, lhsattr);
		appendrearSEQExpr(call->params, voidmark);
	    } else
                appendrearSEQExpr(call->params, lhsattr);
/**/
          }
        }
     }
  }

} /* end of PushAndClobberCorrection */





/***********************************************************************/
/*                            CheckObituary                            */
/*                                                                     */
/* writes out a POP operation for attributes which dies at this action */
/***********************************************************************/

void CheckObituary(id, action)
int      id;
Action   action;
{
  SEQAttributes   X;
  Attributes      obiattr;

  foreachinSEQAttributes(action.IDLclassCommon->obituary, X, obiattr)
  {
     if (obiattr->attrid == id && obiattr->symbno != 0)
     {
       (void) Output(POP, offset[obiattr->symbno], action);
       (void) Update(POP, obiattr->symbno);
     }
  }

} /* end of CheckObituary */





/***********************************************************************/
/*                           ReplaceParamExpr                          */
/***********************************************************************/

void ReplaceParamExpr(id, call)
int      id;
Call     call;
{
  SEQExpr   X;
  Expr      expr;
  Call      newcall;
  Attracc   attracc;
  int       exprcounter =0;

  foreachinSEQExpr(call->params, X, expr)
  {
     exprcounter++;
     switch (typeof(expr))
     {
        case KAttracc :
           attracc = expr.VAttracc;
           if (attracc->attrid == id)
	   {
             newcall = MkCall(TOP, offset[attracc->symbno], globname);
/* for backend visit procs Attracc added as final argument */
             appendrearSEQExpr(newcall->params, expr);
/**/
             rpl_fct_counter = 0;
             insert_index    = exprcounter;
	     IDLtempExpr.VCall= newcall;
             orderedinsertSEQExpr(call->params, IDLtempExpr, RplFkt);
             removeSEQExpr(call->params, expr);
             topcounter++;
           }
           break;
        case KCall : (void) ReplaceParamExpr(id, expr.VCall); break;
        default    : break;
     } /* end of switch */
  }

} /* end of ReplaceParamExpr */





/***********************************************************************/
/*                          ReplaceArguments                           */
/***********************************************************************/

void ReplaceArguments(id, eval)
int    id;
Eval   eval;
{
  Boolean	condition;
  Call		call;
  Expr		firstexpr;

  if (condition= (eval->attrid == CONDITION && eval->symbno == CONDITION))
    call = GetCondition(targetvs->attrrules, eval);
  else
  {
    call = GetAssign(targetvs->attrrules, eval);
    retrievefirstSEQExpr(call->params, firstexpr);
    removefirstSEQExpr(call->params);
  }
  (void) ReplaceParamExpr(id, call);
  if (!condition)
    appendfrontSEQExpr(call->params, firstexpr);

} /* end of ReplaceArguments */





/***********************************************************************/
/*                               Output                                */
/***********************************************************************/

void Output(key, stackindex, action)
int      key, stackindex;
Action   action;
{
  Call   newcall, oldcall;
  Expr   expr;
  Val    value;
  Name   name;

  switch (key)
  {
     case POP:
     case SWAP:
        newcall = MkCall(key, stackindex, globname);
        if (key == POP)
	{
          if (typeof(action) == KVisits &&
              action.VVisits->symbno == 0 && action.VVisits->ord == 0)
            insert_index = 1;
          else
            insert_index = ComputeInsertindex(action, stackindex);
          popcounter++;
        }
        else
	{
          insert_index = ComputeInsertindex(action, stackindex) - 1;
          swapcounter++;
        }
        cmp_fct_counter = 0;
	IDLtempAttrrule.VCall= newcall;
        orderedinsertSEQAttrrule(targetvs->attrrules, IDLtempAttrrule, CmpFkt);
        break;
     case PUSH:
     case CLOBBER:
	oldcall = GetAssign(targetvs->attrrules, action.VEval);
	retrievefirstSEQExpr(oldcall->params, expr);
	removefirstSEQExpr(oldcall->params);
	if (key == PUSH)
	{
	  oldcall->name = "PUSH";
	  pushcounter++;
	}
	else
	{
	  oldcall->name = "CLOBBER";
	  clobbercounter++;
	  value = NVal;
	  value->v = stackindex;
	  IDLtempExpr.VVal= value;
	  appendfrontSEQExpr(oldcall->params, IDLtempExpr);
	}
	name = NName;
	name->n = malloc(strlen(globname) + 1);
	if (name->n == (char*)0)
	{
	  err_setpos(0,0);
	  err_print_deadly ("no more memory");
	  fprintf(listing,"*** DEADLY: no more memory\n");
	  exit(5);
	}
	strcpy(name->n, globname);
	IDLtempExpr.VName= name;
	appendfrontSEQExpr(oldcall->params, IDLtempExpr);
	appendfrontSEQExpr(oldcall->params, expr);
	break;
     default : break;
  } /* end of switch */

} /* end of Output */





/***********************************************************************/
/*                               Update                                */
/***********************************************************************/

void Update(key, symbno)
int   key, symbno;
{
  int   i;

  switch (key) {
     case PUSH :
        for (i=0; i < MAX_EQUAL_SYMBOLS; i++)
	{
           if (offset[i] > NOT_ON_STACK)
	     offset[i]++;
        }
        offset[symbno] = TOP_OF_STACK;
        break;
     case  POP :
        for (i=0; i < MAX_EQUAL_SYMBOLS; i++)
	{
           if (offset[i] > offset[symbno])
	     offset[i]--;
        }
        offset[symbno] = NOT_ON_STACK;
        break;
     case SWAP :
        for (i=0; i < MAX_EQUAL_SYMBOLS; i++)
	{
	  if (offset[i] == TOP_OF_STACK)
	  {
	    offset[i] = offset[symbno];
	    break;
	  }
        }
        offset[symbno] = TOP_OF_STACK;
        break;
     default : break;
  } /* end of switch */

} /* end of Update */





/***********************************************************************/
/*                          CheckBirthList                             */
/*                                                                     */
/***********************************************************************/

void CheckBirthList(action, birthlist, attrid, maxsymbno)
Action          action;
SEQAttributes   birthlist;
int             attrid, maxsymbno;

{
  SEQAttributes   X;
  Attributes      birthattr;
  int             symbno;

  if (lengthSEQAttributes(birthlist))
  {
    for (symbno=1; symbno <= maxsymbno; symbno++)
    {
      foreachinSEQAttributes(birthlist, X, birthattr)
      {
        if (birthattr->attrid == attrid && birthattr->symbno == symbno)
	{
	  if (action.VEval->attrid == attrid)
	  {
	    (void) Output(PUSH, TOP_OF_STACK, symbno);
	    (void) Update(PUSH, symbno);
	  }
	  else
	    (void) Update(PUSH, symbno);
	}
      }
    }
  }

} /* end of CheckBirthList */





/************************************************************************/
/*			CheckObituaryList				*/
/*									*/
/************************************************************************/

void CheckObituaryList(action, obituarylist, attrid, maxsymbno)
Action          action;
SEQAttributes   obituarylist;
int             attrid, maxsymbno;
{
  SEQAttributes   X;
  Attributes      obiattr;
  int            symbno;

  if (lengthSEQAttributes(obituarylist))
  {
    for (symbno=1; symbno <= maxsymbno; symbno++)
    {
      foreachinSEQAttributes(obituarylist, X, obiattr)
      {
        if (obiattr->attrid == attrid && obiattr->symbno == symbno)
        {
	  (void) Output(POP, offset[symbno], action);
	  (void) Update(POP, symbno);
        }
      }
    }
  }

} /* end of CheckObituaryList */





/***********************************************************************/
/*                     InsertTermStackOperations                       */
/*                                                                     */
/*             inserts stack ops for Terminal-Attributes               */
/***********************************************************************/

void InsertTermStackOperations(thisattr, vs)
Attributes   thisattr;
Visit_Seq    vs;
{
  SEQAction       X;
  Action          action;
  Def             def;
  SEQAttributes   birthlist, obilist;
  int             i, maxsymbno, attrid = thisattr->attrid;

  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
    offset[i] = NOT_ON_STACK;
  foreachinSEQAction(vs->actions, X, action)
  {
    def       = lookup_def(vs->prodid);
    maxsymbno = lengthSEQEntity(def.VProd->rhs);
    obilist   = action.IDLclassCommon->obituary;
    birthlist = action.IDLclassCommon->birth;
    switch (typeof(action))
    {
      case KVisits:
	(void) CheckBirthList(action, birthlist, attrid, maxsymbno);
	break;
      case KEval :
	if (InSeqAttrs(action.VEval->params, attrid))
	{
	  (void) ReplaceArguments(attrid, action.VEval);
	}
	(void) CheckBirthList(action, birthlist, attrid, maxsymbno);
	(void) CheckObituaryList(action, obilist, attrid, maxsymbno);
	break;
      default : break;
    } /* end of switch */
  }
  for (i=0; i < MAX_EQUAL_SYMBOLS; i++)
  {
    if (offset[i] != NOT_ON_STACK)
    {
      char errmsgbuff[ERR_BUFF_LEN];

      def = lookup_def(vs->prodid);
      err_setpos(def.VProd->row, def.VProd->col);
      sprintf (errmsgbuff, "The following option is required for optim: 'OPTIM: ATTRSPEZ TREE_NODE %s[%s];'", thisattr->sname, thisattr->aname);
      err_print_error (errmsgbuff);

      fprintf(listing,"*** ERROR: The following option is required for optim:\n");
      fprintf(listing,"           OPTIM: ATTRSPEZ TREE_NODE %s[%s];",
	      thisattr->sname, thisattr->aname);
#ifdef DEBUGG
      fprintf(listing,"*** ERROR: PPFA: offset array not ");
      fprintf(listing,"correct for attribute ");
      fprintf(listing,"%s[%d].%s in production %s\n\n",
	thisattr->sname, i, thisattr->aname, def.VProd->dname);
#endif
      exit(5);
    }
  }

} /* end of InsertTermStackOperations */





/***********************************************************************/
/*                     PUSHfrombelowPOPfromabove                       */
/*                                                                     */
/* inserts stack ops for discipline PUSH from below and POP from above */
/***********************************************************************/

void PUSHfrombelowPOPfromabove(thisattr, vs)
Attributes   thisattr;
Visit_Seq    vs;
{
  int             i;
  Def             def;
  SEQAction       X;
  Action          thisaction;
  Visits          visit;
  Eval            eval;
  Boolean         found;
  SEQAttributes   Y;
  Attributes      obiattr;

  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
    offset[i] = NOT_ON_STACK;
  foreachinSEQAction(vs->actions, X, thisaction)
  {
     switch (typeof(thisaction))
     {
        case KVisits :
           visit = thisaction.VVisits;
           if (visit->symbno == LEAVE)
	   { /* case LEAVE no i */
             if (AttrInstanceInSet(thisattr->attrid, 0, visit->obituary))
	     {
               /* parent X.b popped off during LEAVE */
               offset[PARENT_SYMBOL] = NOT_ON_STACK;
             }
             /* Output(thisvisit) */
           }
           else
	   {
             if (visit->symbid == thisattr->symbid)
	     { /* case VISIT no j on symbol X[i] */
               if (offset[visit->symbno] != NOT_ON_STACK)
	       { /* X[i].b is alive */
                 if (offset[visit->symbno] != TOP_OF_STACK)
		 { /* must swap to make X[i].b stack top */
                   (void) Output(SWAP, offset[visit->symbno], thisaction);
                   (void) Update(SWAP, visit->symbno);
                 }
               }
               /* Output(thisvisit) */
               if (AttrInstanceInSet(thisattr->attrid,visit->symbno, visit->birth))
	       {
               	 /* defined here and PUSHED during visit */
               	 (void) Update(PUSH, visit->symbno);
               }
               if (AttrInstanceInSet(thisattr->attrid,visit->symbno, visit->obituary))
	       {
                 /* died during visit, POP here */
                 (void) Output(POP, offset[visit->symbno], thisaction);
                 (void) Update(POP, visit->symbno);
               }
             }
             else
	     { /* case VISIT no j on symbol Y */
               /* Output(thisvisit) */
               /* no action or rule changes */
             }
           }
           break;
        case KEval :
           eval = thisaction.VEval;
           if (eval->attrid == thisattr->attrid && eval->symbno == PARENT_SYMBOL)
	   {
             /* case -> X[0].b, only parent defined here */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             found = FALSE;
             foreachinSEQAttributes(eval->obituary, Y, obiattr)
	     {
                if (obiattr->attrid == thisattr->attrid)
		{
                  (void) Output(CLOBBER, offset[obiattr->symbno], thisaction);
                  /* Update CLOBBER */
                  offset[0] = offset[obiattr->symbno]; /* parentvalue overwritten */
                  offset[obiattr->symbno] = NOT_ON_STACK; /* overwritten value now unavailable */
                  removeSEQAttributes(eval->obituary, obiattr);
                  found = TRUE;
                  break;
                }
             }
             if (!found)
	     {
               (void) Output(PUSH, TOP_OF_STACK, thisaction);
               (void) Update(PUSH, PARENT_SYMBOL);
             }
             (void) CheckObituary(thisattr->attrid, thisaction);
           }
           else
	   { /* case -> Y.c */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             /* Output(thiseval) */
             (void) CheckObituary(thisattr->attrid, thisaction);
           }
           break;
        default : break;
     } /* end of switch */
  }
  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
  {
     if (offset[i] != NOT_ON_STACK)
     {
       char errmsgbuff[ERR_BUFF_LEN];
       
       def = lookup_def(vs->prodid);
       err_setpos(def.VProd->row, def.VProd->col);
       sprintf (errmsgbuff, "The following option is required for optim: 'OPTIM: ATTRSPEZ TREE_NODE %s[%s];'", thisattr->sname, thisattr->aname);
       err_print_error (errmsgbuff);

       fprintf(listing,"*** ERROR: The following option is required for optim:\n");
       fprintf(listing,"           OPTIM: ATTRSPEZ TREE_NODE %s[%s];",
	      thisattr->sname, thisattr->aname);
#ifdef DEBUGG
       fprintf(listing,"*** ERROR: PFBPFA: offset array not correct ");
       fprintf(listing,"for attribute ");
       fprintf(listing,"%s[%d].%s in production %s\n\n",
               thisattr->sname, i, thisattr->aname, def.VProd->dname);
#endif
       exit(5);
     }
  }

} /* end of PUSHfrombelowPOPfromabove */





/***********************************************************************/
/*                      PUSHfromabovePOPfrombelow                      */
/*                                                                     */
/* inserts stack ops for discipline PUSH from above and POP from below */
/***********************************************************************/

void PUSHfromabovePOPfrombelow(thisattr, vs)
Attributes   thisattr;
Visit_Seq    vs;
{
  int             i;
  Def             def;
  SEQAction       X;
  Action          thisaction;
  Visits          visit;
  Eval            eval;

  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
    offset[i] = NOT_ON_STACK;
  foreachinSEQAction(vs->actions, X, thisaction)
  {
     switch (typeof(thisaction))
     {
        case KVisits :
           visit = thisaction.VVisits;
           if (visit->symbno == LEAVE)
	   { /* case LEAVE no i */
             if (AttrInstanceInSet(thisattr->attrid, 0, visit->birth))
	     {
               /* parent X.b pushed on during LEAVE */
               offset[PARENT_SYMBOL] = TOP_OF_STACK;
             }
             /* is new inserted for artificial inserted Attribuinstances */
             if (AttrInstanceInSet(thisattr->attrid, 0, visit->obituary))
	     {
               (void) Output(POP, offset[PARENT_SYMBOL], thisaction);
               (void) Update(POP, PARENT_SYMBOL);
             }
             /* end of new inserted case */
             /* Output(thisvisit) */
           }
           else
	   {
             if (visit->symbid == thisattr->symbid)
	     { /* case VISIT no j on symbol X[i] */
               if (offset[visit->symbno] != NOT_ON_STACK)
	       { /* X[i].b is alive */
                 if (offset[visit->symbno] != TOP_OF_STACK)
		 { /* must swap to make X[i].b stack top */
                   (void) Output(SWAP, offset[visit->symbno], thisaction);
                   (void) Update(SWAP, visit->symbno);
                 }
               }
               /* Output(thisvisit) */
               if (AttrInstanceInSet(thisattr->attrid,visit->symbno, visit->obituary))
	       {
                 /* POP is emitted in VS below */
                 (void) Update(POP, visit->symbno);
               }
             }
             else
	     { /* case VISIT no j on symbol Y */
               /* Output(thisvisit) */
               /* no action or rule changes */
             }
           }
           break;
        case KEval :
           eval = thisaction.VEval;
           if (eval->attrid == thisattr->attrid)
	   {
             /* case -> X[j].b */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             if (AttrInstanceInSet(thisattr->attrid, 0, eval->obituary))
	     {
               (void) Output(CLOBBER, offset[PARENT_SYMBOL], thisaction);
               /* Update CLOBBER */
               offset[eval->symbno] = offset[PARENT_SYMBOL]; /* new value overwrites old */
               offset[PARENT_SYMBOL] = NOT_ON_STACK; /* parentvalue now unavailable */
             }
             else
	     {
               (void) Output(PUSH, TOP_OF_STACK, thisaction);
               (void) Update(PUSH, eval->symbno);
             }
           }
           else
	   { /* case -> Y.c */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             if (AttrInstanceInSet(thisattr->attrid, 0, eval->obituary))
	     {
               (void) Output(POP, offset[PARENT_SYMBOL], thisaction);
               (void) Update(POP, PARENT_SYMBOL);
             }
           }
           break;
        default : break;
     } /* end of switch */
  }
  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
  {
     if (offset[i] != NOT_ON_STACK)
     {
       char errmsgbuff[ERR_BUFF_LEN];
       
       def = lookup_def(vs->prodid);
       err_setpos(def.VProd->row, def.VProd->col);
       sprintf (errmsgbuff, "The following option is required for optim: 'OPTIM: ATTRSPEZ TREE_NODE %s[%s];'", thisattr->sname, thisattr->aname);
       err_print_error (errmsgbuff);

       fprintf(listing,"*** ERROR: The following option is required for optim:\n");
       fprintf(listing,"           OPTIM: ATTRSPEZ TREE_NODE %s[%s];",
	      thisattr->sname, thisattr->aname);
#ifdef DEBUGG
       fprintf(listing,"*** ERROR: PFAPFB: offset array not correct ");
       fprintf(listing,"for att\ribute ");
       fprintf(listing,"%s[%d]%s in production %s\n\n",
               thisattr->sname, i, thisattr->aname, def.VProd->dname);
#endif
       exit(5);
     }
  }

} /* end of PUSHfromabovePOPfrombelow */





/***********************************************************************/
/*                         PUSHandPOPfromabove                         */
/*                                                                     */
/*       inserts stack ops for discipline PUSH and POP from above      */
/***********************************************************************/

void PUSHandPOPfromabove(thisattr, vs)
Attributes   thisattr;
Visit_Seq    vs;
{
  int             i;
  Def             def;
  SEQAction       X;
  Action          thisaction;
  Visits          visit;
  Eval            eval;
  Boolean         found;
  SEQAttributes   Y;
  Attributes      obiattr;

  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
    offset[i] = NOT_ON_STACK;
  foreachinSEQAction(vs->actions, X, thisaction)
  {
     switch (typeof(thisaction))
     {
        case KVisits :
           visit = thisaction.VVisits;
           if (visit->symbno == LEAVE)
	   { /* case LEAVE no i */
             if (AttrInstanceInSet(thisattr->attrid, 0, visit->birth))
	     {
               /* parent X.b pushed on during LEAVE */
               offset[PARENT_SYMBOL] = TOP_OF_STACK;
             }
             if (AttrInstanceInSet(thisattr->attrid, 0, visit->obituary))
	     {
               /* parent X.b popped off during LEAVE */
               offset[PARENT_SYMBOL] = NOT_ON_STACK;
             }
             /* Output(thisvisit) */
           }
           else
	   {
             if (visit->symbid == thisattr->symbid)
	     { /* case VISIT no j on symbol X[i] */
               if (offset[visit->symbno] != NOT_ON_STACK)
	       { /* X[i].b is alive */
                 if (offset[visit->symbno] != TOP_OF_STACK)
		 { /* must swap to make X[i].b stack top */
                   (void) Output(SWAP, offset[visit->symbno], thisaction);
                   (void) Update(SWAP, visit->symbno);
                 }
               }
               /* Output(thisvisit) */
               if (AttrInstanceInSet(thisattr->attrid,visit->symbno, visit->obituary))
	       {
                 (void) Output(POP, 0, thisaction);
                 (void) Update(POP, visit->symbno);
               }
             }
             else
	     { /* case VISIT no j on symbol Y */
               /* Output(thisvisit) */
               /* no action or rule changes */
             }
           }
           break;
        case KEval :
           eval = thisaction.VEval;
           if (eval->attrid == thisattr->attrid)
	   {
             /* case -> X[j].b */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             found = FALSE;
             foreachinSEQAttributes(eval->obituary, Y, obiattr)
	     {
                if (obiattr->attrid == thisattr->attrid)
		{
                  (void) Output(CLOBBER, offset[obiattr->symbno], thisaction);
                  /* Update CLOBBER */
                  offset[eval->symbno] = offset[obiattr->symbno]; /* parentvalue overwritten */
                  offset[obiattr->symbno] = NOT_ON_STACK; /* overwritten value now unavailable */
                  removeSEQAttributes(eval->obituary, obiattr);
                  found = TRUE;
                  break;
                }
             }
             if (!found)
	     {
               (void) Output(PUSH, TOP_OF_STACK, thisaction);
               (void) Update(PUSH, eval->symbno);
             }
             (void) CheckObituary(thisattr->attrid, thisaction);
           }
           else
	   { /* case -> Y.c */
             if (InSeqAttrs(eval->params, thisattr->attrid))
               (void) ReplaceArguments(thisattr->attrid, eval);
             /* Output(thiseval) */
             (void) CheckObituary(thisattr->attrid, thisaction);
           }
           break;
        default : break;
     } /* end of switch */
  }
  for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
  {
     if (offset[i] != NOT_ON_STACK)
     {
       char errmsgbuff[ERR_BUFF_LEN];
       
       def = lookup_def(vs->prodid);
       err_setpos(def.VProd->row, def.VProd->col);
       sprintf (errmsgbuff, "The following option is required for optim: 'OPTIM: ATTRSPEZ TREE_NODE %s[%s];'", thisattr->sname, thisattr->aname);
       err_print_error (errmsgbuff);

       fprintf(listing,"*** ERROR: The following option is required for optim:\n");
       fprintf(listing,"           OPTIM: ATTRSPEZ TREE_NODE %s[%s];",
	      thisattr->sname, thisattr->aname);

#ifdef DEBUGG
       fprintf(listing,"*** ERROR: PPFA: offset array not correct ");
       fprintf(listing,"for attribute\n ");
       fprintf(listing,"%s[%d].%s in production %s\n\n",
               thisattr->sname, i, thisattr->aname, def.VProd->dname);
#endif
       exit(5);
     }
  }

} /* end of PUSHandPOPfromabove */





/******************************************************************************/
/*										*/
/*		functions for stack grouping					*/
/*										*/
/******************************************************************************/


/************************************************************************/
/*			GetStackAttrs					*/
/*									*/
/*   builds from the attribute names of attrspez a list of attributes   */
/*   which can be implemented as one group of global stack		*/
/************************************************************************/

SEQAttributes GetStackAttrs(anl, attrlist)
ANamesList	anl;
SEQAttributes	attrlist;
{
  IdList	anames;
  SEQAttributes	Y;
  Attributes	firstattr, thisattr;
  int		typeid, symbid, stackclass;
  Boolean	ok;

  for (anames= anl->names; anames; anames=anames->next)
    attrlist= GetAttrsByName (attrlist, anl, GLOBAL_STACK);
  retrievefirstSEQAttributes(attrlist, firstattr);
  typeid = firstattr->typeid;
  symbid = firstattr->symbid;
  if (firstattr->class == SYNT)
    stackclass = PFBPFA;
  else if (firstattr->BnNF)
         stackclass = PFAPFB;
       else
         stackclass = PPFA;
  foreachinSEQAttributes(tailSEQAttributes(attrlist), Y, thisattr)
  {
     ok = TRUE;
     if (thisattr->typeid != typeid || thisattr->symbid == symbid)
       ok=FALSE;
     switch (stackclass)
     {
	case PFBPFA :
	   if (thisattr->class == INH)
	     ok = FALSE;
	   break;
	case PFAPFB :
	   if (thisattr->class == SYNT || !thisattr->BnNF)
	     ok = FALSE;
	   break;
	case PPFA   :
	   if (thisattr->class == SYNT || thisattr->BnNF)
	     ok = FALSE;
	   break;
	default : break;
     }
     if (!ok)
     {
        char errmsgbuff[ERR_BUFF_LEN];
	err_setpos(0,0);
	sprintf (errmsgbuff, "ATTRIBUTE %s.%s cannot be implemented in this GROUP.",
		 thisattr->sname, thisattr->aname);
	err_print_warning (errmsgbuff);
	
	fprintf(listing,"*** WARNING: ATTRIBUTE %s.%s can not implemented in this GROUP\n",
		thisattr->sname, thisattr->aname);
	removeSEQAttributes(attrlist, thisattr);
     }
  }

  return(attrlist);

} /* end of GetStackAttrs */





/***********************************************************************/
/*                         SymbIdInGroup                               */
/*                                                                     */
/*  returns TRUE iff group contains an attribute with sybmid = symbid  */
/***********************************************************************/

Boolean SymbIdInGroup(group, symbid)
Group   group;
int     symbid;
{
  SEQAttributes   X;
  Attributes      groupattr;

  foreachinSEQAttributes(group->members, X, groupattr)
    if (groupattr->symbid == symbid)
      return (TRUE);

  return (FALSE);

} /* end of SymbIdInGroup */





/***********************************************************************/
/*                        VisitToGroupAttr                             */
/*                                                                     */
/*  returns TRUE iff group contains an attribute with sybmid = symbid  */
/***********************************************************************/

Boolean VisitToGroupAttr(group, symbid)
Group   group;
int     symbid;
{
  SEQAttributes   X;
  Attributes      groupattr;

  foreachinSEQAttributes(group->members, X, groupattr)
   if (groupattr->symbid == symbid)
     return (TRUE);

  return(FALSE);

} /* end of VisitToGroupAttr */





/***********************************************************************/
/*                            GroupPPfa                                */
/*                                                                     */
/*   inserts for all group members the stack operations for one stack  */
/*   with dicipline PUSH and POP from above                            */
/***********************************************************************/

void GroupPPfa(root, group)
Visit_Sequences   root;
Group             group;
{
  SEQVisit_Seq    X;
  Visit_Seq       thisvs;
  SEQAction       Y;
  Action          thisaction;
  Eval            eval;
  Visits          visit;
  SEQAttributes   Z;
  Attributes      groupattr, obiattr;
  Def             def;
  Boolean         found;
  int             i;

  strcpy(globname, group->name);
  foreachinSEQVisit_Seq(root->vi_seq, X, thisvs)
  {
     targetvs = GetAttribution(thisvs->prodid);
     for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
       offset[i] = NOT_ON_STACK;
     foreachinSEQAction(thisvs->actions, Y, thisaction)
     {
        switch (typeof(thisaction))
	{
           case KVisits :
              visit = thisaction.VVisits;
              if (visit->symbno == LEAVE)
	      {
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, visit->birth))
		   {
                     offset[0] = 0;
                   }
                }
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid,0,visit->obituary))
		   {
                     offset[0] = -1;
                   }
                }
                /* Output(thisaction) */
              }
              else
	      {
                if (VisitToGroupAttr(group, visit->symbid))
		{
                  if (offset[visit->symbno] != -1)
		  {
                    if (offset[visit->symbno] != 0)
		    {
                      (void) Output(SWAP, offset[visit->symbno], thisaction);
                      (void) Update(SWAP, visit->symbno);
                    }
                  }
                  /* Output(thisaction); */
                  foreachinSEQAttributes(group->members, Z, groupattr)
		  {
                     if (AttrInstanceInSet(groupattr->attrid, visit->symbno, visit->obituary))
		     {
                       (void) Output(POP, 0, thisaction);
                       (void) Update(POP, visit->symbno);
                     }
                  }
                }
                else
		{ /* Output(thisaction) */ }
              }
              break;
           case KEval :
              eval = thisaction.VEval;
              if (eval->symbno != 0 && InSeqAttrs(group->members, eval->attrid))
	      {
                /* case -> X[i].b */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                found = FALSE;
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(CLOBBER, offset[obiattr->symbno], thisaction);
                     offset[eval->symbno] = offset[obiattr->symbno];
                     offset[obiattr->symbno] = -1;
                     removeSEQAttributes(eval->obituary, obiattr);
                     found = TRUE;
                     break;
                   }
                }
                if (!found)
		{
                  (void) Output(PUSH, 0, thisaction);
                  (void) Update(PUSH, eval->symbno);
                }
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (obiattr->symbno != 0 && InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(POP, offset[obiattr->symbno], thisaction);
                     (void) Update(POP, obiattr->symbno);
                   }
                }
              }
              else
	      { /* case -> Y.c */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                /* Output(thisaction) */
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (obiattr->symbno != 0 && InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(POP, offset[obiattr->symbno], thisaction);
                     (void) Update(POP, obiattr->symbno);
                   }
                }
              }
              break;
           default : break;
        } /* end of switch */
     }
     for (i=0; i<MAX_EQUAL_SYMBOLS; i++ )
     {
        if (offset[i] != NOT_ON_STACK)
	{
          def = lookup_def(thisvs->prodid);
	  err_setpos(def.VProd->row, def.VProd->col);
	  err_print_error ("Please do not use a grouping option (in this case)");
	  fprintf(listing,"*** ERROR: Please do not use a grouping option (in this case)\n");
#ifdef DEBUGG
          fprintf(listing,"*** ERROR: GroupPPfa: offset array not correct" );
          fprintf(listing,"for symbol no." );
          fprintf(listing,"%d in production %s\n\n",i,def.VProd->dname);
#endif
          exit(5);
        }
     }
  }

} /* end of GroupPPfa */





/***********************************************************************/
/*                           GroupPfaPfb                               */
/*                                                                     */
/*   inserts for all group members the stack operations for one stack  */
/*   with dicipline PUSH from above and POP from below                 */
/***********************************************************************/

void GroupPfaPfb(root, group)
Visit_Sequences   root;
Group             group;
{
  SEQVisit_Seq    X;
  Visit_Seq       thisvs;
  SEQAction       Y;
  Action          thisaction;
  Eval            eval;
  Visits          visit;
  SEQAttributes   Z;
  Attributes      groupattr;
  Def             def;
  Boolean         found;
  int             i;

  strcpy(globname, group->name);
  foreachinSEQVisit_Seq(root->vi_seq, X, thisvs)
  {
     targetvs = GetAttribution(thisvs->prodid);
     for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
       offset[i] = NOT_ON_STACK;
     foreachinSEQAction(thisvs->actions, Y, thisaction)
     {
        switch (typeof(thisaction))
	{
           case KVisits :
              visit = thisaction.VVisits;
              if (visit->symbno == LEAVE)
	      {
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, visit->birth))
                     offset[0] = 0;
                }
                /* is new inserted for artificial inserted Attribuinstances */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, visit->obituary))
		   {
                     (void) Output(POP, offset[0], thisaction);
                     (void) Update(POP, 0);
                   }
                }
                /* end of new inserted case */
                /* Output(thisaction) */
              }
              else
	      {
                if (VisitToGroupAttr(group, visit->symbid))
		{
                  if (offset[visit->symbno] != -1)
		  {
                    if (offset[visit->symbno] != 0)
		    {
                      (void) Output(SWAP, offset[visit->symbno], thisaction);
                      (void) Update(SWAP, visit->symbno);
                    }
                  }
                  /* Output(thisaction); */
                  foreachinSEQAttributes(group->members, Z, groupattr)
		  {
                     if (AttrInstanceInSet(groupattr->attrid, visit->symbno, visit->obituary))
		     {
                       /* POP is emitted in VS below */
                       (void) Update(POP, visit->symbno);
                     }
                  }
                }
                else
		{ /* Output(thisaction) */ }
              }
              break;
           case KEval :
              eval = thisaction.VEval;
              if (eval->symbno != 0 && InSeqAttrs(group->members, eval->attrid))
	      {
                /* case -> X[i].b */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                found = FALSE;
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, eval->obituary))
		   {
                     (void) Output(CLOBBER, offset[0], thisaction);
                     offset[eval->symbno] = offset[0];
                     offset[0] = -1;
                     found = TRUE;
                     break;
                   }
                }
                if (!found)
		{
                  (void) Output(PUSH, 0, thisaction);
                  (void) Update(PUSH, eval->symbno);
                }
              }
              else
	      { /* case -> Y.c */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                /* Output(thisaction) */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, eval->obituary))
		   {
                     (void) Output(POP, offset[0], thisaction);
                     (void) Update(POP, 0);
                   }
                }
              }
              break;
           default : break;
        } /* end of switch */
     }
     for (i=0; i<MAX_EQUAL_SYMBOLS; i++ )
     {
        if (offset[i] != NOT_ON_STACK)
	{
          def = lookup_def(thisvs->prodid);
	  err_setpos(def.VProd->row, def.VProd->col);
	  err_print_error("Please do not use a grouping option (in this case)");
          fprintf(listing,"*** ERROR: Please do not use a grouping option (in this case)\n");
#ifdef DEBUGG
          fprintf(listing,"*** ERROR: GroupPfaPfb: offset array not correct ");
          fprintf(listing,"for symbol no. ");
          fprintf(listing,"%d in production %s\n\n",i,def.VProd->dname);
#endif
          exit(5);
        }
     }
  }

} /* end of GroupPfaPfb */





/***********************************************************************/
/*                           GroupPfbPfa                               */
/*                                                                     */
/*   inserts for all group members the stack operations for one stack  */
/*   with dicipline PUSH from below and POP from above                 */
/***********************************************************************/

void GroupPfbPfa(root, group)
Visit_Sequences   root;
Group             group;
{
  SEQVisit_Seq    X;
  Visit_Seq       thisvs;
  SEQAction       Y;
  Action          thisaction;
  Eval            eval;
  Visits          visit;
  SEQAttributes   Z;
  Attributes      groupattr, obiattr;
  Def             def;
  Boolean         found;
  int             i;

  strcpy(globname, group->name);
  foreachinSEQVisit_Seq(root->vi_seq, X, thisvs)
  {
     targetvs = GetAttribution(thisvs->prodid);
     for ( i = 0; i < MAX_EQUAL_SYMBOLS; i++ )
       offset[i] = NOT_ON_STACK;
     foreachinSEQAction(thisvs->actions, Y, thisaction)
     {
        switch (typeof(thisaction))
	{
           case KVisits :
              visit = thisaction.VVisits;
              if (visit->symbno == LEAVE)
	      {
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (AttrInstanceInSet(groupattr->attrid, 0, visit->obituary))
                     offset[0] = -1;
                }
                /* Output(thisaction) */
              }
              else
	      {
                if (VisitToGroupAttr(group, visit->symbid))
		{
                  if (offset[visit->symbno] != -1)
		  {
                    if (offset[visit->symbno] != 0)
		    {
                      (void) Output(SWAP, offset[visit->symbno], thisaction);
                      (void) Update(SWAP, visit->symbno);
                    }
                  }
                  /* Output(thisaction); */
                  foreachinSEQAttributes(group->members, Z, groupattr)
		  {
                     if (AttrInstanceInSet(groupattr->attrid, visit->symbno, visit->birth))
		     {
                       (void) Update(PUSH, visit->symbno);
		       break;
		     }
                  }
                  foreachinSEQAttributes(group->members, Z, groupattr)
		  {
                     if (AttrInstanceInSet(groupattr->attrid, visit->symbno, visit->obituary))
		     {
                       (void) Output(POP, offset[visit->symbno], thisaction);
                       (void) Update(POP, visit->symbno);
                       break;
                     }
                  }
                }
                else
		{ /* Output(thisaction) */ }
              }
              break;
           case KEval :
              eval = thisaction.VEval;
              if (eval->symbno == 0 && InSeqAttrs(group->members, eval->attrid))
	      {
                /* case -> X[0].b */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                found = FALSE;
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(CLOBBER, offset[obiattr->symbno], thisaction);
                     offset[0] = offset[obiattr->symbno];
                     offset[obiattr->symbno] = -1;
                     removeSEQAttributes(eval->obituary, obiattr);
                     found = TRUE;
                     break;
                   }
                }
                if (!found)
		{
                  (void) Output(PUSH, 0, thisaction);
                  (void) Update(PUSH, 0);
                }
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (obiattr->symbno != 0 && InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(POP, offset[obiattr->symbno], thisaction);
                     (void) Update(POP, obiattr->symbno);
                   }
                }
              }
              else
	      { /* case -> Y.c */
                foreachinSEQAttributes(group->members, Z, groupattr)
		{
                   if (InSeqAttrs(eval->params, groupattr->attrid))
		   {
                     (void) ReplaceArguments(groupattr->attrid, eval);
                   }
                }
                /* Output(thisaction) */
                foreachinSEQAttributes(eval->obituary, Z, obiattr)
		{
                   if (obiattr->symbno != 0 && InSeqAttrs(group->members, obiattr->attrid))
		   {
                     (void) Output(POP, offset[obiattr->symbno], thisaction);
                     (void) Update(POP, obiattr->symbno);
                   }
                }
              }
              break;
           default : break;
        } /* end of switch */
     }
     for (i=0; i<MAX_EQUAL_SYMBOLS; i++ )
     {
        if (offset[i] != NOT_ON_STACK)
	{
          def = lookup_def(thisvs->prodid);
	  err_setpos(def.VProd->row, def.VProd->col);
	  err_print_error("Please do not use a grouping option (in this case)");

          fprintf(listing,"*** ERROR: Please do not use a grouping option (in this case)\n");
#ifdef DEBUGG
          fprintf(listing,"*** ERROR: GroupPfbPfa: offset array not correct ");
          fprintf(listing,"for symbol no. ");
          fprintf(listing,"%d in production %s\n\n",i,def.VProd->dname);
#endif
          exit(5);
        }
     }
  }

} /* end of GroupPfbPfa */





/***********************************************************************/
/*                        StackListGrouping                            */
/*                                                                     */
/*     builds groups of optional stack lists and calls the various     */
/*     insert routines                                                 */
/***********************************************************************/

void StackListGrouping(root)
Visit_Sequences    root;
{
  OptList optp;
  SEQAttributes   Y, attrlist;
  Attributes      firstattr, thisattr;
  Group           group;

  for (optp= optim_opts->opt_opts; optp; optp= optp->next)
  {
    if (optp->entry->flag== attr_glob_stack)
    {
      attrlist= MkAttrList();
      attrlist= GetStackAttrs (optp->entry->attrs, attrlist);
      retrievefirstSEQAttributes(attrlist, firstattr);
      group = MkGroup(firstattr, UNKNOWN);
      stackgroupcounter++;
      removefirstSEQAttributes(attrlist);
      foreachinSEQAttributes(attrlist, Y, thisattr)
	if (!thisattr->termattr)
	{
          appendfrontSEQAttributes(group->members, thisattr);
          removeSEQAttributes(attrlist, thisattr);
	}
      switch (firstattr->class)
      {
	case SYNT :
	  group->class = PFBPFA;
	  (void) GroupPfbPfa(root, group);
	  break;
	case INH  :
	  if (firstattr->BnNF)
	  {
	    group->class = PFAPFB;
	    (void) GroupPfaPfb(root, group);
	  }
	  else
	  {
	    group->class = PPFA;
	    (void) GroupPPfa(root, group);
	  }
          break;
	default : break;
      } /* end of switch */
       appendfrontSEQGroup(root->groups, group);
    }
  }
} /* end of StackListGrouping */




/***********************************************************************/
/*                          StackGrouping                              */
/*                                                                     */
/*     builds groups of stack attributes and calls the various         */
/*     insert routines                                                 */
/***********************************************************************/

void StackGrouping(root)
Visit_Sequences    root;
{
  SEQAttributes   X, alist, attrlist0, attrlist1, attrlist2;
  Attributes      thisattr, firstattr;
  Group           group;
  int             i, symbid;

  attrlist0 = MkAttrList(); /* PUSH from below, POP from above */
  attrlist1 = MkAttrList(); /* PUSH from above, POP from below */
  attrlist2 = MkAttrList(); /* PUSH and POP from above         */
  foreachinSEQAttributes(root->single_visit, X, thisattr)
  {
    if (!thisattr->termattr)
    {
      switch (thisattr->class)
      {
         case SYNT :
            appendfrontSEQAttributes(attrlist0, thisattr);
            break;
         case INH  :
            if (thisattr->BnNF)
              appendfrontSEQAttributes(attrlist1, thisattr);
            else
              appendfrontSEQAttributes(attrlist2, thisattr);
            break;
         default : break;
      } /* end of switch */
      removeSEQAttributes(root->single_visit, thisattr);
    }
  }
  for (i=0; i<3; i++)
  {
     switch (i)
     {
        case 0 : alist = attrlist0; break;
        case 1 : alist = attrlist1; break;
        case 2 : alist = attrlist2; break;
        default : break;
     } /* end of switch */
     while (!emptySEQAttributes(alist))
     {
	retrievefirstSEQAttributes(alist, firstattr);
	group  = MkGroup(firstattr, i+1);
	stackgroupcounter++;
	symbid = firstattr->symbid;
	removefirstSEQAttributes(alist);
	foreachinSEQAttributes(alist, X, thisattr)
	   if (thisattr->typeid == group->typeid &&
		!SymbIdInGroup(group, thisattr->symbid))
	   {
	     appendfrontSEQAttributes(group->members, thisattr);
	     removeSEQAttributes(alist, thisattr);
	   }
	appendfrontSEQGroup(root->groups, group);
	switch (i)
	{
	   case 0 : (void) GroupPfbPfa(root, group); break;
	   case 1 : (void) GroupPfaPfb(root, group); break;
	   case 2 : (void) GroupPPfa(root, group); break;
	   default : break;
	} /* end of switch */
     }
  }

} /* end of StackGrouping */





/***********************************************************************/
/*                      InsertStackOperations                          */
/*                                                                     */
/*     calls the various stack discipline algorithms, to insert ops    */
/***********************************************************************/

void InsertStackOperations(root)
Visit_Sequences    root;
{
  SEQAttributes   X;
  Attributes      thisattr;
  SEQVisit_Seq    Y;
  Visit_Seq       thisvs;

  globname = malloc(50);
  if (!globname)
  {
      err_setpos(0,0);
      err_print_deadly("no more memory");
      
      fprintf(listing,"*** ERROR: no more memory \n");
      exit(5);
  }
  (void) BuildObituaryAndBirthSets(root);
  if (stack_group_list_option)
    (void) StackListGrouping(root);
  if (group_all_option || stack_group_option)
    (void) StackGrouping(root);
  foreachinSEQAttributes(root->single_visit, X, thisattr)
  {
     strcpy(globname, thisattr->sname);
     strcat(globname, thisattr->aname);
     foreachinSEQVisit_Seq(root->vi_seq, Y, thisvs)
     {
        if (InSeqAttrs(thisvs->attrs, thisattr->attrid))
	{
	  targetvs = GetAttribution(thisvs->prodid);
	  if (thisattr->termattr)
	    (void) InsertTermStackOperations(thisattr, thisvs);
	  else
	    switch (thisattr->class)
	    {
	       case SYNT :
		  /* PUSH from below and POP from above */
		  (void) PUSHfrombelowPOPfromabove(thisattr, thisvs);
		  break;
	       case INH  :
		  if (thisattr->BnNF)
		    /* PUSH from above and POP from below */
		    (void) PUSHfromabovePOPfrombelow(thisattr, thisvs);
		  else
		    /* PUSH and POP from above */
		    (void) PUSHandPOPfromabove(thisattr, thisvs);
		  break;
	       default : break;
	    } /* end of switch */

	}
     }
  }
  (void) PushAndClobberCorrection(ligaroot->attrrules);

} /* end of InsertStackOperations */

