# $Id: Makefile.cpp,v 1.7 1992/11/11 15:13:01 cogito Exp $

# Makefile of the directory idl to create IDL-Library for liga-system


SHELL	= /bin/sh
CFLAGS=
COFLAGS	= -q

SUBDIR	= idllib
DISTRIB = /tmp

LIGAH	= LIGA.h global.h
SOURCES	= LIGA.c lookup_idl.c liga_func.c
HEADER	= $(LIGAH) LIGAMacros.h lookup_idl.h liga_func.h \
	reader.h writer.h scalarlist.h
RCS	= $(SOURCES) $(HEADER)

OBJECTS	= LIGA.o lookup_idl.o liga_func.o

TIDY= *.o *.a
CLEAN= $(TIDY)
CLOBBER= $(CLEAN)

all:	$(LIGAH) LIGAMacros.h liga_func.h IDL.a

#if defined(NO_RANLIB)
IDL.a:  $(OBJECTS) libidl.a
	cp libidl.a IDL.a
	ar rcus IDL.a $(OBJECTS)
#else
IDL.a:  $(OBJECTS) libidl.a
	cp libidl.a IDL.a
	ar rcu IDL.a $(OBJECTS)
	ranlib IDL.a
#endif

LIGA.o: LIGA.c reader.h writer.h $(LIGAH)
	${CC} ${CFLAGS} -c LIGA.c

lookup_idl.o: lookup_idl.c lookup_idl.h LIGAMacros.h $(LIGAH)
	${CC} ${CFLAGS} -c lookup_idl.c

liga_func.o: liga_func.c liga_func.h $(LIGAH)
	${CC} ${CFLAGS} -c liga_func.c

libidl.a:
	(cd idllib; make all CC="$(CC)" )

# SourceDistr

SourceDistr: $(SOURCES) $(HEADER)
	@for i in $(SUBDIR); do echo; echo Source Tool/liga/idl/$$i; mkdir $$i; \
		cd $$i; ln -s $(ELI)/$$i/RCS; co $(COFLAGS) Makefile.cpp; \
                make -u -f Makefile.cpp ELI=$(ELI)/$$i COFLAGS=$(COFLAGS) \
			SourceDistr; \
                rm RCS; cd ..; done

# checkout

idllib/checkout:	idllib/Makefile
	(cd idllib; make checkout );

idllib/Makefile:
	(cd idllib; co $(COFLAGS) Makefile.cpp; \
	 ../../Configure );
 
checkout:	idllib/checkout
	co $(COFLAGSS) $(RCS)
	
# installation

install:

# distribution

distrib:
	- rm -rf $(DISTRIB)/idl
	mkdir $(DISTRIB)/idl
	cp Makefile.cpp README $(SOURCES) $(HEADER) $(DISTRIB)/idl
	cd $(DISTRIB)/idl; chmod 0644 Makefile.cpp README $(SOURCES) $(HEADER)
	(cd idllib; make distrib DISTRIB=$(DISTRIB) );

# clean

tidy:
	rm -f $(TIDY)
	(cd idllib; make tidy)

clean:	
	rm -f $(CLEAN)
	(cd idllib; make clean)

clobber:
	rm -f $(CLOBBER)
	(cd idllib; make clobber)

# cleanall

cleanall:	clean
	rcsclean -q $(SOURCES)
	rcsclean -q $(HEADER)
	(cd idllib; make cleanall);

rcsclean:
	@for i in $(SUBDIR); do echo; echo RcsCleaning Tool/liga/idl/$$i; \
		(cd $$i; make rcsclean); \
                done
	-rcsclean $(COFLAGS) $(SOURCES) $(HEADER) Makefile.cpp
	rm -f *.o *.a Makefile

.PRECIOUS:	$(LIGAH) LIGAMacros.h liga_func.h






