/* $Id: Bitmaps.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: Bitmaps.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Misc/Bitmaps.c					*
 *									*
 *	CONTENTS:	Initialization of the used bitmaps		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#include "Misc.h"
#include "Main.h"

#include "CheckMark.bm"
#include "Cascade.bm"
#include "Icon.bm"


/************************************************************************
 *		     	    Global Definitions				*
 ************************************************************************/

PUBLIC Pixmap	CheckMarkBitmap = None;		/* Menu item checkmark */
PUBLIC Pixmap	CascadeBitmap = None;		/* Menu cascade indicator */
PUBLIC Pixmap	IconBitmap = None;		/* Main window icon */


/************************************************************************
 *        		       LoadBitmaps				*
 ************************************************************************/

/* Initializes the three public bitmaps exported from this file.
 */

PUBLIC void LoadBitmaps()
{
      /* Build CheckMarkBitmap */
	CheckMarkBitmap = XCreateBitmapFromData (dpy, 
		RootWindowOfScreen (XtScreen (Toplevel)),
		CheckMark_bits, CheckMark_width, CheckMark_height);

      /* Build CascadeBitmap */
	CascadeBitmap = XCreateBitmapFromData (dpy,
		RootWindowOfScreen (XtScreen (Toplevel)),
		Cascade_bits, Cascade_width, Cascade_height);

      /* Build IconBitmap */
	IconBitmap = XCreateBitmapFromData (dpy,
		RootWindowOfScreen (XtScreen (Toplevel)),
		Icon_bits, Icon_width, Icon_height);
}
