/* $Id: GramCon.c,v 3.3 1992/11/09 09:03:18 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

/* grammar extraction		*/
/* U. Kastens, 21. 1. 92	*/

#include "HEAD.h"
#include "lookup_idl.h"

#define GENTREEATTR     "GENTREE"
#define IsGenAttr(aname) (strcmp (nameOfAttrdef (aname), GENTREEATTR) == 0)


bool IsVoidAttr (ad)
        Attrdef ad;
{       int     tpdid;

tpdid = typeidOfAttrdef (ad);
return ((tpdid == DIDVOID) || (tpdid == DIDVOLI));
}

Def		tmpDef;
Environment	GlobEnv;
SEQDef		GlobDefs;
int		tcode = 2;
int		idtoken = 4;

DefTableKey DidToKey (did)
	int	did;
{	Def	d;
	char	*name;
	int	id;

d = lookup_def (did);
name = GetBaseName (dnameOfDef (d));
mkidn (name, strlen (name), &idtoken, &id);
return (KeyInEnv (GlobEnv,id));
}/*DidToKey*/

void MarkSymbReach (/*
	DefTableKey	k;
*/);

void MarkRhsReach (rhs)
	SEQEntity	rhs;
{	SEQEntity	es;
	Entity		ent;
	int		nextisgen = false;

foreachinSEQEntity (rhs, es, ent)
	switch (typeof (ent)) {
	case KSymbol:
		if (!nextisgen)
			MarkSymbReach (
			DidToKey (didOfSymbol (EntityToSymbol (ent))));
		nextisgen = false;
		break;
	case KLiteral:
		nextisgen = 
			(strlen (strOfLiteral (EntityToLiteral (ent))) == 0);
	default:;
	}
}/*MarkRhsReach*/

void MarkProdReach (lhsdid)
	int	lhsdid;
{	SEQDef		ds;
	DefTableKey	k;
	Def		d;

foreachinSEQDef (GlobDefs, ds, d)
	if (typeof (d) == KProd) {
		k = DidToKey (didOfDef (d));
		if ((lhsdid == lhsOfProd (DefToProd (d))) &&
		    !GetReached (k, false)) {
			SetReached (k, true, true);
			MarkRhsReach (rhsOfProd (DefToProd (d)));
		}
	}
}/*MarkProdReach*/

void MarkSymbReach (symkey)
	DefTableKey	symkey;
{
if (!GetReached (symkey, false)) {
	SetReached (symkey, true, true);
	MarkProdReach (GetDid (symkey, DIDNON));
}
}/*MarkSymbReach*/

char	*rhsname, *chainprodname;

bool ChkChainSymb (d)
	Def	d;
{	DefTableKey	lhskey, rhskey;

lhskey = DidToKey (didOfDef (d));
rhskey = GetChainSymb (lhskey, NoKey);
if (rhskey != NoKey) {
	tmpDef = lookup_def (GetDid (rhskey, DIDNON));
	rhsname = dnameOfDef (tmpDef);
	tmpDef = lookup_def (GetDid (GetChainProd (lhskey, NoKey), DIDNON));
	chainprodname = GetBaseName (dnameOfDef (tmpDef));
	return (true);
}
return (false);
}/*ChkChainSymb*/

PTGNode	termdefs, termcode, termstack, termcase, termgetdef, grammar,
	mkfctheader, mkfct;

void ProdConstr (pr)
	Prod		pr;
{	SEQEntity	rhs;
	Entity		ent;
	Symbol		sy;
	Symb		sydef;
	PTGNode		symsrhs, args, decr, parmnames, parmspecs, treeassigs;
	int		desccnt = 0, symbcnt = 0;
	int		nextisgen = false;
	int		ischainsymb;
	DefTableKey	k;
	char		*prodname;

prodname = GetBaseName (dnameOfProd (pr));
k = DidToKey (didOfProd (pr));

symsrhs = PTGNULL;
treeassigs = PTGNULL;
parmspecs = PTGNULL;
parmnames = PTGNULL;
args = PTGNULL;

if ((GetChainSymb (k, NoKey) == NoKey) &&
    GetReached (k, false)) {/* grammar part */

foreachinSEQEntity (rhsOfProd (pr), rhs, ent) {
	switch (typeof (ent)) {
	case KLiteral:
		if (strlen (strOfLiteral (EntityToLiteral (ent))) == 0)
			nextisgen = true;
		else {	nextisgen = false;
			symsrhs = PTGSeq (symsrhs,
			PTGGramLit (PTGP_Str (
				strOfLiteral (EntityToLiteral (ent)))));
		}
		break;
	case KSymbol:
		desccnt++;
		if (!nextisgen) symbcnt++;
		sy = EntityToSymbol (ent);
		tmpDef = lookup_def (didOfSymbol (sy));
		sydef = DefToSymb (tmpDef);
		ischainsymb = ChkChainSymb (tmpDef);
		
		if (nextisgen)
			args = PTGSeq (args, PTGComElem (
					PTGNullNodePtr ()));
		else {
			symsrhs = PTGSeq (symsrhs,
				PTGSep (PTGAsIs (
					ischainsymb?rhsname:
						dnameOfSymb (sydef))));

			if (ischainsymb)
				args = PTGSeq (args, PTGComElem (
					PTGChainMkProcCall (
					PTGMkProcName (PTGAsIs (chainprodname)),
					PTGStackArg (PTGNumb (symbcnt-1)),
					PTGComElem (
					PTGStackArg (PTGNumb (symbcnt-1))))));
			else	args = PTGSeq (args, PTGComElem (
					PTGStackArg (PTGNumb (symbcnt-1))));
		}
		nextisgen = false;
		break;
	default:;
	}
}/*foreach*/

if (symbcnt == 0)
	decr = PTGIncrStack ();
else if (symbcnt == 1)
	decr = PTGNULL;
else	decr = PTGDecrStack (PTGNumb (symbcnt-1));

tmpDef = lookup_def (lhsOfProd (pr));

grammar = PTGSeq (grammar,
	PTGProduction (
		PTGAsIs (dnameOfProd (pr)),
		PTGAsIs (dnameOfDef (tmpDef)),
		symsrhs,
		PTGProdAction (
			decr,
			PTGMkProcCall (
				PTGMkProcName (PTGAsIs (dnameOfProd (pr))),
				args))));
}/*grammar part*/

desccnt = 0;
foreachinSEQEntity (rhsOfProd (pr), rhs, ent)
	if (typeof (ent) == KSymbol) {
		desccnt++;
		sy = EntityToSymbol (ent);
		tmpDef = lookup_def (didOfSymbol (sy));
		sydef = DefToSymb (tmpDef);
		
		parmnames = PTGSeq (parmnames, PTGComElem (
				PTGMkParmName (PTGNumb (desccnt))));

		parmspecs = PTGSeq (parmspecs,
			PTGMkParmSpec (PTGMkParmName (PTGNumb (desccnt))));

		treeassigs = PTGSeq (treeassigs,
			PTGTreeAssign (
				PTGDescName (PTGNumb (desccnt)),
				PTGSymbPtrTypeName (
					PTGAsIs (dnameOfSymb (sydef))),
				PTGMkParmName (PTGNumb (desccnt))));
	}

mkfct = PTGSeq (mkfct,
	PTGSeq (
	PTGMkFctHead (
		PTGMkProcName (PTGAsIs (prodname)),
		parmnames,
		parmspecs,
		PTGProdPtrTypeName (PTGAsIs (prodname))),
	PTGMkFctBody (
		PTGProdPtrTypeName (PTGAsIs (prodname)),
		PTGProdStructName (PTGAsIs (prodname)),
		PTGVisitProcName (PTGNumb (1), PTGAsIs (prodname)),
		treeassigs)));

mkfctheader = PTGSeq (mkfctheader,
	PTGMkProcHeader (
		PTGMkProcName (PTGAsIs (prodname))));
}/*ProdConstr*/

void TermConstr (s)
	Symb	s;
{	SEQAttrdef	as;
	Attrdef		ad;
	PTGNode		getname, symbname, attrname, args, attrassigns,
			parmname, parmnames, parmspecs, code;
	int		parmcnt = 0;
	int		reached;
	DefTableKey	k;

k = DidToKey (didOfSymb (s));
reached = GetReached (k, false);
symbname = PTGAsIs (dnameOfSymb (s));
args = PTGNULL;
parmnames = PTGNULL;
parmspecs = PTGNULL;
attrassigns = PTGNULL;

foreachinSEQAttrdef (attrsOfSymb (s), as, ad)
if ((classOfAttrdef (ad) != ATCLINH) &&
    (! IsVoidAttr (ad)) &&
    (! IsGenAttr (ad))) {
	parmcnt++;
	attrname = PTGAsIs (nameOfAttrdef (ad));
	parmname = PTGMkParmName (PTGNumb (parmcnt));
	parmnames = PTGSeq (parmnames, PTGComElem (parmname));

	tmpDef = lookup_def(typeidOfAttrdef (ad));
	parmspecs = PTGSeq (parmspecs,
			PTGDecl (PTGAsIs (dnameOfDef (tmpDef)), parmname));
	attrassigns = PTGSeq (attrassigns,
			PTGTermAttrAssign (
				PTGTreeAttrName (attrname), parmname));

	if (reached) {
		getname = PTGTermGetName (symbname, attrname);
		termgetdef = PTGSeq (termgetdef, 
				PTGTermDefineGet (getname, getname));
		args = PTGSeq (args, PTGComElem (PTGTermArg (getname)));
	}
}

if (reached) {
	code = PTGNumb (tcode++);
	termdefs = PTGSeq (termdefs, PTGDefineCode (symbname, code));
	termcode = PTGSeq (termcode, PTGGramCode (symbname, code));
	termstack = PTGSeq (termstack, PTGGramStack (symbname));
	termcase = PTGSeq (termcase,
		PTGTermNodeCase (code, PTGMkProcName (symbname), args));
}

mkfct = PTGSeq (mkfct,
	PTGMkTermFct (
		PTGMkProcName (symbname), parmnames, parmspecs,
		PTGSymbPtrTypeName (symbname), PTGSymbPtrTypeName (symbname),
		PTGSymbStructName (symbname), attrassigns));
mkfctheader = PTGSeq (mkfctheader,
	PTGMkProcHeader (PTGMkProcName (symbname)));
}/*TermConstr*/


void TreeConstr (env, defs)
	Environment	env;
	SEQDef		defs;
{	SEQDef		ds;
	Def		d;
	PTGNode		startprod;
	DefTableKey	k;
	int		rootdid;
	Def		RootSymbDef;

if ((ErrorCount[ERROR]+ErrorCount[FATAL]+ErrorCount[DEADLY]) != 0) return; 

GlobEnv = env;
GlobDefs = defs;

(void) init_did_table (defs);

rootdid = GetRootDid (GramKey, DIDNON);

if (rootdid != DIDNON) {
	RootSymbDef = lookup_def (rootdid);

	MarkSymbReach (DidToKey (rootdid));
	startprod = PTGGramProdHead (PTGAsIs (dnameOfDef (RootSymbDef)));
} else	startprod = PTGNULL;

mkfct = PTGTreeConFileHead ();
mkfctheader = PTGTreeConHeaderHead ();

termcode = PTGGramCodeHead ();
termstack = PTGGramStackHead ();
termcase = PTGNULL;
termgetdef = PTGNULL;
termcase = PTGNULL;
grammar = PTGNULL;
termdefs = PTGNULL;

foreachinSEQDef (GlobDefs, ds, d)
	switch (typeof (d)) {
	case KSymb:
		k = DidToKey (didOfDef (d));
		if (GetSymClass (k, SYMBTERM) == SYMBTERM)
			TermConstr (DefToSymb (d));
		break;
	case KProd:
		ProdConstr (DefToProd (d));
	default:;
	}/*switch*/

mkfct = PTGSeq (mkfct, PTGSeq (termgetdef, (PTGLeafProc (termcase))));

PTGOutFile ("liga.coding",
	PTGFile (PTGSeq (termcode, PTGSeq (termstack, startprod))));
PTGOutFile ("liga.dec", PTGFile (grammar));
PTGOutFile ("termcode.h", PTGFile (termdefs));
PTGOutFile ("treecon.c", PTGFile (mkfct));
PTGOutFile ("treecon.h", 
	PTGFile (PTGSeq (mkfctheader, PTGTreeConHeaderTail ())));
}/*TreeConstr*/

