/* $Id: expand.c,v 2.4 1991/12/18 15:14:56 cogito Exp $ */
static char rcs_id[]= "$Id: expand.c,v 2.4 1991/12/18 15:14:56 cogito Exp $";

/***********************************************************************\
*									*
*		Implementation of LIGA expand pass			*
*									*
*	Module:		expand.c					*
*	File:		expand.c					*
*	Contents:	main function of expand pass			*
*	Author:		Hans Detlef Siewert				*
*	Creation date:	12 Dec 1990					*
*	Last change:	23 Aug 1991					*
*									*
\***********************************************************************/

#include <stdio.h>

#include "LIGA.h"

#include "err.h"

#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"

#include "expconst.h"
#include "exp_types.h"
#include "expref.h"
#include "expidl.h"
#include "exp_io.h"
#include "expclass.h"
#include "exptransfer.h"
#include "expincl.h"
#include "expchain.h"
#include "expconstit.h"
#include "expand.h"

/*
** GLOBAL VARIABLES
*/

char	*CONST_ATTR;
int	EXP_PROT;
int	EXP_INCL;
char	*INCL_ATTR;
int	IDENT_INCL;
char	*CHAIN_PRE_ATTR;
char	*CHAIN_POST_ATTR;

char	*NULL_FUNC;
char	*CREAT_FUNC;
char	*CONCAT_FUNC;

FILE	*InputFile;
FILE	*OutputFile;
FILE	*ProtocolFile;
FILE	*ExpOptFile;
FILE	*OptOutFile;

/*
** LOCAL VARIABLES
*/

char	*InputFName;
char	*OutputFName;
char	*ProtocolFName;
char	*ExpOptFName;
char	*OptOutFName;

/*
** LOCAL FUNCTIONS
*/

static
#ifdef __STDC__
void usage (char *progname)
#else
void usage (progname)
char *progname;
#endif
/* tell users how to start this program					*/
{
	(void) printf ("usage: %s [-i in][-o out][-p prot][-c ctl][-t optctl]\n",
		progname);
	exit (1);
} /* usage() */


/*
** GLOBAL FUNCTIONS
*/

#ifdef __STDC__
void deadly (char *msg)
#else
void deadly (msg)
char *msg;
#endif
/* print deadly error message and terminate program			*/
{
	curpos.line= 0;
	curpos.col= 0;
	message (DEADLY, msg, 0, &curpos);
} /* deadly() */

#ifdef __STDC__
void fatal (char *msg)
#else
void fatal (msg)
char *msg;
#endif
/* print fatal error message to stderr					*/
{
	curpos.line= 0;
	curpos.col= 0;
	message (FATAL, msg, 0, &curpos);
} /* fatal() */

#ifdef __STDC__
void print_err (int row, int col, char *str, int id)
#else
void print_err (row, col, str, id)
int row, col;
char *str;
int id;
#endif
/* print error message to stderr					*/
{
	curpos.line= row;
	curpos.col= col;
	message (ERROR, str, id, &curpos);
} /* print_err() */

#ifdef __STDC__
void print_warn (int row, int col, char *str, int id)
#else
void print_warn (row, col, str, id)
int row, col;
char *str;
int id;
#endif
/* print warning							*/
{
	curpos.line= row;
	curpos.col= col;
	message (WARNING, str, id, &curpos);
} /* print_warn() */

#ifdef __STDC__
void print_note (int row, int col, char *str)
#else
void print_note (row, col, str)
int row, col;
char *str;
#endif
/* print notes to stderr						*/
{
	curpos.line= row;
	curpos.col= col;
	message (NOTE, str, 0, &curpos);
} /* print_note() */

#ifdef __STDC__
int main (int argc, char *argv[])
#else
int main (argc, argv)
int argc;
char *argv[];
#endif
/* main program of expand module					*/
{
	char *progname;
	int tf;

	InputFName= "expin";
	OutputFName= "expout";
	ProtocolFName= "exproto";
	ExpOptFName= EXPFNAME;
	OptOutFName= OPTFNAME;

	progname= *argv;
	argv++;

	/* evaluate arguments */
	for ( ; argc>1; argc--, argv++)
	{
		if ((*argv)[0] == '-')
		{
		  switch ((*argv)[1])
		  {
			case 'i':
				argv++;
				argc--;
				InputFName= *argv;
				break;
			case 'o':
				argv++;
				argc--;
				OutputFName= *argv;
				break;
			case 'p':
				argv++;
				argc--;
				ProtocolFName= *argv;
				break;
			case 'c':
				argv++;
				argc--;
				ExpOptFName= *argv;
				break;
			case 't':
				argv++;
				argc--;
				OptOutFName= *argv;
				break;
			default:
				usage (progname);
				break;
		  } /* switch */
		}
		else
			usage (progname);
	} /* for */

	/* open input file */
	InputFile= fopen (InputFName, "r");
	if (!InputFile)
		deadly ("Can't read input file\n");

	/* open output file */
	OutputFile= fopen (OutputFName, "w");
	if (!OutputFile)
		deadly ("Can't create output file\n");

	/* open protocol file */
	ProtocolFile= fopen (ProtocolFName, "w");
	if (!ProtocolFile)
		deadly ("Can't create protocol file\n");

	/* open expand option file */
	ExpOptFile= fopen (ExpOptFName, "r");
	if (!ExpOptFile)
		deadly ("Can't read option file\n");

	/* open optim option file for writing */
	OptOutFile= fopen (OptOutFName, "w");
	if (!OptOutFile)
		deadly ("Can't write option file\n");

	/* print header for protocol */
	(void) fprintf (ProtocolFile, "\n-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n");
	(void) fprintf (ProtocolFile, "\tPROTOCOL OF THE LIGA PASS EXPAND\n");
	(void) fprintf (ProtocolFile, "-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n\n");

	/* read files for option handling */
	expand_opts= (OptCollect) malloc (sizeof (struct _optcollect));
	expand_opts->exp_opts= (ExpList) NULL;
	OptionInput (expand_opts, ExpOptFile);
	(void) fclose (ExpOptFile);

	optim_opts= (OptCollect) malloc (sizeof (struct _optcollect));
	optim_opts->exp_opts= (ExpList) NULL;
	optim_opts->ord_opts= (OrdList) NULL;
	optim_opts->opt_opts= (OptList) NULL;
	optim_opts->be_opts= (BEList) NULL;

	/* read input file */
	IdlStruct= ligain (InputFile);
	if (!IdlStruct)
		deadly ("IDL input file is empty\n");

	/* close input file */
	(void) fclose (InputFile);

	/* evaluate expand-options */
	eval_exp_opt();

	/* initialize reference table */
	init_reftab();

	/* search for the root symbol of this grammar */
	find_root();

	/* calculate classes from assignments */
	calc_classes();

	/* explode abbreviated transfer rules */
	tf= unabbrev_transfers();

	/* set classes of terminal attributes */
	set_term_classes();

	/* expand all TRANSFER rules if necessary */
	if (tf)
		tf= expand_transfers();
	if (tf)
	{
		(void) fprintf (ProtocolFile,
			"\n*** ERROR  %d transfer(s) could not be expanded\n\n",
			tf);
		print_err (0, 0, "TRANSFER(s) could not be expanded", TF_ERRID);
	} /* if */

	check_classes();

	find_includings();

	expand_includings();

	find_chains();

	expand_chains();

	find_constits();

	expand_constits();

	/* write output file */
	ligaout (OutputFile, IdlStruct);
	/* close output file */
	(void) fclose (OutputFile);

	/* write options for optim pass */
	OptionOut (optim_opts, OptOutFile);
	(void) fclose (OptOutFile);

	/* print trailer for protocol */
	(void) fprintf (ProtocolFile, "\n\n-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n");
	(void) fprintf (ProtocolFile, "\tEXPAND ");
	if (!ErrorCount[ERROR] && ! ErrorCount[WARNING])
	{
		(void) fprintf (ProtocolFile,
			"SUCCESSFULLY TERMINATED\n");
	} /* if */
	else
	{
	    (void) fprintf (ProtocolFile, "FAILED: ");
	    switch (ErrorCount[ERROR])
	    {
		case 0:
			(void) fprintf (ProtocolFile,
				"no errors, ");
			break;
		case 1:
			(void) fprintf (ProtocolFile, "one error, ");
			break;
		default:
			(void) fprintf (ProtocolFile,
				"%d errors, ", ErrorCount[ERROR]);
	    } /* switch */
	    switch (ErrorCount[WARNING])
	    {
		case 0:
			(void) fprintf (ProtocolFile,
				"no warnings\n");
			break;
		case 1:
			(void) fprintf (ProtocolFile, "one warning\n");
			break;
		default:
			(void) fprintf (ProtocolFile,
				"%d warnings\n", ErrorCount[WARNING]);
	    } /* switch */
	} /* else */
	(void) fprintf (ProtocolFile, "--------------------------------------");
	(void) fprintf (ProtocolFile, "----------------------------------------\n\n");
	/* close protocol file */
	(void) fclose (ProtocolFile);

	/* successful termination */
	return (ErrorCount[ERROR] || ErrorCount[WARNING]);
} /* main() */

/***********************\
* end of expand.c	*
\***********************/

								/* HaDeS */

