# $Id: Makefile.cpp,v 3.3 1992/05/13 09:44:54 cogito Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# hack for Sun auto-mounter
PWD	= pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR	= `expr \`$(PWD)\`'/' : '\(.*[^/]\)/[^/]*/[^/]*/[^/]*/'`

DISTRIB= /tmp
COFLAGS = -q

SKEL    = mess_sort
AUX	= liga.dg
CMD	= ligaEmb_h.cmd ligaFeOut.cmd ligaBackOut.cmd ligaBack.cmd\
	  ligaFe.cmd ligaExp.cmd ligaRepl.cmd \
 	  ligaOptim.cmd ligaOption.cmd ligaOrd.cmd gorto.cmd \
	  showFe.cmd showExp.cmd showOptim.cmd showOrd.cmd showRepl.cmd
RCS	= $(AUX) $(CMD) $(SKEL)

TIDY    = core a.out  *% lintmsg *.p *.o ERRS
CLEAN   = $(TIDY) *.exe
CLOBBER = $(CLEAN) Makefile

all:	$(AUX) $(CMD)
	@if test ! -d $(DESTDIR)/Cmd; \
		then umask 002; mkdir $(DESTDIR)/Cmd; \
		else :; \
		fi
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s `$(PWD)`/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/liga/Cmd; \
		rm -f $(DESTDIR)/Tool/liga/Cmd/$$f; \
		cp $$f $(DESTDIR)/Tool/liga/Cmd/$$f; \
		chmod 644 $(DESTDIR)/Tool/liga/Cmd/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/liga/Cmd/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SKEL); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/liga/Cmd; \
		rm -f $(DESTDIR)/Tool/liga/Cmd/$$f; \
		cp $$f $(DESTDIR)/Tool/liga/Cmd; \
		chmod 644 $(DESTDIR)/Tool/liga/Cmd/$$f; \
	done

executable:
	rm -rf $(TIDY) $(AUX) idl option frontend expand order optim \
		backend replincl Makefile.cpp Makefile

SourceDistr: $(SKEL) $(AUX) $(CMD)

distrib:	$(SKEL) $(AUX) $(CMD)
	- rm -rf $(DISTRIB)/Cmd
	mkdir $(DISTRIB)/Cmd
	cp $(SKEL) $(AUX) $(CMD) Makefile.cpp $(DISTRIB)/Cmd
	cd $(DISTRIB)/Cmd; chmod 0644 $(SKEL) $(AUX) $(CMD) Makefile.cpp

checkout:
	co $(COFLAGS) $(RCS)

# Cleaning targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -f $(CLEAN) Makefile Makefile.cpp
	-rcsclean $(COFLAGS) $(RCS)

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

.PRECIOUS:	$(RCS)

