static char RCSid[] = "$Id: can.c,v 1.1 1992/07/31 14:54:17 waite Exp $";
/* Copyright 1992, The Regents of the University of Colorado */
/* Canned description module */

#include <string.h>
#include "can.h"

CannedDescr lib[] = {
/*  later, read this data from a file - I don't feel like parsing it now! */
{ "C_IDENTIFIER",	"[a-zA-Z_][a-zA-Z_0-9]*",
					NULL, "mkidn" },
{ "C_INTEGER",		"([0-9]+|0[xX][0-9a-fA-F]*)[lLuU]?",
					NULL, "c_mkint"},
{ "C_FLOAT",
"(((([0-9]+\\.[0-9]*)|(\\.[0-9]+))((e|E)(\\+|\\-)?[0-9]+)?)|([0-9]+(e|E)(\\+|\\-)?[0-9]+))[fFlL]?",
					NULL, "mkstr"},
{ "C_STRING_LIT",	"\\\"",
					"auxCString", "c_mkstr"},
{ "C_CHAR_CONSTANT",	"'",
					"auxCChar", "c_mkchar"},
{ "C_COMMENT",		"\"/*\"",
					"auxCComment", NULL },
{ "MODULA2_COMMENT", 	"\"(*\"",
	                                "auxM3Comment", NULL },
{ "MODULA3_COMMENT", 	"\"(*\"",
	                                "auxM3Comment", NULL },
{ "MODULA2_CHARINT",	"[0-9][0-9A-Fa-f]*C",
	                                NULL, "modula_mkint" },
{ "MODULA2_INTEGER",	"[0-9][0-9A-Fa-f]*[BH]?",
	                                NULL, "modula_mkint" },
{ "MODULA2_LITERALDQ",  "\\\"",
                                        "auxM2StringDQ", "mkstr" },
{ "MODULA2_LITERALSQ",	"'",
                                        "auxM2StringSQ", "mkstr" },
{ "PASCAL_COMMENT",	"\"{\"|\"(*\"",
					"auxPascalComment", NULL },
{ "PASCAL_IDENTIFIER",	"[a-zA-Z][a-zA-Z0-9]*",
					NULL, "mkidn" },
{ "PASCAL_REAL",
"(([0-9]+\\.[0-9]+)((e|E)(\\+|\\-)?[0-9]+)?)|([0-9]+(e|E)(\\+|\\-)?[0-9]+)",
					NULL, "mkstr"},
{ "PASCAL_INTEGER",	"[0-9]+",
					NULL, "mkint"},
{ "PASCAL_STRING",	"'",
					"auxPascalString", "mkstr"},
{ "MODULA_INTEGER",	"[0-9][0-9A-Fa-f]*[BCH]?",
					NULL, "modula_mkint"},
{ "ADA_COMMENT",	"--",
					"auxEOL", NULL },
{ "ADA_IDENTIFIER",	"[a-zA-Z](_?[a-zA-Z0-9])*",
					NULL, "mkidn" },
{ "AWK_COMMENT",	"#",
					"auxEOL", NULL },
};


/***/
int
libLookup(s)
char *s;
/* Obtain an index to a canned description
 *    On entry-
 *       s names the canned description desired
 *    If s names a valid canned description then on exit-
 *       libLookup is nonnegative
 *       lib[libLookup] is the canned description
 *    Otherwise on exit-
 *       libLookup=-1
 ***/
{
	int i;

	for(i = 0; i < (sizeof lib)/(sizeof lib[0]); i++) 
		if (!strcmp(s, lib[i].Lname)) break;

	return (i < (sizeof lib)/(sizeof lib[0]) ? i : -1);
}
