static char RCSid[] = "$Id: gla_fe.c,v 1.3 1992/07/31 14:57:34 waite Exp $";
/* Copyright (c) 1989, The Regents of the University of Colorado */

#include <string.h>
#include "dj.h"
#include "err.h"
#include "csm.h"

#define ERR(msg)	fprintf (stderr, "%s", msg);

int ParseErr = 0;

extern int EofCode;

/* Needed for part.c but not actually used in fe */ 
/* Should take these out of dj.h and put into part.c */
int FlexStateFd;
int Nstates;
int *AcceptStates;
char *Targets;

/*
 * main
 */

void
main(argc,argv)
int argc; char **argv;
{
	int f, i;
	int verbose = 0;
	int pflag = 0;
	char *progname, *infile = NULL;
	FILE *FlexFd;
	
	progname = argv[0];
	while (argc > 1) {
		if (argv[1][0] == '+' || argv[1][0] == '-')
			switch (argv[1][1]) {
			case 'e': sscanf(&argv[1][2],"%d", &EofCode); break;
			case 'p': pflag++; break;
			case 'v': verbose++; break;
			default: 
				fprintf(stderr, "%s: unknown option '%c'\n", 
					progname, argv[1][1]);
			}
		else
			infile = argv[1];	/* input file */
		argc--;
		argv++;
	}

	if (infile == NULL) {
		fprintf(stderr, "Usage %s [options] file\n", progname);
		ERR("  -e EofCode: end of file code.\n");
		ERR("  -p just parse the input, do not generate output.\n");
		ERR("  -v give verbose statistics.\n");
		exit(1);
	}

	if ((f = open(infile, 0)) == -1) {
		fprintf(stderr, "Cannot open file %s\n", infile);
		exit(1);
	}

	/* Initialize assuming all are no return codes */
	for (i = 0; i < MAXLITS+MAXNONLITS; i++)
		YextCode[i] = NORETURN;

	initBuf(infile,f);	/* Initialize the source module */
	if (yyparse())
		exit(1);
	if (ParseErr)
		exit(1);
	if (NonLitCount >= MAXNONLITS || LitCount >= MAXLITS) {
		fprintf(stderr, "More than %d Lits or %d non-literals\n",
			MAXLITS, MAXNONLITS);
		exit(4);
	}
	if (pflag)	/* just parse input */
		exit(0);

	FlexFd = fopen("xflex.l", "w");
	if (FlexFd == NULL) {
		fprintf(stderr, "cannot open xflex.l files\n");
		exit(3);
	}
	writeFiles(FlexFd);
	fclose(FlexFd);

	writeBackendData();

	if (verbose) {
		printf("NTokens=%d NonLitCount=%d LitCount=%d EofCode=%d\n",
		       NTokens,   NonLitCount,   LitCount,   EofCode);
	}

	if (ErrorCount[NOTE] || ErrorCount[COMMENT] || ErrorCount[WARNING] ||
	   ErrorCount[ERROR] || ErrorCount[FATAL] || ErrorCount[DEADLY])
		lisedit(infile, stdout, 0, 0);
	exit(0);
}

/*
 * writeFiles
 */

void
writeFiles(fd)
FILE *fd;
{
	int i;

	/*
	** Output the specification for FLEX.
	** This is a bit contorted because we need to output literals
	** first for flex so they are recognized before non-literal patterns.
	**/

	fputs("%%\n\n", fd);
	/* First do Literals */
	for(i = 1; i <= LitCount; i++) {
		fprintf(fd, "\"%s\"		%d; /* ext=%d sourceLine=%d */\n",
			Ypattern[i],i, YextCode[i], YinLine[i]);
	}
	fputs("\n\n", fd);

	/* now do non-literals */
	for(i = 1; i <= NonLitCount; i++) {
		fprintf(fd, "%s		%d; /* ext=%d sourceLine=%d */\n",
			Ypattern[i+LitCount], i+LitCount,YextCode[i+LitCount],
			YinLine [i+LitCount]);
	}

	fclose(fd);
}

/*
 * writeBackendData
 */

#define STR(x) ((x) == NULL ? "(null)" : (x))

writeBackendData ()
{
	FILE *be_file;
	int i;

	be_file = fopen("backend.data", "w");
	if (be_file == NULL) {
		fprintf (stderr, "cannot open backend_data for output\n");
		exit (1);
	}

	fprintf (be_file, "%d %d %d\n", EofCode, LitCount, NonLitCount);
	for (i = 1; i <= NTokens; i++)
		fprintf (be_file, "%s\n%s\n%s\n%d\n",
			 STR(Ypattern[i]), STR(YauxScanner[i]),
			 STR(Yprocessor[i]), YextCode[i]);

	fclose (be_file);
}

/*
 * yyerror
 */

void
yyerror(s)
char *s;
{	message(DEADLY,s,0,&curpos);
	ParseErr = 1;
}

