# $Id: Makefile.cpp,v 1.34 1992/07/31 14:57:34 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

G = gla.par		# File containing the YACC grammar
T = gla.gla		# File containing the token definitions

DESTDIR	= /tmp

BOOTSTRAP	= parser.y xtables.h xcode.h
MISC	= glahead.c
HDRS	= dj.h err.h csm.h source.h csmtbl.h xtables.h xcode.h int.h \
	str.h idn.h idntbl.h gla.h can.h
SRCS	= gla_fe.c err.c csm.c source.c print.c glahead.c int.c \
	str.c idn.c part.c djset.c misc.c pascalCom.c can.c
OBJS    = gla_fe.o y.tab.o err.o csm.o source.o print.o glahead.o int.o \
	str.o idn.o part.o djset.o misc.o pascalCom.o can.o

RCS	= $(SRCS) $(HDRS) $(MISC) $(BOOTSTRAP) $G $T
TIDY	= $(OBJS) y.tab.[ch]
CLEAN	= $(TIDY) gla_fe ../glahead.c ../gla_fe *~
CLOBBER	= $(CLEAN) Makefile

all:	gla_fe

gla_fe:	$(OBJS) $(MISC)
	$(CC) -o $@ $(CFLAGS) $(OBJS)
	-rm -f ../gla_fe ../glahead.c
	-ln gla_fe ..
	-ln glahead.c ..

$(OBJS): $(HDRS)

install:
	@for f in $(MISC); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/gla; \
		rm -f $(DESTDIR)/Tool/gla/$$f; \
		cp $$f $(DESTDIR)/Tool/gla/$$f; \
		chmod 644 $(DESTDIR)/Tool/gla/$$f; \
		done
	rm -f $(DESTDIR)/Tool/gla/gla_fe
	cp gla_fe $(DESTDIR)/Tool/gla
	chmod 755 $(DESTDIR)/Tool/gla/gla_fe

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRCS) $(HDRS) $(BOOTSTRAP) $G $T

SourceDistr:	$(RCS)

lint: $(SRCS) $(MISC) $(HDRS) y.tab.c
	lint -a -b -c -h -I. -I../.. $(SRCS) y.tab.c 2>&1 | grep -v RCS

l:	glahead.o glaDriver.o
	$(CC) $(CFLAGS) -o $@ glaDriver.o glahead.o

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

rcsclean:
	-rcsclean -q $(RCS) Makefile.cpp
	rm -f $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

symbols:	$G
	sed -f ../misc/yacc.sed $G | sort | uniq > symbols

newCodes:	symbols $T
	../misc/makecodes $T symbols
	rm -f term.h comment.h lextbl.h delim.h  #don't need this stuff.

y.tab.c y.tab.h:	parser.y
	yacc -d parser.y

y.tab.o: y.tab.c
	$(CC) -c $(CFLAGS)  y.tab.c

# parser.y:	newCodes $G
# 	../misc/mkyacc.sh newCodes $G
# xcode.h: gla.gla
# 	$(GLA) gla.gla
