static char RCSid[] = "$Id: djset.c,v 1.4 1989/10/20 20:24:11 bob Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */
/* see Ch 2 of D.S. and Network algorithms R.E. Tarjan */

#include "dj.h"

struct el DjSets[SETSIZE];
short Next[SETSIZE];	/* to chain together elements in a set */
int NDistinctSets = 0;

void
makeDJsets()	/* make SETSIZE singleton sets */
{
int x;

	NDistinctSets = SETSIZE;

	for(x=0; x<SETSIZE; x++) {
		Next[x] = x;
		DjSets[x].parent = x;
		DjSets[x].rank = 0;
		DjSets[x].size = 1;
		}
}


int
findWhichSet(x)   /* pathcompression as a side effect */
/*findWhichSet(DjSets,x)
struct el DjSets[];*/
int x;
	{
	if( x != DjSets[x].parent)
	  DjSets[x].parent = findWhichSet(DjSets[x].parent);
	return (DjSets[x].parent);
	}

int
linkSets(x,y)
/*linkSets(DjSets,x,y)
struct el DjSets[];*/
int x,y;
	{
	int t;
	int i;
	if(DjSets[x].rank > DjSets[y].rank)
		{ t=x; x=y; y=t; }	/* swap so x is not larger */
	else if(DjSets[x].rank = DjSets[y].rank)
		DjSets[y].rank++;		/* log of num elements */

	/* update next array.
	** Walk down chain of smaller set to its end and set link to
	** the Next of larger set.
	** Store Next head of smaller set.
	*/
	i = Next[x];
	while(i != Next[i])
		i = Next[i];
	Next[i] = Next[y];	/* link chains together */
	Next[y] = x;

	--NDistinctSets;
	DjSets[y].size += DjSets[x].size;
	return(DjSets[x].parent = y);
	}


void
pntDJset(fp)
FILE *fp;
{
int c;
for(c=0; c<SETSIZE; c++) {
	GPNT(fp,c, "", "");
	fprintf(fp,"  Next[c]=%d parent=%d size=%d\n",
			Next[c], DjSets[c].parent, DjSets[c].size);
	}
}

#ifdef TEST
main()
{
makeDJsets();
linkSets(2,4);
pntDJset(stdout);
}
#endif
