/*
 *  M2int.c
 *
 *  processor for Modula-2 integers
 */


#include <stdio.h>
#include <ctype.h>

# define strtoul(a,b,c) strtol(a,b,c)

/***/
#if defined(__cplusplus) || defined(__STRICT_ANSI__)
void
modula_mkint(char *c, int l, int *t, char *p)
#else
void
modula_mkint(c, l, t, p)
char *c; int l, *t; char *p;
#endif
{
	char base, save;
	int  save_pos;
	unsigned long val;

	base = c[l-1]; 
	if (isdigit(base)) 
	  {
	    save_pos = l;
	    base = '0';
	  }
	else 
	  {
	    save_pos = l-1;
	  }
	save = c[save_pos];
	c[save_pos] = '\0';
	switch (base) 
	  {
	  case 'B' :
	  case 'C' :
	    val = strtoul(c, NULL, 8);
	    break;
	  case 'H' :
	    val = strtoul(c, NULL, 16);
	    break;
	  default  : 
	    val = strtoul(c, NULL, 10);
	    break;
	  }
	*(int *)p = val;
	c[save_pos] = save;
}
