/* $Id: gen_ins.c,v 1.1 1992/05/19 22:14:19 kadhim Exp $ */
/* Copyright, 1991, AG-Kastens, University Of Paderborn */

#include <string.h>
#include <stdio.h>

#include "gen_ins.h"
#include "err.h"        /* definition of message(), ... */
#include "csm.h"       /* definition of string[] */

/**************************************************************************/

char    *ERRTXT[5] =
{
    "Nonterminal expected: symbol is also used as terminal or meta symbol.",
    "Terminal expected: symbol is also used as nonterminal or meta symbol.",
    "Meta symbol expected: symbol is also used as nonterminal or terminal.",
    "It can't be allocated new storage!",
    "Write Error: output file can't be open!"
};

#define ERR0    0
#define ERR1    1
#define ERR2    2
#define ERR3    3
#define ERR4    4

POSITION        NULLPOS = {0,0};

tab_type	TAB;
static	int		MAX = 1;


#ifndef FALSE
#define FALSE ((Boolean)0)
#endif
#ifndef TRUE
#define TRUE  ((Boolean)1)
#endif

/*---------------------------------------------------*/
/* CATEGORIE 1: functions used to compute CHAIN symb */
/*---------------------------------------------------*/

typedef struct tlist
{
  int		id;
  int		ind;
  struct tlist	*next;
}	*tlist;

int	ins_symbol(id, mode)
int	id;
int	mode;
{
  tlist	new, travel;
static	tlist	LIST = (tlist)NULL;

  if ( mode == Kp_string )
	return(0);
  else /* Kp_name */
    {
	for (travel=LIST; travel!=(tlist)NULL; travel=travel->next)
		if (travel->id == id)	return(travel->ind);
	/* id not found in LIST */
	if ( (new = (tlist)malloc(sizeof(*new))) == (tlist)NULL )
	{
		message(FATAL, ERRTXT[ERR3], 0 , &NULLPOS);
		exit(1);
	}
        new->id = id;
	new->ind = MAX++;
	new->next = LIST;
	LIST = new;

	return( new->ind );
    }
}

/*------------------------------------------------------*/
/* CATEGORIE 2: functions used to compute CHAIN unknown */
/*------------------------------------------------------*/

void	init_internal_sid_tab()
{
  int 	i;

  if ( (TAB = (tab_type)malloc((MAX+1) * sizeof(*TAB))) == (tab_type)NULL )
    {
	message(FATAL, ERRTXT[ERR3], 0 , &NULLPOS);
	exit(1);
    }

  for (i=0; i<=MAX; i++)
    {
	TAB[i].tag = UNDEF;
	TAB[i].isprt = FALSE;
    }

  return;
}

/* Try to insert symb as terminal */
void	ins_term(symb, pos)
int	symb;
POSITION	pos;
{
  if (symb != 0 )
    switch ( TAB[symb].tag )
    {
	/* already used: now symbol can be classified as terminal */
	case UNKNOWN	:
	/* not defined => can be inserted as terminal */
	case UNDEF	: TAB[symb].tag = TERM;

	/* already defined as terminal => nothing to do */
	case TERM	: break;

	/* NON or META */
	default		: message(ERROR, ERRTXT[ERR1], 0 , &pos);
			  break;

     }  /* of switch */

  return;
}


void	ins_nonterm(symb, pos)
int	symb;
POSITION	pos;
{
  switch ( TAB[symb].tag )
    {
	/* already used: now symbol can be classified as nonterminal */
	case UNKNOWN	:
	/* not defined => can be inserted as nonterminal */
	case UNDEF	: TAB[symb].tag = NON;

	/* already defined as nonterminal => nothing to do */
	case NON	: break;

	/* TERM or META */
	default		: message(ERROR, ERRTXT[ERR0], 0 , &pos);
			  break;

    }  /* of switch */

  return;
}


void	ins_unknown(symb)
int	symb;
{

  switch ( TAB[symb].tag )
    {
	/* not defined => must be inserted as not classified symbol */
	case UNDEF	: TAB[symb].tag = UNKNOWN;
			  break;
	/* UNKNOWN, TERM, NON or META */
	default		: break;

    }  /* of switch */

  return;
}


void	ins_termlist()
{
  int 	i;

  for (i=0; i<=MAX; i++)
    if ( TAB[i].tag == UNKNOWN )
	ins_term(i, NULLPOS);
  return;
}

