static char RCSid[] = "$Id: texhead.c,v 1.2 1992/07/26 17:59:28 tony Exp $";
/*##############################################################################

FUNNNELWEB COPYRIGHT
====================
FunnelWeb is a literate-programming macro preprocessor.

Copyright (C) 1992 Ross N. Williams.

   Ross N. Williams
   ross@spam.adelaide.edu.au
   16 Lerwick Avenue, Hazelwood Park 5066, Australia.

This program is free software; you can redistribute it and/or modify
it under the terms of Version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See Version 2 of the GNU General Public License for more details.

You should have received a copy of Version 2 of the GNU General Public
License along with this program. If not, you can FTP the license from
prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Section 2a of the license requires that all changes to this file be
recorded prominently in this file. Please record all changes here.

Programmers:
   RNW  Ross N. Williams  ross@spam.adelaide.edu.au

Changes:
   07-May-1992  RNW  Program prepared for release under GNU GPL V2.

##############################################################################*/


/******************************************************************************/
/*                                  TEXHEAD.C                                 */
/******************************************************************************/
/*                                                                            */
/* TEX HEADER PACKAGE                                                         */
/* ==================                                                         */
/* This package contains a single function that writes the TeX header         */
/* (containing all the Weave macros) to the specified stream. The package     */
/* consists of:                                                               */
/*                                                                            */
/* texhead.tex - The header file ("source code" for texhead.ctx).             */
/* texhead.ctx - Automatically generated C code based on texhead.tex.         */
/* texhead.h   - Exported header file containing function definition.         */
/* texhead.c   - Contains the function body and the codified header file.     */
/*                                                                            */
/* WARNING: THE ONLY FILE THAT SHOULD EVER BE MODIFIED BY HAND IS TEXHEAD.TEX.*/
/* From this can be generated a new version of texhead.ctx. Here's how:       */
/* 1. Edit texhead.tex as desired.                                            */
/* 2. Fire up the FunnelWeb shell and give the command:                       */
/*    codify texhead.tex texhead.ctx                                          */
/*                                                                            */
/******************************************************************************/

#include "style.h"

#include "texhead.h"
#include "writfile.h"

/******************************************************************************/

EXPORT void tex_head(p_wf)
p_wf_t p_wf;
/* Writes the FunnelWeb TeX header block to the argument stream. */
{

 /*#############################################################################
 IMPORTANT COPYRIGHT NOTICE
 --------------------------
 The set of FunnelWeb TeX definitions, embodied in C code in the file
 included by the #include directive below, is a public domain work.

 Notwithstanding the fact that the public domain set of FunnelWeb TeX
 definitions is represented in the form of strings in C code #included by the
 FunnelWeb literate-programming preprocessor program released under GNU General
 Public License Version 2, the set of TeX definitions themselves do not fall
 under GNU license. Instead, the set of FunnelWeb TeX definitions is classified
 as a public domain work that is distributed with FunnelWeb as a "separate
 work". The set of definitions is included as strings in the FunnelWeb code for
 the sole reason that this organization avoids FunnelWeb having to locate the
 file at run time. Thus, when FunnelWeb writes the set of TeX definitions to a
 .TeX output file, it is not generating a work based on itself, but is merely
 copying a public domain file (which it happened to represent in the form of
 code rather than data) into the output file.

 The motivation for rigorously clarifying the status of the set of
 FunnelWeb TeX definitions is that it will appear in TeX output files
 generated by FunnelWeb, and I do not want any output files generated by
 FunnelWeb to be under any copyright restrictions.
 
 -- Ross N. Williams, 5:42pm 07-May-1992, Adelaide, Australia.
 
 #############################################################################*/

#define WX(STR) wf_wl(p_wf,STR)

#include "texhead.ctx"
}

/******************************************************************************/
/*                             End of TEXHEAD.C                               */
/******************************************************************************/
