#!/bin/sh
# $Id: fwWeave.cmd,v 1.2 1993/01/05 21:00:51 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

#fwWeave <
#  fwTex 'TeX representation of a FunnelWeb specification'*
#  fwTexinfo 'Texinfo representation of a FunnelWeb specification'*
#  > 'Generate documentation from a FunnelWeb specification'* :
#	USER
#		: fw_srcs
#		: (:fw_srcs :labels)

umask 0
cd (|<<fw_srcs|)
for f in `ls`
do
	(|$/Tool/fw/eliexpand|) $f > $f.new
	mv $f.new $f
done
source=`ls *.fw`

cd (|<RUNDIR|)
ln -s (|<<fw_srcs|)/$source i$$.fw
(|$/Tool/fw/fw|) -I(|<<fw_srcs|)/ +T -O +Q +U i$$.fw \
	1>/dev/null 2>&1
if test $? -ne 0
then
 	sed -n 's;^"'i$$.fw'";"(|<<fw_srcs|)/'$source'";
		s;^"(|<<fw_srcs|)/\([^"]*\)", line \([0-9]*\):\([0-9]*\);\1 \2 \3;
		/WARNING/{
			s/WARNING: //
			w (|<RUNDIR|)/WARNING
			d
		}
		/ERROR/{
			s/ERROR: //
			w (|<RUNDIR|)/ERROR
			d
		}
		/DEADLY/{
			s/DEADLY: //
			w (|<RUNDIR|)/ERROR
			d
		}' i$$.lis
fi

if test -f i$$.tnf
then mv i$$.tnf (|>fwTexinfo|); cp /dev/null (|>fwTex|)
elif test -f i$$.tex
then cp /dev/null (|>fwTexinfo|); mv i$$.tex (|>fwTex|)
else cp /dev/null (|>fwTexinfo|); cp /dev/null (|>fwTex|)
fi

if test -s ERROR
then (|$/Tool/skeleton/err_map.exe|) (|<(:fw_srcs :labels)|) (|<fw_srcs|) ERROR >>(|>ERROR|)
fi

if test -s WARNING
then (|$/Tool/skeleton/err_map.exe|) (|<(:fw_srcs :labels)|) (|<fw_srcs|) WARNING >>(|>WARNING|)
fi

exit 0
