# $Id: Makefile.cpp,v 1.5 1993/01/07 18:57:22 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/fw

COFLAGS	= -q

SRC	= analyse.c as.c clock.c command.c data.c dump.c help.c help_gnu.c \
	list.c lister.c machin.c main.c mapper.c memory.c misc.c option.c \
        parser.c scanner.c section.c table.c tangle.c texhead.c weave.c \
        writfile.c analyse.h as.h clock.h command.h data.h dump.h environ.h \
	help.h help_gnu.h list.h lister.h machin.h mapper.h memory.h misc.h \
	option.h parser.h scanner.h section.h style.h table.h tangle.h \
	texhead.h weave.h writfile.h help_gnu.ctx texhead.ctx \
	weaveinfo.h weaveinfo.c assign_errors.c fw_incl.c eliexpand.c
OBJ	= analyse.o as.o clock.o command.o data.o dump.o help.o help_gnu.o \
	list.o lister.o machin.o main.o mapper.o memory.o misc.o option.o \
        parser.o scanner.o section.o table.o tangle.o texhead.o weave.o \
        writfile.o weaveinfo.o
EXE	= fw assign_errors fw_incl.exe eliexpand
CMD	= fwErr.cmd fwOut.cmd fwTangle.cmd fwWeave.cmd fwincl.dir.cmd
AUX	= fw.dg fw.tnf
RCS 	= $(SRC) $(CMD) $(AUX)

TIDY	= core a.out ERRS *.o
CLEAN	= $(TIDY) $(EXE)

all:	$(EXE) $(CMD) $(AUX)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile.cpp $(AUX) $(SRC) Makefile

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

fw:	$(OBJ)
	$(CC) $(CFLAGS) -o fw $(OBJ)

.PRECIOUS:	assign_errors.c eliexpand.c

eliexpand: eliexpand.o
	$(CC) $(CFLAGS) -o eliexpand eliexpand.o

assign_errors: assign_errors.o
	$(CC) $(CFLAGS) -o assign_errors assign_errors.o

analyse.o : analyse.c style.h environ.h analyse.h as.h data.h clock.h list.h \
	table.h option.h machin.h help.h section.h writfile.h lister.h misc.h
as.o : as.c style.h environ.h as.h machin.h
clock.o : clock.c style.h environ.h as.h clock.h machin.h 
command.o : command.c style.h environ.h analyse.h as.h command.h machin.h \
	data.h clock.h list.h table.h option.h help.h section.h writfile.h \
	dump.h lister.h memory.h mapper.h misc.h parser.h scanner.h tangle.h \
	weave.h weaveinfo.h
data.o : data.c data.h style.h environ.h clock.h list.h table.h option.h \
	machin.h help.h section.h writfile.h
dump.o : dump.c style.h environ.h as.h clock.h data.h list.h table.h \
	option.h machin.h help.h section.h writfile.h dump.h misc.h
help.o : help.c style.h environ.h as.h help.h help_gnu.h misc.h data.h \
	clock.h list.h table.h option.h machin.h section.h writfile.h 
help_gnu.o : help_gnu.c style.h environ.h help_gnu.h help_gnu.ctx 
list.o : list.c style.h environ.h as.h machin.h memory.h list.h 
lister.o : lister.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h lister.h misc.h 
machin.o : machin.c style.h environ.h as.h machin.h 
main.o : main.c style.h environ.h as.h command.h machin.h data.h clock.h \
	list.h table.h option.h help.h section.h writfile.h memory.h 
mapper.o : mapper.c style.h environ.h as.h machin.h mapper.h memory.h 
memory.o : memory.c style.h environ.h as.h machin.h memory.h 
misc.o : misc.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h memory.h misc.h 
option.o : option.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h misc.h 
parser.o : parser.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h lister.h mapper.h \
	memory.h misc.h parser.h
scanner.o : scanner.c style.h environ.h as.h clock.h data.h list.h table.h \
	option.h machin.h help.h section.h writfile.h dump.h lister.h \
	mapper.h memory.h misc.h scanner.h 
section.o : section.c style.h environ.h as.h section.h 
table.o : table.c style.h environ.h as.h machin.h memory.h table.h 
tangle.o : tangle.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h lister.h memory.h \
	misc.h tangle.h 
texhead.o : texhead.c style.h environ.h texhead.h writfile.h texhead.ctx 
weave.o : weave.c style.h environ.h as.h data.h clock.h list.h table.h \
	option.h machin.h help.h section.h writfile.h lister.h misc.h \
	texhead.h weave.h 
weaveinfo.o : weaveinfo.c style.h environ.h as.h data.h clock.h list.h \
	table.h option.h machin.h help.h section.h writfile.h lister.h misc.h \
	texhead.h weaveinfo.h 
writfile.o : writfile.c style.h environ.h as.h machin.h writfile.h 

fw_incl.exe:	fw_incl.c
	$(CC) $(CFLAGS) -o $@ fw_incl.c
