static char RCSid[] = "$Id: fpt.c,v 1.6 1992/04/12 02:28:22 waite Exp $";
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <stdio.h>
#include "fpt.h"
#include "csm.h"

#ifndef NOPRINT
/***/
#if defined(__cplusplus) || defined(__STDC__)
void
prtfptv( FILE *d, char *p)
#else
void
prtfptv(d,p)
FILE *d; char *p;
#endif
/* Print an internal floating point number
 *    On exit-
 *       Internal floating point number p has been added
 *          to the current line of d
 ***/
{
	fprintf(d, " %s", string[*((int *)p)]);
}
#endif

/***/
#if defined(__cplusplus) || defined(__STDC__)
void
mkfpt(char *ip, int il, char *fp, int fl, char *ep, int el, int eneg, char *p)
#else
void
mkfpt(ip, il, fp, fl, ep, el, eneg, p)
char *ip; int il; char *fp; int fl; char *ep; int el, eneg; char *p;
#endif
/* Make an internal floating point value from strings of digits
 *    On entry-
 *       ip points to a digit string of length il for the integer part
 *       fp points to a digit string of length fl for the fractional part
 *       ep points to a digit string of length el for the exponent
 *       eneg = 1 if the exponent is negative
 *              0 if the exponent is zero or positive
 *    On exit-
 *       An internal floating point value representing the digit strings
 *          has been stored at the location pointed to by p
 ***/
{
/* This routine produces a standard floating point representation
   by the algorithm given on p144 of the first edition of "Compiler
   Construction" by Waite and Goos (Springer-Verlag, New York, 1984)
*/
	register char *lim;
	char text[BUFSIZ], significand[BUFSIZ], *beg, *pnt;
	int exponent;

	if (el) {
		lim = text;
		if (eneg) *lim++ = '-';
		while (el--) *lim++ = *ep++; *lim = 0;
		exponent = atoi(text);
	} else exponent = 0;

	beg = lim = significand;
	while (il--) *lim++ = *ip++; pnt = lim;
	while (fl--) *lim++ = *fp++;

	do lim--; while (*lim == '0' && beg < lim);
	while (*beg == '0' && beg < lim) beg++;
	lim[1] = '\0';

	(void)sprintf(text, ".%sE%d", beg,
		*beg != '0' ? exponent + (pnt - beg) : 0);
	*((int *)p) = stostr(text, strlen(text));
}
