#!/bin/sh
# $Id: cpp_specs.cmd.cpp,v 1.14 1993/01/05 21:45:28 kadhim Exp $
# Copyright, 1989, The Regents of the University of Colorado

#cpp_specs <
#  nonlib(.none) "Complete set of files making up a specification"
#  lib.dir(.none) "Directly included libraries"*
#  > "Specification file after pre-processing"* :
#	USER
#		: specs
#		: (:specs :incl.all)

# This script runs in the user's directory.  Cpp should also search the Tool
# directory of the cache.  The result of cpp has to be cleaned up by:
#	1) Removing all white space
#	2) Prefixing the name of each specification file by the name of the
#		directory containing the file introducing it
#	3) Removing all remaining cpp information

CPP -I(|$/Tool|) (|<specs|) > (|<RUNDIR|)/cpp_specs 2> (|>ERROR|)

cat (|<RUNDIR|)/cpp_specs \
	| (|$/Tool/cpp_specs.exe|) (|$|) \
	> (|<RUNDIR|)/names

# The files making up the specification have names NOT ending in ".lib"

grep -v '\.lib$' (|<RUNDIR|)/names > (|>nonlib|)
echo (|<specs|) >> (|>nonlib|)
cat (|<(:specs :incl.all)|) >> (|>nonlib|)

# Extract the library specifications, throw away any path name associated
# with them, and construct the name of the corresponding specification
# file.

cp /dev/null (|>lib.dir|)
for f in `grep '\.lib$' (|<RUNDIR|)/names`
do
	name=`basename $f .lib`
	echo '(|$/Tool|)/'$name/$name'.specs' >> (|>lib.dir|)
done

exit 0
