static char *rscid = "$Id: datamap.c,v 1.5 1993/01/05 04:34:03 waite Exp $";
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <stdlib.h>
#include "storage.h"

/***/
StorageRequired
NewStorage(size, align, top)
int size, align, top;
/* Create a new storage object
 *    On entry-
 *       size=size of the new object
 *       align=required divisor of the object's address
 *       top=FALSE if the lowest address must be aligned
 *           TRUE if the last+1 address must be aligned
 ***/
{
   StorageRequired s;

   s = (StorageRequired)malloc(sizeof(struct StorageRec));
   s->size = size; s->align = align; s->top = top;
   return s;
}

/***/
StorageRequired
CopyStorage(a)
StorageRequired a;
/* Create a new storage object equal to an existing storage object
 *    On entry-
 *       a=storage object to be copied
 ***/
{
   StorageRequired s;

   if (a == NoStorage) return NoStorage;

   s = (StorageRequired)malloc(sizeof(struct StorageRec));
   *s = *a;
   return s;
}

/***/
StorageRequired
ArrayStorage(n,a)
int n; StorageRequired a;
/* Create a new storage object for an array of existing storage objects
 *    On entry-
 *       n=number of array elements
 *       a=element storage object
 ***/
{
   StorageRequired s;
   struct StorageRec t;

   if (a == NoStorage) return NoStorage;

   s = (StorageRequired)malloc(sizeof(struct StorageRec));
   *s = t = *a;
   t.size = 0;
   (void)Concatenate(s, &t);
   s->size *= n;
   return s;
}

/***/
int
StorageSize(a)
StorageRequired a;
/* Obtain the size of a storage object
 *    On exit-
 *       StorageSize=size of the storage object a
 ***/
{
   if (a != NoStorage) return a->size;
   return 0;
}

/***/
int
StorageAlignment(a)
StorageRequired a;
/* Obtain the alignment of a storage object
 *    On exit-
 *       StorageSize=alignment of the storage object a
 ***/
{
   if (a != NoStorage) return a->align;
   return 1;
}

/***/
int
Concatenate(a, b)
StorageRequired a, b;
/* Extend the storage requirement for an object by concatenating another object
 *    On entry-
 *       a describes the object to be extended
 *       b describes the object to be concatentated to a
 *    On exit-
 *       a describes the storage required by the extended object
 *       Concatenate=offset of the address of b from the address of a
 ***/
{
   int offset;

   if (a == NoStorage || b == NoStorage) return 0;

   if (a->top == b->top) {
      offset = ((a->size+(b->align-1)) / b->align)*b->align;
      a->size = offset+b->size;
   } else {
      offset = ((a->size+b->size+(b->align-1)) / b->align)*b->align;
      a->size = offset;
   }
   if (a->align < b->align) a->align = b->align;
   if (a->top) return -offset; else return offset;
}

/***/
int
Overlay(a, b)
StorageRequired a, b;
/* Extend the storage requirement for an object by overlaying another object
 *    On entry-
 *       a describes the object to be extended
 *       b describes the object to be overlaid on a
 *    On exit-
 *       a describes the storage required by the extended object
 *       Overlay=offset of the address of b from the address of a
 ***/
{
   int offset;
   StorageRequired tmp;

   if (a == NoStorage || b == NoStorage) return 0;

   if (a->top == b->top) offset = 0;
   else { tmp = a; tmp->size = 0; offset = Concatenate(tmp,b); b = tmp; }
   if (a->size < b->size) a->size = b->size;
   if (a->align < b->align) a->align = b->align;
   return offset;
}
