
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGout (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGzahl *_PPTGzahl;
struct _SPTGzahl{
  _PTGProc _print;
  int _t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGhbl(_PPTG0 n)
#else
static void _PrPTGhbl(n)
_PPTG0 n;
#endif
{
  fputs ("-hbl", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGdgd(_PPTG0 n)
#else
static void _PrPTGdgd(n)
_PPTG0 n;
#endif
{
  fputs ("-dgd", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmp(_PPTG0 n)
#else
static void _PrPTGmp(n)
_PPTG0 n;
#endif
{
  fputs ("-mp", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGcre(_PPTG0 n)
#else
static void _PrPTGcre(n)
_PPTG0 n;
#endif
{
  fputs ("-cre", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGlp(_PPTG0 n)
#else
static void _PrPTGlp(n)
_PPTG0 n;
#endif
{
  fputs ("-lp", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGnoc(_PPTG1 n)
#else
static void _PrPTGnoc(n)
_PPTG1 n;
#endif
{
  fputs ("-noc ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGnosa(_PPTG1 n)
#else
static void _PrPTGnosa(n)
_PPTG1 n;
#endif
{
  fputs ("-nosa ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGdfs(_PPTG0 n)
#else
static void _PrPTGdfs(n)
_PPTG0 n;
#endif
{
  fputs ("-dfs", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGscc(_PPTG0 n)
#else
static void _PrPTGscc(n)
_PPTG0 n;
#endif
{
  fputs ("-scc", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGcc(_PPTG0 n)
#else
static void _PrPTGcc(n)
_PPTG0 n;
#endif
{
  fputs ("-cc", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGdum(_PPTG0 n)
#else
static void _PrPTGdum(n)
_PPTG0 n;
#endif
{
  fputs ("-dum", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGsrc(_PPTG0 n)
#else
static void _PrPTGsrc(n)
_PPTG0 n;
#endif
{
  fputs ("-src", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGirc(_PPTG0 n)
#else
static void _PrPTGirc(n)
_PPTG0 n;
#endif
{
  fputs ("-irc", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGdsc(_PPTG0 n)
#else
static void _PrPTGdsc(n)
_PPTG0 n;
#endif
{
  fputs ("-dsc", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGlo(_PPTG1 n)
#else
static void _PrPTGlo(n)
_PPTG1 n;
#endif
{
  fputs ("-lo ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGaec(_PPTG0 n)
#else
static void _PrPTGaec(n)
_PPTG0 n;
#endif
{
  fputs ("-aec", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGcl(_PPTG0 n)
#else
static void _PrPTGcl(n)
_PPTG0 n;
#endif
{
  fputs ("-cl", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGqz(_PPTG1 n)
#else
static void _PrPTGqz(n)
_PPTG1 n;
#endif
{
  fputs ("-qz ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGsz(_PPTG1 n)
#else
static void _PrPTGsz(n)
_PPTG1 n;
#endif
{
  fputs ("-sz ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGzahl(_PPTGzahl n)
#else
static void _PrPTGzahl(n)
_PPTGzahl n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGseq(_PPTG2 n)
#else
static void _PrPTGseq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGoptinfo(_PPTG0 n)
#else
static void _PrPTGoptinfo(n)
_PPTG0 n;
#endif
{
  fputs ("OPT_INFO", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGttab(_PPTG1 n)
#else
static void _PrPTGttab(n)
_PPTG1 n;
#endif
{
  fputs ("T_TAB ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGntab(_PPTG1 n)
#else
static void _PrPTGntab(n)
_PPTG1 n;
#endif
{
  fputs ("N_TAB ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_gcsa(_PPTG0 n)
#else
static void _PrPTGmode_gcsa(n)
_PPTG0 n;
#endif
{
  fputs ("GCSA", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_gcsb(_PPTG0 n)
#else
static void _PrPTGmode_gcsb(n)
_PPTG0 n;
#endif
{
  fputs ("GCSB", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_lesa(_PPTG0 n)
#else
static void _PrPTGmode_lesa(n)
_PPTG0 n;
#endif
{
  fputs ("LESA", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_lesb(_PPTG0 n)
#else
static void _PrPTGmode_lesb(n)
_PPTG0 n;
#endif
{
  fputs ("LESB", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_rcsa(_PPTG0 n)
#else
static void _PrPTGmode_rcsa(n)
_PPTG0 n;
#endif
{
  fputs ("RCSA", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_rcsb(_PPTG0 n)
#else
static void _PrPTGmode_rcsb(n)
_PPTG0 n;
#endif
{
  fputs ("RCSB", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_sds(_PPTG0 n)
#else
static void _PrPTGmode_sds(n)
_PPTG0 n;
#endif
{
  fputs ("SDS", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGmode_rds(_PPTG0 n)
#else
static void _PrPTGmode_rds(n)
_PPTG0 n;
#endif
{
  fputs ("RDS", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGline(_PPTG2 n)
#else
static void _PrPTGline(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGinfo(_PPTG0 n)
#else
static void _PrPTGinfo(n)
_PPTG0 n;
#endif
{
  fputs ("ALL_STATES", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGfreepos(_PPTG0 n)
#else
static void _PrPTGfreepos(n)
_PPTG0 n;
#endif
{
  fputs ("FREE_POS", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGaecfile(_PPTG0 n)
#else
static void _PrPTGaecfile(n)
_PPTG0 n;
#endif
{
  fputs ("#ifndef _ERROR_OFF\n", f);
  fputs ("#define _ERROR_OFF\n", f);
  fputs ("#endif\n", f);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGhbl()
#else
PTGNode PTGhbl()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGhbl;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGdgd()
#else
PTGNode PTGdgd()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGdgd;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmp()
#else
PTGNode PTGmp()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmp;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGcre()
#else
PTGNode PTGcre()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGcre;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGlp()
#else
PTGNode PTGlp()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGlp;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGnoc(PTGNode _t0)
#else
PTGNode PTGnoc(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGnoc;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGnosa(PTGNode _t0)
#else
PTGNode PTGnosa(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGnosa;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGdfs()
#else
PTGNode PTGdfs()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGdfs;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGscc()
#else
PTGNode PTGscc()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGscc;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGcc()
#else
PTGNode PTGcc()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGcc;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGdum()
#else
PTGNode PTGdum()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGdum;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGsrc()
#else
PTGNode PTGsrc()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGsrc;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGirc()
#else
PTGNode PTGirc()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGirc;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGdsc()
#else
PTGNode PTGdsc()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGdsc;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGlo(PTGNode _t0)
#else
PTGNode PTGlo(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGlo;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGaec()
#else
PTGNode PTGaec()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGaec;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGcl()
#else
PTGNode PTGcl()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGcl;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGqz(PTGNode _t0)
#else
PTGNode PTGqz(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGqz;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGsz(PTGNode _t0)
#else
PTGNode PTGsz(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGsz;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGzahl(int _t0)
#else
PTGNode PTGzahl(_t0)
  int _t0;
#endif
{
  _PPTGzahl n;

  if ((n = (_PPTGzahl) malloc (sizeof (struct _SPTGzahl)))  ==  (_PPTGzahl)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGzahl;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGseq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGseq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGseq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGoptinfo()
#else
PTGNode PTGoptinfo()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGoptinfo;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGttab(PTGNode _t0)
#else
PTGNode PTGttab(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGttab;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGntab(PTGNode _t0)
#else
PTGNode PTGntab(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGntab;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_gcsa()
#else
PTGNode PTGmode_gcsa()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_gcsa;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_gcsb()
#else
PTGNode PTGmode_gcsb()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_gcsb;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_lesa()
#else
PTGNode PTGmode_lesa()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_lesa;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_lesb()
#else
PTGNode PTGmode_lesb()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_lesb;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_rcsa()
#else
PTGNode PTGmode_rcsa()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_rcsa;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_rcsb()
#else
PTGNode PTGmode_rcsb()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_rcsb;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_sds()
#else
PTGNode PTGmode_sds()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_sds;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGmode_rds()
#else
PTGNode PTGmode_rds()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGmode_rds;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGline(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGline(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGline;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGinfo()
#else
PTGNode PTGinfo()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGinfo;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGfreepos()
#else
PTGNode PTGfreepos()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGfreepos;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGaecfile()
#else
PTGNode PTGaecfile()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGaecfile;
  return ((PTGNode) n);
}

